/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.lingo;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.db.servicedesk.requesttype.RequestTypeFieldsReader;
import com.atlassian.jira.migration.db.servicedesk.requesttype.RequestTypeGroupReader;
import com.atlassian.jira.migration.db.servicedesk.requesttype.RequestTypeIdReader;
import com.atlassian.jira.migration.export.db.servicedesk.lingo.LingoTranslationField;
import com.atlassian.jira.migration.export.db.servicedesk.lingo.LingoTranslationsWrapper;
import com.atlassian.jira.migration.export.db.servicedesk.lingo.LogicalId;
import com.atlassian.jira.migration.export.db.servicedesk.portalsettings.PortalReader;
import com.atlassian.migration.jira.servicedesk.lingo.TranslationFieldUpdate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/lingo/LingoEntityExportValidator;", "", "requestTypeIdReader", "Lcom/atlassian/jira/migration/db/servicedesk/requesttype/RequestTypeIdReader;", "requestTypeFieldsReader", "Lcom/atlassian/jira/migration/db/servicedesk/requesttype/RequestTypeFieldsReader;", "requestTypeGroupReader", "Lcom/atlassian/jira/migration/db/servicedesk/requesttype/RequestTypeGroupReader;", "portalReader", "Lcom/atlassian/jira/migration/export/db/servicedesk/portalsettings/PortalReader;", "(Lcom/atlassian/jira/migration/db/servicedesk/requesttype/RequestTypeIdReader;Lcom/atlassian/jira/migration/db/servicedesk/requesttype/RequestTypeFieldsReader;Lcom/atlassian/jira/migration/db/servicedesk/requesttype/RequestTypeGroupReader;Lcom/atlassian/jira/migration/export/db/servicedesk/portalsettings/PortalReader;)V", "filterEntitiesNotEligibleForExport", "", "Lcom/atlassian/jira/migration/export/db/servicedesk/lingo/LingoTranslationsWrapper;", "projectId", "", "lingoTranslations", "isEligibleForExport", "", "logicalId", "Lcom/atlassian/jira/migration/export/db/servicedesk/lingo/LogicalId;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nLingoEntityExportValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LingoEntityExportValidator.kt\ncom/atlassian/jira/migration/export/servicedesk/lingo/LingoEntityExportValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1549#2:55\n1620#2,2:56\n766#2:58\n857#2,2:59\n1622#2:61\n766#2:62\n857#2,2:63\n*S KotlinDebug\n*F\n+ 1 LingoEntityExportValidator.kt\ncom/atlassian/jira/migration/export/servicedesk/lingo/LingoEntityExportValidator\n*L\n29#1:55\n29#1:56,2\n33#1:58\n33#1:59,2\n29#1:61\n37#1:62\n37#1:63,2\n*E\n"})
public final class LingoEntityExportValidator {
    @NotNull
    private final RequestTypeIdReader requestTypeIdReader;
    @NotNull
    private final RequestTypeFieldsReader requestTypeFieldsReader;
    @NotNull
    private final RequestTypeGroupReader requestTypeGroupReader;
    @NotNull
    private final PortalReader portalReader;

    @Inject
    public LingoEntityExportValidator(@NotNull RequestTypeIdReader requestTypeIdReader, @NotNull RequestTypeFieldsReader requestTypeFieldsReader, @NotNull RequestTypeGroupReader requestTypeGroupReader, @NotNull PortalReader portalReader) {
        Intrinsics.checkNotNullParameter((Object)requestTypeIdReader, (String)"requestTypeIdReader");
        Intrinsics.checkNotNullParameter((Object)requestTypeFieldsReader, (String)"requestTypeFieldsReader");
        Intrinsics.checkNotNullParameter((Object)requestTypeGroupReader, (String)"requestTypeGroupReader");
        Intrinsics.checkNotNullParameter((Object)portalReader, (String)"portalReader");
        this.requestTypeIdReader = requestTypeIdReader;
        this.requestTypeFieldsReader = requestTypeFieldsReader;
        this.requestTypeGroupReader = requestTypeGroupReader;
        this.portalReader = portalReader;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LingoTranslationsWrapper> filterEntitiesNotEligibleForExport(long projectId, @NotNull List<LingoTranslationsWrapper> lingoTranslations) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        LingoTranslationsWrapper it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(lingoTranslations, (String)"lingoTranslations");
        Iterable $this$map$iv = lingoTranslations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List list;
            void $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            LingoTranslationsWrapper lingoTranslationsWrapper = (LingoTranslationsWrapper)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = it.getFieldUpdates();
            String string = it.getLanguageTag();
            long l = it.getProjectId();
            boolean $i$f$filter = false;
            void var18_16 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                LingoTranslationField it2 = (LingoTranslationField)element$iv$iv;
                boolean bl2 = false;
                if (!this.isEligibleForExport(projectId, it2.getLogicalId())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list2 = list = (List)destination$iv$iv2;
            String string2 = string;
            long l2 = l;
            collection.add(new LingoTranslationsWrapper(l2, string2, list2));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (LingoTranslationsWrapper)element$iv$iv;
            boolean bl = false;
            boolean bl3 = !((Collection)it.getFieldUpdates()).isEmpty();
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isEligibleForExport(long projectId, LogicalId logicalId) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[logicalId.getEntityType().ordinal()]) {
            case 1: {
                bl = this.requestTypeIdReader.isRequestTypeExists(projectId, logicalId.getEntityId());
                break;
            }
            case 2: {
                bl = this.requestTypeFieldsReader.isRequestTypeFieldExists(projectId, logicalId.getEntityId());
                break;
            }
            case 3: {
                bl = this.requestTypeGroupReader.isRequestTypeGroupExists(projectId, logicalId.getEntityId());
                break;
            }
            case 4: {
                bl = this.portalReader.isPortalExists(projectId, logicalId.getEntityId());
                break;
            }
            case 5: {
                bl = this.portalReader.isPortalExists(projectId, logicalId.getEntityId());
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TranslationFieldUpdate.Entity.values().length];
            try {
                nArray[TranslationFieldUpdate.Entity.REQUEST_TYPE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TranslationFieldUpdate.Entity.REQUEST_TYPE_FIELD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TranslationFieldUpdate.Entity.REQUEST_TYPE_GROUP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TranslationFieldUpdate.Entity.PORTAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TranslationFieldUpdate.Entity.ANNOUNCEMENT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

