/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.organization;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.export.db.servicedesk.organization.CustomerOrganizationData;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.servicedesk.organization.CustomerOrganizationProjectAssociationWrapper;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.servicedesk.customerorg.CustomerOrgProjectAssociation;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001a2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u001aB\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/organization/CustomerOrganizationProjectAssociationExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/servicedesk/organization/CustomerOrganizationProjectAssociationWrapper;", "Lcom/atlassian/migration/jira/servicedesk/customerorg/CustomerOrgProjectAssociation;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "mapOrganization", "Lcom/atlassian/migration/base/mri/MRI;", "customerOrganization", "Lcom/atlassian/jira/migration/export/db/servicedesk/organization/CustomerOrganizationData;", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "Companion", "jira-migration-plugin"})
public final class CustomerOrganizationProjectAssociationExporter
implements Exporter<String, CustomerOrganizationProjectAssociationWrapper, CustomerOrgProjectAssociation> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ExporterKey key;
    private static final Logger log = LoggerFactory.getLogger(CustomerOrganizationProjectAssociationExporter.class);

    @Inject
    public CustomerOrganizationProjectAssociationExporter(@NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.exportService = exportService;
        this.key = new ExporterKey(CustomerOrgProjectAssociation.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, CustomerOrganizationProjectAssociationWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForKey(@NotNull String entityKey) {
        Intrinsics.checkNotNullParameter((Object)entityKey, (String)"entityKey");
        return MriExtensionsKt.mri$default(CustomerOrgProjectAssociation.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull CustomerOrganizationProjectAssociationWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public CustomerOrgProjectAssociation exportData(@NotNull ExportContext ctx, @NotNull CustomerOrganizationProjectAssociationWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        log.info("Exporting CustomerOrgProjectAssociation entity [" + entity.getId() + "] for project [" + ctx.getProject() + "] as user [" + ctx.getStartedBy() + ']');
        MRI entityMri = this.mriForEntity(entity);
        return new CustomerOrgProjectAssociation(entityMri, this.exportService.checkExportedOrThrow(ctx, entity.getServiceDesk(), (Function1<? super MRI, ? extends Exception>)((Function1)new Function1<MRI, Exception>(entityMri, entity){
            final /* synthetic */ MRI $entityMri;
            final /* synthetic */ CustomerOrganizationProjectAssociationWrapper $entity;
            {
                this.$entityMri = $entityMri;
                this.$entity = $entity;
                super(1);
            }

            @NotNull
            public final Exception invoke(@NotNull MRI mri) {
                Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
                String string = "CustomerOrgProjectAssociation with MRI - " + this.$entityMri + " has missing Service Desk with MRI - " + mri + '.';
                String string2 = "Verify if Service Desk with id " + this.$entity.getServiceDesk().getId() + " is valid";
                ExportErrorCode exportErrorCode = ExportErrorCode.JSD_REQUIRED_REFERRED_ENTITY_NOT_EXPORTED;
                return new ExportException(this.$entityMri, exportErrorCode, string, string2, null, null, null, 112, null);
            }
        })), this.mapOrganization(ctx, entity.getOrganization()));
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull CustomerOrganizationProjectAssociationWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), entity.getServiceDesk().getId(), entity.getOrganization().getId(), ctx.getMigrationId(), ctx.getExportMode()};
        log.debug("Exporting users and groups for customerOrganizationProjectAssociation {} for serviceDeskId {} and organizationId {} for migration {} under exportMode {}", objectArray);
        this.mapOrganization(ctx, entity.getOrganization());
    }

    private final MRI mapOrganization(ExportContext ctx, CustomerOrganizationData customerOrganization) {
        return ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, customerOrganization, false, 4, null);
    }

    @Override
    @Nullable
    public CustomerOrganizationProjectAssociationWrapper extractServerEntity(@NotNull ExportContext ctx, @NotNull String entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull CustomerOrganizationProjectAssociationWrapper entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/organization/CustomerOrganizationProjectAssociationExporter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

