/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.organization;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.servicedesk.organization.CustomerOrganizationUsersWrapper;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.servicedesk.customerorg.CustomerOrganizationUsers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00192\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u0019B\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/organization/CustomerOrganizationUsersExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/servicedesk/organization/CustomerOrganizationUsersWrapper;", "Lcom/atlassian/migration/jira/servicedesk/customerorg/CustomerOrganizationUsers;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "mapUsers", "", "Lcom/atlassian/migration/base/mri/MRI;", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCustomerOrganizationUsersExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomerOrganizationUsersExporter.kt\ncom/atlassian/jira/migration/export/servicedesk/organization/CustomerOrganizationUsersExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1603#2,9:73\n1855#2:82\n1856#2:85\n1612#2:86\n1#3:83\n1#3:84\n*S KotlinDebug\n*F\n+ 1 CustomerOrganizationUsersExporter.kt\ncom/atlassian/jira/migration/export/servicedesk/organization/CustomerOrganizationUsersExporter\n*L\n65#1:73,9\n65#1:82\n65#1:85\n65#1:86\n65#1:84\n*E\n"})
public final class CustomerOrganizationUsersExporter
implements Exporter<String, CustomerOrganizationUsersWrapper, CustomerOrganizationUsers> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ExporterKey key;
    private static final Logger log = LoggerFactory.getLogger(CustomerOrganizationUsersExporter.class);

    @Inject
    public CustomerOrganizationUsersExporter(@NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.exportService = exportService;
        this.key = new ExporterKey(CustomerOrganizationUsers.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, CustomerOrganizationUsersWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForKey(@NotNull String entityKey) {
        Intrinsics.checkNotNullParameter((Object)entityKey, (String)"entityKey");
        return MriExtensionsKt.mri$default(CustomerOrganizationUsers.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull CustomerOrganizationUsersWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public CustomerOrganizationUsers exportData(@NotNull ExportContext ctx, @NotNull CustomerOrganizationUsersWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        log.info("Exporting CustomerOrganizationUsers entity [" + entity.getId() + "] for project [" + ctx.getProject() + "] as user [" + ctx.getStartedBy() + ']');
        MRI entityMri = this.mriForEntity(entity);
        return new CustomerOrganizationUsers(entityMri, this.exportService.checkExportedOrThrow(ctx, entity.getOrganization(), (Function1<? super MRI, ? extends Exception>)((Function1)new Function1<MRI, Exception>(entityMri, entity){
            final /* synthetic */ MRI $entityMri;
            final /* synthetic */ CustomerOrganizationUsersWrapper $entity;
            {
                this.$entityMri = $entityMri;
                this.$entity = $entity;
                super(1);
            }

            @NotNull
            public final Exception invoke(@NotNull MRI mri) {
                Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
                String string = "CustomerOrganizationUsers with MRI - " + this.$entityMri + " has missing Organization with MRI - " + mri + '.';
                String string2 = "Verify if Organization with id " + this.$entity.getOrganization().getId() + " is valid";
                ExportErrorCode exportErrorCode = ExportErrorCode.JSD_REQUIRED_REFERRED_ENTITY_NOT_EXPORTED;
                return new ExportException(this.$entityMri, exportErrorCode, string, string2, null, null, null, 112, null);
            }
        })), this.mapUsers(ctx, entity));
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull CustomerOrganizationUsersWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getOrganization().getId(), ctx.getMigrationId(), ctx.getExportMode()};
        log.debug("Exporting users and groups for customer organization {} for migration {} under exportMode {}", objectArray);
        this.mapUsers(ctx, entity);
    }

    /*
     * WARNING - void declaration
     */
    private final List<MRI> mapUsers(ExportContext ctx, CustomerOrganizationUsersWrapper entity) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = entity.getUsers();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            MRI mRI;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (UserRef.Companion.fromString(it) != null) {
                UserRef userKey;
                boolean bl3 = false;
                mRI = this.exportService.userRef(ctx, userKey);
            } else {
                mRI = null;
            }
            if (mRI == null) continue;
            MRI it$iv$iv = mRI;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public CustomerOrganizationUsersWrapper extractServerEntity(@NotNull ExportContext ctx, @NotNull String entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull CustomerOrganizationUsersWrapper entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/organization/CustomerOrganizationUsersExporter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

