/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.portalsettings;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.export.db.servicedesk.portalsettings.ParticipantSettingReader;
import com.atlassian.jira.migration.export.db.servicedesk.portalsettings.PortalData;
import com.atlassian.jira.migration.export.db.servicedesk.portalsettings.ServiceDeskParticipantSetting;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.servicedesk.PortalSettings;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001f2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0002\u001e\u001fB\u001f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/portalsettings/PortalSettingsExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/db/servicedesk/portalsettings/PortalData;", "Lcom/atlassian/migration/jira/servicedesk/PortalSettings;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "participantSettingReader", "Lcom/atlassian/jira/migration/export/db/servicedesk/portalsettings/ParticipantSettingReader;", "jiraPropertySetFactory", "Lcom/atlassian/jira/propertyset/JiraPropertySetFactory;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/db/servicedesk/portalsettings/ParticipantSettingReader;Lcom/atlassian/jira/propertyset/JiraPropertySetFactory;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "getCanAgentsManagePortalAnnouncement", "", "getPortalAnnouncements", "Lcom/atlassian/jira/migration/export/servicedesk/portalsettings/PortalSettingsExporter$Announcement;", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "", "Announcement", "Companion", "jira-migration-plugin"})
public final class PortalSettingsExporter
implements Exporter<Long, PortalData, PortalSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ParticipantSettingReader participantSettingReader;
    @NotNull
    private final JiraPropertySetFactory jiraPropertySetFactory;
    @NotNull
    private final ExporterKey key;
    @NotNull
    private static final String HEADER = "header";
    @NotNull
    private static final String MESSAGE = "message";
    @NotNull
    private static final String ENTITY_NAME = "vp.properties";
    @NotNull
    private static final String PORTAL_ANNOUNCEMENT_KEY_PREFIX = "com.atlassian.servicedesk.portal.announcement_";
    @NotNull
    private static final String BASE_AGENT_ANNOUNCEMENTS_ENABLED_KEY_PREFIX = "com.atlassian.servicedesk.agent.announcement.project.enabled.";
    private static final Logger log = LoggerFactory.getLogger(PortalSettingsExporter.class);

    @Inject
    public PortalSettingsExporter(@NotNull ExportService exportService, @NotNull ParticipantSettingReader participantSettingReader, @NotNull JiraPropertySetFactory jiraPropertySetFactory) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)participantSettingReader, (String)"participantSettingReader");
        Intrinsics.checkNotNullParameter((Object)jiraPropertySetFactory, (String)"jiraPropertySetFactory");
        this.exportService = exportService;
        this.participantSettingReader = participantSettingReader;
        this.jiraPropertySetFactory = jiraPropertySetFactory;
        this.key = new ExporterKey(PortalSettings.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, PortalData.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull PortalData entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(PortalSettings.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public PortalSettings exportData(@NotNull ExportContext ctx, @NotNull PortalData entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.getCanAgentsManagePortalAnnouncement(entity);
        MRI entityMri = this.mriForEntity(entity);
        MRI mRI = this.exportService.checkExportedOrThrow(ctx, ctx.getProject(), (Function1<? super MRI, ? extends Exception>)((Function1)new Function1<MRI, Exception>(entityMri, ctx){
            final /* synthetic */ MRI $entityMri;
            final /* synthetic */ ExportContext $ctx;
            {
                this.$entityMri = $entityMri;
                this.$ctx = $ctx;
                super(1);
            }

            @NotNull
            public final Exception invoke(@NotNull MRI mri) {
                Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
                String string = "Portal Settings with MRI - " + this.$entityMri + " has missing Project with MRI - " + mri + '.';
                String string2 = "Verify if Project with id " + this.$ctx.getProject().getId() + " is valid";
                ExportErrorCode exportErrorCode = ExportErrorCode.JSD_REQUIRED_REFERRED_ENTITY_NOT_EXPORTED;
                return new ExportException(this.$entityMri, exportErrorCode, string, string2, null, null, null, 112, null);
            }
        }));
        String string = entity.getName();
        String string2 = entity.getDescription();
        Announcement announcement = this.getPortalAnnouncements(entity);
        String string3 = announcement != null ? announcement.getHeader() : null;
        Announcement announcement2 = this.getPortalAnnouncements(entity);
        String string4 = announcement2 != null ? announcement2.getMessage() : null;
        Object object = this.participantSettingReader.getParticipantSettings(entity.getServiceDeskId());
        boolean bl = object != null && (object = ((ServiceDeskParticipantSetting)object).getAutocompleteEnabled()) != null ? (Boolean)object : false;
        boolean bl2 = this.getCanAgentsManagePortalAnnouncement(entity);
        Object object2 = this.participantSettingReader.getParticipantSettings(entity.getServiceDeskId());
        boolean bl3 = object2 != null && (object2 = ((ServiceDeskParticipantSetting)object2).getManageEnabled()) != null ? (Boolean)object2 : false;
        return new PortalSettings(entityMri, mRI, string, string2, bl2, string3, string4, bl3, null, bl, 256, null);
    }

    private final boolean getCanAgentsManagePortalAnnouncement(PortalData entity) {
        boolean isAgentCanManagePortalAnnouncement = false;
        MRI entityMri = this.mriForEntity(entity);
        try {
            isAgentCanManagePortalAnnouncement = this.jiraPropertySetFactory.buildNoncachingPropertySet(ENTITY_NAME).getBoolean(BASE_AGENT_ANNOUNCEMENTS_ENABLED_KEY_PREFIX + entity.getId());
        }
        catch (Exception e) {
            ExportErrorCode exportErrorCode = ExportErrorCode.JSD_ENTITY_RETRIEVAL_ERROR;
            throw new ExportException(entityMri, exportErrorCode, "Couldn't retrieve Base Agent Announcement Enabled flag for Portal Settings Entity.", null, null, null, null, 120, null);
        }
        return isAgentCanManagePortalAnnouncement;
    }

    private final Announcement getPortalAnnouncements(PortalData entity) {
        Announcement announcement;
        try {
            Announcement announcement2;
            String helpCenterJson = this.jiraPropertySetFactory.buildNoncachingPropertySet(ENTITY_NAME).getText(PORTAL_ANNOUNCEMENT_KEY_PREFIX + entity.getId());
            if (StringUtils.isNotEmpty((String)helpCenterJson)) {
                JSONObject jsonObject = new JSONObject(helpCenterJson);
                String string = jsonObject.optString(HEADER);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"optString(...)");
                String string2 = jsonObject.optString(MESSAGE);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"optString(...)");
                announcement2 = new Announcement(string, string2);
            } else {
                announcement2 = null;
            }
            announcement = announcement2;
        }
        catch (Exception e) {
            log.info("Failed to retrieve announcement for portalId {}", (Object)entity.getId());
            MRI mRI = MriExtensionsKt.mri$default(PortalSettings.Companion.getEntityType(), entity.getId(), null, 2, null);
            String string = "Failed to retrieve announcement for portal with id= " + entity.getId();
            ExportErrorCode exportErrorCode = ExportErrorCode.JSD_ENTITY_RETRIEVAL_ERROR;
            throw new ExportException(mRI, exportErrorCode, string, null, null, null, null, 120, null);
        }
        return announcement;
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull PortalData entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public PortalData extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull PortalData entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/portalsettings/PortalSettingsExporter$Announcement;", "", "header", "", "message", "(Ljava/lang/String;Ljava/lang/String;)V", "getHeader", "()Ljava/lang/String;", "getMessage", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    private static final class Announcement {
        @NotNull
        private final String header;
        @NotNull
        private final String message;

        public Announcement(@NotNull String header, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)header, (String)PortalSettingsExporter.HEADER);
            Intrinsics.checkNotNullParameter((Object)message, (String)PortalSettingsExporter.MESSAGE);
            this.header = header;
            this.message = message;
        }

        @NotNull
        public final String getHeader() {
            return this.header;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final String component1() {
            return this.header;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final Announcement copy(@NotNull String header, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)header, (String)PortalSettingsExporter.HEADER);
            Intrinsics.checkNotNullParameter((Object)message, (String)PortalSettingsExporter.MESSAGE);
            return new Announcement(header, message);
        }

        public static /* synthetic */ Announcement copy$default(Announcement announcement, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = announcement.header;
            }
            if ((n & 2) != 0) {
                string2 = announcement.message;
            }
            return announcement.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Announcement(header=" + this.header + ", message=" + this.message + ')';
        }

        public int hashCode() {
            int result2 = this.header.hashCode();
            result2 = result2 * 31 + this.message.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Announcement)) {
                return false;
            }
            Announcement announcement = (Announcement)other;
            if (!Intrinsics.areEqual((Object)this.header, (Object)announcement.header)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)announcement.message);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/portalsettings/PortalSettingsExporter$Companion;", "", "()V", "BASE_AGENT_ANNOUNCEMENTS_ENABLED_KEY_PREFIX", "", "ENTITY_NAME", "HEADER", "MESSAGE", "PORTAL_ANNOUNCEMENT_KEY_PREFIX", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

