/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.queue;

import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.ExportFilters;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.core.JQL;
import com.atlassian.migration.jira.servicedesk.Queue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001f2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u001fB\u001f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/queue/QueueExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/db/servicedesk/queue/Queue;", "Lcom/atlassian/migration/jira/servicedesk/Queue;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "fieldManager", "Lcom/atlassian/jira/issue/fields/FieldManager;", "exportFilters", "Lcom/atlassian/jira/migration/export/utils/ExportFilters;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/issue/fields/FieldManager;Lcom/atlassian/jira/migration/export/utils/ExportFilters;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportField", "Lcom/atlassian/migration/base/mri/MRI;", "fieldId", "", "mapJqlFieldNames", "", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nQueueExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueueExporter.kt\ncom/atlassian/jira/migration/export/servicedesk/queue/QueueExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n766#2:79\n857#2,2:80\n1603#2,9:82\n1855#2:91\n1856#2:93\n1612#2:94\n1#3:92\n1#3:95\n*S KotlinDebug\n*F\n+ 1 QueueExporter.kt\ncom/atlassian/jira/migration/export/servicedesk/queue/QueueExporter\n*L\n63#1:79\n63#1:80,2\n66#1:82,9\n66#1:91\n66#1:93\n66#1:94\n66#1:92\n*E\n"})
public final class QueueExporter
implements Exporter<Long, com.atlassian.jira.migration.db.servicedesk.queue.Queue, Queue> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final FieldManager fieldManager;
    @NotNull
    private final ExportFilters exportFilters;
    @NotNull
    private final ExporterKey key;
    private static final Logger log = LoggerFactory.getLogger(QueueExporter.class);

    @Inject
    public QueueExporter(@NotNull ExportService exportService, @NotNull FieldManager fieldManager, @NotNull ExportFilters exportFilters) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)fieldManager, (String)"fieldManager");
        Intrinsics.checkNotNullParameter((Object)exportFilters, (String)"exportFilters");
        this.exportService = exportService;
        this.fieldManager = fieldManager;
        this.exportFilters = exportFilters;
        this.key = new ExporterKey(Queue.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, com.atlassian.jira.migration.db.servicedesk.queue.Queue.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(Queue.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull com.atlassian.jira.migration.db.servicedesk.queue.Queue entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public Queue exportData(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.migration.db.servicedesk.queue.Queue entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        log.info("Exporting Queue entity [" + entity.getId() + "] for project [" + ctx.getProject() + "] as user [" + ctx.getStartedBy() + ']');
        MRI entityMri = this.mriForEntity(entity);
        MRI mRI = this.exportService.checkExportedOrThrow(ctx, ctx.getProject(), (Function1<? super MRI, ? extends Exception>)((Function1)new Function1<MRI, Exception>(entityMri, ctx){
            final /* synthetic */ MRI $entityMri;
            final /* synthetic */ ExportContext $ctx;
            {
                this.$entityMri = $entityMri;
                this.$ctx = $ctx;
                super(1);
            }

            @NotNull
            public final Exception invoke(@NotNull MRI mri) {
                Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
                String string = "Queue with MRI - " + this.$entityMri + " has missing Project with MRI - " + mri + '.';
                String string2 = "Verify if Project with id " + this.$ctx.getProject().getId() + " is valid";
                ExportErrorCode exportErrorCode = ExportErrorCode.JSD_REQUIRED_REFERRED_ENTITY_NOT_EXPORTED;
                return new ExportException(this.$entityMri, exportErrorCode, string, string2, null, null, null, 112, null);
            }
        }));
        String string = entity.getName();
        String string2 = entity.getJql();
        if (string2 == null) {
            string2 = "";
        }
        return new Queue(entityMri, mRI, string, new JQL(string2), this.mapJqlFieldNames(ctx, entity), Integer.valueOf(entity.getOrder()), null, null, null, 448, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<MRI> mapJqlFieldNames(ExportContext ctx, com.atlassian.jira.migration.db.servicedesk.queue.Queue entity) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CollectionsKt.distinct((Iterable)entity.getFields());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!this.exportFilters.isSupportedField(ctx, this.fieldManager.getField(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            MRI it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.exportField(ctx, it, entity) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final MRI exportField(ExportContext ctx, String fieldId, com.atlassian.jira.migration.db.servicedesk.queue.Queue entity) {
        MRI mRI;
        MRI it = mRI = this.exportService.exportFieldOrNull(ctx, fieldId);
        boolean bl = false;
        MRI mRI2 = it;
        if (mRI2 == null) {
            log.error("Couldn't find field with id - [" + fieldId + "] while exporting queue with id -  [" + entity.getId() + ']');
            mRI2 = Unit.INSTANCE;
        }
        return mRI;
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.migration.db.servicedesk.queue.Queue entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public com.atlassian.jira.migration.db.servicedesk.queue.Queue extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.migration.db.servicedesk.queue.Queue entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/queue/QueueExporter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

