/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.report;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.export.db.servicedesk.report.Report;
import com.atlassian.jira.migration.export.db.servicedesk.report.SeriesDataType;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.servicedesk.report.ReportExporter;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.utils.StringUtils;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.core.JQL;
import com.atlassian.migration.jira.servicedesk.Servicedesk;
import com.atlassian.migration.jira.servicedesk.TimeMetric;
import com.atlassian.migration.jira.servicedesk.report.Series;
import com.atlassian.migration.jira.servicedesk.report.SeriesDataTypeKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \"2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\"B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\b\u0010 \u001a\u00020!H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/report/ReportExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/db/servicedesk/report/Report;", "Lcom/atlassian/migration/jira/servicedesk/report/Report;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "logFailureAndReturnNull", "Lkotlin/Function2;", "", "", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "mapSeries", "Lcom/atlassian/migration/jira/servicedesk/report/Series;", "series", "Lcom/atlassian/jira/migration/export/db/servicedesk/report/Series;", "mapSeriesList", "", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nReportExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportExporter.kt\ncom/atlassian/jira/migration/export/servicedesk/report/ReportExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1603#2,9:126\n1855#2:135\n1856#2:137\n1612#2:138\n1#3:136\n*S KotlinDebug\n*F\n+ 1 ReportExporter.kt\ncom/atlassian/jira/migration/export/servicedesk/report/ReportExporter\n*L\n75#1:126,9\n75#1:135\n75#1:137\n75#1:138\n75#1:136\n*E\n"})
public final class ReportExporter
implements Exporter<Long, Report, com.atlassian.migration.jira.servicedesk.report.Report> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ExporterKey key;
    @NotNull
    private final Function2 logFailureAndReturnNull;
    private static final Logger log = LoggerFactory.getLogger(ReportExporter.class);
    @NotNull
    private static final Map<SeriesDataType, SeriesDataTypeKeys> seriesDataTypeToSeriesDataTypeKeys;
    public static final long SERIES_LIMIT = 20L;

    @Inject
    public ReportExporter(@NotNull ExportService exportService, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.exportService = exportService;
        this.migrationFeatures = migrationFeatures;
        this.key = new ExporterKey(com.atlassian.migration.jira.servicedesk.report.Report.Companion.getEntityType());
        this.logFailureAndReturnNull = logFailureAndReturnNull.1.INSTANCE;
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, Report.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(com.atlassian.migration.jira.servicedesk.report.Report.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull Report entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public com.atlassian.migration.jira.servicedesk.report.Report exportData(@NotNull ExportContext ctx, @NotNull Report entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        log.info("Exporting report [" + entity.getId() + "] for project [" + ctx.getProject() + "] by [" + ctx.getStartedBy() + ']');
        MRI entityMri = this.mriForEntity(entity);
        return new com.atlassian.migration.jira.servicedesk.report.Report(entityMri, this.exportService.checkExportedOrThrow(ctx, Servicedesk.Companion.getEntityType(), entity.getServicedeskId(), (Function1<? super MRI, ? extends Exception>)((Function1)new Function1<MRI, Exception>(entityMri, entity){
            final /* synthetic */ MRI $entityMri;
            final /* synthetic */ Report $entity;
            {
                this.$entityMri = $entityMri;
                this.$entity = $entity;
                super(1);
            }

            @NotNull
            public final Exception invoke(@NotNull MRI mri) {
                Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
                String string = "Report with MRI - " + this.$entityMri + " has missing Service Desk with MRI - " + mri + '.';
                String string2 = "Verify if Service Desk with id " + this.$entity.getServicedeskId() + " is valid";
                ExportErrorCode exportErrorCode = ExportErrorCode.JSD_REQUIRED_REFERRED_ENTITY_NOT_EXPORTED;
                return new ExportException(this.$entityMri, exportErrorCode, string, string2, null, null, null, 112, null);
            }
        })), entity.getName(), Long.valueOf(entity.getTarget()), entity.getCreatedDate(), entity.getUpdatedDate(), this.mapSeriesList(entity, ctx), null, 128, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Series> mapSeriesList(Report entity, ExportContext ctx) {
        List list;
        if (!this.migrationFeatures.getDisableReportSeriesLimitFix() && entity.getSeries() != null) {
            List<com.atlassian.jira.migration.export.db.servicedesk.report.Series> list2 = entity.getSeries();
            Intrinsics.checkNotNull(list2);
            if ((long)list2.size() > 20L) {
                throw new ExportException(this.mriForEntity(entity), ExportErrorCode.JSD_TOO_MANY_SERIES_IN_REPORT, "Report with name " + entity.getName() + " has more than 20 series.", "Reduce the series list in report " + entity.getName() + " to 20.", null, null, null, 112, null);
            }
        }
        List<com.atlassian.jira.migration.export.db.servicedesk.report.Series> list3 = entity.getSeries();
        if (list3 != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list3;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Series it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                com.atlassian.jira.migration.export.db.servicedesk.report.Series it = (com.atlassian.jira.migration.export.db.servicedesk.report.Series)element$iv$iv;
                boolean bl2 = false;
                if (this.mapSeries(it, ctx) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final Series mapSeries(com.atlassian.jira.migration.export.db.servicedesk.report.Series series, ExportContext ctx) {
        MRI mRI;
        MRI mRI2;
        MRI mRI3;
        long it;
        SeriesDataTypeKeys seriesDataTypeKeys;
        String string;
        String string2;
        JQL jQL;
        com.atlassian.jira.migration.export.db.servicedesk.report.Series $this$mapSeries_u24lambda_u243 = series;
        boolean bl = false;
        SeriesDataTypeKeys seriesDataTypeKeys2 = seriesDataTypeToSeriesDataTypeKeys.get((Object)$this$mapSeries_u24lambda_u243.getSeriesDataType());
        if (seriesDataTypeKeys2 == null) {
            return (Series)this.logFailureAndReturnNull.invoke((Object)"series type", (Object)$this$mapSeries_u24lambda_u243.getSeriesDataType().toString());
        }
        String string3 = StringUtils.INSTANCE.trimString($this$mapSeries_u24lambda_u243.getLabel(), 40, true);
        String string4 = $this$mapSeries_u24lambda_u243.getColor();
        JQL jQL2 = new JQL($this$mapSeries_u24lambda_u243.getJql());
        Long l = $this$mapSeries_u24lambda_u243.getTimeMetricId();
        if (l != null) {
            long l2 = ((Number)l).longValue();
            jQL = jQL2;
            string2 = string4;
            string = string3;
            seriesDataTypeKeys = seriesDataTypeKeys2;
            boolean bl2 = false;
            MRI mRI4 = this.exportService.getExportedOrNull(ctx, TimeMetric.Companion.getEntityType(), it);
            if (mRI4 == null) {
                return (Series)this.logFailureAndReturnNull.invoke((Object)"time metric", (Object)String.valueOf(it));
            }
            mRI3 = mRI4;
            seriesDataTypeKeys2 = seriesDataTypeKeys;
            string3 = string;
            string4 = string2;
            jQL2 = jQL;
            mRI2 = mRI3;
        } else {
            mRI2 = null;
        }
        Long l3 = $this$mapSeries_u24lambda_u243.getGoalId();
        if (l3 != null) {
            it = ((Number)l3).longValue();
            mRI3 = mRI2;
            jQL = jQL2;
            string2 = string4;
            string = string3;
            seriesDataTypeKeys = seriesDataTypeKeys2;
            boolean bl3 = false;
            MRI mRI5 = this.exportService.getExportedOrNull(ctx, TimeMetric.Goal.Companion.getEntityType(), it);
            if (mRI5 == null) {
                return (Series)this.logFailureAndReturnNull.invoke((Object)"time metric goal", (Object)String.valueOf(it));
            }
            MRI mRI6 = mRI5;
            seriesDataTypeKeys2 = seriesDataTypeKeys;
            string3 = string;
            string4 = string2;
            jQL2 = jQL;
            mRI2 = mRI3;
            mRI = mRI6;
        } else {
            mRI = null;
        }
        Date date = $this$mapSeries_u24lambda_u243.getUpdatedDate();
        Date date2 = $this$mapSeries_u24lambda_u243.getCreatedDate();
        MRI mRI7 = mRI;
        MRI mRI8 = mRI2;
        JQL jQL3 = jQL2;
        String string5 = string4;
        String string6 = string3;
        SeriesDataTypeKeys seriesDataTypeKeys3 = seriesDataTypeKeys2;
        return new Series(seriesDataTypeKeys3, string6, string5, jQL3, mRI8, mRI7, date2, date);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull Report entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public Report extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull Report entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)SeriesDataType.CREATED_COUNT_SERIES_TYPE_KEY), (Object)SeriesDataTypeKeys.CREATED_COUNT_SERIES_TYPE_KEY), TuplesKt.to((Object)((Object)SeriesDataType.RESOLVED_COUNT_SERIES_TYPE_KEY), (Object)SeriesDataTypeKeys.RESOLVED_COUNT_SERIES_TYPE_KEY), TuplesKt.to((Object)((Object)SeriesDataType.TIME_METRIC_ELAPSED_TIME_SERIES_TYPE_KEY), (Object)SeriesDataTypeKeys.TIME_METRIC_ELAPSED_TIME_SERIES_TYPE_KEY), TuplesKt.to((Object)((Object)SeriesDataType.SLA_SUCCEEDED_SERIES_TYPE_KEY), (Object)SeriesDataTypeKeys.SLA_SUCCEEDED_SERIES_TYPE_KEY), TuplesKt.to((Object)((Object)SeriesDataType.SLA_BREACHED_SERIES_TYPE_KEY), (Object)SeriesDataTypeKeys.SLA_BREACHED_SERIES_TYPE_KEY), TuplesKt.to((Object)((Object)SeriesDataType.AVERAGE_RATING_SERIES_TYPE_KEY), (Object)SeriesDataTypeKeys.AVERAGE_RATING_SERIES_TYPE_KEY), TuplesKt.to((Object)((Object)SeriesDataType.PERCENTAGE_SERIES_TYPE_KEY), (Object)SeriesDataTypeKeys.PERCENTAGE_SERIES_TYPE_KEY)};
        seriesDataTypeToSeriesDataTypeKeys = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/report/ReportExporter$Companion;", "", "()V", "SERIES_LIMIT", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "seriesDataTypeToSeriesDataTypeKeys", "", "Lcom/atlassian/jira/migration/export/db/servicedesk/report/SeriesDataType;", "Lcom/atlassian/migration/jira/servicedesk/report/SeriesDataTypeKeys;", "getSeriesDataTypeToSeriesDataTypeKeys", "()Ljava/util/Map;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<SeriesDataType, SeriesDataTypeKeys> getSeriesDataTypeToSeriesDataTypeKeys() {
            return seriesDataTypeToSeriesDataTypeKeys;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

