/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.requesttype;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.db.servicedesk.requesttype.QRequestTypeField;
import com.atlassian.jira.migration.db.servicedesk.requesttype.RequestType;
import com.atlassian.jira.migration.db.servicedesk.requesttype.RequestTypeFieldsReader;
import com.atlassian.jira.migration.export.servicedesk.requesttype.RequestTypeService;
import com.atlassian.jira.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001d\u001a\u00020\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u001e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/requesttype/RequestTypeExporterUtils;", "", "issueFactory", "Lcom/atlassian/jira/issue/IssueFactory;", "requestTypeFieldsReader", "Lcom/atlassian/jira/migration/db/servicedesk/requesttype/RequestTypeFieldsReader;", "issueTypeManager", "Lcom/atlassian/jira/config/IssueTypeManager;", "requestTypeService", "Lcom/atlassian/jira/migration/export/servicedesk/requesttype/RequestTypeService;", "issueTypeScreenSchemeManager", "Lcom/atlassian/jira/issue/fields/screen/issuetype/IssueTypeScreenSchemeManager;", "(Lcom/atlassian/jira/issue/IssueFactory;Lcom/atlassian/jira/migration/db/servicedesk/requesttype/RequestTypeFieldsReader;Lcom/atlassian/jira/config/IssueTypeManager;Lcom/atlassian/jira/migration/export/servicedesk/requesttype/RequestTypeService;Lcom/atlassian/jira/issue/fields/screen/issuetype/IssueTypeScreenSchemeManager;)V", "createIssue", "Lcom/atlassian/jira/issue/Issue;", "project", "Lcom/atlassian/jira/project/Project;", "issueType", "Lcom/atlassian/jira/issue/issuetype/IssueType;", "getAllCreateScreenFieldIds", "", "", "getFieldIds", "getValidRequestTypeFields", "Lcom/atlassian/jira/migration/db/servicedesk/requesttype/QRequestTypeField;", "requestType", "Lcom/atlassian/jira/migration/db/servicedesk/requesttype/RequestType;", "hasAssociatedFieldScreenSchemeItems", "", "hasSummary", "fieldIds", "isValidField", "requestTypeId", "", "requestTypeFieldId", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nRequestTypeExporterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestTypeExporterUtils.kt\ncom/atlassian/jira/migration/export/servicedesk/requesttype/RequestTypeExporterUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n3190#2,10:103\n1549#2:113\n1620#2,3:114\n1360#2:117\n1446#2,5:118\n1360#2:123\n1446#2,5:124\n1603#2,9:129\n1855#2:138\n1856#2:140\n1612#2:141\n1#3:139\n*S KotlinDebug\n*F\n+ 1 RequestTypeExporterUtils.kt\ncom/atlassian/jira/migration/export/servicedesk/requesttype/RequestTypeExporterUtils\n*L\n37#1:103,10\n51#1:113\n51#1:114,3\n82#1:117\n82#1:118,5\n83#1:123\n83#1:124,5\n84#1:129,9\n84#1:138\n84#1:140\n84#1:141\n84#1:139\n*E\n"})
public final class RequestTypeExporterUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IssueFactory issueFactory;
    @NotNull
    private final RequestTypeFieldsReader requestTypeFieldsReader;
    @NotNull
    private final IssueTypeManager issueTypeManager;
    @NotNull
    private final RequestTypeService requestTypeService;
    @NotNull
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private static final Logger log = LoggerFactory.getLogger(RequestTypeExporterUtils.class);

    @Inject
    public RequestTypeExporterUtils(@NotNull IssueFactory issueFactory, @NotNull RequestTypeFieldsReader requestTypeFieldsReader, @NotNull IssueTypeManager issueTypeManager, @NotNull RequestTypeService requestTypeService, @NotNull IssueTypeScreenSchemeManager issueTypeScreenSchemeManager) {
        Intrinsics.checkNotNullParameter((Object)issueFactory, (String)"issueFactory");
        Intrinsics.checkNotNullParameter((Object)requestTypeFieldsReader, (String)"requestTypeFieldsReader");
        Intrinsics.checkNotNullParameter((Object)issueTypeManager, (String)"issueTypeManager");
        Intrinsics.checkNotNullParameter((Object)requestTypeService, (String)"requestTypeService");
        Intrinsics.checkNotNullParameter((Object)issueTypeScreenSchemeManager, (String)"issueTypeScreenSchemeManager");
        this.issueFactory = issueFactory;
        this.requestTypeFieldsReader = requestTypeFieldsReader;
        this.issueTypeManager = issueTypeManager;
        this.requestTypeService = requestTypeService;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<QRequestTypeField> getValidRequestTypeFields(@NotNull Project project, @NotNull RequestType requestType) {
        void $this$partition$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)requestType, (String)"requestType");
        IssueType issueType = this.issueTypeManager.getIssueType(String.valueOf(requestType.getIssueTypeId()));
        Intrinsics.checkNotNull((Object)issueType);
        List<String> screenSchemeFieldIds = this.getAllCreateScreenFieldIds(project, issueType);
        Iterable iterable = this.requestTypeFieldsReader.getRequestTypeFields(requestType.getId());
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            QRequestTypeField it = (QRequestTypeField)element$iv;
            boolean bl = false;
            if (screenSchemeFieldIds.contains(it.getHeaders().getField())) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List validFieldIdList = (List)pair.component1();
        List invalidFieldIdList = (List)pair.component2();
        if (!((Collection)invalidFieldIdList).isEmpty()) {
            log.warn("Request Type with id: " + requestType.getId() + " has invalid fields ids: " + invalidFieldIdList);
        }
        return validFieldIdList;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidField(@NotNull Project project, int requestTypeId2, @NotNull String requestTypeFieldId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)requestTypeFieldId, (String)"requestTypeFieldId");
        RequestType requestType = this.requestTypeService.getRequestTypeWithoutGroupsByIdOrNull(requestTypeId2);
        if (requestType == null) {
            log.error("Invalid requestType response for id: " + requestTypeId2);
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getValidRequestTypeFields(project, requestType);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                QRequestTypeField qRequestTypeField = (QRequestTypeField)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getHeaders().getField());
            }
            List validList = (List)destination$iv$iv;
            if (validList.contains(requestTypeFieldId)) {
                return true;
            }
        }
        return false;
    }

    private final List<String> getAllCreateScreenFieldIds(Project project, IssueType issueType) {
        List fieldIds = CollectionsKt.toMutableList((Collection)CollectionsKt.distinct((Iterable)this.getFieldIds(project, issueType)));
        if (!this.hasSummary(fieldIds)) {
            fieldIds.add("summary");
        }
        return fieldIds;
    }

    private final Issue createIssue(Project project, IssueType issueType) {
        MutableIssue issue2 = this.issueFactory.getIssue();
        issue2.setProjectObject(project);
        issue2.setIssueTypeObject(issueType);
        Intrinsics.checkNotNull((Object)issue2);
        return (Issue)issue2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getFieldIds(Project project, IssueType issueType) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable list$iv$iv;
        FieldScreenSchemeItem it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Issue issue2 = this.createIssue(project, issueType);
        Collection collection = this.issueTypeScreenSchemeManager.getFieldScreenScheme(issue2).getFieldScreenSchemeItems();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFieldScreenSchemeItems(...)");
        Iterable iterable = collection;
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (FieldScreenSchemeItem)element$iv$iv;
            boolean bl = false;
            List list = it.getFieldScreen().getTabs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTabs(...)");
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (FieldScreenTab)element$iv$iv;
            boolean bl = false;
            List list = it.getFieldScreenLayoutItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFieldScreenLayoutItems(...)");
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FieldScreenLayoutItem it2 = (FieldScreenLayoutItem)element$iv$iv;
            boolean bl2 = false;
            OrderableField orderableField = it2.getOrderableField();
            if ((orderableField != null ? orderableField.getId() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean hasAssociatedFieldScreenSchemeItems(@NotNull Project project, @NotNull RequestType requestType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)requestType, (String)"requestType");
        IssueType issueType = this.issueTypeManager.getIssueType(String.valueOf(requestType.getIssueTypeId()));
        Intrinsics.checkNotNull((Object)issueType);
        Issue issue2 = this.createIssue(project, issueType);
        Collection collection = this.issueTypeScreenSchemeManager.getFieldScreenScheme(issue2).getFieldScreenSchemeItems();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFieldScreenSchemeItems(...)");
        return !collection.isEmpty();
    }

    private final boolean hasSummary(List<String> fieldIds) {
        return fieldIds.contains("summary");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/requesttype/RequestTypeExporterUtils$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

