/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.service;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.migration.db.servicedesk.ServiceDeskCoreDataReader;
import com.atlassian.jira.migration.export.db.servicedesk.approval.ApprovalData;
import com.atlassian.jira.migration.export.db.servicedesk.notification.NotificationInstanceData;
import com.atlassian.jira.migration.export.db.servicedesk.notification.NotificationInstanceReader;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.servicedesk.approval.ApprovalService;
import com.atlassian.jira.migration.export.servicedesk.service.JsdExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.Project;
import com.atlassian.servicedesk.api.ServiceDesk;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/service/JsdExportServiceImpl;", "Lcom/atlassian/jira/migration/export/servicedesk/service/JsdExportService;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "serviceDeskCoreDataReader", "Lcom/atlassian/jira/migration/db/servicedesk/ServiceDeskCoreDataReader;", "approvalService", "Lcom/atlassian/jira/migration/export/servicedesk/approval/ApprovalService;", "notificationInstanceReader", "Lcom/atlassian/jira/migration/export/db/servicedesk/notification/NotificationInstanceReader;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/db/servicedesk/ServiceDeskCoreDataReader;Lcom/atlassian/jira/migration/export/servicedesk/approval/ApprovalService;Lcom/atlassian/jira/migration/export/db/servicedesk/notification/NotificationInstanceReader;)V", "exportApprovals", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "issue", "Lcom/atlassian/jira/issue/Issue;", "exportNotificationInstances", "exportServiceDesk", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJsdExportServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsdExportServiceImpl.kt\ncom/atlassian/jira/migration/export/servicedesk/service/JsdExportServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1855#2,2:49\n1855#2,2:51\n*S KotlinDebug\n*F\n+ 1 JsdExportServiceImpl.kt\ncom/atlassian/jira/migration/export/servicedesk/service/JsdExportServiceImpl\n*L\n37#1:49,2\n43#1:51,2\n*E\n"})
public final class JsdExportServiceImpl
implements JsdExportService {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ServiceDeskCoreDataReader serviceDeskCoreDataReader;
    @NotNull
    private final ApprovalService approvalService;
    @NotNull
    private final NotificationInstanceReader notificationInstanceReader;

    public JsdExportServiceImpl(@NotNull ExportService exportService, @NotNull ServiceDeskCoreDataReader serviceDeskCoreDataReader, @NotNull ApprovalService approvalService, @NotNull NotificationInstanceReader notificationInstanceReader) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)serviceDeskCoreDataReader, (String)"serviceDeskCoreDataReader");
        Intrinsics.checkNotNullParameter((Object)approvalService, (String)"approvalService");
        Intrinsics.checkNotNullParameter((Object)notificationInstanceReader, (String)"notificationInstanceReader");
        this.exportService = exportService;
        this.serviceDeskCoreDataReader = serviceDeskCoreDataReader;
        this.approvalService = approvalService;
        this.notificationInstanceReader = notificationInstanceReader;
    }

    @Override
    public void exportServiceDesk(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ServiceDesk serviceDesk = this.serviceDeskCoreDataReader.getServiceDeskByProject(ctx.getProject());
        if (serviceDesk == null) {
            MRI mRI = MriExtensionsKt.mri$default(Project.Companion.getEntityType(), ctx.getProject(), null, 2, null);
            String string = "Failed to retrieve Service Desk for project with id - " + ctx.getProject().getId() + ", project key - " + ctx.getProject().getKey();
            String string2 = "Verify if Project with id " + ctx.getProject().getId() + " is valid";
            ExportErrorCode exportErrorCode = ExportErrorCode.JSD_ENTITY_RETRIEVAL_ERROR;
            throw new ExportException(mRI, exportErrorCode, string, string2, null, null, null, 112, null);
        }
        ServiceDesk currentServiceDesk = serviceDesk;
        ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, currentServiceDesk, false, 4, null);
    }

    @Override
    public void exportApprovals(@NotNull ExportContext ctx, @NotNull Issue issue2) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        Long l = issue2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        Iterable $this$forEach$iv = this.approvalService.getApprovalsByIssueId(((Number)l).longValue());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ApprovalData approval = (ApprovalData)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, approval, false, 4, null);
        }
    }

    @Override
    public void exportNotificationInstances(@NotNull ExportContext ctx, @NotNull Issue issue2) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        Long l = issue2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        Iterable $this$forEach$iv = this.notificationInstanceReader.getAllNotificationInstancesByIssueId(((Number)l).longValue());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotificationInstanceData notification = (NotificationInstanceData)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, notification, false, 4, null);
        }
    }
}

