/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.timemetric;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.db.servicedesk.timemetric.TimeMetricData;
import com.atlassian.jira.migration.db.servicedesk.timemetric.TimeMetricGoalsData;
import com.atlassian.jira.migration.db.servicedesk.timemetric.TimeMetricGoalsReader;
import com.atlassian.jira.migration.export.db.servicedesk.timemetric.SLAThresholdData;
import com.atlassian.jira.migration.export.db.servicedesk.timemetric.SLAThresholdReader;
import com.atlassian.jira.migration.export.db.servicedesk.timemetric.TimeMetricMetricConditionRefData;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.servicedesk.timemetric.TimeMetricConditionService;
import com.atlassian.jira.migration.export.utils.ExportFilters;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.servicedesk.Servicedesk;
import com.atlassian.migration.jira.servicedesk.TimeMetric;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 +2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001+B7\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0002H\u0002J\u0010\u0010&\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020\u0002H\u0016J\b\u0010)\u001a\u00020*H\u0007R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/timemetric/TimeMetricExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/db/servicedesk/timemetric/TimeMetricData;", "Lcom/atlassian/migration/jira/servicedesk/TimeMetric;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "timeMetricGoalsReader", "Lcom/atlassian/jira/migration/db/servicedesk/timemetric/TimeMetricGoalsReader;", "timeMetricConditionService", "Lcom/atlassian/jira/migration/export/servicedesk/timemetric/TimeMetricConditionService;", "slaThresholdReader", "Lcom/atlassian/jira/migration/export/db/servicedesk/timemetric/SLAThresholdReader;", "customFieldManager", "Lcom/atlassian/jira/issue/CustomFieldManager;", "exportFilters", "Lcom/atlassian/jira/migration/export/utils/ExportFilters;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/db/servicedesk/timemetric/TimeMetricGoalsReader;Lcom/atlassian/jira/migration/export/servicedesk/timemetric/TimeMetricConditionService;Lcom/atlassian/jira/migration/export/db/servicedesk/timemetric/SLAThresholdReader;Lcom/atlassian/jira/issue/CustomFieldManager;Lcom/atlassian/jira/migration/export/utils/ExportFilters;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "getMetricConditionRef", "", "Lcom/atlassian/migration/jira/servicedesk/TimeMetric$MetricConditionRef;", "id", "", "getSlaThreshold", "Lcom/atlassian/migration/jira/servicedesk/TimeMetric$SlaThreshold;", "getTimeMetricGoals", "Lcom/atlassian/migration/jira/servicedesk/TimeMetric$Goal;", "mapCustomField", "Lcom/atlassian/migration/base/mri/MRI;", "customFieldId", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nTimeMetricExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeMetricExporter.kt\ncom/atlassian/jira/migration/export/servicedesk/timemetric/TimeMetricExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1#2:106\n1549#3:107\n1620#3,3:108\n1549#3:111\n1620#3,3:112\n1549#3:115\n1620#3,3:116\n*S KotlinDebug\n*F\n+ 1 TimeMetricExporter.kt\ncom/atlassian/jira/migration/export/servicedesk/timemetric/TimeMetricExporter\n*L\n80#1:107\n80#1:108,3\n93#1:111\n93#1:112,3\n97#1:115\n97#1:116,3\n*E\n"})
public final class TimeMetricExporter
implements Exporter<Long, TimeMetricData, TimeMetric> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final TimeMetricGoalsReader timeMetricGoalsReader;
    @NotNull
    private final TimeMetricConditionService timeMetricConditionService;
    @NotNull
    private final SLAThresholdReader slaThresholdReader;
    @NotNull
    private final CustomFieldManager customFieldManager;
    @NotNull
    private final ExportFilters exportFilters;
    @NotNull
    private final ExporterKey key;
    private static final Logger log = LoggerFactory.getLogger(TimeMetricExporter.class);

    @Inject
    public TimeMetricExporter(@NotNull ExportService exportService, @NotNull TimeMetricGoalsReader timeMetricGoalsReader, @NotNull TimeMetricConditionService timeMetricConditionService, @NotNull SLAThresholdReader slaThresholdReader, @NotNull CustomFieldManager customFieldManager, @NotNull ExportFilters exportFilters) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)timeMetricGoalsReader, (String)"timeMetricGoalsReader");
        Intrinsics.checkNotNullParameter((Object)timeMetricConditionService, (String)"timeMetricConditionService");
        Intrinsics.checkNotNullParameter((Object)slaThresholdReader, (String)"slaThresholdReader");
        Intrinsics.checkNotNullParameter((Object)customFieldManager, (String)"customFieldManager");
        Intrinsics.checkNotNullParameter((Object)exportFilters, (String)"exportFilters");
        this.exportService = exportService;
        this.timeMetricGoalsReader = timeMetricGoalsReader;
        this.timeMetricConditionService = timeMetricConditionService;
        this.slaThresholdReader = slaThresholdReader;
        this.customFieldManager = customFieldManager;
        this.exportFilters = exportFilters;
        this.key = new ExporterKey(TimeMetric.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, TimeMetricData.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull TimeMetricData entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(TimeMetric.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public TimeMetric exportData(@NotNull ExportContext ctx, @NotNull TimeMetricData entity) {
        Long l;
        String string;
        MRI mRI;
        MRI mRI2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                mRI2 = this.mriForEntity(entity);
                mRI = MriExtensionsKt.mri$default(Servicedesk.Companion.getEntityType(), entity.getServiceDeskId(), null, 2, null);
                string = entity.getName();
                l = entity.getCustomFieldId();
                if (l == null) break block2;
                long it = ((Number)l).longValue();
                boolean bl = false;
                MRI mRI3 = this.mapCustomField(ctx, it);
                l = mRI3;
                if (mRI3 != null) break block3;
            }
            MRI mRI4 = this.mriForEntity(entity);
            String string2 = "Check if TimeMetric with ID " + entity.getId() + " is valid";
            ExportErrorCode exportErrorCode = ExportErrorCode.JSD_REQUIRED_REFERENCE_NOT_FOUND;
            throw new ExportException(mRI4, exportErrorCode, "Referenced custom field cannot be null.", string2, null, null, null, 112, null);
        }
        Long l2 = l;
        Long l3 = entity.getCreatedDate();
        Long l4 = entity.getDefinitionChangeMsEpoch();
        Long l5 = entity.getGoalsChangeMsEpoch();
        Long l6 = entity.getThresholdsChangedMsEpoch();
        List<TimeMetric.Goal> list = this.getTimeMetricGoals(ctx, entity.getId());
        List<TimeMetric.MetricConditionRef> list2 = this.getMetricConditionRef(ctx, entity.getId());
        List<TimeMetric.SlaThreshold> list3 = this.getSlaThreshold(ctx, entity.getId());
        return new TimeMetric(mRI2, mRI, string, (MRI)l2, l4, l5, l6, l3, list, list2, list3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final MRI mapCustomField(ExportContext ctx, long customFieldId) {
        CustomField customField;
        CustomField customField2;
        CustomField it = customField2 = this.customFieldManager.getCustomFieldObject(Long.valueOf(customFieldId));
        boolean bl = false;
        if (it == null) {
            log.warn("has reference to field " + customFieldId + " which cannot be found by CustomFieldManager. Skipping...");
        }
        CustomField customField3 = customField2;
        if (customField3 == null) return null;
        CustomField it2 = customField = customField3;
        boolean bl2 = false;
        if (!this.exportFilters.isSupportedField(ctx, (Field)it2)) return null;
        CustomField customField4 = customField;
        customField2 = customField4;
        if (customField2 == null) return null;
        it2 = customField2;
        boolean bl3 = false;
        MRI mRI = ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it2, false, 4, null);
        return mRI;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TimeMetric.Goal> getTimeMetricGoals(ExportContext ctx, int id) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean defaultGoal = false;
        Iterable iterable = CollectionsKt.reversed((Iterable)this.timeMetricGoalsReader.getGoalsByTimeMetricId(id));
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void goal;
            TimeMetricGoalsData timeMetricGoalsData = (TimeMetricGoalsData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (goal.getDefaultGoal()) {
                if (defaultGoal) {
                    goal.setDefaultGoal(false);
                }
                defaultGoal = true;
            }
            collection.add(this.exportService.exportObjectOrThrow(ctx, goal, TimeMetric.Goal.class));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TimeMetric.MetricConditionRef> getMetricConditionRef(ExportContext ctx, int id) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.timeMetricConditionService.getTimeMetricCondition(id);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TimeMetricMetricConditionRefData timeMetricMetricConditionRefData = (TimeMetricMetricConditionRefData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.exportService.exportObjectOrThrow(ctx, it, TimeMetric.MetricConditionRef.class));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TimeMetric.SlaThreshold> getSlaThreshold(ExportContext ctx, int id) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.slaThresholdReader.getSLAThresholdByTimeMetricId(id);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void slaThreshold;
            SLAThresholdData sLAThresholdData = (SLAThresholdData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.exportService.exportObjectOrThrow(ctx, slaThreshold, TimeMetric.SlaThreshold.class));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull TimeMetricData entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public TimeMetricData extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull TimeMetricData entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/timemetric/TimeMetricExporter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

