/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.timemetric;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.db.servicedesk.calendar.Calendar;
import com.atlassian.jira.migration.db.servicedesk.calendar.CalendarReader;
import com.atlassian.jira.migration.db.servicedesk.timemetric.TimeMetricGoalsData;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.core.JQL;
import com.atlassian.migration.jira.servicedesk.TimeMetric;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u00022\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0007R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/timemetric/TimeMetricGoalExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/db/servicedesk/timemetric/TimeMetricGoalsData;", "Lcom/atlassian/migration/jira/servicedesk/TimeMetric$Goal;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "calendarReader", "Lcom/atlassian/jira/migration/db/servicedesk/calendar/CalendarReader;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/db/servicedesk/calendar/CalendarReader;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "exportCalendar", "Lcom/atlassian/migration/base/mri/MRI;", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "calendarId", "", "exportData", "entity", "getValidGoalDuration", "goalDuration", "(Ljava/lang/Long;)Ljava/lang/Long;", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nTimeMetricGoalExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeMetricGoalExporter.kt\ncom/atlassian/jira/migration/export/servicedesk/timemetric/TimeMetricGoalExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class TimeMetricGoalExporter
implements Exporter<Long, TimeMetricGoalsData, TimeMetric.Goal> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final CalendarReader calendarReader;
    @NotNull
    private final ExporterKey key;

    @Inject
    public TimeMetricGoalExporter(@NotNull ExportService exportService, @NotNull CalendarReader calendarReader) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)calendarReader, (String)"calendarReader");
        this.exportService = exportService;
        this.calendarReader = calendarReader;
        this.key = new ExporterKey(TimeMetric.Goal.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, TimeMetricGoalsData.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull TimeMetricGoalsData entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(TimeMetric.Goal.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public TimeMetric.Goal exportData(@NotNull ExportContext ctx, @NotNull TimeMetricGoalsData entity) {
        JQL jQL;
        MRI mRI;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        MRI mRI2 = this.mriForEntity(entity);
        Integer n = entity.getCalendarId();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            mRI = this.exportCalendar(ctx, it);
        } else {
            mRI = null;
        }
        MRI mRI3 = mRI;
        boolean bl = entity.getDefaultGoal();
        Long l = this.getValidGoalDuration(entity.getDuration());
        String string = entity.getJqlQuery();
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            jQL = new JQL(it);
        } else {
            jQL = null;
        }
        JQL jQL2 = jQL;
        int n2 = entity.getPosition();
        Long l2 = entity.getTimeUpdatedMsEpoch();
        return new TimeMetric.Goal(mRI2, jQL2, l, mRI3, bl, n2, null, l2, 64, null);
    }

    private final MRI exportCalendar(ExportContext ctx, int calendarId) {
        MRI mRI;
        Calendar calendar = this.calendarReader.getCalendarById(calendarId);
        if (calendar != null) {
            Calendar it = calendar;
            boolean bl = false;
            mRI = ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        } else {
            mRI = null;
        }
        return mRI;
    }

    private final Long getValidGoalDuration(Long goalDuration) {
        Long l;
        Long l2 = goalDuration;
        if (l2 != null) {
            long it = ((Number)l2).longValue();
            boolean bl = false;
            l = it <= 0L ? null : Long.valueOf(it);
        } else {
            l = null;
        }
        return l;
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull TimeMetricGoalsData entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public TimeMetricGoalsData extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull TimeMetricGoalsData entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

