/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.servicedesk.timemetric;

import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.db.servicedesk.timemetric.TimeMetricData;
import com.atlassian.jira.migration.db.servicedesk.timemetric.TimeMetricReader;
import com.atlassian.jira.migration.export.db.servicedesk.timemetric.TimeMetricMetricConditionRefData;
import com.atlassian.jira.migration.export.servicedesk.timemetric.TimeMetricConditionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/timemetric/TimeMetricService;", "", "timeMetricReader", "Lcom/atlassian/jira/migration/db/servicedesk/timemetric/TimeMetricReader;", "timeMetricConditionService", "Lcom/atlassian/jira/migration/export/servicedesk/timemetric/TimeMetricConditionService;", "(Lcom/atlassian/jira/migration/db/servicedesk/timemetric/TimeMetricReader;Lcom/atlassian/jira/migration/export/servicedesk/timemetric/TimeMetricConditionService;)V", "getTimeMetricByServiceDeskId", "", "Lcom/atlassian/jira/migration/db/servicedesk/timemetric/TimeMetricData;", "serviceDeskId", "", "isValidMetricCondition", "", "id", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nTimeMetricService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeMetricService.kt\ncom/atlassian/jira/migration/export/servicedesk/timemetric/TimeMetricService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n766#2:35\n857#2,2:36\n1747#2,3:38\n*S KotlinDebug\n*F\n+ 1 TimeMetricService.kt\ncom/atlassian/jira/migration/export/servicedesk/timemetric/TimeMetricService\n*L\n19#1:35\n19#1:36,2\n23#1:38,3\n*E\n"})
public final class TimeMetricService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TimeMetricReader timeMetricReader;
    @NotNull
    private final TimeMetricConditionService timeMetricConditionService;
    private static final Logger log = LoggerFactory.getLogger(TimeMetricService.class);

    @Inject
    public TimeMetricService(@NotNull TimeMetricReader timeMetricReader, @NotNull TimeMetricConditionService timeMetricConditionService) {
        Intrinsics.checkNotNullParameter((Object)timeMetricReader, (String)"timeMetricReader");
        Intrinsics.checkNotNullParameter((Object)timeMetricConditionService, (String)"timeMetricConditionService");
        this.timeMetricReader = timeMetricReader;
        this.timeMetricConditionService = timeMetricConditionService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TimeMetricData> getTimeMetricByServiceDeskId(int serviceDeskId) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.timeMetricReader.getTimeMetricByServiceDeskId(serviceDeskId);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TimeMetricData it = (TimeMetricData)element$iv$iv;
            boolean bl = false;
            if (!this.isValidMetricCondition(it.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidMetricCondition(int id) {
        TimeMetricMetricConditionRefData it;
        boolean bl;
        boolean $i$f$any;
        Iterable $this$any$iv;
        List<TimeMetricMetricConditionRefData> validMetricConditionRefs;
        block8: {
            validMetricConditionRefs = this.timeMetricConditionService.getTimeMetricCondition(id);
            $this$any$iv = validMetricConditionRefs;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (TimeMetricMetricConditionRefData)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)"Start")) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            boolean bl3;
            $this$any$iv = validMetricConditionRefs;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl3 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (TimeMetricMetricConditionRefData)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)"Stop")) continue;
                    return true;
                }
                bl3 = false;
            }
            if (bl3) {
                return true;
            }
        }
        boolean bl5 = false;
        boolean hasAtLeastOneStartStopCondition = bl5;
        if (hasAtLeastOneStartStopCondition) return hasAtLeastOneStartStopCondition;
        log.warn("TimeMetric with ID " + id + " does not have at least one valid start and stop conditions. Skipped from exporting.");
        return hasAtLeastOneStartStopCondition;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/servicedesk/timemetric/TimeMetricService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

