/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.site;

import com.atlassian.activeobjects.spi.ActiveObjectsImportExportException;
import com.atlassian.activeobjects.spi.Backup;
import com.atlassian.activeobjects.spi.BackupProgressMonitor;
import com.atlassian.activeobjects.spi.NullBackupProgressMonitor;
import com.atlassian.jira.action.admin.export.DefaultEntityXmlWriter;
import com.atlassian.jira.action.admin.export.EntityXmlWriter;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.migration.export.site.MigrationSaxEntitiesExporter;
import com.atlassian.jira.migration.export.site.SiteExportService;
import com.atlassian.jira.migration.export.site.utils.ActiveObjectsExportProgressMonitor;
import com.atlassian.jira.migration.export.site.utils.EntitiesExportProgressMonitor;
import com.atlassian.jira.migration.export.site.utils.EntitiesExportProgressMonitorImpl;
import com.atlassian.jira.migration.export.site.utils.EntityExclusionUtil;
import com.atlassian.jira.migration.export.site.utils.NullEntitiesExportProgressMonitorImpl;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.java.ao.ActiveObjectsException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.model.ModelReader;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0004J(\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0004J<\u0010\u001c\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\u00112\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00110\u001f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0016J<\u0010!\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\u00112\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00110\u001f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H&J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/atlassian/jira/migration/export/site/AbstractSiteExportService;", "Lcom/atlassian/jira/migration/export/site/SiteExportService;", "entitiesExporter", "Lcom/atlassian/jira/migration/export/site/MigrationSaxEntitiesExporter;", "genericDelegator", "Lorg/ofbiz/core/entity/DelegatorInterface;", "jiraSystemProperties", "Lcom/atlassian/jira/config/properties/JiraProperties;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/export/site/MigrationSaxEntitiesExporter;Lorg/ofbiz/core/entity/DelegatorInterface;Lcom/atlassian/jira/config/properties/JiraProperties;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "entitiesToExport", "Ljava/util/TreeSet;", "", "exportActiveObjects", "", "out", "Ljava/io/OutputStream;", "heartbeat", "Lkotlin/Function0;", "exportJIRA", "loggedInUser", "Lcom/atlassian/jira/user/ApplicationUser;", "outputStream", "exportWithAdditionalFiles", "exportPath", "filesToAdd", "", "Ljava/nio/file/Path;", "exportWithCompression", "getActiveObjectsBackup", "Lcom/atlassian/activeobjects/spi/Backup;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAbstractSiteExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSiteExportService.kt\ncom/atlassian/jira/migration/export/site/AbstractSiteExportService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,143:1\n215#2,2:144\n*S KotlinDebug\n*F\n+ 1 AbstractSiteExportService.kt\ncom/atlassian/jira/migration/export/site/AbstractSiteExportService\n*L\n58#1:144,2\n*E\n"})
public abstract class AbstractSiteExportService
implements SiteExportService {
    @NotNull
    private final MigrationSaxEntitiesExporter entitiesExporter;
    @NotNull
    private final DelegatorInterface genericDelegator;
    @NotNull
    private final JiraProperties jiraSystemProperties;
    @NotNull
    private final MigrationFeatures migrationFeatures;

    public AbstractSiteExportService(@NotNull MigrationSaxEntitiesExporter entitiesExporter, @NotNull DelegatorInterface genericDelegator, @NotNull JiraProperties jiraSystemProperties, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)entitiesExporter, (String)"entitiesExporter");
        Intrinsics.checkNotNullParameter((Object)genericDelegator, (String)"genericDelegator");
        Intrinsics.checkNotNullParameter((Object)jiraSystemProperties, (String)"jiraSystemProperties");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.entitiesExporter = entitiesExporter;
        this.genericDelegator = genericDelegator;
        this.jiraSystemProperties = jiraSystemProperties;
        this.migrationFeatures = migrationFeatures;
    }

    @NotNull
    protected abstract Logger getLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportWithAdditionalFiles(@Nullable ApplicationUser loggedInUser, @NotNull String exportPath, @NotNull Map<Path, String> filesToAdd, @NotNull Function0<Unit> heartbeat2) {
        Intrinsics.checkNotNullParameter((Object)exportPath, (String)"exportPath");
        Intrinsics.checkNotNullParameter(filesToAdd, (String)"filesToAdd");
        Intrinsics.checkNotNullParameter(heartbeat2, (String)"heartbeat");
        heartbeat2.invoke();
        try {
            this.exportWithCompression(loggedInUser, exportPath, filesToAdd, (Function0<Unit>)((Function0)new Function0<Unit>(heartbeat2){
                final /* synthetic */ Function0<Unit> $heartbeat;
                {
                    this.$heartbeat = $heartbeat;
                    super(0);
                }

                public final void invoke() {
                    this.$heartbeat.invoke();
                }
            }));
        }
        catch (GenericEntityException e) {
            this.getLog().error("GenericEntity Error during export", (Throwable)e);
            throw e;
        }
        catch (ActiveObjectsImportExportException e) {
            this.getLog().error("Error during Active Objects Backup", (Throwable)e);
            throw e;
        }
        finally {
            heartbeat2.invoke();
            Map<Path, String> $this$forEach$iv = filesToAdd;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Path, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<Path, String> element$iv;
                Map.Entry<Path, String> it = element$iv = iterator2.next();
                boolean bl = false;
                Files.deleteIfExists(it.getKey());
            }
        }
    }

    public abstract void exportWithCompression(@Nullable ApplicationUser var1, @NotNull String var2, @NotNull Map<Path, String> var3, @NotNull Function0<Unit> var4);

    protected final void exportJIRA(@Nullable ApplicationUser loggedInUser, @NotNull OutputStream outputStream, @NotNull Function0<Unit> heartbeat2) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter(heartbeat2, (String)"heartbeat");
        TreeSet<String> entityNames = this.entitiesToExport();
        this.getLog().info("numberOfEntities = " + entityNames.size());
        EntityXmlWriter entityWriter = (EntityXmlWriter)new DefaultEntityXmlWriter();
        long start = System.currentTimeMillis();
        EntitiesExportProgressMonitor progressMonitor = this.migrationFeatures.getDisableSinglePathExportHeartbeat() ? (EntitiesExportProgressMonitor)new NullEntitiesExportProgressMonitorImpl() : (EntitiesExportProgressMonitor)new EntitiesExportProgressMonitorImpl(heartbeat2);
        long entitiesWritten = this.entitiesExporter.exportEntities(outputStream, (SortedSet<String>)entityNames, entityWriter, loggedInUser, progressMonitor);
        this.getLog().info("Data export completed in " + (System.currentTimeMillis() - start) + "ms. Wrote " + entitiesWritten + " entities to export.");
    }

    private final TreeSet<String> entitiesToExport() {
        ModelReader modelReader = this.genericDelegator.getModelReader();
        Intrinsics.checkNotNullExpressionValue((Object)modelReader, (String)"getModelReader(...)");
        ModelReader reader = modelReader;
        TreeSet treeSet = Sets.newTreeSet((Iterable)((Iterable)Sets.difference((Set)Sets.newHashSet((Iterable)reader.getEntityNames()), EntityExclusionUtil.INSTANCE.getENTITIES_EXCLUDED_FROM_S2C_EXPORT())));
        Intrinsics.checkNotNullExpressionValue((Object)treeSet, (String)"newTreeSet(...)");
        return treeSet;
    }

    protected final void exportActiveObjects(@NotNull OutputStream out, @NotNull Function0<Unit> heartbeat2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter(heartbeat2, (String)"heartbeat");
        Backup ao = this.getActiveObjectsBackup();
        if (ao == null) {
            throw new ActiveObjectsException("Could not find ActiveObjects in OSGi fairy land");
        }
        this.getLog().info("Attempting to save the Active Objects Backup");
        BackupProgressMonitor progressMonitor = this.migrationFeatures.getDisableSinglePathExportHeartbeat() ? NullBackupProgressMonitor.INSTANCE : (BackupProgressMonitor)new ActiveObjectsExportProgressMonitor(heartbeat2);
        try {
            ao.save(out, progressMonitor);
        }
        catch (NoSuchMethodError ex) {
            String javaRuntimeVersion = this.jiraSystemProperties.getProperty("java.runtime.version");
            String message = "Error exporting Active Objects. You must run JRE 1.6_18 or higher. java.runtime.version: " + javaRuntimeVersion;
            this.getLog().error(message, (Throwable)ex);
            throw new NoSuchMethodError(message);
        }
        this.getLog().info("Finished saving the Active Objects Backup");
    }

    private final Backup getActiveObjectsBackup() {
        return (Backup)ComponentAccessor.getOSGiComponentInstanceOfType(Backup.class);
    }
}

