/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.site;

import com.atlassian.jira.migration.export.site.SiteBackupExportService;
import com.atlassian.jira.migration.export.site.SiteExportService;
import com.atlassian.jira.migration.export.site.SiteLZ4ExportService;
import com.atlassian.jira.migration.export.site.SiteMigrationExportService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/export/site/ExportServiceFactory;", "", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;Lorg/springframework/context/ApplicationContext;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "create", "Lcom/atlassian/jira/migration/export/site/SiteExportService;", "jira-migration-plugin"})
public final class ExportServiceFactory {
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ApplicationContext applicationContext;
    private final Logger log;

    @Inject
    public ExportServiceFactory(@NotNull MigrationFeatures migrationFeatures, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.migrationFeatures = migrationFeatures;
        this.applicationContext = applicationContext;
        this.log = LoggerFactory.getLogger(ExportServiceFactory.class);
    }

    @NotNull
    public final SiteExportService create() {
        SiteExportService siteExportService;
        this.log.info("single-path.migration.export enabled: " + !this.migrationFeatures.getDisableSinglePathExport());
        if (this.migrationFeatures.getEnableSinglePathLZ4MCS()) {
            Object object = this.applicationContext.getBean(SiteLZ4ExportService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBean(...)");
            siteExportService = (SiteExportService)object;
        } else if (this.migrationFeatures.getDisableSinglePathExport()) {
            Object object = this.applicationContext.getBean(SiteBackupExportService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBean(...)");
            siteExportService = (SiteExportService)object;
        } else {
            Object object = this.applicationContext.getBean(SiteMigrationExportService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBean(...)");
            siteExportService = (SiteExportService)object;
        }
        return siteExportService;
    }
}

