/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.site;

import com.atlassian.jira.action.admin.export.EntityXmlWriter;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.migration.export.site.EntitiesExporterHelper;
import com.atlassian.jira.migration.export.site.SiteExportDatabaseHelper;
import com.atlassian.jira.migration.export.site.entityfilter.EntityFilter;
import com.atlassian.jira.migration.export.site.entityfilter.EntityFilterAdapter;
import com.atlassian.jira.migration.export.site.transformer.SaxEntityTransformerAdapter;
import com.atlassian.jira.migration.export.site.transformer.SaxEntityTransformerAdapterFactory;
import com.atlassian.jira.migration.export.site.utils.EntitiesExportProgressMonitor;
import com.atlassian.jira.migration.export.site.utils.OfBizUtilKt;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.startup.FormattedLogMsg;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.TransactionSupport;
import com.atlassian.jira.user.ApplicationUser;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelViewEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 A2\u00020\u0001:\u0001ABW\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J8\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0016\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J8\u0010.\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020 H\u0002J8\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u0001042\f\u00105\u001a\b\u0012\u0004\u0012\u00020 062\u0006\u0010#\u001a\u00020$2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u0010'\u001a\u00020(J8\u00109\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010:\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010;\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"JL\u0010<\u001a\u00020=2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010>\u001a\u00020?2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020\u001b0@H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/atlassian/jira/migration/export/site/MigrationSaxEntitiesExporter;", "", "delegator", "Lcom/atlassian/jira/ofbiz/OfBizDelegator;", "applicationProperties", "Lcom/atlassian/jira/config/properties/ApplicationProperties;", "jiraSystemProperties", "Lcom/atlassian/jira/config/properties/JiraProperties;", "databaseHelper", "Lcom/atlassian/jira/migration/export/site/SiteExportDatabaseHelper;", "saxEntityTransformerRouterFactory", "Lcom/atlassian/jira/migration/export/site/transformer/SaxEntityTransformerAdapterFactory;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "openSaxEntitiesExporter", "Lcom/atlassian/jira/migration/export/site/EntitiesExporterHelper;", "transactionSupport", "Lcom/atlassian/jira/transaction/TransactionSupport;", "entityFilterAdapter", "Lcom/atlassian/jira/migration/export/site/entityfilter/EntityFilterAdapter;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/ofbiz/OfBizDelegator;Lcom/atlassian/jira/config/properties/ApplicationProperties;Lcom/atlassian/jira/config/properties/JiraProperties;Lcom/atlassian/jira/migration/export/site/SiteExportDatabaseHelper;Lcom/atlassian/jira/migration/export/site/transformer/SaxEntityTransformerAdapterFactory;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/export/site/EntitiesExporterHelper;Lcom/atlassian/jira/transaction/TransactionSupport;Lcom/atlassian/jira/migration/export/site/entityfilter/EntityFilterAdapter;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addMissingTimezoneEntry", "", "printWriter", "Ljava/io/PrintWriter;", "batchExportEntityForMySql", "curEntityName", "", "entityCounter", "Lcom/atlassian/jira/migration/export/site/MigrationSaxEntitiesExporter$Companion$EntityCounter;", "entityWriter", "Lcom/atlassian/jira/action/admin/export/EntityXmlWriter;", "saxTransformer", "Lcom/atlassian/jira/migration/export/site/transformer/SaxEntityTransformerAdapter;", "progressMonitor", "Lcom/atlassian/jira/migration/export/site/utils/EntitiesExportProgressMonitor;", "cleanUpAfterEntity", "transaction", "Lcom/atlassian/jira/transaction/Transaction;", "ok", "", "defaultExportEntity", "escapeXmlComment", "xmlComment", "exportEntities", "", "outputStream", "Ljava/io/OutputStream;", "entityNames", "Ljava/util/SortedSet;", "exportingUser", "Lcom/atlassian/jira/user/ApplicationUser;", "exportEntity", "writeEntityCountComment", "writeFooter", "writeGenericValues", "", "listIterator", "Lcom/atlassian/jira/ofbiz/OfBizListIterator;", "Lkotlin/Function1;", "Companion", "jira-migration-plugin"})
public final class MigrationSaxEntitiesExporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OfBizDelegator delegator;
    @NotNull
    private final ApplicationProperties applicationProperties;
    @NotNull
    private final JiraProperties jiraSystemProperties;
    @NotNull
    private final SiteExportDatabaseHelper databaseHelper;
    @NotNull
    private final SaxEntityTransformerAdapterFactory saxEntityTransformerRouterFactory;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final EntitiesExporterHelper openSaxEntitiesExporter;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final EntityFilterAdapter entityFilterAdapter;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private final Logger log;
    public static final int TIMEZONE_PROPERTY_ENTITY_ID = 1;
    public static final int TIMEZONE_PROPERTY_TYPE = 5;

    @Inject
    public MigrationSaxEntitiesExporter(@NotNull OfBizDelegator delegator, @NotNull ApplicationProperties applicationProperties, @NotNull JiraProperties jiraSystemProperties, @NotNull SiteExportDatabaseHelper databaseHelper, @NotNull SaxEntityTransformerAdapterFactory saxEntityTransformerRouterFactory, @NotNull ProjectManager projectManager, @NotNull EntitiesExporterHelper openSaxEntitiesExporter, @NotNull TransactionSupport transactionSupport, @NotNull EntityFilterAdapter entityFilterAdapter, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)delegator, (String)"delegator");
        Intrinsics.checkNotNullParameter((Object)applicationProperties, (String)"applicationProperties");
        Intrinsics.checkNotNullParameter((Object)jiraSystemProperties, (String)"jiraSystemProperties");
        Intrinsics.checkNotNullParameter((Object)databaseHelper, (String)"databaseHelper");
        Intrinsics.checkNotNullParameter((Object)saxEntityTransformerRouterFactory, (String)"saxEntityTransformerRouterFactory");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)openSaxEntitiesExporter, (String)"openSaxEntitiesExporter");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)entityFilterAdapter, (String)"entityFilterAdapter");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.delegator = delegator;
        this.applicationProperties = applicationProperties;
        this.jiraSystemProperties = jiraSystemProperties;
        this.databaseHelper = databaseHelper;
        this.saxEntityTransformerRouterFactory = saxEntityTransformerRouterFactory;
        this.projectManager = projectManager;
        this.openSaxEntitiesExporter = openSaxEntitiesExporter;
        this.transactionSupport = transactionSupport;
        this.entityFilterAdapter = entityFilterAdapter;
        this.migrationFeatures = migrationFeatures;
        this.log = LoggerFactory.getLogger(MigrationSaxEntitiesExporter.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long exportEntities(@Nullable OutputStream outputStream, @NotNull SortedSet<String> entityNames, @NotNull EntityXmlWriter entityWriter, @Nullable ApplicationUser exportingUser, @NotNull EntitiesExportProgressMonitor progressMonitor) throws IOException, GenericEntityException {
        Intrinsics.checkNotNullParameter(entityNames, (String)"entityNames");
        Intrinsics.checkNotNullParameter((Object)entityWriter, (String)"entityWriter");
        Intrinsics.checkNotNullParameter((Object)progressMonitor, (String)"progressMonitor");
        progressMonitor.beginExport();
        this.projectManager.getProjectCount();
        Companion.EntityCounter entityCounter = new Companion.EntityCounter();
        PrintWriter printWriter = this.openSaxEntitiesExporter.getWriter(outputStream);
        progressMonitor.beginHeader();
        this.openSaxEntitiesExporter.writeHeader(printWriter, exportingUser);
        progressMonitor.endHeader();
        SaxEntityTransformerAdapter saxTransformer = this.saxEntityTransformerRouterFactory.create();
        try {
            for (String curEntityName : entityNames) {
                ModelEntity modelEntity = this.delegator.getModelReader().getModelEntity(curEntityName);
                if (!(modelEntity instanceof ModelViewEntity)) {
                    Intrinsics.checkNotNull((Object)curEntityName);
                    this.exportEntity(curEntityName, entityCounter, entityWriter, printWriter, saxTransformer, progressMonitor);
                    continue;
                }
                this.log.info("No need to export entity '" + curEntityName + "' as it is a view entity.");
            }
            this.addMissingTimezoneEntry(this.applicationProperties, printWriter);
            progressMonitor.beginFooter();
            this.writeFooter(printWriter, entityCounter);
            progressMonitor.endFooter();
        }
        finally {
            printWriter.flush();
            progressMonitor.endExport();
        }
        return entityCounter.getTotal().get();
    }

    private final void exportEntity(String curEntityName, Companion.EntityCounter entityCounter, EntityXmlWriter entityWriter, PrintWriter printWriter, SaxEntityTransformerAdapter saxTransformer, EntitiesExportProgressMonitor progressMonitor) {
        if (this.openSaxEntitiesExporter.isMySql() && !this.migrationFeatures.getDisableSinglePathMySqlBatch()) {
            this.batchExportEntityForMySql(curEntityName, entityCounter, entityWriter, printWriter, saxTransformer, progressMonitor);
        } else {
            this.defaultExportEntity(curEntityName, entityCounter, entityWriter, printWriter, saxTransformer, progressMonitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void defaultExportEntity(String curEntityName, Companion.EntityCounter entityCounter, EntityXmlWriter entityWriter, PrintWriter printWriter, SaxEntityTransformerAdapter saxTransformer, EntitiesExportProgressMonitor progressMonitor) {
        progressMonitor.beginEntity(curEntityName);
        EntityFindOptions findOptions = this.openSaxEntitiesExporter.getFindOptions();
        boolean ok = false;
        Transaction transaction = this.transactionSupport.begin();
        if (this.log.isDebugEnabled()) {
            this.log.debug("  inTransaction={}", (Object)(transaction.isNewTransaction() ? "NEW" : "JOINED"));
        }
        OfBizListIterator listIterator = null;
        try {
            EntityFilter entityFilter;
            EntityFilter entityFilter2 = entityFilter = this.entityFilterAdapter.get(curEntityName);
            listIterator = this.delegator.findListIteratorByCondition(curEntityName, (EntityCondition)(entityFilter2 != null ? entityFilter2.getWhereCondition() : null), null, null, null, findOptions);
            this.writeGenericValues(curEntityName, listIterator, entityCounter, entityWriter, printWriter, saxTransformer, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(progressMonitor, curEntityName){
                final /* synthetic */ EntitiesExportProgressMonitor $progressMonitor;
                final /* synthetic */ String $curEntityName;
                {
                    this.$progressMonitor = $progressMonitor;
                    this.$curEntityName = $curEntityName;
                    super(1);
                }

                public final void invoke(int rowIndex) {
                    if (rowIndex % 1000 == 0) {
                        this.$progressMonitor.progressEntity(this.$curEntityName, rowIndex);
                    }
                }
            }));
            ok = true;
        }
        finally {
            progressMonitor.endEntity(curEntityName);
            OfBizListIterator ofBizListIterator = listIterator;
            if (ofBizListIterator != null) {
                ofBizListIterator.close();
            }
            Intrinsics.checkNotNull((Object)transaction);
            this.cleanUpAfterEntity(transaction, ok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void batchExportEntityForMySql(String curEntityName, Companion.EntityCounter entityCounter, EntityXmlWriter entityWriter, PrintWriter printWriter, SaxEntityTransformerAdapter saxTransformer, EntitiesExportProgressMonitor progressMonitor) {
        progressMonitor.beginEntity(curEntityName);
        boolean ok = false;
        Transaction transaction = this.transactionSupport.begin();
        if (this.log.isDebugEnabled()) {
            this.log.debug("  inTransaction={}", (Object)(transaction.isNewTransaction() ? "NEW" : "JOINED"));
        }
        Ref.IntRef currentOffset = new Ref.IntRef();
        try {
            int actualBatchSize;
            int batchSize = this.migrationFeatures.getSinglePathMySqlBatchSize();
            EntityFilter entityFilter = this.entityFilterAdapter.get(curEntityName);
            do {
                OfBizListIterator listIterator = null;
                actualBatchSize = 0;
                try {
                    EntityFindOptions findOptions = this.openSaxEntitiesExporter.getFindOptions(currentOffset.element, batchSize);
                    EntityFilter entityFilter2 = entityFilter;
                    Object object = entityFilter2 != null ? entityFilter2.getWhereCondition() : null;
                    ModelEntity modelEntity = this.delegator.getModelReader().getModelEntity(curEntityName);
                    Intrinsics.checkNotNullExpressionValue((Object)modelEntity, (String)"getModelEntity(...)");
                    listIterator = this.delegator.findListIteratorByCondition(curEntityName, object, null, null, this.openSaxEntitiesExporter.getOrderByFields(modelEntity), findOptions);
                    actualBatchSize = this.writeGenericValues(curEntityName, listIterator, entityCounter, entityWriter, printWriter, saxTransformer, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(batchSize, progressMonitor, curEntityName, currentOffset){
                        final /* synthetic */ int $batchSize;
                        final /* synthetic */ EntitiesExportProgressMonitor $progressMonitor;
                        final /* synthetic */ String $curEntityName;
                        final /* synthetic */ Ref.IntRef $currentOffset;
                        {
                            this.$batchSize = $batchSize;
                            this.$progressMonitor = $progressMonitor;
                            this.$curEntityName = $curEntityName;
                            this.$currentOffset = $currentOffset;
                            super(1);
                        }

                        public final void invoke(int rowIndex) {
                            if (rowIndex % this.$batchSize == 0) {
                                this.$progressMonitor.progressEntity(this.$curEntityName, this.$currentOffset.element);
                            }
                        }
                    }));
                    currentOffset.element += batchSize;
                }
                finally {
                    OfBizListIterator ofBizListIterator = listIterator;
                    if (ofBizListIterator != null) {
                        ofBizListIterator.close();
                    }
                }
            } while (actualBatchSize == batchSize);
            ok = true;
        }
        finally {
            Intrinsics.checkNotNull((Object)transaction);
            this.cleanUpAfterEntity(transaction, ok);
        }
    }

    private final int writeGenericValues(String curEntityName, OfBizListIterator listIterator, Companion.EntityCounter entityCounter, EntityXmlWriter entityWriter, PrintWriter printWriter, SaxEntityTransformerAdapter saxTransformer, Function1<? super Integer, Unit> progressMonitor) {
        int rowIndex = 0;
        GenericValue genericValue = OfBizUtilKt.nextWithRetries(listIterator);
        while (genericValue != null) {
            progressMonitor.invoke((Object)rowIndex);
            genericValue = saxTransformer.transform(curEntityName, genericValue);
            entityWriter.writeXmlText(genericValue, printWriter);
            entityCounter.increment(curEntityName);
            genericValue = OfBizUtilKt.nextWithRetries(listIterator);
            ++rowIndex;
        }
        return rowIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanUpAfterEntity(@NotNull Transaction transaction, boolean ok) throws GenericEntityException {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        if (transaction.isNewTransaction()) {
            try {
                if (ok) {
                    transaction.commit();
                }
            }
            finally {
                transaction.finallyRollbackIfNotCommitted();
            }
        }
    }

    private final void addMissingTimezoneEntry(ApplicationProperties applicationProperties, PrintWriter printWriter) {
        String key = "jvm.system.timezone";
        boolean timezoneInfoExists = applicationProperties.getKeys().contains(key);
        if (!timezoneInfoExists) {
            this.log.info("No timezone information can be found in application properties, writing timezone information...");
            String timezone = this.jiraSystemProperties.getProperty("user.timezone");
            this.log.info("====================> Jira user.timezone: " + timezone);
            CharSequence charSequence = timezone;
            if (!(charSequence == null || charSequence.length() == 0)) {
                Long l = this.databaseHelper.getMaxPropertyEntryId();
                long maxPropertyEntryId = l != null ? l : 0L;
                long id = maxPropertyEntryId + 1L;
                printWriter.write("<OSPropertyEntry id=\"" + id + "\" entityName=\"jira.properties\" entityId=\"1\" propertyKey=\"" + key + "\" type=\"5\"/>\n");
                printWriter.write("<OSPropertyString id=\"" + id + "\" value=\"" + timezone + "\"/>\n");
            }
        }
    }

    public final void writeFooter(@NotNull PrintWriter printWriter, @NotNull Companion.EntityCounter entityCounter) {
        Intrinsics.checkNotNullParameter((Object)printWriter, (String)"printWriter");
        Intrinsics.checkNotNullParameter((Object)entityCounter, (String)"entityCounter");
        this.writeEntityCountComment(printWriter, entityCounter);
        printWriter.write("</entity-engine-xml>");
    }

    private final void writeEntityCountComment(PrintWriter printWriter, Companion.EntityCounter entityCounter) {
        FormattedLogMsg logMsg = new FormattedLogMsg();
        try {
            entityCounter.outputToMessage(logMsg);
        }
        catch (RuntimeException rte) {
            this.log.error("An exception occuring while writing the JIRA system info end comment", (Throwable)rte);
            return;
        }
        printWriter.println("<!-- ");
        String string = logMsg.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        printWriter.println(this.escapeXmlComment(string));
        printWriter.println(" -->");
    }

    private final String escapeXmlComment(String xmlComment) {
        String escapedComment = xmlComment;
        if (StringsKt.contains$default((CharSequence)xmlComment, (CharSequence)"--", (boolean)false, (int)2, null)) {
            CharSequence charSequence = escapedComment;
            Regex regex = new Regex("--");
            String string = "-:";
            escapedComment = regex.replace(charSequence, string);
            escapedComment = StringsKt.trimIndent((String)("\n                \n                The comment data contained one of more occurences of a '-' character followed immediately by another '-' character.\n                This is not allowed according to http://www.w3.org/TR/REC-xml/#dt-comment.\n                These have been replaced by '-:' characters to make the XML valid\n                \n                " + escapedComment + "\n                "));
        }
        return escapedComment;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/export/site/MigrationSaxEntitiesExporter$Companion;", "", "()V", "TIMEZONE_PROPERTY_ENTITY_ID", "", "TIMEZONE_PROPERTY_TYPE", "EntityCounter", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/export/site/MigrationSaxEntitiesExporter$Companion$EntityCounter;", "", "()V", "map", "", "", "Ljava/util/concurrent/atomic/AtomicLong;", "getMap", "()Ljava/util/Map;", "setMap", "(Ljava/util/Map;)V", "total", "getTotal", "()Ljava/util/concurrent/atomic/AtomicLong;", "setTotal", "(Ljava/util/concurrent/atomic/AtomicLong;)V", "increment", "", "entityName", "outputToMessage", "logMsg", "Lcom/atlassian/jira/startup/FormattedLogMsg;", "jira-migration-plugin"})
        public static final class EntityCounter {
            @NotNull
            private Map<String, AtomicLong> map = new LinkedHashMap();
            @NotNull
            private AtomicLong total = new AtomicLong(0L);

            @NotNull
            public final Map<String, AtomicLong> getMap() {
                return this.map;
            }

            public final void setMap(@NotNull Map<String, AtomicLong> map) {
                Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
                this.map = map;
            }

            @NotNull
            public final AtomicLong getTotal() {
                return this.total;
            }

            public final void setTotal(@NotNull AtomicLong atomicLong) {
                Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
                this.total = atomicLong;
            }

            public final void increment(@NotNull String entityName) {
                Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
                AtomicLong count2 = this.map.get(entityName);
                if (count2 == null) {
                    count2 = new AtomicLong(0L);
                    this.map.put(entityName, count2);
                }
                count2.incrementAndGet();
                this.total.incrementAndGet();
            }

            public final void outputToMessage(@NotNull FormattedLogMsg logMsg) {
                Intrinsics.checkNotNullParameter((Object)logMsg, (String)"logMsg");
                logMsg.outputHeader("Entities");
                logMsg.outputProperty("Total", this.total.toString());
                logMsg.add((Object)"");
                for (Map.Entry<String, AtomicLong> entry : this.map.entrySet()) {
                    String key = entry.getKey();
                    AtomicLong value = entry.getValue();
                    logMsg.outputProperty(key, value.toString());
                }
            }
        }
    }
}

