/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.site;

import com.atlassian.jira.action.admin.export.DefaultSaxEntitiesExporter;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.migration.export.site.EntitiesExporterHelper;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.BuildUtilsInfo;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelIndex;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/export/site/OpenDefaultSaxEntitiesExporter;", "Lcom/atlassian/jira/action/admin/export/DefaultSaxEntitiesExporter;", "Lcom/atlassian/jira/migration/export/site/EntitiesExporterHelper;", "delegator", "Lcom/atlassian/jira/ofbiz/OfBizDelegator;", "applicationProperties", "Lcom/atlassian/jira/config/properties/ApplicationProperties;", "buildUtilsInfo", "Lcom/atlassian/jira/util/BuildUtilsInfo;", "databaseConfigurationManager", "Lcom/atlassian/jira/config/database/DatabaseConfigurationManager;", "(Lcom/atlassian/jira/ofbiz/OfBizDelegator;Lcom/atlassian/jira/config/properties/ApplicationProperties;Lcom/atlassian/jira/util/BuildUtilsInfo;Lcom/atlassian/jira/config/database/DatabaseConfigurationManager;)V", "getFindOptions", "Lorg/ofbiz/core/entity/EntityFindOptions;", "offset", "", "limit", "getOrderByFields", "", "", "modelEntity", "Lorg/ofbiz/core/entity/model/ModelEntity;", "getWriter", "Ljava/io/PrintWriter;", "outputStream", "Ljava/io/OutputStream;", "isMySql", "", "writeHeader", "", "printWriter", "exportingUser", "Lcom/atlassian/jira/user/ApplicationUser;", "jira-migration-plugin"})
public final class OpenDefaultSaxEntitiesExporter
extends DefaultSaxEntitiesExporter
implements EntitiesExporterHelper {
    @NotNull
    private final ApplicationProperties applicationProperties;
    @NotNull
    private final DatabaseConfigurationManager databaseConfigurationManager;

    public OpenDefaultSaxEntitiesExporter(@NotNull OfBizDelegator delegator, @NotNull ApplicationProperties applicationProperties, @NotNull BuildUtilsInfo buildUtilsInfo, @NotNull DatabaseConfigurationManager databaseConfigurationManager) {
        Intrinsics.checkNotNullParameter((Object)delegator, (String)"delegator");
        Intrinsics.checkNotNullParameter((Object)applicationProperties, (String)"applicationProperties");
        Intrinsics.checkNotNullParameter((Object)buildUtilsInfo, (String)"buildUtilsInfo");
        Intrinsics.checkNotNullParameter((Object)databaseConfigurationManager, (String)"databaseConfigurationManager");
        super(delegator, applicationProperties, buildUtilsInfo, databaseConfigurationManager);
        this.applicationProperties = applicationProperties;
        this.databaseConfigurationManager = databaseConfigurationManager;
    }

    public /* synthetic */ OpenDefaultSaxEntitiesExporter(OfBizDelegator ofBizDelegator, ApplicationProperties applicationProperties, BuildUtilsInfo buildUtilsInfo, DatabaseConfigurationManager databaseConfigurationManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Object object = ComponentAccessor.getComponent(DatabaseConfigurationManager.class);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.atlassian.jira.config.database.DatabaseConfigurationManager");
            databaseConfigurationManager = (DatabaseConfigurationManager)object;
        }
        this(ofBizDelegator, applicationProperties, buildUtilsInfo, databaseConfigurationManager);
    }

    @Override
    public boolean isMySql() {
        return this.databaseConfigurationManager.getDatabaseConfiguration().isMySql();
    }

    @Override
    @NotNull
    public EntityFindOptions getFindOptions(int offset, int limit) {
        EntityFindOptions entityFindOptions = EntityFindOptions.findOptions().range(offset, limit);
        Intrinsics.checkNotNullExpressionValue((Object)entityFindOptions, (String)"range(...)");
        return entityFindOptions;
    }

    @Override
    @Nullable
    public EntityFindOptions getFindOptions() {
        DatabaseConfig dbConfig = this.databaseConfigurationManager.getDatabaseConfiguration();
        int fetchSize = PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.export.fetchsize", (int)-1);
        if (fetchSize == -1) {
            fetchSize = dbConfig.isMySql() ? Integer.MIN_VALUE : 1000;
        }
        return EntityFindOptions.findOptions().fetchSize(fetchSize);
    }

    @Override
    public void writeHeader(@NotNull PrintWriter printWriter, @Nullable ApplicationUser exportingUser) {
        Intrinsics.checkNotNullParameter((Object)printWriter, (String)"printWriter");
        super.writeHeader(printWriter, exportingUser);
    }

    @Override
    @NotNull
    public PrintWriter getWriter(@Nullable OutputStream outputStream) throws UnsupportedEncodingException {
        PrintWriter printWriter = super.getWriter(outputStream);
        Intrinsics.checkNotNullExpressionValue((Object)printWriter, (String)"getWriter(...)");
        return printWriter;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getOrderByFields(@NotNull ModelEntity modelEntity) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)modelEntity, (String)"modelEntity");
        Collection collection2 = modelEntity.getPkFieldNames();
        if (!(collection2 == null || collection2.isEmpty())) {
            collection2 = modelEntity.getPkFieldNames();
            Intrinsics.checkNotNull((Object)collection2);
            collection = collection2;
        } else if (modelEntity.getIndexesSize() > 0) {
            void var3_3;
            ModelIndex index = modelEntity.getIndex(0);
            List indexFields = new ArrayList();
            int n = index.getIndexFieldsSize();
            for (int i = 0; i < n; ++i) {
                String string = index.getIndexField(i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIndexField(...)");
                indexFields.add(string);
            }
            collection = var3_3;
        } else {
            collection = CollectionsKt.listOf((Object)modelEntity.getField(0).getName());
        }
        return collection;
    }
}

