/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.site;

import com.atlassian.jira.bc.dataimport.ExportService;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.export.site.SiteExportService;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.user.ApplicationUser;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\fH\u0002J<\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/export/site/SiteBackupExportService;", "Lcom/atlassian/jira/migration/export/site/SiteExportService;", "exportService", "Lcom/atlassian/jira/bc/dataimport/ExportService;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "(Lcom/atlassian/jira/bc/dataimport/ExportService;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;)V", "enrichSiteBackup", "", "exportPath", "", "filesToAdd", "", "Ljava/nio/file/Path;", "exportWithAdditionalFiles", "loggedInUser", "Lcom/atlassian/jira/user/ApplicationUser;", "heartbeat", "Lkotlin/Function0;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nSiteBackupExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SiteBackupExportService.kt\ncom/atlassian/jira/migration/export/site/SiteBackupExportService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,55:1\n215#2,2:56\n*S KotlinDebug\n*F\n+ 1 SiteBackupExportService.kt\ncom/atlassian/jira/migration/export/site/SiteBackupExportService\n*L\n50#1:56,2\n*E\n"})
public final class SiteBackupExportService
implements SiteExportService {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;

    @Inject
    public SiteBackupExportService(@NotNull ExportService exportService, @NotNull LocalFileDataOutput localFileDataOutput) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        this.exportService = exportService;
        this.localFileDataOutput = localFileDataOutput;
    }

    @Override
    public void exportWithAdditionalFiles(@Nullable ApplicationUser loggedInUser, @NotNull String exportPath, @NotNull Map<Path, String> filesToAdd, @NotNull Function0<Unit> heartbeat2) {
        Intrinsics.checkNotNullParameter((Object)exportPath, (String)"exportPath");
        Intrinsics.checkNotNullParameter(filesToAdd, (String)"filesToAdd");
        Intrinsics.checkNotNullParameter(heartbeat2, (String)"heartbeat");
        heartbeat2.invoke();
        this.exportService.export(loggedInUser, exportPath, TaskProgressSink.NULL_SINK);
        heartbeat2.invoke();
        this.enrichSiteBackup(exportPath, filesToAdd);
        heartbeat2.invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void enrichSiteBackup(String exportPath, Map<Path, String> filesToAdd) {
        if (!filesToAdd.isEmpty()) {
            try {
                Path path = Paths.get(exportPath, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                this.localFileDataOutput.addFilesToExistingZip(path, filesToAdd);
            }
            finally {
                Map<Path, String> $this$forEach$iv = filesToAdd;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<Path, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<Path, String> element$iv;
                    Map.Entry<Path, String> it = element$iv = iterator2.next();
                    boolean bl = false;
                    Files.deleteIfExists(it.getKey());
                }
            }
        }
    }
}

