/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.site;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.migration.export.site.AbstractSiteExportService;
import com.atlassian.jira.migration.export.site.MigrationSaxEntitiesExporter;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.user.ApplicationUser;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FrameOutputStream;
import net.jpountz.xxhash.XXHashFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ofbiz.core.entity.DelegatorInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00120\u0014H\u0002J<\u0010\u0016\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00120\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/export/site/SiteLZ4ExportService;", "Lcom/atlassian/jira/migration/export/site/AbstractSiteExportService;", "entitiesExporter", "Lcom/atlassian/jira/migration/export/site/MigrationSaxEntitiesExporter;", "genericDelegator", "Lorg/ofbiz/core/entity/DelegatorInterface;", "jiraSystemProperties", "Lcom/atlassian/jira/config/properties/JiraProperties;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/export/site/MigrationSaxEntitiesExporter;Lorg/ofbiz/core/entity/DelegatorInterface;Lcom/atlassian/jira/config/properties/JiraProperties;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "addAdditionalFiles", "", "directory", "", "filesToAdd", "", "Ljava/nio/file/Path;", "exportWithCompression", "loggedInUser", "Lcom/atlassian/jira/user/ApplicationUser;", "exportPath", "heartbeat", "Lkotlin/Function0;", "getLZ4OutputStream", "Lnet/jpountz/lz4/LZ4FrameOutputStream;", "file", "Ljava/io/File;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nSiteLZ4ExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SiteLZ4ExportService.kt\ncom/atlassian/jira/migration/export/site/SiteLZ4ExportService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n215#2:105\n216#2:107\n1#3:106\n*S KotlinDebug\n*F\n+ 1 SiteLZ4ExportService.kt\ncom/atlassian/jira/migration/export/site/SiteLZ4ExportService\n*L\n69#1:105\n69#1:107\n*E\n"})
public final class SiteLZ4ExportService
extends AbstractSiteExportService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger log;
    @NotNull
    public static final String ACTIVE_OBJECTS_XML_LZ4 = "activeobjects.xml.lz4";
    @NotNull
    public static final String ENTITIES_XML_LZ4 = "entities.xml.lz4";
    public static final int BUFFER_SIZE = 2048;
    public static final int COMPRESSION_LEVEL = 9;

    @Inject
    public SiteLZ4ExportService(@NotNull MigrationSaxEntitiesExporter entitiesExporter, @NotNull DelegatorInterface genericDelegator, @NotNull JiraProperties jiraSystemProperties, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)entitiesExporter, (String)"entitiesExporter");
        Intrinsics.checkNotNullParameter((Object)genericDelegator, (String)"genericDelegator");
        Intrinsics.checkNotNullParameter((Object)jiraSystemProperties, (String)"jiraSystemProperties");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        super(entitiesExporter, genericDelegator, jiraSystemProperties, migrationFeatures);
        Logger logger2 = LoggerFactory.getLogger(SiteLZ4ExportService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        this.log = logger2;
    }

    @Override
    @NotNull
    protected Logger getLog() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportWithCompression(@Nullable ApplicationUser loggedInUser, @NotNull String exportPath, @NotNull Map<Path, String> filesToAdd, @NotNull Function0<Unit> heartbeat2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)exportPath, (String)"exportPath");
        Intrinsics.checkNotNullParameter(filesToAdd, (String)"filesToAdd");
        Intrinsics.checkNotNullParameter(heartbeat2, (String)"heartbeat");
        Files.createDirectories(Paths.get(exportPath, new String[0]), new FileAttribute[0]);
        File entitiesFile = new File(exportPath, ENTITIES_XML_LZ4);
        Closeable closeable = (Closeable)this.getLZ4OutputStream(entitiesFile);
        Object object2 = null;
        try {
            LZ4FrameOutputStream it = (LZ4FrameOutputStream)closeable;
            boolean bl = false;
            this.exportJIRA(loggedInUser, (OutputStream)it, (Function0<Unit>)((Function0)new Function0<Unit>(heartbeat2){
                final /* synthetic */ Function0<Unit> $heartbeat;
                {
                    this.$heartbeat = $heartbeat;
                    super(0);
                }

                public final void invoke() {
                    this.$heartbeat.invoke();
                }
            }));
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        }
        File activeObjectsFile = new File(exportPath, ACTIVE_OBJECTS_XML_LZ4);
        object2 = (Closeable)this.getLZ4OutputStream(activeObjectsFile);
        object = null;
        try {
            LZ4FrameOutputStream it = (LZ4FrameOutputStream)object2;
            boolean bl = false;
            this.exportActiveObjects((OutputStream)it, (Function0<Unit>)((Function0)new Function0<Unit>(heartbeat2){
                final /* synthetic */ Function0<Unit> $heartbeat;
                {
                    this.$heartbeat = $heartbeat;
                    super(0);
                }

                public final void invoke() {
                    this.$heartbeat.invoke();
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
        }
        this.addAdditionalFiles(exportPath, filesToAdd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addAdditionalFiles(String directory, Map<Path, String> filesToAdd) {
        Map<Path, String> $this$forEach$iv = filesToAdd;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Path, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Path, String> element$iv;
            Map.Entry<Path, String> entry = element$iv = iterator2.next();
            boolean bl = false;
            Path path = entry.getKey();
            String filename = entry.getValue();
            File fileToAdd = new File(directory, filename + ".lz4");
            Closeable closeable = new FileInputStream(((Object)path).toString());
            Throwable throwable = null;
            try {
                FileInputStream inputStream = (FileInputStream)closeable;
                boolean bl2 = false;
                Closeable closeable2 = (Closeable)this.getLZ4OutputStream(fileToAdd);
                Throwable throwable2 = null;
                try {
                    LZ4FrameOutputStream outputStream = (LZ4FrameOutputStream)closeable2;
                    boolean bl3 = false;
                    byte[] buffer = new byte[2048];
                    int len = 0;
                    while (true) {
                        int n;
                        int it = n = inputStream.read(buffer);
                        boolean bl4 = false;
                        len = it;
                        if (n == -1) break;
                        outputStream.write(buffer, 0, len);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    private final LZ4FrameOutputStream getLZ4OutputStream(File file2) throws IOException {
        LZ4FrameOutputStream.FLG.Bits[] bitsArray = new LZ4FrameOutputStream.FLG.Bits[]{LZ4FrameOutputStream.FLG.Bits.BLOCK_INDEPENDENCE};
        return new LZ4FrameOutputStream((OutputStream)new FileOutputStream(file2), LZ4FrameOutputStream.BLOCKSIZE.SIZE_4MB, -1L, LZ4Factory.fastestInstance().highCompressor(9), XXHashFactory.fastestInstance().hash32(), bitsArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/export/site/SiteLZ4ExportService$Companion;", "", "()V", "ACTIVE_OBJECTS_XML_LZ4", "", "BUFFER_SIZE", "", "COMPRESSION_LEVEL", "ENTITIES_XML_LZ4", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

