/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.site;

import com.atlassian.core.util.DataUtils;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.migration.export.site.AbstractSiteExportService;
import com.atlassian.jira.migration.export.site.MigrationSaxEntitiesExporter;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.user.ApplicationUser;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ofbiz.core.entity.DelegatorInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0002J<\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00162\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0016H\u0002R\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/export/site/SiteMigrationExportService;", "Lcom/atlassian/jira/migration/export/site/AbstractSiteExportService;", "entitiesExporter", "Lcom/atlassian/jira/migration/export/site/MigrationSaxEntitiesExporter;", "genericDelegator", "Lorg/ofbiz/core/entity/DelegatorInterface;", "jiraSystemProperties", "Lcom/atlassian/jira/config/properties/JiraProperties;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/export/site/MigrationSaxEntitiesExporter;Lorg/ofbiz/core/entity/DelegatorInterface;Lcom/atlassian/jira/config/properties/JiraProperties;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "addAdditionalFiles", "", "zip", "Lorg/apache/commons/compress/archivers/zip/ZipArchiveOutputStream;", "filesToAdd", "", "Ljava/nio/file/Path;", "", "exportWithCompression", "loggedInUser", "Lcom/atlassian/jira/user/ApplicationUser;", "exportPath", "heartbeat", "Lkotlin/Function0;", "getZipOutputStream", "filename", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nSiteMigrationExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SiteMigrationExportService.kt\ncom/atlassian/jira/migration/export/site/SiteMigrationExportService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,84:1\n215#2,2:85\n*S KotlinDebug\n*F\n+ 1 SiteMigrationExportService.kt\ncom/atlassian/jira/migration/export/site/SiteMigrationExportService\n*L\n65#1:85,2\n*E\n"})
public final class SiteMigrationExportService
extends AbstractSiteExportService {
    @NotNull
    private final Logger log;

    @Inject
    public SiteMigrationExportService(@NotNull MigrationSaxEntitiesExporter entitiesExporter, @NotNull DelegatorInterface genericDelegator, @NotNull JiraProperties jiraSystemProperties, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)entitiesExporter, (String)"entitiesExporter");
        Intrinsics.checkNotNullParameter((Object)genericDelegator, (String)"genericDelegator");
        Intrinsics.checkNotNullParameter((Object)jiraSystemProperties, (String)"jiraSystemProperties");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        super(entitiesExporter, genericDelegator, jiraSystemProperties, migrationFeatures);
        Logger logger2 = LoggerFactory.getLogger(SiteMigrationExportService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        this.log = logger2;
    }

    @Override
    @NotNull
    protected Logger getLog() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportWithCompression(@Nullable ApplicationUser loggedInUser, @NotNull String exportPath, @NotNull Map<Path, String> filesToAdd, @NotNull Function0<Unit> heartbeat2) {
        Intrinsics.checkNotNullParameter((Object)exportPath, (String)"exportPath");
        Intrinsics.checkNotNullParameter(filesToAdd, (String)"filesToAdd");
        Intrinsics.checkNotNullParameter(heartbeat2, (String)"heartbeat");
        Closeable closeable = (Closeable)this.getZipOutputStream(exportPath);
        Throwable throwable = null;
        try {
            ZipArchiveOutputStream zip = (ZipArchiveOutputStream)closeable;
            boolean bl = false;
            zip.setUseZip64(Zip64Mode.AsNeeded);
            zip.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("entities.xml"));
            this.exportJIRA(loggedInUser, (OutputStream)zip, (Function0<Unit>)((Function0)new Function0<Unit>(heartbeat2){
                final /* synthetic */ Function0<Unit> $heartbeat;
                {
                    this.$heartbeat = $heartbeat;
                    super(0);
                }

                public final void invoke() {
                    this.$heartbeat.invoke();
                }
            }));
            zip.closeArchiveEntry();
            zip.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("activeobjects.xml"));
            this.exportActiveObjects((OutputStream)zip, (Function0<Unit>)((Function0)new Function0<Unit>(heartbeat2){
                final /* synthetic */ Function0<Unit> $heartbeat;
                {
                    this.$heartbeat = $heartbeat;
                    super(0);
                }

                public final void invoke() {
                    this.$heartbeat.invoke();
                }
            }));
            zip.closeArchiveEntry();
            this.addAdditionalFiles(zip, filesToAdd);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addAdditionalFiles(ZipArchiveOutputStream zip, Map<Path, String> filesToAdd) {
        Map<Path, String> $this$forEach$iv = filesToAdd;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Path, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Path, String> element$iv;
            Map.Entry<Path, String> entry = element$iv = iterator2.next();
            boolean bl = false;
            Path path = entry.getKey();
            String filename = entry.getValue();
            ZipArchiveEntry entry2 = new ZipArchiveEntry(filename);
            entry2.setSize(path.toFile().length());
            zip.putArchiveEntry((ArchiveEntry)entry2);
            Closeable closeable = new FileInputStream(path.toFile());
            Throwable throwable = null;
            try {
                FileInputStream inputStream = (FileInputStream)closeable;
                boolean bl2 = false;
                long l = IOUtils.copy((InputStream)inputStream, (OutputStream)((OutputStream)zip));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            zip.closeArchiveEntry();
        }
    }

    private final ZipArchiveOutputStream getZipOutputStream(String filename) throws IOException {
        String zipFileName = DataUtils.getZipFilename((String)filename);
        File zipFile = new File(zipFileName);
        FileUtils.openOutputStream((File)zipFile).close();
        return new ZipArchiveOutputStream(zipFile);
    }
}

