/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.site.transformer.customfield;

import com.atlassian.jira.migration.app.AppCustomFieldGetter;
import com.atlassian.jira.migration.export.site.transformer.SaxEntityTransformer;
import com.atlassian.migration.app.dto.ConnectAppCustomField;
import com.atlassian.migration.app.dto.ServerAddonCustomField;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.ofbiz.core.entity.GenericValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/export/site/transformer/customfield/AppCustomFieldTransformer;", "Lcom/atlassian/jira/migration/export/site/transformer/SaxEntityTransformer;", "appCustomFieldGetter", "Lcom/atlassian/jira/migration/app/AppCustomFieldGetter;", "serverAppKeysIncludedInMigration", "", "", "(Lcom/atlassian/jira/migration/app/AppCustomFieldGetter;Ljava/util/Set;)V", "getServerAppKeysIncludedInMigration", "()Ljava/util/Set;", "transform", "Lorg/ofbiz/core/entity/GenericValue;", "genericValue", "jira-migration-plugin"})
public final class AppCustomFieldTransformer
implements SaxEntityTransformer {
    @NotNull
    private final AppCustomFieldGetter appCustomFieldGetter;
    @NotNull
    private final Set<String> serverAppKeysIncludedInMigration;

    public AppCustomFieldTransformer(@NotNull AppCustomFieldGetter appCustomFieldGetter, @NotNull Set<String> serverAppKeysIncludedInMigration) {
        Intrinsics.checkNotNullParameter((Object)appCustomFieldGetter, (String)"appCustomFieldGetter");
        Intrinsics.checkNotNullParameter(serverAppKeysIncludedInMigration, (String)"serverAppKeysIncludedInMigration");
        this.appCustomFieldGetter = appCustomFieldGetter;
        this.serverAppKeysIncludedInMigration = serverAppKeysIncludedInMigration;
    }

    @NotNull
    public final Set<String> getServerAppKeysIncludedInMigration() {
        return this.serverAppKeysIncludedInMigration;
    }

    @Override
    @NotNull
    public GenericValue transform(@NotNull GenericValue genericValue) {
        GenericValue genericValue2;
        ConnectAppCustomField connectAppCustomField;
        Intrinsics.checkNotNullParameter((Object)genericValue, (String)"genericValue");
        String string = genericValue.getString("customfieldtypekey");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String[] stringArray = new String[]{":"};
        List split = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (split.size() != 2) {
            return genericValue;
        }
        String serverAppKey = (String)split.get(0);
        String customFieldType = (String)split.get(1);
        String customFieldName = genericValue.getString("name");
        ServerAddonCustomField serverAddonCustomKey = new ServerAddonCustomField(serverAppKey, customFieldName, customFieldType);
        if (!this.serverAppKeysIncludedInMigration.contains(serverAppKey)) {
            return genericValue;
        }
        Map<ServerAddonCustomField, ConnectAppCustomField> retrieveAllAppCustomFields = this.appCustomFieldGetter.retrieveAllAppCustomFields();
        ConnectAppCustomField connectAppCustomField2 = connectAppCustomField = retrieveAllAppCustomFields.get(serverAddonCustomKey);
        if (connectAppCustomField2 != null) {
            ConnectAppCustomField it = connectAppCustomField2;
            boolean bl = false;
            genericValue.set("customfieldtypekey", (Object)("com.atlassian.plugins.atlassian-connect-plugin:" + it.getCloudAppKey() + "__" + it.getJiraIssueFieldModuleKey()));
            genericValue2 = genericValue;
        } else {
            genericValue2 = genericValue;
        }
        return genericValue2;
    }
}

