/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.site.utils;

import com.atlassian.activeobjects.spi.BackupProgressMonitor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\u0012\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\u0012\u0010\u0015\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/export/site/utils/ActiveObjectsExportProgressMonitor;", "Lcom/atlassian/activeobjects/spi/BackupProgressMonitor;", "heartbeat", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "getHeartbeat", "()Lkotlin/jvm/functions/Function0;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "beginBackup", "beginDatabaseInformationBackup", "beginTableBackup", "tableName", "", "beginTableDefinitionsBackup", "beginTablesBackup", "endBackup", "endDatabaseInformationBackup", "endTableBackup", "endTableDefinitionsBackup", "endTablesBackup", "updateTotalNumberOfTablesToBackup", "tableCount", "", "jira-migration-plugin"})
public final class ActiveObjectsExportProgressMonitor
implements BackupProgressMonitor {
    @NotNull
    private final Function0<Unit> heartbeat;
    @NotNull
    private final Logger log;

    public ActiveObjectsExportProgressMonitor(@NotNull Function0<Unit> heartbeat2) {
        Intrinsics.checkNotNullParameter(heartbeat2, (String)"heartbeat");
        this.heartbeat = heartbeat2;
        Logger logger2 = LoggerFactory.getLogger(ActiveObjectsExportProgressMonitor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        this.log = logger2;
    }

    @NotNull
    public final Function0<Unit> getHeartbeat() {
        return this.heartbeat;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    public void beginBackup() {
        this.heartbeat.invoke();
        this.log.info("ActiveObjects export: start");
    }

    public void beginDatabaseInformationBackup() {
        this.heartbeat.invoke();
        this.log.info("ActiveObjects export: begin export database information");
    }

    public void beginTableBackup(@Nullable String tableName) {
        this.heartbeat.invoke();
        this.log.info("ActiveObjects export: begin export table data => " + tableName);
    }

    public void beginTableDefinitionsBackup() {
        this.heartbeat.invoke();
        this.log.info("ActiveObjects export: begin export table definitions");
    }

    public void beginTablesBackup() {
        this.heartbeat.invoke();
        this.log.info("ActiveObjects export: begin export tables");
    }

    public void endBackup() {
        this.heartbeat.invoke();
        this.log.info("ActiveObjects export: finished");
    }

    public void endDatabaseInformationBackup() {
        this.heartbeat.invoke();
        this.log.info("ActiveObjects export: export database information finished");
    }

    public void endTableBackup(@Nullable String tableName) {
        this.heartbeat.invoke();
        this.log.info("ActiveObjects export: export table data => " + tableName + " finishes");
    }

    public void endTableDefinitionsBackup() {
        this.heartbeat.invoke();
        this.log.info("ActiveObjects export: export table definitions finished");
    }

    public void endTablesBackup() {
        this.heartbeat.invoke();
        this.log.info("ActiveObjects export: export tables finished");
    }

    public void updateTotalNumberOfTablesToBackup(int tableCount) {
        this.heartbeat.invoke();
        this.log.info("ActiveObjects export: total number of tables to backup is " + tableCount);
    }
}

