/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.site.utils;

import com.atlassian.jira.migration.export.site.utils.EntitiesExportProgressMonitor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/export/site/utils/EntitiesExportProgressMonitorImpl;", "Lcom/atlassian/jira/migration/export/site/utils/EntitiesExportProgressMonitor;", "heartbeat", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "getHeartbeat", "()Lkotlin/jvm/functions/Function0;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "beginEntity", "entityName", "", "beginExport", "beginFooter", "beginHeader", "endEntity", "endExport", "endFooter", "endHeader", "progressEntity", "count", "", "jira-migration-plugin"})
public final class EntitiesExportProgressMonitorImpl
implements EntitiesExportProgressMonitor {
    @NotNull
    private final Function0<Unit> heartbeat;
    @NotNull
    private final Logger log;

    public EntitiesExportProgressMonitorImpl(@NotNull Function0<Unit> heartbeat2) {
        Intrinsics.checkNotNullParameter(heartbeat2, (String)"heartbeat");
        this.heartbeat = heartbeat2;
        Logger logger2 = LoggerFactory.getLogger(EntitiesExportProgressMonitorImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        this.log = logger2;
    }

    @NotNull
    public final Function0<Unit> getHeartbeat() {
        return this.heartbeat;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @Override
    public void beginExport() {
        this.heartbeat.invoke();
        this.log.info("Entities export: started");
    }

    @Override
    public void endExport() {
        this.heartbeat.invoke();
        this.log.info("Entities export: finished");
    }

    @Override
    public void beginHeader() {
        this.heartbeat.invoke();
        this.log.info("Entities export: begin export jira system information");
    }

    @Override
    public void endHeader() {
        this.heartbeat.invoke();
        this.log.info("Entities export: export jira system information finished");
    }

    @Override
    public void beginEntity(@NotNull String entityName) {
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        this.heartbeat.invoke();
        this.log.info("Entities export: begin export entity => " + entityName);
    }

    @Override
    public void progressEntity(@NotNull String entityName, int count2) {
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        this.heartbeat.invoke();
        this.log.info("Entities export: exporting entity => " + entityName + ", " + count2);
    }

    @Override
    public void endEntity(@NotNull String entityName) {
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        this.heartbeat.invoke();
        this.log.info("Entities export: export entity => " + entityName + " finished");
    }

    @Override
    public void beginFooter() {
        this.heartbeat.invoke();
        this.log.info("Entities export: begin footer section");
    }

    @Override
    public void endFooter() {
        this.heartbeat.invoke();
        this.log.info("Entities export: footer section finished");
    }
}

