/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.size;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.jira.migration.export.size.ExportSizeService;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.atlassian.pocketknife.spi.querydsl.EnhancedRelationalPathBase;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\b\u0007\u0018\u0000 #2\u00020\u0001:\u0004#$%&B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J8\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001c2\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00150 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010!\u001a\u00020\u000bJ\u0006\u0010\"\u001a\u00020\u000bR)\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \f*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/atlassian/jira/migration/export/size/ExportSizeService;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "executor", "Ljava/util/concurrent/Executor;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Ljava/util/concurrent/Executor;Lcom/atlassian/cache/CacheManager;)V", "cache", "Lcom/atlassian/cache/CachedReference;", "Lcom/atlassian/jira/migration/export/size/ExportSizeService$DatabaseEstimate;", "kotlin.jvm.PlatformType", "getCache", "()Lcom/atlassian/cache/CachedReference;", "cache$delegate", "Lkotlin/Lazy;", "log", "Lorg/slf4j/Logger;", "calculateDatabaseEstimate", "timeoutMs", "", "countForTableName", "Ljava/util/function/Supplier;", "Lcom/atlassian/jira/migration/export/size/ExportSizeService$CountAndRuntime;", "name", "", "estimateTableSizes", "", "Ljava/util/concurrent/CompletableFuture;", "Lcom/atlassian/jira/migration/export/size/ExportSizeService$TableEstimate;", "tablesToSizes", "", "getDatabaseSizeEstimate", "getDatabaseSizeEstimateCached", "Companion", "CountAndRuntime", "DatabaseEstimate", "TableEstimate", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nExportSizeService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportSizeService.kt\ncom/atlassian/jira/migration/export/size/ExportSizeService\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,569:1\n37#2,2:570\n125#3:572\n152#3,3:573\n*S KotlinDebug\n*F\n+ 1 ExportSizeService.kt\ncom/atlassian/jira/migration/export/size/ExportSizeService\n*L\n489#1:570,2\n516#1:572\n516#1:573,3\n*E\n"})
public final class ExportSizeService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final Executor executor;
    private final Logger log;
    @NotNull
    private final Lazy cache$delegate;
    public static final long DB_LOOKUP_TIMEOUT = 30000L;
    public static final long ACTIVE_OBJECTS_XML_OVERHEAD = 350000L;
    public static final long ENTITIES_XML_OVERHEAD = 170000L;
    @NotNull
    private static final Map<String, Long> ENTITIES_TO_TYPICAL_SIZE;
    @NotNull
    private static final Map<String, Long> ACTIVEOBJECTS_TO_TYPICAL_SIZE;

    @Inject
    public ExportSizeService(@NotNull DatabaseAccessor databaseAccessor, @NotNull Executor executor, @NotNull CacheManager cacheManager) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        this.databaseAccessor = databaseAccessor;
        this.executor = executor;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.cache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CachedReference<DatabaseEstimate>>(cacheManager, this){
            final /* synthetic */ CacheManager $cacheManager;
            final /* synthetic */ ExportSizeService this$0;
            {
                this.$cacheManager = $cacheManager;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CachedReference<DatabaseEstimate> invoke() {
                return this.$cacheManager.getCachedReference(ExportSizeService.class.getName() + ".cache", () -> cache.2.invoke$lambda$0(this.this$0), new CacheSettingsBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build());
            }

            private static final DatabaseEstimate invoke$lambda$0(ExportSizeService this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                return this$0.calculateDatabaseEstimate(30000L);
            }
        }));
    }

    private final CachedReference<DatabaseEstimate> getCache() {
        Lazy lazy = this.cache$delegate;
        return (CachedReference)lazy.getValue();
    }

    @NotNull
    public final DatabaseEstimate getDatabaseSizeEstimateCached() {
        Object object = this.getCache().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (DatabaseEstimate)object;
    }

    @NotNull
    public final DatabaseEstimate getDatabaseSizeEstimate() {
        this.getCache().reset();
        Object object = this.getCache().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (DatabaseEstimate)object;
    }

    @NotNull
    public final DatabaseEstimate calculateDatabaseEstimate(long timeoutMs) {
        long startTime = System.currentTimeMillis();
        List<CompletableFuture<TableEstimate>> entityFutures = this.estimateTableSizes(this.executor, ENTITIES_TO_TYPICAL_SIZE, timeoutMs);
        List<CompletableFuture<TableEstimate>> activeObjectFutures = this.estimateTableSizes(this.executor, ACTIVEOBJECTS_TO_TYPICAL_SIZE, timeoutMs);
        Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)entityFutures, (Iterable)activeObjectFutures);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletionStage estimate2 = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).thenApply(arg_0 -> ExportSizeService.calculateDatabaseEstimate$lambda$0((Function1)new Function1<Void, DatabaseEstimate>(entityFutures, activeObjectFutures, startTime){
            final /* synthetic */ List<CompletableFuture<TableEstimate>> $entityFutures;
            final /* synthetic */ List<CompletableFuture<TableEstimate>> $activeObjectFutures;
            final /* synthetic */ long $startTime;
            {
                this.$entityFutures = $entityFutures;
                this.$activeObjectFutures = $activeObjectFutures;
                this.$startTime = $startTime;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final DatabaseEstimate invoke(Void it) {
                long l;
                TableEstimate it2;
                long l2;
                void $this$mapTo$iv$iv;
                Collection collection;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv = this.$entityFutures;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Iterable<E> destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it3;
                    CompletableFuture completableFuture = (CompletableFuture)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((TableEstimate)it3.get());
                }
                List entities = (List)destination$iv$iv;
                Iterable $this$map$iv2 = this.$activeObjectFutures;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (E item$iv$iv : $this$mapTo$iv$iv) {
                    void it4;
                    CompletableFuture bl = (CompletableFuture)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add((TableEstimate)it4.get());
                }
                List activeObjects = (List)destination$iv$iv2;
                Iterable iterable2 = entities;
                long l3 = 170000L;
                List list = activeObjects;
                long l4 = 350000L;
                List list2 = entities;
                long l5 = 170000L;
                long l6 = 0L;
                for (T t : iterable2) {
                    Object item$iv$iv;
                    item$iv$iv = (TableEstimate)t;
                    l2 = l6;
                    boolean bl = false;
                    l = it2.getSize();
                    l6 = l2 + l;
                }
                l2 = l6;
                iterable2 = activeObjects;
                l3 = l3 + l2 + 350000L;
                l6 = 0L;
                for (T t : iterable2) {
                    it2 = (TableEstimate)t;
                    l2 = l6;
                    boolean bl = false;
                    l = it2.getSize();
                    l6 = l2 + l;
                }
                l2 = l6;
                long l7 = l3 + l2;
                iterable2 = CollectionsKt.plus((Collection)entities, (Iterable)activeObjects);
                l2 = System.currentTimeMillis() - this.$startTime;
                l3 = l7;
                l6 = 0L;
                for (T t : iterable2) {
                    it2 = (TableEstimate)t;
                    l = l6;
                    boolean bl = false;
                    long l8 = it2.getRuntimeMs();
                    l6 = l + l8;
                }
                long l9 = l = l6;
                long l10 = l2;
                long l11 = l3;
                List list3 = list;
                long l12 = l4;
                List list4 = list2;
                long l13 = l5;
                return new DatabaseEstimate(l13, list4, l12, list3, l11, l10, l9);
            }
        }, arg_0));
        ((CompletableFuture)estimate2).join();
        Object t = ((CompletableFuture)estimate2).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (DatabaseEstimate)t;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CompletableFuture<TableEstimate>> estimateTableSizes(Executor executor, Map<String, Long> tablesToSizes, long timeoutMs) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map<String, Long> map = tablesToSizes;
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String tableName = (String)it.getKey();
            long typicalSize = ((Number)it.getValue()).longValue();
            collection.add(((CompletableFuture)CompletableFuture.supplyAsync(() -> ExportSizeService.estimateTableSizes$lambda$4$lambda$1(this, tableName, executor, timeoutMs)).thenApply(arg_0 -> ExportSizeService.estimateTableSizes$lambda$4$lambda$2((Function1)new Function1<CountAndRuntime, TableEstimate>(tableName, typicalSize){
                final /* synthetic */ String $tableName;
                final /* synthetic */ long $typicalSize;
                {
                    this.$tableName = $tableName;
                    this.$typicalSize = $typicalSize;
                    super(1);
                }

                public final TableEstimate invoke(CountAndRuntime result2) {
                    return new TableEstimate(this.$tableName, result2.getCount(), result2.getCount() * this.$typicalSize, result2.getRuntimeMs());
                }
            }, arg_0))).exceptionally(arg_0 -> ExportSizeService.estimateTableSizes$lambda$4$lambda$3(this, tableName, arg_0)));
        }
        return (List)destination$iv$iv;
    }

    private final Supplier<CountAndRuntime> countForTableName(String name) {
        return () -> ExportSizeService.countForTableName$lambda$6(this, name);
    }

    private static final DatabaseEstimate calculateDatabaseEstimate$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DatabaseEstimate)$tmp0.invoke(p0);
    }

    private static final CountAndRuntime estimateTableSizes$lambda$4$lambda$1(ExportSizeService this$0, String $tableName, Executor $executor, long $timeoutMs) {
        CountAndRuntime countAndRuntime;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$tableName, (String)"$tableName");
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        try {
            countAndRuntime = CompletableFuture.supplyAsync(this$0.countForTableName($tableName), $executor).get($timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            this$0.log.warn("Timeout counting " + $tableName + ", defaulting to 2_000_000", (Throwable)ex);
            countAndRuntime = new CountAndRuntime(2000000L, $timeoutMs);
        }
        return countAndRuntime;
    }

    private static final TableEstimate estimateTableSizes$lambda$4$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (TableEstimate)$tmp0.invoke(p0);
    }

    private static final TableEstimate estimateTableSizes$lambda$4$lambda$3(ExportSizeService this$0, String $tableName, Throwable ex) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$tableName, (String)"$tableName");
        this$0.log.debug("Failed to count " + $tableName, ex);
        return new TableEstimate($tableName, -1L, 0L, 0L);
    }

    private static final Long countForTableName$lambda$6$lambda$5(String $name, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Class<Object> clazz = Object.class;
        return ((SQLQuery)db.query().from((Expression)new EnhancedRelationalPathBase<Object>($name, clazz){})).fetchCount();
    }

    private static final CountAndRuntime countForTableName$lambda$6(ExportSizeService this$0, String $name) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        long startTime = System.currentTimeMillis();
        Long count2 = (Long)this$0.databaseAccessor.run(arg_0 -> ExportSizeService.countForTableName$lambda$6$lambda$5($name, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNull((Object)count2);
        return new CountAndRuntime(count2, System.currentTimeMillis() - startTime);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"JiraAction", (Object)2000L), TuplesKt.to((Object)"cwd_application", (Object)250L), TuplesKt.to((Object)"app_user", (Object)200L), TuplesKt.to((Object)"audit_changed_value", (Object)200L), TuplesKt.to((Object)"audit_item", (Object)200L), TuplesKt.to((Object)"audit_log", (Object)600L), TuplesKt.to((Object)"Avatar", (Object)150L), TuplesKt.to((Object)"ChangeGroup", (Object)100L), TuplesKt.to((Object)"ChangeItem", (Object)200L), TuplesKt.to((Object)"ClusteredJob", (Object)800L), TuplesKt.to((Object)"ColumnLayout", (Object)50L), TuplesKt.to((Object)"ColumnLayoutItem", (Object)150L), TuplesKt.to((Object)"Component", (Object)100L), TuplesKt.to((Object)"ConfigurationContext", (Object)100L), TuplesKt.to((Object)"CustomField", (Object)400L), TuplesKt.to((Object)"CustomFieldOption", (Object)150L), TuplesKt.to((Object)"CustomFieldValue", (Object)150L), TuplesKt.to((Object)"cwd_directory", (Object)400L), TuplesKt.to((Object)"cwd_directory_attribute", (Object)100L), TuplesKt.to((Object)"cwd_directory_operation", (Object)100L), TuplesKt.to((Object)"jiradraftworkflows", (Object)16000L), TuplesKt.to((Object)"entity_property", (Object)300L), TuplesKt.to((Object)"jiraeventtype", (Object)150L), TuplesKt.to((Object)"Feature", (Object)150L), TuplesKt.to((Object)"FieldConfigScheme", (Object)200L), TuplesKt.to((Object)"FieldConfigSchemeIssueType", (Object)100L), TuplesKt.to((Object)"FieldConfiguration", (Object)200L), TuplesKt.to((Object)"FieldLayout", (Object)200L), TuplesKt.to((Object)"FieldLayoutItem", (Object)300L), TuplesKt.to((Object)"FieldScreen", (Object)150L), TuplesKt.to((Object)"FieldScreenLayoutItem", (Object)100L), TuplesKt.to((Object)"FieldScreenScheme", (Object)100L), TuplesKt.to((Object)"FieldScreenSchemeItem", (Object)100L), TuplesKt.to((Object)"FieldScreenTab", (Object)100L), TuplesKt.to((Object)"FileAttachment", (Object)200L), TuplesKt.to((Object)"GadgetUserPreference", (Object)100L), TuplesKt.to((Object)"GenericConfiguration", (Object)100L), TuplesKt.to((Object)"GlobalPermissionEntry", (Object)100L), TuplesKt.to((Object)"cwd_group", (Object)200L), TuplesKt.to((Object)"jiraissue", (Object)2000L), TuplesKt.to((Object)"IssueLink", (Object)100L), TuplesKt.to((Object)"IssueLinkType", (Object)150L), TuplesKt.to((Object)"IssueSecurityScheme", (Object)100L), TuplesKt.to((Object)"IssueType", (Object)150L), TuplesKt.to((Object)"IssueTypeScreenScheme", (Object)100L), TuplesKt.to((Object)"IssueTypeScreenSchemeEntity", (Object)100L), TuplesKt.to((Object)"jquartz_locks", (Object)50L), TuplesKt.to((Object)"Label", (Object)100L), TuplesKt.to((Object)"licenserolesdefault", (Object)100L), TuplesKt.to((Object)"licenserolesgroup", (Object)100L), TuplesKt.to((Object)"ListenerConfig", (Object)150L), TuplesKt.to((Object)"ManagedConfigurationItem", (Object)300L), TuplesKt.to((Object)"cwd_membership", (Object)250L), TuplesKt.to((Object)"NodeAssociation", (Object)150L), TuplesKt.to((Object)"Notification", (Object)100L), TuplesKt.to((Object)"NotificationScheme", (Object)100L), TuplesKt.to((Object)"os_currentstep", (Object)150L), TuplesKt.to((Object)"os_currentstep_prev", (Object)150L), TuplesKt.to((Object)"os_historystep", (Object)150L), TuplesKt.to((Object)"propertydate", (Object)100L), TuplesKt.to((Object)"propertyentry", (Object)150L), TuplesKt.to((Object)"propertynumber", (Object)50L), TuplesKt.to((Object)"propertystring", (Object)100L), TuplesKt.to((Object)"propertytext", (Object)2000L), TuplesKt.to((Object)"os_wfentry", (Object)100L), TuplesKt.to((Object)"OptionConfiguration", (Object)100L), TuplesKt.to((Object)"PermissionScheme", (Object)200L), TuplesKt.to((Object)"PluginState", (Object)100L), TuplesKt.to((Object)"PluginVersion", (Object)150L), TuplesKt.to((Object)"PortalPage", (Object)100L), TuplesKt.to((Object)"PortletConfiguration", (Object)150L), TuplesKt.to((Object)"Priority", (Object)150L), TuplesKt.to((Object)"ProductLicense", (Object)650L), TuplesKt.to((Object)"Project", (Object)1000L), TuplesKt.to((Object)"project_key", (Object)100L), TuplesKt.to((Object)"ProjectRole", (Object)100L), TuplesKt.to((Object)"ProjectRoleActor", (Object)150L), TuplesKt.to((Object)"Resolution", (Object)300L), TuplesKt.to((Object)"RunDetails", (Object)200L), TuplesKt.to((Object)"SchemeIssueSecurities", (Object)100L), TuplesKt.to((Object)"SchemeIssueSecurityLevels", (Object)100L), TuplesKt.to((Object)"SchemePermissions", (Object)150L), TuplesKt.to((Object)"SearchRequest", (Object)200L), TuplesKt.to((Object)"sequence_value_item", (Object)100L), TuplesKt.to((Object)"ServiceConfig", (Object)200L), TuplesKt.to((Object)"SharePermissions", (Object)100L), TuplesKt.to((Object)"issuestatus", (Object)250L), TuplesKt.to((Object)"UpgradeHistory", (Object)200L), TuplesKt.to((Object)"UpgradeTaskHistory", (Object)150L), TuplesKt.to((Object)"UpgradeTaskHistoryAuditLog", (Object)200L), TuplesKt.to((Object)"UpgradeVersionHistory", (Object)100L), TuplesKt.to((Object)"cwd_user", (Object)700L), TuplesKt.to((Object)"UserAssociation", (Object)150L), TuplesKt.to((Object)"cwd_user_attributes", (Object)200L), TuplesKt.to((Object)"UserHistoryItem", (Object)150L), TuplesKt.to((Object)"projectversion", (Object)150L), TuplesKt.to((Object)"jiraworkflows", (Object)16000L), TuplesKt.to((Object)"WorkflowScheme", (Object)300L), TuplesKt.to((Object)"WorkflowSchemeEntity", (Object)100L)};
        ENTITIES_TO_TYPICAL_SIZE = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"AO_0201F0_KB_HELPFUL_AGGR", (Object)150L), TuplesKt.to((Object)"AO_0201F0_KB_VIEW_AGGR", (Object)150L), TuplesKt.to((Object)"AO_0201F0_STATS_EVENT", (Object)200L), TuplesKt.to((Object)"AO_0201F0_STATS_EVENT_PARAM", (Object)200L), TuplesKt.to((Object)"AO_0AC321_RECOMMENDATION_AO", (Object)200L), TuplesKt.to((Object)"AO_21D670_WHITELIST_RULES", (Object)150L), TuplesKt.to((Object)"AO_21F425_MESSAGE_AO", (Object)200L), TuplesKt.to((Object)"AO_21F425_MESSAGE_MAPPING_AO", (Object)200L), TuplesKt.to((Object)"AO_21F425_USER_PROPERTY_AO", (Object)200L), TuplesKt.to((Object)"AO_2C4E5C_MAILCHANNEL", (Object)350L), TuplesKt.to((Object)"AO_2C4E5C_MAILCONNECTION", (Object)600L), TuplesKt.to((Object)"AO_2C4E5C_MAILGLOBALHANDLER", (Object)200L), TuplesKt.to((Object)"AO_2C4E5C_MAILHANDLER", (Object)250L), TuplesKt.to((Object)"AO_2C4E5C_MAILITEM", (Object)200L), TuplesKt.to((Object)"AO_2C4E5C_MAILITEMAUDIT", (Object)300L), TuplesKt.to((Object)"AO_2C4E5C_MAILITEMCHUNK", (Object)200L), TuplesKt.to((Object)"AO_2C4E5C_MAILRUNAUDIT", (Object)200L), TuplesKt.to((Object)"AO_319474_MESSAGE", (Object)1200L), TuplesKt.to((Object)"AO_319474_MESSAGE_PROPERTY", (Object)200L), TuplesKt.to((Object)"AO_319474_QUEUE", (Object)400L), TuplesKt.to((Object)"AO_319474_QUEUE_PROPERTY", (Object)400L), TuplesKt.to((Object)"AO_38321B_CUSTOM_CONTENT_LINK", (Object)150L), TuplesKt.to((Object)"AO_3B1893_LOOP_DETECTION", (Object)150L), TuplesKt.to((Object)"AO_4789DD_HEALTH_CHECK_STATUS", (Object)600L), TuplesKt.to((Object)"AO_4789DD_PROPERTIES", (Object)150L), TuplesKt.to((Object)"AO_4789DD_READ_NOTIFICATIONS", (Object)200L), TuplesKt.to((Object)"AO_4789DD_TASK_MONITOR", (Object)300L), TuplesKt.to((Object)"AO_4AEACD_WEBHOOK_DAO", (Object)600L), TuplesKt.to((Object)"AO_4E8AE6_NOTIF_BATCH_QUEUE", (Object)600L), TuplesKt.to((Object)"AO_4E8AE6_OUT_EMAIL_SETTINGS", (Object)150L), TuplesKt.to((Object)"AO_54307E_ASYNCUPGRADERECORD", (Object)300L), TuplesKt.to((Object)"AO_54307E_CAPABILITY", (Object)150L), TuplesKt.to((Object)"AO_54307E_CONFLUENCEKB", (Object)400L), TuplesKt.to((Object)"AO_54307E_CONFLUENCEKBENABLED", (Object)200L), TuplesKt.to((Object)"AO_54307E_CONFLUENCEKBLABELS", (Object)200L), TuplesKt.to((Object)"AO_54307E_CUSTOMGLOBALTHEME", (Object)500L), TuplesKt.to((Object)"AO_54307E_CUSTOMTHEME", (Object)150L), TuplesKt.to((Object)"AO_54307E_EMAILCHANNELSETTING", (Object)200L), TuplesKt.to((Object)"AO_54307E_EMAILSETTINGS", (Object)400L), TuplesKt.to((Object)"AO_54307E_GOAL", (Object)300L), TuplesKt.to((Object)"AO_54307E_GROUP", (Object)150L), TuplesKt.to((Object)"AO_54307E_GROUPTOREQUESTTYPE", (Object)150L), TuplesKt.to((Object)"AO_54307E_IMAGES", (Object)150000L), TuplesKt.to((Object)"AO_54307E_METRICCONDITION", (Object)200L), TuplesKt.to((Object)"AO_54307E_ORGANIZATION", (Object)200L), TuplesKt.to((Object)"AO_54307E_ORGANIZATION_MEMBER", (Object)150L), TuplesKt.to((Object)"AO_54307E_ORGANIZATION_PROJECT", (Object)100L), TuplesKt.to((Object)"AO_54307E_OUT_EMAIL_SETTINGS", (Object)400L), TuplesKt.to((Object)"AO_54307E_PARTICIPANTSETTINGS", (Object)200L), TuplesKt.to((Object)"AO_54307E_QUEUE", (Object)300L), TuplesKt.to((Object)"AO_54307E_QUEUECOLUMN", (Object)150L), TuplesKt.to((Object)"AO_54307E_REPORT", (Object)400L), TuplesKt.to((Object)"AO_54307E_SERIES", (Object)400L), TuplesKt.to((Object)"AO_54307E_SERVICEDESK", (Object)400L), TuplesKt.to((Object)"AO_54307E_SLAAUDITLOG", (Object)150L), TuplesKt.to((Object)"AO_54307E_SLAAUDITLOGDATA", (Object)150L), TuplesKt.to((Object)"AO_54307E_STATUSMAPPING", (Object)150L), TuplesKt.to((Object)"AO_54307E_SUBSCRIPTION", (Object)150L), TuplesKt.to((Object)"AO_54307E_SYNCUPGRADERECORD", (Object)300L), TuplesKt.to((Object)"AO_54307E_THRESHOLD", (Object)100L), TuplesKt.to((Object)"AO_54307E_TIMEMETRIC", (Object)400L), TuplesKt.to((Object)"AO_54307E_VIEWPORT", (Object)350L), TuplesKt.to((Object)"AO_54307E_VIEWPORTFIELD", (Object)300L), TuplesKt.to((Object)"AO_54307E_VIEWPORTFIELDVALUE", (Object)350L), TuplesKt.to((Object)"AO_54307E_VIEWPORTFORM", (Object)350L), TuplesKt.to((Object)"AO_550953_SHORTCUT", (Object)300L), TuplesKt.to((Object)"AO_563AEE_ACTIVITY_ENTITY", (Object)600L), TuplesKt.to((Object)"AO_563AEE_ACTOR_ENTITY", (Object)400L), TuplesKt.to((Object)"AO_563AEE_MEDIA_LINK_ENTITY", (Object)400L), TuplesKt.to((Object)"AO_563AEE_OBJECT_ENTITY", (Object)400L), TuplesKt.to((Object)"AO_563AEE_TARGET_ENTITY", (Object)400L), TuplesKt.to((Object)"AO_56464C_APPROVAL", (Object)350L), TuplesKt.to((Object)"AO_56464C_APPROVER", (Object)150L), TuplesKt.to((Object)"AO_56464C_APPROVERDECISION", (Object)200L), TuplesKt.to((Object)"AO_56464C_NOTIFICATIONRECORD", (Object)400L), TuplesKt.to((Object)"AO_575BF5_DEV_SUMMARY", (Object)400L), TuplesKt.to((Object)"AO_575BF5_PROCESSED_COMMITS", (Object)200L), TuplesKt.to((Object)"AO_575BF5_PROVIDER_ISSUE", (Object)200L), TuplesKt.to((Object)"AO_575BF5_PROVIDER_SEQ_NO", (Object)400L), TuplesKt.to((Object)"AO_587B34_GLANCE_CONFIG", (Object)300L), TuplesKt.to((Object)"AO_587B34_PROJECT_CONFIG", (Object)350L), TuplesKt.to((Object)"AO_5FB9D7_AOHIP_CHAT_LINK", (Object)400L), TuplesKt.to((Object)"AO_5FB9D7_AOHIP_CHAT_USER", (Object)400L), TuplesKt.to((Object)"AO_60DB71_AUDITENTRY", (Object)300L), TuplesKt.to((Object)"AO_60DB71_BOARDADMINS", (Object)150L), TuplesKt.to((Object)"AO_60DB71_CARDCOLOR", (Object)200L), TuplesKt.to((Object)"AO_60DB71_CARDLAYOUT", (Object)200L), TuplesKt.to((Object)"AO_60DB71_COLUMN", (Object)250L), TuplesKt.to((Object)"AO_60DB71_COLUMNSTATUS", (Object)150L), TuplesKt.to((Object)"AO_60DB71_DETAILVIEWFIELD", (Object)150L), TuplesKt.to((Object)"AO_60DB71_ESTIMATESTATISTIC", (Object)150L), TuplesKt.to((Object)"AO_60DB71_ISSUERANKING", (Object)150L), TuplesKt.to((Object)"AO_60DB71_ISSUERANKINGLOG", (Object)400L), TuplesKt.to((Object)"AO_60DB71_LEXORANK", (Object)265L), TuplesKt.to((Object)"AO_60DB71_LEXORANKBALANCER", (Object)400L), TuplesKt.to((Object)"AO_60DB71_NONWORKINGDAY", (Object)150L), TuplesKt.to((Object)"AO_60DB71_QUICKFILTER", (Object)350L), TuplesKt.to((Object)"AO_60DB71_RANKABLEOBJECT", (Object)50L), TuplesKt.to((Object)"AO_60DB71_RAPIDVIEW", (Object)500L), TuplesKt.to((Object)"AO_60DB71_SPRINT", (Object)400L), TuplesKt.to((Object)"AO_60DB71_STATSFIELD", (Object)100L), TuplesKt.to((Object)"AO_60DB71_SUBQUERY", (Object)200L), TuplesKt.to((Object)"AO_60DB71_SWIMLANE", (Object)300L), TuplesKt.to((Object)"AO_60DB71_TRACKINGSTATISTIC", (Object)150L), TuplesKt.to((Object)"AO_60DB71_VERSION", (Object)150L), TuplesKt.to((Object)"AO_60DB71_WORKINGDAYS", (Object)300L), TuplesKt.to((Object)"AO_6FF49D_ACTUAL_MIG_COUNTS", (Object)300L), TuplesKt.to((Object)"AO_6FF49D_ANALYTICS_EVENT", (Object)1000L), TuplesKt.to((Object)"AO_6FF49D_APP_ASSESSMENT_INFO", (Object)400L), TuplesKt.to((Object)"AO_6FF49D_CLOUD_SITE", (Object)300L), TuplesKt.to((Object)"AO_6FF49D_CONFIG_ITEMS", (Object)400L), TuplesKt.to((Object)"AO_6FF49D_EXPECTED_MIG_COUNTS", (Object)200L), TuplesKt.to((Object)"AO_6FF49D_GBL_EXPORT_CONTEXT", (Object)400L), TuplesKt.to((Object)"AO_6FF49D_MIGRATED_FILE", (Object)400L), TuplesKt.to((Object)"AO_6FF49D_MIGRATION_ENTITY", (Object)400L), TuplesKt.to((Object)"AO_6FF49D_MIGRATION_SCOPE", (Object)400L), TuplesKt.to((Object)"AO_6FF49D_MIG_REPORT_STATUS", (Object)300L), TuplesKt.to((Object)"AO_6FF49D_PLAN_ENTITY", (Object)800L), TuplesKt.to((Object)"AO_6FF49D_TOMBSTONE_ACCOUNT", (Object)200L), TuplesKt.to((Object)"AO_6FF49D_UNSUPPORTED_EMAIL", (Object)400L), TuplesKt.to((Object)"AO_6FF49D_UNSUPPORTED_ENTITY", (Object)400L), TuplesKt.to((Object)"AO_6FF49D_USERS_GROUPS_EXTRACT", (Object)400L), TuplesKt.to((Object)"AO_6FF49D_USER_EMAIL_EVENT_LOG", (Object)400L), TuplesKt.to((Object)"AO_7A2604_CALENDAR", (Object)200L), TuplesKt.to((Object)"AO_7A2604_HOLIDAY", (Object)200L), TuplesKt.to((Object)"AO_7A2604_WORKINGTIME", (Object)200L), TuplesKt.to((Object)"AO_82B313_ABILITY", (Object)150L), TuplesKt.to((Object)"AO_82B313_ABSENCE", (Object)200L), TuplesKt.to((Object)"AO_82B313_AVAILABILITY", (Object)200L), TuplesKt.to((Object)"AO_82B313_INIT", (Object)100L), TuplesKt.to((Object)"AO_82B313_PERSON", (Object)300L), TuplesKt.to((Object)"AO_82B313_RESOURCE", (Object)200L), TuplesKt.to((Object)"AO_82B313_SKILL", (Object)100L), TuplesKt.to((Object)"AO_82B313_TEAM", (Object)200L), TuplesKt.to((Object)"AO_97EDAB_USERINVITATION", (Object)300L), TuplesKt.to((Object)"AO_9B2E3B_EXEC_RULE_MSG_ITEM", (Object)150L), TuplesKt.to((Object)"AO_9B2E3B_IF_CONDITION_CONFIG", (Object)250L), TuplesKt.to((Object)"AO_9B2E3B_IF_COND_CONF_DATA", (Object)150L), TuplesKt.to((Object)"AO_9B2E3B_IF_COND_EXECUTION", (Object)250L), TuplesKt.to((Object)"AO_9B2E3B_IF_EXECUTION", (Object)250L), TuplesKt.to((Object)"AO_9B2E3B_IF_THEN", (Object)100L), TuplesKt.to((Object)"AO_9B2E3B_IF_THEN_EXECUTION", (Object)250L), TuplesKt.to((Object)"AO_9B2E3B_PROJECT_USER_CONTEXT", (Object)150L), TuplesKt.to((Object)"AO_9B2E3B_RSETREV_PROJ_CONTEXT", (Object)100L), TuplesKt.to((Object)"AO_9B2E3B_RSETREV_USER_CONTEXT", (Object)150L), TuplesKt.to((Object)"AO_9B2E3B_RULE", (Object)150L), TuplesKt.to((Object)"AO_9B2E3B_RULESET", (Object)100L), TuplesKt.to((Object)"AO_9B2E3B_RULESET_REVISION", (Object)350L), TuplesKt.to((Object)"AO_9B2E3B_RULE_EXECUTION", (Object)250L), TuplesKt.to((Object)"AO_9B2E3B_THEN_ACTION_CONFIG", (Object)250L), TuplesKt.to((Object)"AO_9B2E3B_THEN_ACT_CONF_DATA", (Object)250L), TuplesKt.to((Object)"AO_9B2E3B_THEN_ACT_EXECUTION", (Object)250L), TuplesKt.to((Object)"AO_9B2E3B_THEN_EXECUTION", (Object)250L), TuplesKt.to((Object)"AO_9B2E3B_WHEN_HANDLER_CONFIG", (Object)250L), TuplesKt.to((Object)"AO_9B2E3B_WHEN_HAND_CONF_DATA", (Object)250L), TuplesKt.to((Object)"AO_A0B856_WEB_HOOK_LISTENER_AO", (Object)400L), TuplesKt.to((Object)"AO_A415DF_AOABILITY", (Object)200L), TuplesKt.to((Object)"AO_A415DF_AOABSENCE", (Object)350L), TuplesKt.to((Object)"AO_A415DF_AOAVAILABILITY", (Object)350L), TuplesKt.to((Object)"AO_A415DF_AOCONFIGURATION", (Object)100L), TuplesKt.to((Object)"AO_A415DF_AOCUSTOM_WORDING", (Object)100L), TuplesKt.to((Object)"AO_A415DF_AODEPENDENCY", (Object)100L), TuplesKt.to((Object)"AO_A415DF_AODOOR_STOP", (Object)50L), TuplesKt.to((Object)"AO_A415DF_AOESTIMATE", (Object)250L), TuplesKt.to((Object)"AO_A415DF_AOEXTENSION_LINK", (Object)300L), TuplesKt.to((Object)"AO_A415DF_AONON_WORKING_DAYS", (Object)350L), TuplesKt.to((Object)"AO_A415DF_AOPERMISSION", (Object)250L), TuplesKt.to((Object)"AO_A415DF_AOPERSON", (Object)250L), TuplesKt.to((Object)"AO_A415DF_AOPLAN", (Object)400L), TuplesKt.to((Object)"AO_A415DF_AOPLAN_CONFIGURATION", (Object)1000L), TuplesKt.to((Object)"AO_A415DF_AOPRESENCE", (Object)300L), TuplesKt.to((Object)"AO_A415DF_AORELEASE", (Object)500L), TuplesKt.to((Object)"AO_A415DF_AOREPLANNING", (Object)150L), TuplesKt.to((Object)"AO_A415DF_AORESOURCE", (Object)200L), TuplesKt.to((Object)"AO_A415DF_AOSKILL", (Object)300L), TuplesKt.to((Object)"AO_A415DF_AOSOLUTION_STORE", (Object)300000L), TuplesKt.to((Object)"AO_A415DF_AOSPRINT", (Object)350L), TuplesKt.to((Object)"AO_A415DF_AOSTAGE", (Object)300L), TuplesKt.to((Object)"AO_A415DF_AOSTREAM", (Object)300L), TuplesKt.to((Object)"AO_A415DF_AOSTREAM_TO_TEAM", (Object)150L), TuplesKt.to((Object)"AO_A415DF_AOTEAM", (Object)500L), TuplesKt.to((Object)"AO_A415DF_AOTHEME", (Object)300L), TuplesKt.to((Object)"AO_A415DF_AOWORK_ITEM", (Object)1000L), TuplesKt.to((Object)"AO_A415DF_AOWORK_ITEM_TO_RES", (Object)150L), TuplesKt.to((Object)"AO_B9A0F0_APPLIED_TEMPLATE", (Object)250L), TuplesKt.to((Object)"AO_C16815_ALERT_AO", (Object)1000L), TuplesKt.to((Object)"AO_C7F17E_LINGO", (Object)300L), TuplesKt.to((Object)"AO_C7F17E_LINGO_REVISION", (Object)100L), TuplesKt.to((Object)"AO_C7F17E_LINGO_TRANSLATION", (Object)250L), TuplesKt.to((Object)"AO_C7F17E_PROJECT_LANGUAGE", (Object)200L), TuplesKt.to((Object)"AO_C7F17E_PROJECT_LANG_CONFIG", (Object)150L), TuplesKt.to((Object)"AO_C7F17E_PROJECT_LANG_REV", (Object)200L), TuplesKt.to((Object)"AO_CFF990_AOTRANSITION_FAILURE", (Object)500L), TuplesKt.to((Object)"AO_D530BB_CANNEDRESPONSE", (Object)1000L), TuplesKt.to((Object)"AO_D530BB_CANNEDRESPONSEAUDIT", (Object)1000L), TuplesKt.to((Object)"AO_D530BB_CANNEDRESPONSEUSAGE", (Object)400L), TuplesKt.to((Object)"AO_D530BB_CRAUDITACTIONDATA", (Object)400L), TuplesKt.to((Object)"AO_D9132D_ASSIGNMENT", (Object)400L), TuplesKt.to((Object)"AO_D9132D_ASSIGNMENT_EXT", (Object)500L), TuplesKt.to((Object)"AO_D9132D_CONFIGURATION", (Object)150L), TuplesKt.to((Object)"AO_D9132D_DEP_ISSUE_LINK_TYPES", (Object)100L), TuplesKt.to((Object)"AO_D9132D_DISTRIBUTION", (Object)200L), TuplesKt.to((Object)"AO_D9132D_EXCLUDED_VERSIONS", (Object)100L), TuplesKt.to((Object)"AO_D9132D_GENERICREPORT", (Object)15000L), TuplesKt.to((Object)"AO_D9132D_HIERARCHY_CONFIG", (Object)150L), TuplesKt.to((Object)"AO_D9132D_INIT", (Object)100L), TuplesKt.to((Object)"AO_D9132D_ISSUE_SOURCE", (Object)150L), TuplesKt.to((Object)"AO_D9132D_NONWORKINGDAYS", (Object)200L), TuplesKt.to((Object)"AO_D9132D_PERMISSIONS", (Object)150L), TuplesKt.to((Object)"AO_D9132D_PLAN", (Object)1500L), TuplesKt.to((Object)"AO_D9132D_PLANNED_CAPACITY", (Object)300L), TuplesKt.to((Object)"AO_D9132D_PLANSKILL", (Object)200L), TuplesKt.to((Object)"AO_D9132D_PLANTEAM", (Object)250L), TuplesKt.to((Object)"AO_D9132D_PLANTHEME", (Object)150L), TuplesKt.to((Object)"AO_D9132D_PLANVERSION", (Object)200L), TuplesKt.to((Object)"AO_D9132D_PLAN_CUSTOM_FIELD", (Object)200L), TuplesKt.to((Object)"AO_D9132D_PLAN_USER_PROPERTY", (Object)5000L), TuplesKt.to((Object)"AO_D9132D_PLAN_US_PR_MAPPING", (Object)400L), TuplesKt.to((Object)"AO_D9132D_PROGRAM", (Object)400L), TuplesKt.to((Object)"AO_D9132D_PROGRAM_CUSTOM_FIELD", (Object)400L), TuplesKt.to((Object)"AO_D9132D_RANK_ITEM", (Object)200L), TuplesKt.to((Object)"AO_D9132D_SAVED_VIEW", (Object)400L), TuplesKt.to((Object)"AO_D9132D_SAVED_VIEW2", (Object)4000L), TuplesKt.to((Object)"AO_D9132D_SCENARIO", (Object)200L), TuplesKt.to((Object)"AO_D9132D_SCENARIO_ABILITY", (Object)500L), TuplesKt.to((Object)"AO_D9132D_SCENARIO_AVLBLTY", (Object)200L), TuplesKt.to((Object)"AO_D9132D_SCENARIO_CHANGES", (Object)200L), TuplesKt.to((Object)"AO_D9132D_SCENARIO_ISSUES", (Object)2000L), TuplesKt.to((Object)"AO_D9132D_SCENARIO_ISSUE_CMPNT", (Object)100L), TuplesKt.to((Object)"AO_D9132D_SCENARIO_ISSUE_LABEL", (Object)100L), TuplesKt.to((Object)"AO_D9132D_SCENARIO_ISSUE_LINKS", (Object)500L), TuplesKt.to((Object)"AO_D9132D_SCENARIO_ISSUE_RES", (Object)150L), TuplesKt.to((Object)"AO_D9132D_SCENARIO_PERSON", (Object)400L), TuplesKt.to((Object)"AO_D9132D_SCENARIO_PLAN_CAP", (Object)500L), TuplesKt.to((Object)"AO_D9132D_SCENARIO_RESOURCE", (Object)600L), TuplesKt.to((Object)"AO_D9132D_SCENARIO_SKILL", (Object)600L), TuplesKt.to((Object)"AO_D9132D_SCENARIO_STAGE", (Object)500L), TuplesKt.to((Object)"AO_D9132D_SCENARIO_TEAM", (Object)800L), TuplesKt.to((Object)"AO_D9132D_SCENARIO_THEME", (Object)600L), TuplesKt.to((Object)"AO_D9132D_SCENARIO_VERSION", (Object)800L), TuplesKt.to((Object)"AO_D9132D_SCENARIO_XPVERSION", (Object)400L), TuplesKt.to((Object)"AO_D9132D_SCEN_CSTM_FLD_MVAL", (Object)100L), TuplesKt.to((Object)"AO_D9132D_SCEN_CUSTOM_FIELD", (Object)250L), TuplesKt.to((Object)"AO_D9132D_SCEN_TEAM_EX_SPRINT", (Object)100L), TuplesKt.to((Object)"AO_D9132D_SHARED_REPORT", (Object)800L), TuplesKt.to((Object)"AO_D9132D_SOLUTION", (Object)30000L), TuplesKt.to((Object)"AO_D9132D_STAGE", (Object)200L), TuplesKt.to((Object)"AO_D9132D_TEAM_EX_SPRINT", (Object)100L), TuplesKt.to((Object)"AO_D9132D_THEME", (Object)150L), TuplesKt.to((Object)"AO_D9132D_VERSION_ENRICHMENT", (Object)100L), TuplesKt.to((Object)"AO_D9132D_X_PROJECT_VERSION", (Object)100L), TuplesKt.to((Object)"AO_E8B6CC_BRANCH", (Object)100L), TuplesKt.to((Object)"AO_E8B6CC_BRANCH_HEAD_MAPPING", (Object)100L), TuplesKt.to((Object)"AO_E8B6CC_CHANGESET_MAPPING", (Object)500L), TuplesKt.to((Object)"AO_E8B6CC_COMMIT", (Object)400L), TuplesKt.to((Object)"AO_E8B6CC_GIT_HUB_EVENT", (Object)150L), TuplesKt.to((Object)"AO_E8B6CC_ISSUE_MAPPING", (Object)400L), TuplesKt.to((Object)"AO_E8B6CC_ISSUE_MAPPING_V2", (Object)400L), TuplesKt.to((Object)"AO_E8B6CC_ISSUE_TO_BRANCH", (Object)100L), TuplesKt.to((Object)"AO_E8B6CC_ISSUE_TO_CHANGESET", (Object)100L), TuplesKt.to((Object)"AO_E8B6CC_MESSAGE", (Object)4000L), TuplesKt.to((Object)"AO_E8B6CC_MESSAGE_QUEUE_ITEM", (Object)200L), TuplesKt.to((Object)"AO_E8B6CC_MESSAGE_TAG", (Object)150L), TuplesKt.to((Object)"AO_E8B6CC_ORGANIZATION_MAPPING", (Object)600L), TuplesKt.to((Object)"AO_E8B6CC_ORG_TO_PROJECT", (Object)100L), TuplesKt.to((Object)"AO_E8B6CC_PROJECT_MAPPING", (Object)400L), TuplesKt.to((Object)"AO_E8B6CC_PROJECT_MAPPING_V2", (Object)400L), TuplesKt.to((Object)"AO_E8B6CC_PR_ISSUE_KEY", (Object)100L), TuplesKt.to((Object)"AO_E8B6CC_PR_PARTICIPANT", (Object)150L), TuplesKt.to((Object)"AO_E8B6CC_PR_TO_COMMIT", (Object)100L), TuplesKt.to((Object)"AO_E8B6CC_PULL_REQUEST", (Object)400L), TuplesKt.to((Object)"AO_E8B6CC_REPOSITORY_MAPPING", (Object)800L), TuplesKt.to((Object)"AO_E8B6CC_REPO_TO_CHANGESET", (Object)100L), TuplesKt.to((Object)"AO_E8B6CC_REPO_TO_PROJECT", (Object)100L), TuplesKt.to((Object)"AO_E8B6CC_SYNC_AUDIT_LOG", (Object)500L), TuplesKt.to((Object)"AO_E8B6CC_SYNC_EVENT", (Object)200L), TuplesKt.to((Object)"AO_ED669C_SEEN_ASSERTIONS", (Object)400L), TuplesKt.to((Object)"AO_F1B27B_HISTORY_RECORD", (Object)300L), TuplesKt.to((Object)"AO_F1B27B_KEY_COMPONENT", (Object)200L), TuplesKt.to((Object)"AO_F1B27B_KEY_COMP_HISTORY", (Object)150L), TuplesKt.to((Object)"AO_F1B27B_PROMISE", (Object)400L), TuplesKt.to((Object)"AO_F1B27B_PROMISE_HISTORY", (Object)250L)};
        ACTIVEOBJECTS_TO_TYPICAL_SIZE = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/export/size/ExportSizeService$Companion;", "", "()V", "ACTIVEOBJECTS_TO_TYPICAL_SIZE", "", "", "", "getACTIVEOBJECTS_TO_TYPICAL_SIZE", "()Ljava/util/Map;", "ACTIVE_OBJECTS_XML_OVERHEAD", "DB_LOOKUP_TIMEOUT", "ENTITIES_TO_TYPICAL_SIZE", "getENTITIES_TO_TYPICAL_SIZE", "ENTITIES_XML_OVERHEAD", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Long> getENTITIES_TO_TYPICAL_SIZE() {
            return ENTITIES_TO_TYPICAL_SIZE;
        }

        @NotNull
        public final Map<String, Long> getACTIVEOBJECTS_TO_TYPICAL_SIZE() {
            return ACTIVEOBJECTS_TO_TYPICAL_SIZE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/export/size/ExportSizeService$CountAndRuntime;", "", "count", "", "runtimeMs", "(JJ)V", "getCount", "()J", "getRuntimeMs", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jira-migration-plugin"})
    public static final class CountAndRuntime {
        private final long count;
        private final long runtimeMs;

        public CountAndRuntime(long count2, long runtimeMs) {
            this.count = count2;
            this.runtimeMs = runtimeMs;
        }

        public final long getCount() {
            return this.count;
        }

        public final long getRuntimeMs() {
            return this.runtimeMs;
        }

        public final long component1() {
            return this.count;
        }

        public final long component2() {
            return this.runtimeMs;
        }

        @NotNull
        public final CountAndRuntime copy(long count2, long runtimeMs) {
            return new CountAndRuntime(count2, runtimeMs);
        }

        public static /* synthetic */ CountAndRuntime copy$default(CountAndRuntime countAndRuntime, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = countAndRuntime.count;
            }
            if ((n & 2) != 0) {
                l2 = countAndRuntime.runtimeMs;
            }
            return countAndRuntime.copy(l, l2);
        }

        @NotNull
        public String toString() {
            return "CountAndRuntime(count=" + this.count + ", runtimeMs=" + this.runtimeMs + ')';
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.count);
            result2 = result2 * 31 + Long.hashCode(this.runtimeMs);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CountAndRuntime)) {
                return false;
            }
            CountAndRuntime countAndRuntime = (CountAndRuntime)other;
            if (this.count != countAndRuntime.count) {
                return false;
            }
            return this.runtimeMs == countAndRuntime.runtimeMs;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J[\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/atlassian/jira/migration/export/size/ExportSizeService$DatabaseEstimate;", "", "entityOverhead", "", "entities", "", "Lcom/atlassian/jira/migration/export/size/ExportSizeService$TableEstimate;", "activeObjectOverhead", "activeObjects", "total", "clockRunTimeMs", "cpuRunTimeMs", "(JLjava/util/List;JLjava/util/List;JJJ)V", "getActiveObjectOverhead", "()J", "getActiveObjects", "()Ljava/util/List;", "getClockRunTimeMs", "getCpuRunTimeMs", "getEntities", "getEntityOverhead", "getTotal", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jira-migration-plugin"})
    public static final class DatabaseEstimate {
        private final long entityOverhead;
        @NotNull
        private final List<TableEstimate> entities;
        private final long activeObjectOverhead;
        @NotNull
        private final List<TableEstimate> activeObjects;
        private final long total;
        private final long clockRunTimeMs;
        private final long cpuRunTimeMs;

        public DatabaseEstimate(long entityOverhead, @NotNull List<TableEstimate> entities, long activeObjectOverhead, @NotNull List<TableEstimate> activeObjects, long total, long clockRunTimeMs, long cpuRunTimeMs) {
            Intrinsics.checkNotNullParameter(entities, (String)"entities");
            Intrinsics.checkNotNullParameter(activeObjects, (String)"activeObjects");
            this.entityOverhead = entityOverhead;
            this.entities = entities;
            this.activeObjectOverhead = activeObjectOverhead;
            this.activeObjects = activeObjects;
            this.total = total;
            this.clockRunTimeMs = clockRunTimeMs;
            this.cpuRunTimeMs = cpuRunTimeMs;
        }

        public final long getEntityOverhead() {
            return this.entityOverhead;
        }

        @NotNull
        public final List<TableEstimate> getEntities() {
            return this.entities;
        }

        public final long getActiveObjectOverhead() {
            return this.activeObjectOverhead;
        }

        @NotNull
        public final List<TableEstimate> getActiveObjects() {
            return this.activeObjects;
        }

        public final long getTotal() {
            return this.total;
        }

        public final long getClockRunTimeMs() {
            return this.clockRunTimeMs;
        }

        public final long getCpuRunTimeMs() {
            return this.cpuRunTimeMs;
        }

        public final long component1() {
            return this.entityOverhead;
        }

        @NotNull
        public final List<TableEstimate> component2() {
            return this.entities;
        }

        public final long component3() {
            return this.activeObjectOverhead;
        }

        @NotNull
        public final List<TableEstimate> component4() {
            return this.activeObjects;
        }

        public final long component5() {
            return this.total;
        }

        public final long component6() {
            return this.clockRunTimeMs;
        }

        public final long component7() {
            return this.cpuRunTimeMs;
        }

        @NotNull
        public final DatabaseEstimate copy(long entityOverhead, @NotNull List<TableEstimate> entities, long activeObjectOverhead, @NotNull List<TableEstimate> activeObjects, long total, long clockRunTimeMs, long cpuRunTimeMs) {
            Intrinsics.checkNotNullParameter(entities, (String)"entities");
            Intrinsics.checkNotNullParameter(activeObjects, (String)"activeObjects");
            return new DatabaseEstimate(entityOverhead, entities, activeObjectOverhead, activeObjects, total, clockRunTimeMs, cpuRunTimeMs);
        }

        public static /* synthetic */ DatabaseEstimate copy$default(DatabaseEstimate databaseEstimate, long l, List list, long l2, List list2, long l3, long l4, long l5, int n, Object object) {
            if ((n & 1) != 0) {
                l = databaseEstimate.entityOverhead;
            }
            if ((n & 2) != 0) {
                list = databaseEstimate.entities;
            }
            if ((n & 4) != 0) {
                l2 = databaseEstimate.activeObjectOverhead;
            }
            if ((n & 8) != 0) {
                list2 = databaseEstimate.activeObjects;
            }
            if ((n & 0x10) != 0) {
                l3 = databaseEstimate.total;
            }
            if ((n & 0x20) != 0) {
                l4 = databaseEstimate.clockRunTimeMs;
            }
            if ((n & 0x40) != 0) {
                l5 = databaseEstimate.cpuRunTimeMs;
            }
            return databaseEstimate.copy(l, list, l2, list2, l3, l4, l5);
        }

        @NotNull
        public String toString() {
            return "DatabaseEstimate(entityOverhead=" + this.entityOverhead + ", entities=" + this.entities + ", activeObjectOverhead=" + this.activeObjectOverhead + ", activeObjects=" + this.activeObjects + ", total=" + this.total + ", clockRunTimeMs=" + this.clockRunTimeMs + ", cpuRunTimeMs=" + this.cpuRunTimeMs + ')';
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.entityOverhead);
            result2 = result2 * 31 + ((Object)this.entities).hashCode();
            result2 = result2 * 31 + Long.hashCode(this.activeObjectOverhead);
            result2 = result2 * 31 + ((Object)this.activeObjects).hashCode();
            result2 = result2 * 31 + Long.hashCode(this.total);
            result2 = result2 * 31 + Long.hashCode(this.clockRunTimeMs);
            result2 = result2 * 31 + Long.hashCode(this.cpuRunTimeMs);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DatabaseEstimate)) {
                return false;
            }
            DatabaseEstimate databaseEstimate = (DatabaseEstimate)other;
            if (this.entityOverhead != databaseEstimate.entityOverhead) {
                return false;
            }
            if (!Intrinsics.areEqual(this.entities, databaseEstimate.entities)) {
                return false;
            }
            if (this.activeObjectOverhead != databaseEstimate.activeObjectOverhead) {
                return false;
            }
            if (!Intrinsics.areEqual(this.activeObjects, databaseEstimate.activeObjects)) {
                return false;
            }
            if (this.total != databaseEstimate.total) {
                return false;
            }
            if (this.clockRunTimeMs != databaseEstimate.clockRunTimeMs) {
                return false;
            }
            return this.cpuRunTimeMs == databaseEstimate.cpuRunTimeMs;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/jira/migration/export/size/ExportSizeService$TableEstimate;", "", "table", "", "count", "", "size", "runtimeMs", "(Ljava/lang/String;JJJ)V", "getCount", "()J", "getRuntimeMs", "getSize", "getTable", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class TableEstimate {
        @NotNull
        private final String table;
        private final long count;
        private final long size;
        private final long runtimeMs;

        public TableEstimate(@NotNull String table, long count2, long size, long runtimeMs) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            this.table = table;
            this.count = count2;
            this.size = size;
            this.runtimeMs = runtimeMs;
        }

        @NotNull
        public final String getTable() {
            return this.table;
        }

        public final long getCount() {
            return this.count;
        }

        public final long getSize() {
            return this.size;
        }

        public final long getRuntimeMs() {
            return this.runtimeMs;
        }

        @NotNull
        public final String component1() {
            return this.table;
        }

        public final long component2() {
            return this.count;
        }

        public final long component3() {
            return this.size;
        }

        public final long component4() {
            return this.runtimeMs;
        }

        @NotNull
        public final TableEstimate copy(@NotNull String table, long count2, long size, long runtimeMs) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            return new TableEstimate(table, count2, size, runtimeMs);
        }

        public static /* synthetic */ TableEstimate copy$default(TableEstimate tableEstimate, String string, long l, long l2, long l3, int n, Object object) {
            if ((n & 1) != 0) {
                string = tableEstimate.table;
            }
            if ((n & 2) != 0) {
                l = tableEstimate.count;
            }
            if ((n & 4) != 0) {
                l2 = tableEstimate.size;
            }
            if ((n & 8) != 0) {
                l3 = tableEstimate.runtimeMs;
            }
            return tableEstimate.copy(string, l, l2, l3);
        }

        @NotNull
        public String toString() {
            return "TableEstimate(table=" + this.table + ", count=" + this.count + ", size=" + this.size + ", runtimeMs=" + this.runtimeMs + ')';
        }

        public int hashCode() {
            int result2 = this.table.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.count);
            result2 = result2 * 31 + Long.hashCode(this.size);
            result2 = result2 * 31 + Long.hashCode(this.runtimeMs);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TableEstimate)) {
                return false;
            }
            TableEstimate tableEstimate = (TableEstimate)other;
            if (!Intrinsics.areEqual((Object)this.table, (Object)tableEstimate.table)) {
                return false;
            }
            if (this.count != tableEstimate.count) {
                return false;
            }
            if (this.size != tableEstimate.size) {
                return false;
            }
            return this.runtimeMs == tableEstimate.runtimeMs;
        }
    }
}

