/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.software.board;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.jira.migration.config.JiraSoftwareOnly;
import com.atlassian.jira.migration.export.core.filter.service.jql.FilterJqlService;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportMode;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.software.board.retrieve.RapidViewRetrieveService;
import com.atlassian.jira.migration.export.utils.InMemExportingMemoryService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.serverdataextractors.cpb.model.CrossProjectRapidViewReferringProjectsInfo;
import com.atlassian.jira.migration.serverdataextractors.cpb.service.CPBRapidViewService;
import com.atlassian.migration.base.mri.MRI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named(value="rapidViewExportService")
@Conditional(value={JiraSoftwareOnly.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 +2\u00020\u0001:\u0001+B=\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J$\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u0019H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010*\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/atlassian/jira/migration/export/software/board/RapidViewExportService;", "", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "rapidViewRetrieveService", "Lcom/atlassian/jira/migration/export/software/board/retrieve/RapidViewRetrieveService;", "filterJqlService", "Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService;", "exportingMemoryService", "Lcom/atlassian/jira/migration/export/utils/InMemExportingMemoryService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "cpbRapidViewServiceProvider", "Ljavax/inject/Provider;", "Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CPBRapidViewService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/software/board/retrieve/RapidViewRetrieveService;Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService;Lcom/atlassian/jira/migration/export/utils/InMemExportingMemoryService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Ljavax/inject/Provider;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportAllCrossProjectRapidViews", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "exportCrossProjectRapidViews", "crossProjectRapidViewList", "", "Lcom/atlassian/greenhopper/model/rapid/RapidView;", "exportCrossProjectRapidViewsReferringAnySelectedProject", "exportMultiProjectRapidViews", "exportRapidViewById", "Lcom/atlassian/migration/base/mri/MRI;", "id", "", "exportSingleProjectRapidViews", "getAllCrossProjectRapidViews", "getCrossProjectRapidViewsReferringAnySelectedProject", "selectedProjectIds", "isExportModeEligibleForMemoriseSkip", "", "exportMode", "Lcom/atlassian/jira/migration/export/framework/ExportMode;", "logSkippingExportCrossProjectRapidViews", "shouldExportCrossProjectBoards", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nRapidViewExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RapidViewExportService.kt\ncom/atlassian/jira/migration/export/software/board/RapidViewExportService\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1313#2,2:187\n1313#2,2:189\n1549#3:191\n1620#3,3:192\n1549#3:195\n1620#3,3:196\n1855#3,2:199\n*S KotlinDebug\n*F\n+ 1 RapidViewExportService.kt\ncom/atlassian/jira/migration/export/software/board/RapidViewExportService\n*L\n44#1:187,2\n67#1:189,2\n115#1:191\n115#1:192,3\n124#1:195\n124#1:196,3\n143#1:199,2\n*E\n"})
public final class RapidViewExportService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final RapidViewRetrieveService rapidViewRetrieveService;
    @NotNull
    private final FilterJqlService filterJqlService;
    @NotNull
    private final InMemExportingMemoryService exportingMemoryService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final Provider<CPBRapidViewService> cpbRapidViewServiceProvider;
    private final Logger log;
    @NotNull
    private static final Set<ExportMode> exportModeSet;

    @Inject
    public RapidViewExportService(@NotNull ExportService exportService, @NotNull RapidViewRetrieveService rapidViewRetrieveService, @NotNull FilterJqlService filterJqlService, @NotNull InMemExportingMemoryService exportingMemoryService, @NotNull MigrationFeatures migrationFeatures, @NotNull Provider<CPBRapidViewService> cpbRapidViewServiceProvider) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)rapidViewRetrieveService, (String)"rapidViewRetrieveService");
        Intrinsics.checkNotNullParameter((Object)filterJqlService, (String)"filterJqlService");
        Intrinsics.checkNotNullParameter((Object)exportingMemoryService, (String)"exportingMemoryService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter(cpbRapidViewServiceProvider, (String)"cpbRapidViewServiceProvider");
        this.exportService = exportService;
        this.rapidViewRetrieveService = rapidViewRetrieveService;
        this.filterJqlService = filterJqlService;
        this.exportingMemoryService = exportingMemoryService;
        this.migrationFeatures = migrationFeatures;
        this.cpbRapidViewServiceProvider = cpbRapidViewServiceProvider;
        this.log = LoggerFactory.getLogger(RapidViewExportService.class);
    }

    private final boolean isExportModeEligibleForMemoriseSkip(ExportMode exportMode) {
        return exportModeSet.contains((Object)exportMode);
    }

    public final void exportMultiProjectRapidViews(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this.shouldExportCrossProjectBoards(ctx)) {
            try {
                this.log.info("Exporting all multi-projects boards for migration " + ctx.getMigrationId() + " under exportMode " + (Object)((Object)ctx.getExportMode()));
                Sequence<RapidView> $this$forEach$iv = this.rapidViewRetrieveService.retrieveAllRapidViews(100);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RapidView rapidView = (RapidView)element$iv;
                    boolean bl = false;
                    List<Long> list = ctx.getProjectIds();
                    Long l = rapidView.getSavedFilterId();
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getSavedFilterId(...)");
                    FilterJqlService.JqlProjectReferenceInfo jqlProjectReferenceInfo = this.filterJqlService.collectProjectReferenceInfo(list, ((Number)l).longValue());
                    if (jqlProjectReferenceInfo == null) continue;
                    FilterJqlService.JqlProjectReferenceInfo res = jqlProjectReferenceInfo;
                    boolean bl2 = false;
                    if (res.isReferringMultiProjects()) {
                        this.log.info("Exporting multi-projects board " + rapidView.getName() + " under exportMode " + (Object)((Object)ctx.getExportMode()));
                        this.exportService.exportOrThrow(ctx, rapidView, true);
                        continue;
                    }
                    this.log.warn("Skipp exporting multi-projects board " + rapidView.getName() + " under exportMode " + (Object)((Object)ctx.getExportMode()));
                }
                this.exportingMemoryService.memorizeExportedCrossProjectsBoards(ctx.getMigrationId(), ctx.getExportMode());
            }
            catch (Exception e) {
                this.exportingMemoryService.memorizeExportFailedCrossProjectsBoards(ctx.getMigrationId(), ctx.getExportMode());
                throw e;
            }
        }
    }

    public final void exportSingleProjectRapidViews(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Sequence<RapidView> $this$forEach$iv = this.rapidViewRetrieveService.retrieveRapidViewsForProject(ctx.getStartedBy(), ctx.getProject(), ctx.getExportMode());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RapidView rapidView = (RapidView)element$iv;
            boolean bl = false;
            List<Long> list = ctx.getProjectIds();
            Long l = rapidView.getSavedFilterId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getSavedFilterId(...)");
            FilterJqlService.JqlProjectReferenceInfo jqlProjectReferenceInfo = this.filterJqlService.collectProjectReferenceInfo(list, ((Number)l).longValue());
            if (jqlProjectReferenceInfo == null) continue;
            FilterJqlService.JqlProjectReferenceInfo res = jqlProjectReferenceInfo;
            boolean bl2 = false;
            if (!res.isReferringToSingleProject()) continue;
            if (res.isReferringToCurrentProjects()) {
                this.log.info("Exporting single-project board=\"" + rapidView.getName() + "\", saved filter=\"" + res.getFilter().getName() + "\" references projects " + res.getReferringProjectIds() + " when we expect " + res.getCurrentProjectIds() + '.');
                ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, rapidView, false, 4, null);
                continue;
            }
            this.log.warn("Skip exporting single-project board=\"" + rapidView.getName() + "\", saved filter=\"" + res.getFilter().getName() + "\" references projects " + res.getReferringProjectIds() + " when we expect " + res.getCurrentProjectIds() + '.');
        }
    }

    @Nullable
    public final MRI exportRapidViewById(@NotNull ExportContext ctx, long id) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this.rapidViewRetrieveService.retrieveRapidViewById(id).map(arg_0 -> RapidViewExportService.exportRapidViewById$lambda$4((Function1)new Function1<RapidView, MRI>(this, ctx){
            final /* synthetic */ RapidViewExportService this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(1);
            }

            public final MRI invoke(RapidView rapidView) {
                RapidViewExportService.access$getLog$p(this.this$0).info("Exporting (by ID) board=\"" + rapidView.getName() + " under exportMode " + (Object)((Object)this.$ctx.getExportMode()));
                return RapidViewExportService.access$getExportService$p(this.this$0).exportOrThrow(this.$ctx, rapidView, true);
            }
        }, arg_0)).orElse(null);
    }

    public final void exportAllCrossProjectRapidViews(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this.shouldExportCrossProjectBoards(ctx)) {
            List<RapidView> crossProjectRapidViewList = this.getAllCrossProjectRapidViews(ctx);
            this.exportCrossProjectRapidViews(ctx, crossProjectRapidViewList);
        } else {
            this.logSkippingExportCrossProjectRapidViews(ctx);
        }
    }

    public final void exportCrossProjectRapidViewsReferringAnySelectedProject(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this.shouldExportCrossProjectBoards(ctx)) {
            List<RapidView> crossProjectRapidViewList = this.getCrossProjectRapidViewsReferringAnySelectedProject(ctx, ctx.getProjectIds());
            this.exportCrossProjectRapidViews(ctx, crossProjectRapidViewList);
        } else {
            this.logSkippingExportCrossProjectRapidViews(ctx);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<RapidView> getAllCrossProjectRapidViews(ExportContext ctx) {
        List list;
        List<CrossProjectRapidViewReferringProjectsInfo> list2;
        CPBRapidViewService cPBRapidViewService = (CPBRapidViewService)this.cpbRapidViewServiceProvider.get();
        if (cPBRapidViewService != null && (list2 = cPBRapidViewService.getCrossProjectRapidViewReferringProjectsInfoList(ctx)) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CrossProjectRapidViewReferringProjectsInfo crossProjectRapidViewReferringProjectsInfo = (CrossProjectRapidViewReferringProjectsInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getCrossProjectRapidView());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RapidView> getCrossProjectRapidViewsReferringAnySelectedProject(ExportContext ctx, List<Long> selectedProjectIds) {
        List list;
        List<CrossProjectRapidViewReferringProjectsInfo> list2;
        CPBRapidViewService cPBRapidViewService = (CPBRapidViewService)this.cpbRapidViewServiceProvider.get();
        if (cPBRapidViewService != null && (list2 = cPBRapidViewService.getCrossProjectRapidViewReferringProjectsInfoList(ctx, selectedProjectIds)) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            boolean $i$f$map = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CrossProjectRapidViewReferringProjectsInfo crossProjectRapidViewReferringProjectsInfo = (CrossProjectRapidViewReferringProjectsInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getCrossProjectRapidView());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final void logSkippingExportCrossProjectRapidViews(ExportContext ctx) {
        this.log.info("Skipping exporting cross project boards for migration: " + ctx.getMigrationId() + " having exportMode: " + (Object)((Object)ctx.getExportMode()));
    }

    private final void exportCrossProjectRapidViews(ExportContext ctx, List<? extends RapidView> crossProjectRapidViewList) {
        try {
            this.log.info("Exporting cross project rapid views for migration " + ctx.getMigrationId() + " under exportMode " + (Object)((Object)ctx.getExportMode()));
            Iterable $this$forEach$iv = crossProjectRapidViewList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RapidView rapidView = (RapidView)element$iv;
                boolean bl = false;
                this.log.info("Exporting cross project rapid view " + rapidView.getName() + " under exportMode " + (Object)((Object)ctx.getExportMode()));
                this.exportService.exportOrThrow(ctx, rapidView, true);
            }
            this.exportingMemoryService.memorizeExportedCrossProjectsBoards(ctx.getMigrationId(), ctx.getExportMode());
        }
        catch (Throwable e) {
            this.exportingMemoryService.memorizeExportFailedCrossProjectsBoards(ctx.getMigrationId(), ctx.getExportMode());
            throw e;
        }
    }

    private final boolean shouldExportCrossProjectBoards(ExportContext ctx) {
        return !this.migrationFeatures.getEnableFilterAndBoardMemorize() && this.isExportModeEligibleForMemoriseSkip(ctx.getExportMode()) || this.exportingMemoryService.tryMemorizeExportingCrossProjectsBoards(ctx.getMigrationId(), ctx.getExportMode());
    }

    private static final MRI exportRapidViewById$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MRI)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLog$p(RapidViewExportService $this) {
        return $this.log;
    }

    public static final /* synthetic */ ExportService access$getExportService$p(RapidViewExportService $this) {
        return $this.exportService;
    }

    static {
        ExportMode[] exportModeArray = new ExportMode[]{ExportMode.COLLECT_USER_AND_GROUP_REFS, ExportMode.COLLECT_PREFLIGHT_PROJECT_DATA};
        exportModeSet = SetsKt.setOf((Object[])exportModeArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/export/software/board/RapidViewExportService$Companion;", "", "()V", "exportModeSet", "", "Lcom/atlassian/jira/migration/export/framework/ExportMode;", "getExportModeSet", "()Ljava/util/Set;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<ExportMode> getExportModeSet() {
            return exportModeSet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

