/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.software.board;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.migration.config.JiraSoftwareOnly;
import com.atlassian.jira.migration.export.core.filter.SearchRequestWrapper;
import com.atlassian.jira.migration.export.core.filter.service.FilterSharingInfoService;
import com.atlassian.jira.migration.export.core.filter.service.jql.FilterJqlService;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraSoftwareOnly.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0016B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/export/software/board/RapidViewFilterExportService;", "", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "searchRequestManager", "Lcom/atlassian/jira/issue/search/SearchRequestManager;", "filterJqlService", "Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService;", "filterSharingInfoService", "Lcom/atlassian/jira/migration/export/core/filter/service/FilterSharingInfoService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/issue/search/SearchRequestManager;Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService;Lcom/atlassian/jira/migration/export/core/filter/service/FilterSharingInfoService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportSavedFilter", "Lcom/atlassian/jira/migration/export/software/board/RapidViewFilterExportService$ExportResult;", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "rapidView", "Lcom/atlassian/greenhopper/model/rapid/RapidView;", "parentIdentifier", "", "ExportResult", "jira-migration-plugin"})
public final class RapidViewFilterExportService {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final SearchRequestManager searchRequestManager;
    @NotNull
    private final FilterJqlService filterJqlService;
    @NotNull
    private final FilterSharingInfoService filterSharingInfoService;
    private final Logger log;

    @Inject
    public RapidViewFilterExportService(@NotNull ExportService exportService, @NotNull SearchRequestManager searchRequestManager, @NotNull FilterJqlService filterJqlService, @NotNull FilterSharingInfoService filterSharingInfoService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)searchRequestManager, (String)"searchRequestManager");
        Intrinsics.checkNotNullParameter((Object)filterJqlService, (String)"filterJqlService");
        Intrinsics.checkNotNullParameter((Object)filterSharingInfoService, (String)"filterSharingInfoService");
        this.exportService = exportService;
        this.searchRequestManager = searchRequestManager;
        this.filterJqlService = filterJqlService;
        this.filterSharingInfoService = filterSharingInfoService;
        this.log = LoggerFactory.getLogger(RapidViewFilterExportService.class);
    }

    @NotNull
    public final ExportResult exportSavedFilter(@NotNull ExportContext ctx, @NotNull RapidView rapidView, @NotNull String parentIdentifier) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)rapidView, (String)"rapidView");
        Intrinsics.checkNotNullParameter((Object)parentIdentifier, (String)"parentIdentifier");
        Object object = new Object[]{ctx.getMigrationId(), rapidView.getSavedFilterId(), rapidView.getId(), ctx.getExportMode()};
        this.log.debug("[MigrationId:{}] Exporting filter with id {} associated with rapidViewId {} under exportMode:{}", object);
        try {
            SearchRequest searchRequest = this.searchRequestManager.getSearchRequestById(rapidView.getSavedFilterId());
            if (searchRequest == null) {
                Long l = rapidView.getSavedFilterId();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getSavedFilterId(...)");
                return new ExportResult.FailOnFilterNotFoundForId(((Number)l).longValue());
            }
            SearchRequest filter = searchRequest;
            FilterSharingInfoService.FilterProjectSharingInfo sharingInfo = this.filterSharingInfoService.collectProjectSharingInfo(filter);
            boolean bl = false;
            FilterJqlService.JqlProjectReferenceInfo it = this.filterJqlService.collectProjectReferenceInfo(ctx.getProjectIds(), filter);
            boolean bl2 = false;
            MRI exportedFilter = this.exportService.exportOrThrow(ctx, new SearchRequestWrapper(parentIdentifier, it.getFilter()), true);
            object = new ExportResult.Success(sharingInfo, it, exportedFilter);
        }
        catch (Exception e) {
            Long l = rapidView.getSavedFilterId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getSavedFilterId(...)");
            object = new ExportResult.FailOnUnexpectedException(((Number)l).longValue(), e);
        }
        return object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u0082\u0001\u0003\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/export/software/board/RapidViewFilterExportService$ExportResult;", "", "()V", "isReferringMultiProjects", "", "isSharedToOtherProjects", "projectIds", "", "", "FailOnFilterNotFoundForId", "FailOnUnexpectedException", "Success", "Lcom/atlassian/jira/migration/export/software/board/RapidViewFilterExportService$ExportResult$FailOnFilterNotFoundForId;", "Lcom/atlassian/jira/migration/export/software/board/RapidViewFilterExportService$ExportResult$FailOnUnexpectedException;", "Lcom/atlassian/jira/migration/export/software/board/RapidViewFilterExportService$ExportResult$Success;", "jira-migration-plugin"})
    public static abstract class ExportResult {
        private ExportResult() {
        }

        public boolean isReferringMultiProjects() {
            return false;
        }

        public boolean isSharedToOtherProjects(@NotNull List<Long> projectIds) {
            Intrinsics.checkNotNullParameter(projectIds, (String)"projectIds");
            return false;
        }

        public /* synthetic */ ExportResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/export/software/board/RapidViewFilterExportService$ExportResult$FailOnFilterNotFoundForId;", "Lcom/atlassian/jira/migration/export/software/board/RapidViewFilterExportService$ExportResult;", "filterId", "", "(J)V", "getFilterId", "()J", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "jira-migration-plugin"})
        public static final class FailOnFilterNotFoundForId
        extends ExportResult {
            private final long filterId;

            public FailOnFilterNotFoundForId(long filterId) {
                super(null);
                this.filterId = filterId;
            }

            public final long getFilterId() {
                return this.filterId;
            }

            public final long component1() {
                return this.filterId;
            }

            @NotNull
            public final FailOnFilterNotFoundForId copy(long filterId) {
                return new FailOnFilterNotFoundForId(filterId);
            }

            public static /* synthetic */ FailOnFilterNotFoundForId copy$default(FailOnFilterNotFoundForId failOnFilterNotFoundForId, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    l = failOnFilterNotFoundForId.filterId;
                }
                return failOnFilterNotFoundForId.copy(l);
            }

            @NotNull
            public String toString() {
                return "FailOnFilterNotFoundForId(filterId=" + this.filterId + ')';
            }

            public int hashCode() {
                return Long.hashCode(this.filterId);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FailOnFilterNotFoundForId)) {
                    return false;
                }
                FailOnFilterNotFoundForId failOnFilterNotFoundForId = (FailOnFilterNotFoundForId)other;
                return this.filterId == failOnFilterNotFoundForId.filterId;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\r\u001a\u00060\u0005j\u0002`\u0006H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/export/software/board/RapidViewFilterExportService$ExportResult$FailOnUnexpectedException;", "Lcom/atlassian/jira/migration/export/software/board/RapidViewFilterExportService$ExportResult;", "filterId", "", "err", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(JLjava/lang/Exception;)V", "getErr", "()Ljava/lang/Exception;", "getFilterId", "()J", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "jira-migration-plugin"})
        public static final class FailOnUnexpectedException
        extends ExportResult {
            private final long filterId;
            @NotNull
            private final Exception err;

            public FailOnUnexpectedException(long filterId, @NotNull Exception err) {
                Intrinsics.checkNotNullParameter((Object)err, (String)"err");
                super(null);
                this.filterId = filterId;
                this.err = err;
            }

            public final long getFilterId() {
                return this.filterId;
            }

            @NotNull
            public final Exception getErr() {
                return this.err;
            }

            public final long component1() {
                return this.filterId;
            }

            @NotNull
            public final Exception component2() {
                return this.err;
            }

            @NotNull
            public final FailOnUnexpectedException copy(long filterId, @NotNull Exception err) {
                Intrinsics.checkNotNullParameter((Object)err, (String)"err");
                return new FailOnUnexpectedException(filterId, err);
            }

            public static /* synthetic */ FailOnUnexpectedException copy$default(FailOnUnexpectedException failOnUnexpectedException, long l, Exception exception, int n, Object object) {
                if ((n & 1) != 0) {
                    l = failOnUnexpectedException.filterId;
                }
                if ((n & 2) != 0) {
                    exception = failOnUnexpectedException.err;
                }
                return failOnUnexpectedException.copy(l, exception);
            }

            @NotNull
            public String toString() {
                return "FailOnUnexpectedException(filterId=" + this.filterId + ", err=" + this.err + ')';
            }

            public int hashCode() {
                int result2 = Long.hashCode(this.filterId);
                result2 = result2 * 31 + this.err.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FailOnUnexpectedException)) {
                    return false;
                }
                FailOnUnexpectedException failOnUnexpectedException = (FailOnUnexpectedException)other;
                if (this.filterId != failOnUnexpectedException.filterId) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.err, (Object)failOnUnexpectedException.err);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\u0016\u0010\u001a\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/export/software/board/RapidViewFilterExportService$ExportResult$Success;", "Lcom/atlassian/jira/migration/export/software/board/RapidViewFilterExportService$ExportResult;", "projectSharingInfo", "Lcom/atlassian/jira/migration/export/core/filter/service/FilterSharingInfoService$FilterProjectSharingInfo;", "jqlProjectReferenceInfo", "Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService$JqlProjectReferenceInfo;", "exportedFilter", "Lcom/atlassian/migration/base/mri/MRI;", "(Lcom/atlassian/jira/migration/export/core/filter/service/FilterSharingInfoService$FilterProjectSharingInfo;Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService$JqlProjectReferenceInfo;Lcom/atlassian/migration/base/mri/MRI;)V", "getExportedFilter", "()Lcom/atlassian/migration/base/mri/MRI;", "getJqlProjectReferenceInfo", "()Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService$JqlProjectReferenceInfo;", "getProjectSharingInfo", "()Lcom/atlassian/jira/migration/export/core/filter/service/FilterSharingInfoService$FilterProjectSharingInfo;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "isReferringMultiProjects", "isSharedToOtherProjects", "projectIds", "", "", "toString", "", "jira-migration-plugin"})
        public static final class Success
        extends ExportResult {
            @NotNull
            private final FilterSharingInfoService.FilterProjectSharingInfo projectSharingInfo;
            @NotNull
            private final FilterJqlService.JqlProjectReferenceInfo jqlProjectReferenceInfo;
            @NotNull
            private final MRI exportedFilter;

            public Success(@NotNull FilterSharingInfoService.FilterProjectSharingInfo projectSharingInfo, @NotNull FilterJqlService.JqlProjectReferenceInfo jqlProjectReferenceInfo, @NotNull MRI exportedFilter) {
                Intrinsics.checkNotNullParameter((Object)projectSharingInfo, (String)"projectSharingInfo");
                Intrinsics.checkNotNullParameter((Object)jqlProjectReferenceInfo, (String)"jqlProjectReferenceInfo");
                Intrinsics.checkNotNullParameter((Object)exportedFilter, (String)"exportedFilter");
                super(null);
                this.projectSharingInfo = projectSharingInfo;
                this.jqlProjectReferenceInfo = jqlProjectReferenceInfo;
                this.exportedFilter = exportedFilter;
            }

            @NotNull
            public final FilterSharingInfoService.FilterProjectSharingInfo getProjectSharingInfo() {
                return this.projectSharingInfo;
            }

            @NotNull
            public final FilterJqlService.JqlProjectReferenceInfo getJqlProjectReferenceInfo() {
                return this.jqlProjectReferenceInfo;
            }

            @NotNull
            public final MRI getExportedFilter() {
                return this.exportedFilter;
            }

            @Override
            public boolean isReferringMultiProjects() {
                return this.jqlProjectReferenceInfo.isReferringMultiProjects();
            }

            @Override
            public boolean isSharedToOtherProjects(@NotNull List<Long> projectIds) {
                Intrinsics.checkNotNullParameter(projectIds, (String)"projectIds");
                return this.projectSharingInfo.isSharedToOtherProjects(projectIds);
            }

            @NotNull
            public final FilterSharingInfoService.FilterProjectSharingInfo component1() {
                return this.projectSharingInfo;
            }

            @NotNull
            public final FilterJqlService.JqlProjectReferenceInfo component2() {
                return this.jqlProjectReferenceInfo;
            }

            @NotNull
            public final MRI component3() {
                return this.exportedFilter;
            }

            @NotNull
            public final Success copy(@NotNull FilterSharingInfoService.FilterProjectSharingInfo projectSharingInfo, @NotNull FilterJqlService.JqlProjectReferenceInfo jqlProjectReferenceInfo, @NotNull MRI exportedFilter) {
                Intrinsics.checkNotNullParameter((Object)projectSharingInfo, (String)"projectSharingInfo");
                Intrinsics.checkNotNullParameter((Object)jqlProjectReferenceInfo, (String)"jqlProjectReferenceInfo");
                Intrinsics.checkNotNullParameter((Object)exportedFilter, (String)"exportedFilter");
                return new Success(projectSharingInfo, jqlProjectReferenceInfo, exportedFilter);
            }

            public static /* synthetic */ Success copy$default(Success success, FilterSharingInfoService.FilterProjectSharingInfo filterProjectSharingInfo, FilterJqlService.JqlProjectReferenceInfo jqlProjectReferenceInfo, MRI mRI, int n, Object object) {
                if ((n & 1) != 0) {
                    filterProjectSharingInfo = success.projectSharingInfo;
                }
                if ((n & 2) != 0) {
                    jqlProjectReferenceInfo = success.jqlProjectReferenceInfo;
                }
                if ((n & 4) != 0) {
                    mRI = success.exportedFilter;
                }
                return success.copy(filterProjectSharingInfo, jqlProjectReferenceInfo, mRI);
            }

            @NotNull
            public String toString() {
                return "Success(projectSharingInfo=" + this.projectSharingInfo + ", jqlProjectReferenceInfo=" + this.jqlProjectReferenceInfo + ", exportedFilter=" + this.exportedFilter + ')';
            }

            public int hashCode() {
                int result2 = this.projectSharingInfo.hashCode();
                result2 = result2 * 31 + this.jqlProjectReferenceInfo.hashCode();
                result2 = result2 * 31 + this.exportedFilter.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                if (!Intrinsics.areEqual((Object)this.projectSharingInfo, (Object)success.projectSharingInfo)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.jqlProjectReferenceInfo, (Object)success.jqlProjectReferenceInfo)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.exportedFilter, (Object)success.exportedFilter);
            }
        }
    }
}

