/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.software.board;

import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.jira.migration.config.JiraSoftwareOnly;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.software.rapidview.RapidView;
import com.atlassian.migration.jira.classic.software.sprint.Sprint;
import com.atlassian.migration.jira.classic.software.sprint.SprintState;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraSoftwareOnly.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u000f\b\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\b\u0010!\u001a\u00020\"H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/atlassian/jira/migration/export/software/board/SprintExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/greenhopper/service/sprint/Sprint;", "Lcom/atlassian/migration/jira/classic/software/sprint/Sprint;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;)V", "sprintService", "Lcom/atlassian/greenhopper/service/sprint/SprintService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/greenhopper/service/sprint/SprintService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "extractServerEntity", "entityKey", "getActivatedDate", "Lorg/joda/time/DateTime;", "mapState", "Lcom/atlassian/migration/jira/classic/software/sprint/SprintState;", "state", "Lcom/atlassian/greenhopper/service/sprint/Sprint$State;", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "postConstruct", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nSprintExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SprintExporter.kt\ncom/atlassian/jira/migration/export/software/board/SprintExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,86:1\n1#2:87\n1282#3,2:88\n*S KotlinDebug\n*F\n+ 1 SprintExporter.kt\ncom/atlassian/jira/migration/export/software/board/SprintExporter\n*L\n83#1:88,2\n*E\n"})
public final class SprintExporter
implements Exporter<Long, com.atlassian.greenhopper.service.sprint.Sprint, Sprint> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final SprintService sprintService;
    private final Logger log;

    public SprintExporter(@NotNull ExportService exportService, @NotNull SprintService sprintService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)sprintService, (String)"sprintService");
        this.exportService = exportService;
        this.sprintService = sprintService;
        this.log = LoggerFactory.getLogger(SprintExporter.class);
    }

    @Inject
    public SprintExporter(@NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Object object = OsgiServices.importOsgiService(SprintService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"importOsgiService(...)");
        this(exportService, (SprintService)object);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, com.atlassian.greenhopper.service.sprint.Sprint.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(Sprint.Companion.getEntityType());
    }

    @Override
    @Nullable
    public com.atlassian.greenhopper.service.sprint.Sprint extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return (com.atlassian.greenhopper.service.sprint.Sprint)this.sprintService.getSprint(ctx.getStartedBy(), Long.valueOf(entityKey)).getValue();
    }

    @Override
    @NotNull
    public Sprint exportData(@NotNull ExportContext ctx, @NotNull com.atlassian.greenhopper.service.sprint.Sprint entity) {
        Instant instant;
        Instant instant2;
        DateTime it;
        Object object;
        String string;
        SprintState sprintState;
        MRI mRI;
        String string2;
        Object[] objectArray;
        block12: {
            block11: {
                MRI mRI2;
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                objectArray = new Object[]{ctx.getMigrationId(), entity.getId(), ctx.getExportMode()};
                this.log.debug("[MigrationId:{}] Exporting jiraSprint with id {} under exportMode:{}", objectArray);
                objectArray = this.mriForEntity(entity);
                string2 = entity.getName();
                Long l = entity.getRapidViewId();
                if (l != null) {
                    long it2 = ((Number)l).longValue();
                    boolean bl = false;
                    mRI2 = this.exportService.getExportedOrNull(ctx, RapidView.Companion.getEntityType(), it2);
                } else {
                    mRI2 = null;
                }
                mRI = mRI2;
                Sprint.State state = entity.getState();
                Intrinsics.checkNotNullExpressionValue((Object)state, (String)"getState(...)");
                sprintState = this.mapState(state);
                string = entity.getGoal();
                object = this.getActivatedDate(entity);
                if (object == null) break block11;
                it = object;
                boolean bl = false;
                Instant instant3 = Instant.ofEpochMilli(it.getMillis());
                object = instant3;
                if (instant3 != null) break block12;
            }
            DateTime dateTime = entity.getStartDate();
            if (dateTime != null) {
                DateTime it3 = dateTime;
                boolean bl = false;
                object = Instant.ofEpochMilli(it3.getMillis());
            } else {
                object = null;
            }
        }
        Object object2 = object;
        DateTime dateTime = entity.getEndDate();
        if (dateTime != null) {
            it = dateTime;
            boolean bl = false;
            instant2 = Instant.ofEpochMilli(it.getMillis());
        } else {
            instant2 = null;
        }
        Instant instant4 = instant2;
        DateTime dateTime2 = entity.getCompleteDate();
        if (dateTime2 != null) {
            DateTime it4 = dateTime2;
            boolean bl = false;
            instant = Instant.ofEpochMilli(it4.getMillis());
        } else {
            instant = null;
        }
        Instant instant5 = instant;
        Long l = entity.getSequence();
        Intrinsics.checkNotNull((Object)string2);
        return new Sprint((MRI)objectArray, mRI, sprintState, string2, string, (Instant)object2, instant4, instant5, l);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull com.atlassian.greenhopper.service.sprint.Sprint entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(Sprint.Companion.getEntityType(), entityKey, null, 2, null);
    }

    private final SprintState mapState(Sprint.State state) {
        SprintState sprintState;
        switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                sprintState = SprintState.FUTURE;
                break;
            }
            case 2: {
                sprintState = SprintState.ACTIVE;
                break;
            }
            case 3: {
                sprintState = SprintState.CLOSED;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sprintState;
    }

    private final DateTime getActivatedDate(com.atlassian.greenhopper.service.sprint.Sprint entity) {
        Object object;
        block1: {
            Method[] methodArray = com.atlassian.greenhopper.service.sprint.Sprint.class.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
            Object[] $this$firstOrNull$iv = methodArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Method it = (Method)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"getActivatedDate")) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        Method method = (Method)object;
        return (DateTime)(method != null ? method.invoke((Object)entity, new Object[0]) : null);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull com.atlassian.greenhopper.service.sprint.Sprint entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull com.atlassian.greenhopper.service.sprint.Sprint entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Sprint.State.values().length];
            try {
                nArray[Sprint.State.FUTURE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Sprint.State.ACTIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Sprint.State.CLOSED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

