/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.software.board.retrieve;

import com.atlassian.greenhopper.manager.rapidview.RapidViewManager;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.atlassian.greenhopper.service.PageRequests;
import com.atlassian.greenhopper.service.Pages;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.rapid.ProjectRapidViewService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewQuery;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewSimpleQuery;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.migration.common.PaginatedList;
import com.atlassian.jira.migration.config.JiraSoftwareOnly;
import com.atlassian.jira.migration.export.db.software.RapidViewReader;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.ExportMode;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.software.board.retrieve.RapidViewRetrieveService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.jiraservice.JswExtensionsKt;
import com.atlassian.jira.migration.jiraservice.OsgiUtil;
import com.atlassian.jira.migration.log.ExportMessageFormatter;
import com.atlassian.jira.migration.utils.StringUtils;
import com.atlassian.jira.migration.version.JiraMigrationVersionService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.jira.classic.software.rapidview.RapidView;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraSoftwareOnly.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 42\u00020\u0001:\u00014B\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ(\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018H\u0007J.\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001a2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001a2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J,\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u001f0\u001e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0%2\u0006\u0010&\u001a\u00020'J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0)2\u0006\u0010*\u001a\u00020+J$\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000e0%2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0002J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J&\u00101\u001a\u0002022\u0006\u0010\u0013\u001a\u00020\u00142\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00182\u0006\u0010-\u001a\u00020.H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/atlassian/jira/migration/export/software/board/retrieve/RapidViewRetrieveService;", "", "rapidViewReader", "Lcom/atlassian/jira/migration/export/db/software/RapidViewReader;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "jiraMigrationVersionService", "Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;", "(Lcom/atlassian/jira/migration/export/db/software/RapidViewReader;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;)V", "rapidViewService", "Lcom/atlassian/greenhopper/service/rapid/view/RapidViewService;", "(Lcom/atlassian/jira/migration/export/db/software/RapidViewReader;Lcom/atlassian/greenhopper/service/rapid/view/RapidViewService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;)V", "boardBelongsToProject", "Lcom/google/common/base/Predicate;", "Lcom/atlassian/greenhopper/model/rapid/RapidView;", "projectRapidViewService", "Lcom/atlassian/greenhopper/service/rapid/ProjectRapidViewService;", "user", "Lcom/atlassian/jira/user/ApplicationUser;", "project", "Lcom/atlassian/jira/project/Project;", "businessProjectContainsRapidViews", "", "rapidViews", "", "filterRapidViews", "", "query", "Lcom/atlassian/greenhopper/service/rapid/view/RapidViewQuery;", "getRapidViews", "Lcom/atlassian/greenhopper/service/ServiceOutcome;", "Lcom/atlassian/greenhopper/service/Page;", "pageRequest", "Lcom/atlassian/greenhopper/service/PageRequest;", "getRapidViewsForProject", "projectIsBusinessType", "retrieveAllRapidViews", "Lkotlin/sequences/Sequence;", "pageSize", "", "retrieveRapidViewById", "Ljava/util/Optional;", "id", "", "retrieveRapidViewsForProject", "mode", "Lcom/atlassian/jira/migration/export/framework/ExportMode;", "skipBusinessProjectInSoftwareBoardsValidation", "userSeesRapidView", "validateBusinessProjectsRapidViews", "", "rapidViewsForProject", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nRapidViewRetrieveService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RapidViewRetrieveService.kt\ncom/atlassian/jira/migration/export/software/board/retrieve/RapidViewRetrieveService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1#2:218\n*E\n"})
public final class RapidViewRetrieveService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RapidViewReader rapidViewReader;
    @NotNull
    private final RapidViewService rapidViewService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final JiraMigrationVersionService jiraMigrationVersionService;
    private static final Logger log = LoggerFactory.getLogger(RapidViewRetrieveService.class);
    @NotNull
    private static final String JIRA_VERSION_BEYOND_WHICH_PRIVATE_FILTERS_ARE_MIGRATED = "8.8";

    @VisibleForTesting
    public RapidViewRetrieveService(@NotNull RapidViewReader rapidViewReader, @NotNull RapidViewService rapidViewService, @NotNull MigrationFeatures migrationFeatures, @NotNull JiraMigrationVersionService jiraMigrationVersionService) {
        Intrinsics.checkNotNullParameter((Object)rapidViewReader, (String)"rapidViewReader");
        Intrinsics.checkNotNullParameter((Object)rapidViewService, (String)"rapidViewService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)jiraMigrationVersionService, (String)"jiraMigrationVersionService");
        this.rapidViewReader = rapidViewReader;
        this.rapidViewService = rapidViewService;
        this.migrationFeatures = migrationFeatures;
        this.jiraMigrationVersionService = jiraMigrationVersionService;
    }

    @Inject
    public RapidViewRetrieveService(@NotNull RapidViewReader rapidViewReader, @NotNull MigrationFeatures migrationFeatures, @NotNull JiraMigrationVersionService jiraMigrationVersionService) {
        Intrinsics.checkNotNullParameter((Object)rapidViewReader, (String)"rapidViewReader");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)jiraMigrationVersionService, (String)"jiraMigrationVersionService");
        Object object = OsgiServices.importOsgiService(RapidViewService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"importOsgiService(...)");
        this(rapidViewReader, (RapidViewService)object, migrationFeatures, jiraMigrationVersionService);
    }

    @NotNull
    public final Sequence<com.atlassian.greenhopper.model.rapid.RapidView> retrieveAllRapidViews(int pageSize) {
        RapidViewReader $this$retrieveAllRapidViews_u24lambda_u240 = this.rapidViewReader;
        boolean bl = false;
        return SequencesKt.flatMap((Sequence)SequencesKt.asSequence(PaginatedList.Companion.fetchByPage(pageSize, (Function2)new Function2<Integer, Integer, Collection<? extends com.atlassian.greenhopper.model.rapid.RapidView>>($this$retrieveAllRapidViews_u24lambda_u240){
            final /* synthetic */ RapidViewReader $this_run;
            {
                this.$this_run = $receiver;
                super(2);
            }

            @NotNull
            public final Collection<com.atlassian.greenhopper.model.rapid.RapidView> invoke(int offset, int limit) {
                RapidViewRetrieveService.access$getLog$cp().info("Fetching boards offset=" + offset + ", limit=" + limit);
                return this.$this_run.fetchRapidViews(offset, limit);
            }
        })), (Function1)retrieveAllRapidViews.1.2.INSTANCE);
    }

    @NotNull
    public final Sequence<com.atlassian.greenhopper.model.rapid.RapidView> retrieveRapidViewsForProject(@NotNull ApplicationUser user, @NotNull Project project, @NotNull ExportMode mode) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        List<com.atlassian.greenhopper.model.rapid.RapidView> rapidViewsForProject = null;
        String jiraVersion = this.jiraMigrationVersionService.getJiraServerVersion();
        if (!this.migrationFeatures.getDisableMigrationAllBoards() && StringUtils.INSTANCE.compareVersions(jiraVersion, JIRA_VERSION_BEYOND_WHICH_PRIVATE_FILTERS_ARE_MIGRATED) < 0) {
            try {
                rapidViewsForProject = this.getRapidViewsForProject(user, project);
            }
            catch (Exception ex) {
                log.warn("Retrieving Rapid Views bypassing userPermission flow failed because of this Error " + ex.getMessage());
                rapidViewsForProject = JswExtensionsKt.getRapidViewsForProject(this.rapidViewService, user, project);
            }
        } else {
            rapidViewsForProject = JswExtensionsKt.getRapidViewsForProject(this.rapidViewService, user, project);
        }
        this.validateBusinessProjectsRapidViews(project, rapidViewsForProject, mode);
        return CollectionsKt.asSequence((Iterable)rapidViewsForProject);
    }

    private final List<com.atlassian.greenhopper.model.rapid.RapidView> getRapidViewsForProject(ApplicationUser user, Project project) {
        Page page;
        PageRequest pageRequest = PageRequests.all();
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"all(...)");
        RapidViewQuery rapidViewQuery = RapidViewQuery.builder().project(project).build();
        Intrinsics.checkNotNullExpressionValue((Object)rapidViewQuery, (String)"build(...)");
        Page it = page = this.getRapidViews(user, pageRequest, rapidViewQuery);
        boolean bl = false;
        Object object = it.isValid() ? page : null;
        List list = object != null && (object = (Page)object.getValue()) != null ? object.getValues() : null;
        return list == null ? CollectionsKt.emptyList() : list;
    }

    private final ServiceOutcome<Page<com.atlassian.greenhopper.model.rapid.RapidView>> getRapidViews(ApplicationUser user, PageRequest pageRequest, RapidViewQuery query) {
        RapidViewManager rapidViewManager = OsgiUtil.INSTANCE.lazyGetRapidViewManager();
        Intrinsics.checkNotNull((Object)rapidViewManager);
        ServiceOutcome serviceOutcome = rapidViewManager.find(RapidViewSimpleQuery.fromRapidViewQuery((RapidViewQuery)query));
        Intrinsics.checkNotNullExpressionValue((Object)serviceOutcome, (String)"find(...)");
        ServiceOutcome rapidViewsOutcome = serviceOutcome;
        if (!rapidViewsOutcome.isValid()) {
            ServiceOutcome serviceOutcome2 = ServiceOutcomeImpl.error((ServiceResult)((ServiceResult)rapidViewsOutcome));
            Intrinsics.checkNotNullExpressionValue((Object)serviceOutcome2, (String)"error(...)");
            return serviceOutcome2;
        }
        Object object = rapidViewsOutcome.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Iterable<com.atlassian.greenhopper.model.rapid.RapidView> filteredRapidViews = this.filterRapidViews((Iterable)object, user, query);
        ArrayList arrayList = Lists.newArrayList(filteredRapidViews);
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
        List sortedRapidViews = arrayList;
        Iterable iterable = sortedRapidViews;
        Comparator<Object> comparator = Comparator.comparingLong(arg_0 -> RapidViewRetrieveService.getRapidViews$lambda$2(getRapidViews.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparingLong(...)");
        CollectionsKt.sortedWith((Iterable)iterable, comparator);
        ServiceOutcome serviceOutcome3 = ServiceOutcomeImpl.ok((Object)Pages.toPage((Iterable)sortedRapidViews, (PageRequest)pageRequest, null));
        Intrinsics.checkNotNullExpressionValue((Object)serviceOutcome3, (String)"ok(...)");
        return serviceOutcome3;
    }

    private final Iterable<com.atlassian.greenhopper.model.rapid.RapidView> filterRapidViews(Iterable<? extends com.atlassian.greenhopper.model.rapid.RapidView> rapidViews, ApplicationUser user, RapidViewQuery query) {
        Iterable iterable;
        Iterable iterable2 = Iterables.filter(rapidViews, this.userSeesRapidView());
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"filter(...)");
        Iterable visibleRapidViews = iterable2;
        if (query.getProject() == null) {
            iterable = visibleRapidViews;
        } else {
            log.info("Total no. of rapid-views: " + CollectionsKt.count((Iterable)visibleRapidViews) + ". Filtering rapid-views belonging to project: " + query.getProject().getKey());
            ProjectRapidViewService projectRapidViewService = OsgiUtil.INSTANCE.lazyGetProjectRapidViewService();
            Intrinsics.checkNotNull((Object)projectRapidViewService);
            ProjectRapidViewService rapidViewService = projectRapidViewService;
            Project project = query.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Iterable iterable3 = Iterables.filter((Iterable)visibleRapidViews, this.boardBelongsToProject(rapidViewService, user, project));
            Intrinsics.checkNotNull((Object)iterable3);
            iterable = iterable3;
        }
        return iterable;
    }

    private final Predicate<com.atlassian.greenhopper.model.rapid.RapidView> userSeesRapidView() {
        return RapidViewRetrieveService::userSeesRapidView$lambda$3;
    }

    private final Predicate<com.atlassian.greenhopper.model.rapid.RapidView> boardBelongsToProject(ProjectRapidViewService projectRapidViewService, ApplicationUser user, Project project) {
        return arg_0 -> RapidViewRetrieveService.boardBelongsToProject$lambda$4(projectRapidViewService, user, project, arg_0);
    }

    private final void validateBusinessProjectsRapidViews(Project project, List<? extends com.atlassian.greenhopper.model.rapid.RapidView> rapidViewsForProject, ExportMode mode) {
        if (this.migrationFeatures.getEnableSoftwareBoardsMigrationInBusinessProjects() || this.skipBusinessProjectInSoftwareBoardsValidation(mode)) {
            return;
        }
        if (!this.businessProjectContainsRapidViews(project, rapidViewsForProject)) {
            return;
        }
        if (!((Collection)rapidViewsForProject).isEmpty()) {
            String reasons2 = CollectionsKt.joinToString$default((Iterable)rapidViewsForProject, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<com.atlassian.greenhopper.model.rapid.RapidView, CharSequence>(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull com.atlassian.greenhopper.model.rapid.RapidView it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return "ID: " + it.getId() + " - " + it.getType() + " board [" + it.getName() + "] cannot be linked to business project [" + this.$project.getKey() + "] on Cloud.";
                }
            }), (int)30, null);
            EntityType entityType = RapidView.Companion.getEntityType();
            Long l = ((com.atlassian.greenhopper.model.rapid.RapidView)CollectionsKt.first(rapidViewsForProject)).getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            MRI mRI = MriExtensionsKt.mri$default(entityType, l, null, 2, null);
            String string = ExportMessageFormatter.INSTANCE.getTroubleshootingExportErrorGuide();
            ExportErrorCode exportErrorCode = ExportErrorCode.BUSINESS_PRJ_HAS_SOFTWARE_BOARDS;
            throw new ExportException(mRI, exportErrorCode, reasons2, string, null, null, null, 112, null);
        }
    }

    private final boolean skipBusinessProjectInSoftwareBoardsValidation(ExportMode mode) {
        boolean result2;
        boolean bl = result2 = mode == ExportMode.PROJECT_DATA && this.migrationFeatures.getSkipPreflightCheckExportErrors();
        if (result2) {
            log.warn("Skipping validation for Business Projects having Software Boards");
        }
        return result2;
    }

    @VisibleForTesting
    public final boolean businessProjectContainsRapidViews(@NotNull Project project, @NotNull List<? extends com.atlassian.greenhopper.model.rapid.RapidView> rapidViews) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(rapidViews, (String)"rapidViews");
        return this.projectIsBusinessType(project) && !((Collection)rapidViews).isEmpty();
    }

    private final boolean projectIsBusinessType(Project project) {
        return Intrinsics.areEqual((Object)project.getProjectTypeKey().getKey(), (Object)"business");
    }

    @NotNull
    public final Optional<com.atlassian.greenhopper.model.rapid.RapidView> retrieveRapidViewById(long id) {
        RapidViewReader $this$retrieveRapidViewById_u24lambda_u245 = this.rapidViewReader;
        boolean bl = false;
        com.atlassian.greenhopper.model.rapid.RapidView maybeRapidView = (com.atlassian.greenhopper.model.rapid.RapidView)CollectionsKt.firstOrNull($this$retrieveRapidViewById_u24lambda_u245.fetchRapidViewsByIds(CollectionsKt.listOf((Object)id)));
        if (maybeRapidView == null) {
            log.warn("Not RapidView found with ID " + id);
        }
        Optional<com.atlassian.greenhopper.model.rapid.RapidView> optional = Optional.ofNullable(maybeRapidView);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"run(...)");
        return optional;
    }

    private static final long getRapidViews$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    private static final boolean userSeesRapidView$lambda$3(com.atlassian.greenhopper.model.rapid.RapidView rapidView) {
        return true;
    }

    private static final boolean boardBelongsToProject$lambda$4(ProjectRapidViewService $projectRapidViewService, ApplicationUser $user, Project $project, com.atlassian.greenhopper.model.rapid.RapidView rapidView) {
        Intrinsics.checkNotNullParameter((Object)$projectRapidViewService, (String)"$projectRapidViewService");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        com.atlassian.greenhopper.model.rapid.RapidView rapidView2 = rapidView;
        Intrinsics.checkNotNull((Object)rapidView2);
        ServiceOutcome serviceOutcome = $projectRapidViewService.findProjectsByRapidView($user, rapidView2);
        Intrinsics.checkNotNullExpressionValue((Object)serviceOutcome, (String)"findProjectsByRapidView(...)");
        ServiceOutcome projectsByRapidView = serviceOutcome;
        ServiceOutcome serviceOutcome2 = $projectRapidViewService.findProjectsByRapidView(ComponentAccessor.getUserManager().getUserByName(rapidView.getOwner()), rapidView);
        Intrinsics.checkNotNullExpressionValue((Object)serviceOutcome2, (String)"findProjectsByRapidView(...)");
        ServiceOutcome projectsByRapidViewThroughRapidViewOwner = serviceOutcome2;
        if (!projectsByRapidView.isInvalid() && !projectsByRapidViewThroughRapidViewOwner.isInvalid()) {
            return ((Set)projectsByRapidView.get()).contains($project) || ((Set)projectsByRapidViewThroughRapidViewOwner.get()).contains($project);
        }
        if (!projectsByRapidView.isInvalid()) {
            return ((Set)projectsByRapidView.get()).contains($project);
        }
        if (!projectsByRapidViewThroughRapidViewOwner.isInvalid()) {
            return ((Set)projectsByRapidViewThroughRapidViewOwner.get()).contains($project);
        }
        return false;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/export/software/board/retrieve/RapidViewRetrieveService$Companion;", "", "()V", "JIRA_VERSION_BEYOND_WHICH_PRIVATE_FILTERS_ARE_MIGRATED", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

