/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.software.service;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequests;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintQuery;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.software.board.FeatureFlagProtectedRapidViewExportService;
import com.atlassian.jira.migration.export.software.service.JswExportService;
import com.atlassian.jira.migration.jiraservice.JswExtensionsKt;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/export/software/service/JswExportServiceImpl;", "Lcom/atlassian/jira/migration/export/software/service/JswExportService;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "rapidViewExportService", "Lcom/atlassian/jira/migration/export/software/board/FeatureFlagProtectedRapidViewExportService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/software/board/FeatureFlagProtectedRapidViewExportService;)V", "sprintService", "Lcom/atlassian/greenhopper/service/sprint/SprintService;", "rapidViewService", "Lcom/atlassian/greenhopper/service/rapid/view/RapidViewService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/software/board/FeatureFlagProtectedRapidViewExportService;Lcom/atlassian/greenhopper/service/sprint/SprintService;Lcom/atlassian/greenhopper/service/rapid/view/RapidViewService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportMultiProjectRapidViews", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "exportRapidView", "Lcom/atlassian/migration/base/mri/MRI;", "id", "", "exportSingleProjectRapidViews", "exportSprints", "getSprints", "", "Lcom/atlassian/greenhopper/service/sprint/Sprint;", "rapidView", "Lcom/atlassian/greenhopper/model/rapid/RapidView;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJswExportServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JswExportServiceImpl.kt\ncom/atlassian/jira/migration/export/software/service/JswExportServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1549#2:80\n1620#2,2:81\n1855#2,2:83\n1622#2:85\n1#3:86\n*S KotlinDebug\n*F\n+ 1 JswExportServiceImpl.kt\ncom/atlassian/jira/migration/export/software/service/JswExportServiceImpl\n*L\n42#1:80\n42#1:81,2\n43#1:83,2\n42#1:85\n*E\n"})
public final class JswExportServiceImpl
implements JswExportService {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final FeatureFlagProtectedRapidViewExportService rapidViewExportService;
    @NotNull
    private final SprintService sprintService;
    @NotNull
    private final RapidViewService rapidViewService;
    private final Logger log;

    @VisibleForTesting
    public JswExportServiceImpl(@NotNull ExportService exportService, @NotNull FeatureFlagProtectedRapidViewExportService rapidViewExportService, @NotNull SprintService sprintService, @NotNull RapidViewService rapidViewService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)rapidViewExportService, (String)"rapidViewExportService");
        Intrinsics.checkNotNullParameter((Object)sprintService, (String)"sprintService");
        Intrinsics.checkNotNullParameter((Object)rapidViewService, (String)"rapidViewService");
        this.exportService = exportService;
        this.rapidViewExportService = rapidViewExportService;
        this.sprintService = sprintService;
        this.rapidViewService = rapidViewService;
        this.log = LoggerFactory.getLogger(JswExportServiceImpl.class);
    }

    public JswExportServiceImpl(@NotNull ExportService exportService, @NotNull FeatureFlagProtectedRapidViewExportService rapidViewExportService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)rapidViewExportService, (String)"rapidViewExportService");
        RapidViewService rapidViewService = (RapidViewService)OsgiServices.importOsgiService(RapidViewService.class);
        SprintService sprintService = (SprintService)OsgiServices.importOsgiService(SprintService.class);
        Intrinsics.checkNotNull((Object)sprintService);
        Intrinsics.checkNotNull((Object)rapidViewService);
        this(exportService, rapidViewExportService, sprintService, rapidViewService);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void exportSprints(@NotNull ExportContext ctx) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Iterable $this$map$iv = JswExtensionsKt.getRapidViewsForProject(this.rapidViewService, ctx.getStartedBy(), ctx.getProject());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void rapidView;
            RapidView rapidView2 = (RapidView)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$forEach$iv = this.getSprints(ctx, (RapidView)rapidView);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Sprint sprint = (Sprint)element$iv;
                boolean bl2 = false;
                if (sprint.getRapidViewId() != null && !Intrinsics.areEqual((Object)sprint.getRapidViewId(), (Object)rapidView.getId())) continue;
                ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, sprint, false, 4, null);
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @Override
    public void exportSingleProjectRapidViews(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.rapidViewExportService.exportSingleProjectRapidViews(ctx);
    }

    @Override
    public void exportMultiProjectRapidViews(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.rapidViewExportService.exportMultiProjectRapidViews(ctx);
    }

    @Override
    @Nullable
    public MRI exportRapidView(@NotNull ExportContext ctx, long id) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this.rapidViewExportService.exportRapidViewById(ctx, id);
    }

    private final List<Sprint> getSprints(ExportContext ctx, RapidView rapidView) {
        List list;
        ServiceOutcome outcome;
        ServiceOutcome serviceOutcome;
        ServiceOutcome serviceOutcome2 = this.sprintService.getSprints(ctx.getStartedBy(), rapidView, PageRequests.all(), SprintQuery.noQuery());
        Intrinsics.checkNotNullExpressionValue((Object)serviceOutcome2, (String)"getSprints(...)");
        ServiceOutcome it = serviceOutcome = (outcome = serviceOutcome2);
        boolean bl = false;
        Object object = it.isValid() ? serviceOutcome : null;
        if ((object != null && (object = (Page)object.getValue()) != null ? object.getValues() : (list = null)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

