/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.utils;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.migration.datafilters.model.DataFilterContext;
import com.atlassian.jira.migration.datafilters.service.DataFilterService;
import com.atlassian.jira.migration.datafilters.utils.DataFiltersUtil;
import com.atlassian.jira.migration.export.core.customfieldScope.CustomFieldScopeValue;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.model.JSDConstants;
import com.atlassian.jira.migration.export.model.JiraToolkitConstants;
import com.atlassian.jira.migration.export.model.PortletConfigConstants;
import com.atlassian.jira.migration.export.utils.CustomFieldUtils;
import com.atlassian.jira.migration.export.utils.ExportFilters;
import com.atlassian.jira.migration.export.utils.ExportFiltersKt;
import com.atlassian.jira.migration.export.utils.JsdExportUtil;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.jiraservice.JiraExtensionsKt;
import com.atlassian.jira.migration.utils.MigrationModeUtil;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.type.ShareType;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 d2\u00020\u0001:\u0001dB7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u0011J\"\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00170/2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00170/J\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\u00170/2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00170/J(\u00104\u001a\b\u0012\u0004\u0012\u00020\u00170/2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00170/2\f\u00105\u001a\b\u0012\u0004\u0012\u0002060\u0010J\u0016\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u0002062\u0006\u00109\u001a\u000206J\u0010\u0010:\u001a\u0004\u0018\u00010\u00112\u0006\u0010-\u001a\u00020\u0011J\u000e\u0010;\u001a\u00020\u00182\u0006\u0010<\u001a\u000206J \u0010=\u001a\u00020\u00182\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\b\u0010B\u001a\u0004\u0018\u00010CJ\u000e\u0010D\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u0011J\u000e\u0010E\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u0011J\u000e\u0010F\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u0011J\u0010\u0010G\u001a\u00020\u00182\u0006\u0010H\u001a\u00020\u0011H\u0002J\u0018\u0010I\u001a\u00020\u00182\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u0018\u0010J\u001a\u00020\u00182\u0006\u0010>\u001a\u00020?2\b\u0010K\u001a\u0004\u0018\u00010LJ\u0018\u0010M\u001a\u00020\u00182\u0006\u0010>\u001a\u00020?2\b\u0010N\u001a\u0004\u0018\u00010\u0011J\u000e\u0010O\u001a\u00020\u00182\u0006\u0010P\u001a\u00020QJ\u000e\u0010R\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u0011J\u000e\u0010S\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u0011J\u000e\u0010T\u001a\u00020\u00182\u0006\u0010U\u001a\u00020VJ\u000e\u0010W\u001a\u00020\u00182\u0006\u0010U\u001a\u00020VJ\u000e\u0010X\u001a\u00020\u00182\u0006\u0010U\u001a\u00020VJ\u000e\u0010Y\u001a\u00020\u00182\u0006\u0010Z\u001a\u00020[J\u0010\u0010\\\u001a\u00020\u00182\u0006\u0010N\u001a\u00020\u0011H\u0002J\u000e\u0010]\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u0011J\u0010\u0010^\u001a\u00020\u00182\u0006\u0010@\u001a\u00020AH\u0002J\u0016\u0010_\u001a\u00020\u00182\u0006\u0010>\u001a\u00020?2\u0006\u0010<\u001a\u000206J\u0016\u0010`\u001a\u00020\u00182\u0006\u0010>\u001a\u00020?2\u0006\u0010<\u001a\u000206J\u0016\u0010a\u001a\u00020\u00182\u0006\u00100\u001a\u0002012\u0006\u0010<\u001a\u000206J\u001e\u0010b\u001a\u00020\u00182\u0006\u00100\u001a\u0002012\u0006\u00108\u001a\u0002062\u0006\u00109\u001a\u000206J\f\u0010c\u001a\u00020\u0018*\u00020QH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0013R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0013R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lcom/atlassian/jira/migration/export/utils/ExportFilters;", "", "customFieldUtils", "Lcom/atlassian/jira/migration/export/utils/CustomFieldUtils;", "jsdExportUtil", "Lcom/atlassian/jira/migration/export/utils/JsdExportUtil;", "customFieldManager", "Lcom/atlassian/jira/issue/CustomFieldManager;", "issueManager", "Lcom/atlassian/jira/issue/IssueManager;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "dataFilterService", "Lcom/atlassian/jira/migration/datafilters/service/DataFilterService;", "(Lcom/atlassian/jira/migration/export/utils/CustomFieldUtils;Lcom/atlassian/jira/migration/export/utils/JsdExportUtil;Lcom/atlassian/jira/issue/CustomFieldManager;Lcom/atlassian/jira/issue/IssueManager;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/datafilters/service/DataFilterService;)V", "emptyUserReferenceGadgets", "", "", "getEmptyUserReferenceGadgets", "()Ljava/util/Set;", "gadgetsContainProjectReferences", "hasArchived", "Lkotlin/Function1;", "Lcom/atlassian/jira/issue/Issue;", "", "getHasArchived", "()Lkotlin/jvm/functions/Function1;", "hasArchived$delegate", "Lkotlin/Lazy;", "jsdSupportedProjectPermissionKeys", "jswSupportedProjectPermissionKeys", "projectIdGadgets", "projectOrCategoriesGadgets", "projectOrFilterIdGadgets", "supportedCustomFieldTypes", "getSupportedCustomFieldTypes", "supportedJiraCoreAndJswCustomFieldTypes", "supportedProjectPermissionKeys", "supportedSharePermissions", "Lcom/atlassian/jira/sharing/type/ShareType$Name;", "supportedToolkitCustomFieldTypes", "getSupportedToolkitCustomFieldTypes", "typeIdGadgets", "unsupportedStandardFieldIds", "containsProjectReference", "gadgetXml", "excludeFilteredIssues", "Lkotlin/sequences/Sequence;", "dataFilterContext", "Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;", "issues", "filterArchivedIssues", "filterArchivedIssuesByProjects", "projectIds", "", "filterArchivedParentLinks", "parentIssueId", "childIssueId", "getSupportedGadgetValue", "isActiveIssue", "issueId", "isInScopeCustomField", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "customField", "Lcom/atlassian/jira/issue/fields/CustomField;", "issueType", "Lcom/atlassian/jira/issue/issuetype/IssueType;", "isProjectIdGadget", "isProjectOrCategoriesGadget", "isProjectOrFilterIdGadget", "isSupportedARCustomField", "customFieldTypeKey", "isSupportedCustomField", "isSupportedField", "field", "Lcom/atlassian/jira/issue/fields/Field;", "isSupportedFieldById", "fieldId", "isSupportedForMigration", "portletConfiguration", "Lcom/atlassian/jira/portal/PortletConfiguration;", "isSupportedGadget", "isSupportedIFrameGadget", "isSupportedProjectPermission", "key", "Lcom/atlassian/jira/security/plugin/ProjectPermissionKey;", "isSupportedProjectPermissionForJsd", "isSupportedProjectPermissionForJsw", "isSupportedSharePermission", "sharePermission", "Lcom/atlassian/jira/sharing/SharePermission;", "isSupportedStandardField", "isTypeIdGadget", "isUserDefinedCustomField", "shouldFilterArchivedIssues", "shouldFilterIssue", "shouldFilterIssueWithAppliedDataFilters", "shouldIncludeParentLinksWithAppliedDataFilters", "isIframeGadget", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nExportFilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportFilters.kt\ncom/atlassian/jira/migration/export/utils/ExportFilters\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,466:1\n1#2:467\n*E\n"})
public final class ExportFilters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CustomFieldUtils customFieldUtils;
    @NotNull
    private final JsdExportUtil jsdExportUtil;
    @NotNull
    private final CustomFieldManager customFieldManager;
    @NotNull
    private final IssueManager issueManager;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final DataFilterService dataFilterService;
    @NotNull
    private final Set<String> supportedJiraCoreAndJswCustomFieldTypes;
    @NotNull
    private final Set<String> supportedProjectPermissionKeys;
    @NotNull
    private final Set<String> jswSupportedProjectPermissionKeys;
    @NotNull
    private final Set<String> jsdSupportedProjectPermissionKeys;
    @NotNull
    private final Set<ShareType.Name> supportedSharePermissions;
    @NotNull
    private final Set<String> typeIdGadgets;
    @NotNull
    private final Set<String> projectOrFilterIdGadgets;
    @NotNull
    private final Set<String> projectOrCategoriesGadgets;
    @NotNull
    private final Set<String> projectIdGadgets;
    @NotNull
    private final Set<String> emptyUserReferenceGadgets;
    @NotNull
    private final Set<String> gadgetsContainProjectReferences;
    @NotNull
    private final Set<String> unsupportedStandardFieldIds;
    @NotNull
    private final Lazy hasArchived$delegate;
    @NotNull
    private static final Logger log;

    @Inject
    public ExportFilters(@NotNull CustomFieldUtils customFieldUtils, @NotNull JsdExportUtil jsdExportUtil, @NotNull CustomFieldManager customFieldManager, @NotNull IssueManager issueManager, @NotNull MigrationFeatures migrationFeatures, @NotNull DataFilterService dataFilterService) {
        Intrinsics.checkNotNullParameter((Object)customFieldUtils, (String)"customFieldUtils");
        Intrinsics.checkNotNullParameter((Object)jsdExportUtil, (String)"jsdExportUtil");
        Intrinsics.checkNotNullParameter((Object)customFieldManager, (String)"customFieldManager");
        Intrinsics.checkNotNullParameter((Object)issueManager, (String)"issueManager");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)dataFilterService, (String)"dataFilterService");
        this.customFieldUtils = customFieldUtils;
        this.jsdExportUtil = jsdExportUtil;
        this.customFieldManager = customFieldManager;
        this.issueManager = issueManager;
        this.migrationFeatures = migrationFeatures;
        this.dataFilterService = dataFilterService;
        Object[] objectArray = new String[]{"com.atlassian.jira.plugin.system.customfieldtypes:textfield", "com.atlassian.jira.plugin.system.customfieldtypes:readonlyfield", "com.atlassian.jira.plugin.system.customfieldtypes:textarea", "com.atlassian.jira.plugin.system.customfieldtypes:float", "com.atlassian.jira.plugin.system.customfieldtypes:datepicker", "com.atlassian.jira.plugin.system.customfieldtypes:datetime", "com.atlassian.jira.plugin.system.customfieldtypes:labels", "com.atlassian.jira.plugin.system.customfieldtypes:select", "com.atlassian.jira.plugin.system.customfieldtypes:multiselect", "com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect", "com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes", "com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons", "com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker", "com.atlassian.jira.plugin.system.customfieldtypes:grouppicker", "com.atlassian.jira.plugin.system.customfieldtypes:multigrouppicker", "com.atlassian.jira.plugin.system.customfieldtypes:url", "com.atlassian.jira.plugin.system.customfieldtypes:project", "com.atlassian.jira.plugin.system.customfieldtypes:version", "com.atlassian.jira.plugin.system.customfieldtypes:multiversion", "com.pyxis.greenhopper.jira:gh-epic-color", "com.pyxis.greenhopper.jira:gh-epic-label", "com.pyxis.greenhopper.jira:gh-epic-link", "com.pyxis.greenhopper.jira:gh-epic-status", "com.pyxis.greenhopper.jira:gh-lexo-rank", "com.pyxis.greenhopper.jira:gh-sprint"};
        this.supportedJiraCoreAndJswCustomFieldTypes = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"ADD_COMMENTS", "ADMINISTER_PROJECTS", "ASSIGN_ISSUES", "ASSIGNABLE_USER", "BROWSE_PROJECTS", "CLOSE_ISSUES", "CREATE_ATTACHMENTS", "CREATE_ISSUES", "DELETE_ALL_ATTACHMENTS", "DELETE_ALL_COMMENTS", "DELETE_ALL_WORKLOGS", "DELETE_ISSUES", "DELETE_OWN_ATTACHMENTS", "DELETE_OWN_COMMENTS", "DELETE_OWN_WORKLOGS", "EDIT_ALL_COMMENTS", "EDIT_ALL_WORKLOGS", "EDIT_ISSUES", "EDIT_OWN_COMMENTS", "EDIT_OWN_WORKLOGS", "LINK_ISSUES", "MANAGE_WATCHERS", "MODIFY_REPORTER", "MOVE_ISSUES", "RESOLVE_ISSUES", "SCHEDULE_ISSUES", "SET_ISSUE_SECURITY", "TRANSITION_ISSUES", "VIEW_DEV_TOOLS", "VIEW_READONLY_WORKFLOW", "VIEW_VOTERS_AND_WATCHERS", "WORK_ON_ISSUES"};
        this.supportedProjectPermissionKeys = SetsKt.setOf((Object[])objectArray);
        this.jswSupportedProjectPermissionKeys = SetsKt.setOf((Object)"MANAGE_SPRINTS_PERMISSION");
        this.jsdSupportedProjectPermissionKeys = SetsKt.setOf((Object)"SERVICEDESK_AGENT");
        objectArray = new ShareType.Name[6];
        Intrinsics.checkNotNullExpressionValue((Object)ShareType.Name.AUTHENTICATED, (String)"AUTHENTICATED");
        Intrinsics.checkNotNullExpressionValue((Object)ShareType.Name.GLOBAL, (String)"GLOBAL");
        Intrinsics.checkNotNullExpressionValue((Object)ShareType.Name.PROJECT_UNKNOWN, (String)"PROJECT_UNKNOWN");
        Intrinsics.checkNotNullExpressionValue((Object)ShareType.Name.GROUP, (String)"GROUP");
        Intrinsics.checkNotNullExpressionValue((Object)ShareType.Name.PROJECT, (String)"PROJECT");
        objectArray[5] = ExportFiltersKt.getUSER();
        this.supportedSharePermissions = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:created-vs-resolved-issues-chart-gadget/gadgets/createdvsresolved-gadget.xml", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:pie-chart-gadget/gadgets/piechart-gadget.xml", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:stats-gadget/gadgets/stats-gadget.xml"};
        this.typeIdGadgets = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:recently-created-chart-gadget/gadgets/recently-created-gadget.xml", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:time-since-chart-gadget/gadgets/timesince-gadget.xml", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:resolution-time-gadget/gadgets/resolution-time-gadget.xml", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:heat-map-gadget/gadgets/heatmap-gadget.xml", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:average-age-chart-gadget/gadgets/average-age-gadget.xml", "rest/gadgets/1.0/g/com.atlassian.jira.ext.charting:workloadpie-gadget/com/atlassian/jira/ext/charting/gadget/workloadpie-gadget.xml", "rest/gadgets/1.0/g/com.atlassian.jira.ext.charting:timeinstatus-gadget/com/atlassian/jira/ext/charting/gadget/timeinstatus-gadget.xml", "rest/gadgets/1.0/g/com.atlassian.jira.ext.charting:numberoftimesinstatus-gadget/com/atlassian/jira/ext/charting/gadget/numberoftimesinstatus-gadget.xml", "rest/gadgets/1.0/g/com.atlassian.jira.ext.charting:firstresponse-gadget/com/atlassian/jira/ext/charting/gadget/firstresponse-gadget.xml", "rest/gadgets/1.0/g/com.atlassian.jira.ext.calendar:issuescalendar-gadget/templates/plugins/jira/portlets/calendar/gadget/calendar-gadget.xml"};
        this.projectOrFilterIdGadgets = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:project-gadget/gadgets/project-gadget.xml", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:road-map-gadget/gadgets/roadmap-gadget.xml"};
        this.projectOrCategoriesGadgets = SetsKt.setOf((Object[])objectArray);
        this.projectIdGadgets = SetsKt.setOf((Object)"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:labels-gadget/gadgets/labels-gadget.xml");
        objectArray = new String[]{"com.atlassian.jira.gadgets:introduction-dashboard-item", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:quicklinks-gadget/gadgets/quicklinks-gadget.xml"};
        this.emptyUserReferenceGadgets = SetsKt.setOf((Object[])objectArray);
        objectArray = new Set[]{this.typeIdGadgets, this.projectOrFilterIdGadgets, this.projectOrCategoriesGadgets, this.projectIdGadgets};
        this.gadgetsContainProjectReferences = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)SetsKt.setOf((Object[])objectArray)));
        objectArray = new String[]{"archiveddate", "archivedby"};
        this.unsupportedStandardFieldIds = SetsKt.setOf((Object[])objectArray);
        this.hasArchived$delegate = LazyKt.lazy((Function0)hasArchived.2.INSTANCE);
    }

    private final Set<String> getSupportedCustomFieldTypes() {
        return SetsKt.plus((Set)SetsKt.plus(this.supportedJiraCoreAndJswCustomFieldTypes, (Iterable)this.getSupportedToolkitCustomFieldTypes()), (Iterable)JSDConstants.INSTANCE.getJSD_CUSTOM_FIELDS());
    }

    private final Set<String> getSupportedToolkitCustomFieldTypes() {
        return JiraToolkitConstants.INSTANCE.supportedFieldTypes();
    }

    public final boolean isSupportedForMigration(@NotNull PortletConfiguration portletConfiguration) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)portletConfiguration, (String)"portletConfiguration");
        if (this.isIframeGadget(portletConfiguration)) {
            bl = true;
        } else {
            String string = JiraExtensionsKt.getGadgetXml(portletConfiguration);
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                bl = this.isSupportedGadget(it);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isIframeGadget(PortletConfiguration $this$isIframeGadget) {
        boolean bl;
        String string = JiraExtensionsKt.accessModuleKey($this$isIframeGadget);
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            bl = this.isSupportedIFrameGadget(it);
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final Set<String> getEmptyUserReferenceGadgets() {
        return this.emptyUserReferenceGadgets;
    }

    public final boolean isSupportedGadget(@NotNull String gadgetXml) {
        Intrinsics.checkNotNullParameter((Object)gadgetXml, (String)"gadgetXml");
        return PortletConfigConstants.INSTANCE.getSupportedGadgets().keySet().contains(gadgetXml);
    }

    public final boolean isSupportedIFrameGadget(@NotNull String gadgetXml) {
        Intrinsics.checkNotNullParameter((Object)gadgetXml, (String)"gadgetXml");
        return PortletConfigConstants.INSTANCE.getSupportedIFrameGadgets().keySet().contains(gadgetXml);
    }

    public final boolean containsProjectReference(@NotNull String gadgetXml) {
        Intrinsics.checkNotNullParameter((Object)gadgetXml, (String)"gadgetXml");
        return this.gadgetsContainProjectReferences.contains(gadgetXml);
    }

    public final boolean isTypeIdGadget(@NotNull String gadgetXml) {
        Intrinsics.checkNotNullParameter((Object)gadgetXml, (String)"gadgetXml");
        return this.typeIdGadgets.contains(gadgetXml);
    }

    public final boolean isProjectOrFilterIdGadget(@NotNull String gadgetXml) {
        Intrinsics.checkNotNullParameter((Object)gadgetXml, (String)"gadgetXml");
        return this.projectOrFilterIdGadgets.contains(gadgetXml);
    }

    public final boolean isProjectOrCategoriesGadget(@NotNull String gadgetXml) {
        Intrinsics.checkNotNullParameter((Object)gadgetXml, (String)"gadgetXml");
        return this.projectOrCategoriesGadgets.contains(gadgetXml);
    }

    public final boolean isProjectIdGadget(@NotNull String gadgetXml) {
        Intrinsics.checkNotNullParameter((Object)gadgetXml, (String)"gadgetXml");
        return this.projectIdGadgets.contains(gadgetXml);
    }

    @Nullable
    public final String getSupportedGadgetValue(@NotNull String gadgetXml) {
        Intrinsics.checkNotNullParameter((Object)gadgetXml, (String)"gadgetXml");
        return PortletConfigConstants.INSTANCE.getSupportedGadgets().get(gadgetXml);
    }

    private final boolean isSupportedCustomField(ExportContext ctx, CustomField customField) {
        boolean bl;
        String string = customField.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = customField.getCustomFieldType().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKey(...)");
        if (this.customFieldUtils.isSupportedAppVendorCF(ctx, string, string2)) {
            bl = true;
        } else if (JSDConstants.INSTANCE.getJSD_CUSTOM_FIELDS().contains(customField.getCustomFieldType().getKey())) {
            bl = this.jsdExportUtil.isJsdProjectEligibleForMigration(ctx);
        } else {
            String string3 = customField.getCustomFieldType().getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getKey(...)");
            bl = this.isSupportedARCustomField(string3) && !this.isUserDefinedCustomField(customField) ? true : this.getSupportedCustomFieldTypes().contains(customField.getCustomFieldType().getKey()) && (this.customFieldUtils.isFieldLocked(ctx, customField) == false || this.customFieldUtils.hasManagedCustomFieldKey(customField));
        }
        return bl;
    }

    private final boolean isSupportedARCustomField(String customFieldTypeKey) {
        return Intrinsics.areEqual((Object)customFieldTypeKey, (Object)"com.atlassian.jpo:jpo-custom-field-baseline-start") || Intrinsics.areEqual((Object)customFieldTypeKey, (Object)"com.atlassian.jpo:jpo-custom-field-baseline-end") || Intrinsics.areEqual((Object)customFieldTypeKey, (Object)"com.atlassian.teams:rm-teams-custom-field-team") || Intrinsics.areEqual((Object)customFieldTypeKey, (Object)"com.atlassian.jpo:jpo-custom-field-parent");
    }

    private final boolean isUserDefinedCustomField(CustomField customField) {
        return !Intrinsics.areEqual((Object)customField.getName(), (Object)customField.getCustomFieldType().getName());
    }

    public final boolean isSupportedProjectPermission(@NotNull ProjectPermissionKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.supportedProjectPermissionKeys.contains(key.permissionKey());
    }

    public final boolean isSupportedProjectPermissionForJsd(@NotNull ProjectPermissionKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.jsdSupportedProjectPermissionKeys.contains(key.permissionKey());
    }

    public final boolean isSupportedProjectPermissionForJsw(@NotNull ProjectPermissionKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.jswSupportedProjectPermissionKeys.contains(key.permissionKey());
    }

    public final boolean isInScopeCustomField(@NotNull ExportContext ctx, @NotNull CustomField customField, @Nullable IssueType issueType) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)customField, (String)"customField");
        CustomFieldScopeValue customFieldScopeValue = ctx.getOrLoadCustomFieldScopeValue(customField, ctx.getProject());
        return customFieldScopeValue.getGlobal() || customFieldScopeValue.isInScopeOfProject() || customFieldScopeValue.isInScopeOfIssueType(issueType);
    }

    public final boolean isSupportedSharePermission(@NotNull SharePermission sharePermission) {
        Intrinsics.checkNotNullParameter((Object)sharePermission, (String)"sharePermission");
        return this.supportedSharePermissions.contains(sharePermission.getType());
    }

    private final boolean isSupportedStandardField(String fieldId) {
        return !this.unsupportedStandardFieldIds.contains(fieldId);
    }

    public final boolean isSupportedField(@NotNull ExportContext ctx, @Nullable Field field) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Field field2 = field;
        if (field2 != null) {
            Field it = field2;
            boolean bl2 = false;
            if (field instanceof CustomField) {
                bl = this.isSupportedCustomField(ctx, (CustomField)field);
            } else {
                String string = field.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                bl = this.isSupportedStandardField(string);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean isSupportedFieldById(@NotNull ExportContext ctx, @Nullable String fieldId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        String string = fieldId;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            if (StringsKt.startsWith$default((String)fieldId, (String)"customfield_", (boolean)false, (int)2, null)) {
                CustomField customField = this.customFieldManager.getCustomFieldObject(fieldId);
                if (customField != null) {
                    CustomField it2 = customField;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it2);
                    bl = this.isSupportedCustomField(ctx, it2);
                } else {
                    bl = false;
                }
            } else {
                bl = this.isSupportedStandardField(fieldId);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final Sequence<Issue> filterArchivedIssues(@NotNull Sequence<? extends Issue> issues) {
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        return SequencesKt.filterNot(issues, this.getHasArchived());
    }

    @NotNull
    public final Sequence<Issue> excludeFilteredIssues(@NotNull DataFilterContext dataFilterContext, @NotNull Sequence<? extends Issue> issues) {
        Intrinsics.checkNotNullParameter((Object)dataFilterContext, (String)"dataFilterContext");
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        return DataFiltersUtil.INSTANCE.shouldApplyDataFilters(this.migrationFeatures, dataFilterContext) ? SequencesKt.filter(issues, (Function1)((Function1)new Function1<Issue, Boolean>(this, dataFilterContext){
            final /* synthetic */ ExportFilters this$0;
            final /* synthetic */ DataFilterContext $dataFilterContext;
            {
                this.this$0 = $receiver;
                this.$dataFilterContext = $dataFilterContext;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Issue it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ExportFilters.access$getDataFilterService$p(this.this$0).shouldExportEntity(this.$dataFilterContext, it);
            }
        })) : this.filterArchivedIssues(issues);
    }

    private final Function1<Issue, Boolean> getHasArchived() {
        Lazy lazy = this.hasArchived$delegate;
        return (Function1)lazy.getValue();
    }

    @NotNull
    public final Sequence<Issue> filterArchivedIssuesByProjects(@NotNull Sequence<? extends Issue> issues, @NotNull Set<Long> projectIds) {
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        Intrinsics.checkNotNullParameter(projectIds, (String)"projectIds");
        return SequencesKt.filter(issues, (Function1)((Function1)new Function1<Issue, Boolean>(this, projectIds){
            final /* synthetic */ ExportFilters this$0;
            final /* synthetic */ Set<Long> $projectIds;
            {
                this.this$0 = $receiver;
                this.$projectIds = $projectIds;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Issue issue2) {
                Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
                return (Boolean)ExportFilters.access$getHasArchived(this.this$0).invoke((Object)issue2) == false && CollectionsKt.contains((Iterable)this.$projectIds, (Object)issue2.getProjectId());
            }
        }));
    }

    public final boolean shouldFilterArchivedIssues(@NotNull ExportContext ctx, long issueId) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return MigrationModeUtil.INSTANCE.shouldMigrateArchivedIssues(this.migrationFeatures, ctx.getMigrateArchivedIssues()) || this.isActiveIssue(issueId);
    }

    public final boolean shouldFilterIssue(@NotNull ExportContext ctx, long issueId) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return DataFiltersUtil.INSTANCE.shouldApplyDataFilters(this.migrationFeatures, ctx.getDataFilterContext()) ? this.shouldFilterIssueWithAppliedDataFilters(ctx.getDataFilterContext(), issueId) : this.shouldFilterArchivedIssues(ctx, issueId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean filterArchivedParentLinks(long parentIssueId, long childIssueId) {
        MutableIssue parentIssue = this.issueManager.getIssueObject(Long.valueOf(parentIssueId));
        MutableIssue childIssue = this.issueManager.getIssueObject(Long.valueOf(childIssueId));
        if (this.migrationFeatures.getEnableSkipBrokenParentChildIssueLinks() && (parentIssue == null || childIssue == null)) {
            log.debug("Excluding broken parent/child issue link because parent [" + parentIssueId + "] or child [" + childIssueId + "] issue not found");
            return true;
        }
        Function1<Issue, Boolean> function1 = this.getHasArchived();
        Intrinsics.checkNotNull((Object)parentIssue);
        if ((Boolean)function1.invoke((Object)parentIssue) != false) return true;
        Function1<Issue, Boolean> function12 = this.getHasArchived();
        Intrinsics.checkNotNull((Object)childIssue);
        if ((Boolean)function12.invoke((Object)childIssue) == false) return false;
        return true;
    }

    public final boolean shouldIncludeParentLinksWithAppliedDataFilters(@NotNull DataFilterContext dataFilterContext, long parentIssueId, long childIssueId) {
        Intrinsics.checkNotNullParameter((Object)dataFilterContext, (String)"dataFilterContext");
        MutableIssue parentIssue = this.issueManager.getIssueObject(Long.valueOf(parentIssueId));
        MutableIssue childIssue = this.issueManager.getIssueObject(Long.valueOf(childIssueId));
        if (parentIssue != null && childIssue != null) {
            return this.dataFilterService.shouldExportEntity(dataFilterContext, parentIssue) && this.dataFilterService.shouldExportEntity(dataFilterContext, childIssue);
        }
        log.debug("Excluding broken parent/child issue link based on data filters specified because parent [" + parentIssueId + "] or child [" + childIssueId + "] issue not found");
        return false;
    }

    public final boolean shouldFilterIssueWithAppliedDataFilters(@NotNull DataFilterContext dataFilterContext, long issueId) {
        Intrinsics.checkNotNullParameter((Object)dataFilterContext, (String)"dataFilterContext");
        MutableIssue issue2 = this.issueManager.getIssueObject(Long.valueOf(issueId));
        return issue2 != null ? this.dataFilterService.shouldExportEntity(dataFilterContext, issue2) : false;
    }

    public final boolean isActiveIssue(long issueId) {
        Function1<Issue, Boolean> function1 = this.getHasArchived();
        MutableIssue mutableIssue = this.issueManager.getIssueObject(Long.valueOf(issueId));
        Intrinsics.checkNotNullExpressionValue((Object)mutableIssue, (String)"getIssueObject(...)");
        return (Boolean)function1.invoke((Object)mutableIssue) == false;
    }

    public static final /* synthetic */ DataFilterService access$getDataFilterService$p(ExportFilters $this) {
        return $this.dataFilterService;
    }

    public static final /* synthetic */ Function1 access$getHasArchived(ExportFilters $this) {
        return $this.getHasArchived();
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(ExportFilters.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/export/utils/ExportFilters$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

