/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.utils;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/export/utils/ExportLoggers;", "", "()V", "logUnsupportedCustomField", "", "log", "Lorg/slf4j/Logger;", "customField", "Lcom/atlassian/jira/issue/fields/CustomField;", "msg", "", "logUnsupportedPermissions", "permissionKey", "Lcom/atlassian/jira/security/plugin/ProjectPermissionKey;", "logUnsupportedStandardField", "field", "Lcom/atlassian/jira/issue/fields/Field;", "jira-migration-plugin"})
public final class ExportLoggers {
    @NotNull
    public static final ExportLoggers INSTANCE = new ExportLoggers();

    private ExportLoggers() {
    }

    public final void logUnsupportedStandardField(@NotNull Logger log2, @NotNull Field field, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        log2.info("Unsupported field \"" + field.getId() + "\" " + msg);
    }

    public final void logUnsupportedCustomField(@NotNull Logger log2, @NotNull CustomField customField, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        Intrinsics.checkNotNullParameter((Object)customField, (String)"customField");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        log2.info("Unsupported custom field \"" + customField.getName() + "\"(" + customField.getId() + ") of type " + customField.getCustomFieldType().getKey() + ' ' + msg);
    }

    public final void logUnsupportedPermissions(@NotNull Logger log2, @NotNull ProjectPermissionKey permissionKey, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        Intrinsics.checkNotNullParameter((Object)permissionKey, (String)"permissionKey");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        log2.info("Unsupported permission key \"" + permissionKey.permissionKey() + "\" " + msg);
    }
}

