/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.utils;

import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.MigrationEventBusInterface;
import com.atlassian.jira.migration.events.MigrationStatusUpdatedEvent;
import com.atlassian.jira.migration.export.framework.ExportMode;
import com.atlassian.jira.migration.export.utils.ExportingKey;
import com.atlassian.jira.migration.export.utils.ExportingMemoryService;
import com.atlassian.jira.migration.export.utils.ExportingStatus;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.markers.KMutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u0011\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u0011\u001a\u00020\tH\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001c\u001a\u00020\tH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/export/utils/InMemExportingMemoryService;", "Lcom/atlassian/jira/migration/export/utils/ExportingMemoryService;", "eventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBusInterface;", "(Lcom/atlassian/jira/migration/events/MigrationEventBusInterface;)V", "exportingStatusStore", "Lcom/atlassian/jira/migration/export/utils/InMemExportingMemoryService$ExportingStatusStore;", "(Lcom/atlassian/jira/migration/events/MigrationEventBusInterface;Lcom/atlassian/jira/migration/export/utils/InMemExportingMemoryService$ExportingStatusStore;)V", "forget", "", "exportingKey", "Lcom/atlassian/jira/migration/export/utils/ExportingKey;", "memorizeExportFailed", "memorizeExported", "onMigrationStatusUpdate", "event", "Lcom/atlassian/jira/migration/events/MigrationStatusUpdatedEvent;", "register", "tryMemorizeExporting", "", "key", "tryMemorizeExportingAllFilters", "migrationId", "", "exportMode", "Lcom/atlassian/jira/migration/export/framework/ExportMode;", "tryMemorizeExportingCrossProjectFilters", "tryMemorizeExportingCrossProjectsBoards", "unregister", "Companion", "ExportingStatusStore", "jira-migration-plugin"})
public final class InMemExportingMemoryService
implements ExportingMemoryService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationEventBusInterface eventBus;
    @NotNull
    private final ExportingStatusStore exportingStatusStore;
    private static final Logger log = LoggerFactory.getLogger(InMemExportingMemoryService.class);

    @VisibleForTesting
    public InMemExportingMemoryService(@NotNull MigrationEventBusInterface eventBus, @NotNull ExportingStatusStore exportingStatusStore) {
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)exportingStatusStore, (String)"exportingStatusStore");
        this.eventBus = eventBus;
        this.exportingStatusStore = exportingStatusStore;
    }

    @Inject
    public InMemExportingMemoryService(@NotNull MigrationEventBusInterface eventBus) {
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this(eventBus, new ExportingStatusStore(null, 1, null));
    }

    public /* synthetic */ InMemExportingMemoryService(MigrationEventBusInterface migrationEventBusInterface, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            migrationEventBusInterface = new MigrationEventBus(null, null, 3, null);
        }
        this(migrationEventBusInterface);
    }

    @PostConstruct
    public final void register() {
        this.eventBus.register(this);
    }

    @PreDestroy
    public final void unregister() {
        this.eventBus.unregister(this);
    }

    @Subscribe
    public final void onMigrationStatusUpdate(@NotNull MigrationStatusUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (MigrationStatusUpdatedEvent.Status.ERRORED == event.getStatus() || MigrationStatusUpdatedEvent.Status.FINISHED == event.getStatus() || MigrationStatusUpdatedEvent.Status.CANCELLED == event.getStatus()) {
            log.info("Forget exported all filters for migration " + event.getMigrationId());
            this.forgetExportedAllFilters(event.getMigrationId());
            log.info("Forget exported all boards for migration " + event.getMigrationId());
            this.forgetExportedAllBoards(event.getMigrationId());
        }
    }

    @Override
    public boolean tryMemorizeExporting(@NotNull ExportingKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Ref.BooleanRef newlyInserted = new Ref.BooleanRef();
        Ref.BooleanRef isNotExportedOrExporting = new Ref.BooleanRef();
        this.exportingStatusStore.compute(key, (arg_0, arg_1) -> InMemExportingMemoryService.tryMemorizeExporting$lambda$0((Function2)new Function2<ExportingKey, ExportingStatus, ExportingStatus>(newlyInserted, isNotExportedOrExporting){
            final /* synthetic */ Ref.BooleanRef $newlyInserted;
            final /* synthetic */ Ref.BooleanRef $isNotExportedOrExporting;
            {
                this.$newlyInserted = $newlyInserted;
                this.$isNotExportedOrExporting = $isNotExportedOrExporting;
                super(2);
            }

            @Nullable
            public final ExportingStatus invoke(@NotNull ExportingKey exportingKey, @Nullable ExportingStatus status) {
                ExportingStatus exportingStatus;
                Intrinsics.checkNotNullParameter((Object)exportingKey, (String)"<anonymous parameter 0>");
                this.$newlyInserted.element = status == null;
                ExportingStatus[] exportingStatusArray = new ExportingStatus[]{ExportingStatus.EXPORTING, ExportingStatus.EXPORTED};
                if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])exportingStatusArray), (Object)((Object)status))) {
                    exportingStatus = status;
                } else {
                    this.$isNotExportedOrExporting.element = true;
                    exportingStatus = ExportingStatus.EXPORTING;
                }
                return exportingStatus;
            }
        }, arg_0, arg_1));
        return newlyInserted.element || isNotExportedOrExporting.element;
    }

    @Override
    public void memorizeExported(@NotNull ExportingKey exportingKey) {
        Intrinsics.checkNotNullParameter((Object)exportingKey, (String)"exportingKey");
        ((Map)this.exportingStatusStore).put(exportingKey, ExportingStatus.EXPORTED);
    }

    @Override
    public void memorizeExportFailed(@NotNull ExportingKey exportingKey) {
        Intrinsics.checkNotNullParameter((Object)exportingKey, (String)"exportingKey");
        ((Map)this.exportingStatusStore).put(exportingKey, ExportingStatus.EXPORT_FAILED);
    }

    @Override
    public void forget(@NotNull ExportingKey exportingKey) {
        Intrinsics.checkNotNullParameter((Object)exportingKey, (String)"exportingKey");
        this.exportingStatusStore.remove((Object)exportingKey);
    }

    @Override
    public boolean tryMemorizeExportingAllFilters(@NotNull String migrationId, @NotNull ExportMode exportMode) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)((Object)exportMode), (String)"exportMode");
        return this.tryMemorizeExporting(new ExportingKey.AllFilters(migrationId, exportMode));
    }

    @Override
    public boolean tryMemorizeExportingCrossProjectFilters(@NotNull String migrationId, @NotNull ExportMode exportMode) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)((Object)exportMode), (String)"exportMode");
        return this.tryMemorizeExporting(new ExportingKey.CrossProjectFilters(migrationId, exportMode));
    }

    @Override
    public boolean tryMemorizeExportingCrossProjectsBoards(@NotNull String migrationId, @NotNull ExportMode exportMode) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)((Object)exportMode), (String)"exportMode");
        return this.tryMemorizeExporting(new ExportingKey.CrossProjectBoards(migrationId, exportMode));
    }

    @Override
    public void memorizeExportedAllFilters(@NotNull String migrationId, @NotNull ExportMode exportMode) {
        ExportingMemoryService.DefaultImpls.memorizeExportedAllFilters(this, migrationId, exportMode);
    }

    @Override
    public void memorizeExportedCrossProjectFilters(@NotNull String migrationId, @NotNull ExportMode exportMode) {
        ExportingMemoryService.DefaultImpls.memorizeExportedCrossProjectFilters(this, migrationId, exportMode);
    }

    @Override
    public void memorizeExportedCrossProjectsBoards(@NotNull String migrationId, @NotNull ExportMode exportMode) {
        ExportingMemoryService.DefaultImpls.memorizeExportedCrossProjectsBoards(this, migrationId, exportMode);
    }

    @Override
    public void memorizeExportFailedAllFilters(@NotNull String migrationId, @NotNull ExportMode exportMode) {
        ExportingMemoryService.DefaultImpls.memorizeExportFailedAllFilters(this, migrationId, exportMode);
    }

    @Override
    public void memorizeExportFailedCrossProjectFilters(@NotNull String migrationId, @NotNull ExportMode exportMode) {
        ExportingMemoryService.DefaultImpls.memorizeExportFailedCrossProjectFilters(this, migrationId, exportMode);
    }

    @Override
    public void memorizeExportFailedCrossProjectsBoards(@NotNull String migrationId, @NotNull ExportMode exportMode) {
        ExportingMemoryService.DefaultImpls.memorizeExportFailedCrossProjectsBoards(this, migrationId, exportMode);
    }

    @Override
    public void forgetExportedAllFilters(@NotNull String migrationId) {
        ExportingMemoryService.DefaultImpls.forgetExportedAllFilters(this, migrationId);
    }

    @Override
    public void forgetExportedAllBoards(@NotNull String migrationId) {
        ExportingMemoryService.DefaultImpls.forgetExportedAllBoards(this, migrationId);
    }

    private static final ExportingStatus tryMemorizeExporting$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ExportingStatus)((Object)$tmp0.invoke(p0, p1));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/utils/InMemExportingMemoryService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001b\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0016\u001a\u00020\u0017H\u0096\u0001J\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0096\u0001J\u0011\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0003H\u0096\u0001J\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u0002H\u0096\u0003J\t\u0010\u001e\u001a\u00020\u0019H\u0096\u0001J\u001b\u0010\u001f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0096\u0001J\u001f\u0010 \u001a\u00020\u00172\u0014\u0010!\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\"H\u0096\u0001J\u0013\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u0002H\u0096\u0001R$\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\t0\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lcom/atlassian/jira/migration/export/utils/InMemExportingMemoryService$ExportingStatusStore;", "", "Lcom/atlassian/jira/migration/export/utils/ExportingKey;", "Lcom/atlassian/jira/migration/export/utils/ExportingStatus;", "store", "Ljava/util/concurrent/ConcurrentHashMap;", "(Ljava/util/concurrent/ConcurrentHashMap;)V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "clear", "", "containsKey", "", "key", "containsValue", "value", "get", "isEmpty", "put", "putAll", "from", "", "remove", "jira-migration-plugin"})
    public static final class ExportingStatusStore
    implements Map<ExportingKey, ExportingStatus>,
    KMutableMap {
        @NotNull
        private final ConcurrentHashMap<ExportingKey, ExportingStatus> store;

        public ExportingStatusStore(@NotNull ConcurrentHashMap<ExportingKey, ExportingStatus> store) {
            Intrinsics.checkNotNullParameter(store, (String)"store");
            this.store = store;
        }

        public /* synthetic */ ExportingStatusStore(ConcurrentHashMap concurrentHashMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                concurrentHashMap = new ConcurrentHashMap();
            }
            this(concurrentHashMap);
        }

        @NotNull
        public Set<Map.Entry<ExportingKey, ExportingStatus>> getEntries() {
            Set<Map.Entry<ExportingKey, ExportingStatus>> set = this.store.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            return set;
        }

        @NotNull
        public Set<ExportingKey> getKeys() {
            Set set = this.store.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            return set;
        }

        public int getSize() {
            return this.store.size();
        }

        @NotNull
        public Collection<ExportingStatus> getValues() {
            Collection<ExportingStatus> collection = this.store.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            return collection;
        }

        @Override
        public void clear() {
            this.store.clear();
        }

        public boolean containsKey(@NotNull ExportingKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.store.containsKey(key);
        }

        public boolean containsValue(@NotNull ExportingStatus value) {
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            return this.store.containsValue((Object)value);
        }

        @Nullable
        public ExportingStatus get(@NotNull ExportingKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.store.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.store.isEmpty();
        }

        @Override
        @Nullable
        public ExportingStatus put(@NotNull ExportingKey key, @NotNull ExportingStatus value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            return this.store.put(key, value);
        }

        @Override
        public void putAll(@NotNull Map<? extends ExportingKey, ? extends ExportingStatus> from) {
            Intrinsics.checkNotNullParameter(from, (String)"from");
            this.store.putAll(from);
        }

        @Nullable
        public ExportingStatus remove(@NotNull ExportingKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.store.remove(key);
        }

        public ExportingStatusStore() {
            this(null, 1, null);
        }
    }
}

