/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.utils;

import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ProjectExportContext;
import com.atlassian.jira.migration.export.utils.JsdExportUtil;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.api.util.paging.PagedResponseImpl;
import com.atlassian.servicedesk.api.util.paging.SimplePagedRequest;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/export/utils/JsdExportUtil;", "", "()V", "isJsdProjectEligibleForMigration", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "Companion", "jira-migration-plugin"})
public final class JsdExportUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean isJsdProjectEligibleForMigration(@NotNull ExportContext ctx) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx instanceof ProjectExportContext) {
            String string = ((ProjectExportContext)ctx).getProject().getProjectTypeKey().getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
            bl = Companion.isJsdProjectEligibleForMigration(string);
        } else {
            bl = true;
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u0005J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007\"\u0004\b\u0000\u0010\u00052\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\u00040\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/export/utils/JsdExportUtil$Companion;", "", "()V", "emptyPagedResponse", "Lcom/atlassian/servicedesk/api/util/paging/PagedResponse;", "T", "generateItemsFromPagedResponses", "Lkotlin/sequences/Sequence;", "pagedResponseGenerator", "Lkotlin/Function0;", "isJsdProjectEligibleForMigration", "", "projectTypeKey", "", "JsmApiFailureException", "PagedRequestGenerator", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> PagedResponse<T> emptyPagedResponse() {
            PagedResponseImpl pagedResponseImpl = new PagedResponseImpl.Builder().hasMore(false).build();
            Intrinsics.checkNotNullExpressionValue((Object)pagedResponseImpl, (String)"build(...)");
            return (PagedResponse)pagedResponseImpl;
        }

        @NotNull
        public final <T> Sequence<T> generateItemsFromPagedResponses(@NotNull Function0<? extends PagedResponse<T>> pagedResponseGenerator) {
            Intrinsics.checkNotNullParameter(pagedResponseGenerator, (String)"pagedResponseGenerator");
            return SequencesKt.flatMapIterable((Sequence)SequencesKt.generateSequence(pagedResponseGenerator, (Function1)new Function1<PagedResponse<T>, PagedResponse<T>>(pagedResponseGenerator){
                final /* synthetic */ Function0<PagedResponse<T>> $pagedResponseGenerator;
                {
                    this.$pagedResponseGenerator = $pagedResponseGenerator;
                    super(1);
                }

                @Nullable
                public final PagedResponse<T> invoke(@NotNull PagedResponse<T> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return it.hasNextPage() ? (PagedResponse)this.$pagedResponseGenerator.invoke() : null;
                }
            }), (Function1)generateItemsFromPagedResponses.2.INSTANCE);
        }

        public final boolean isJsdProjectEligibleForMigration(@NotNull String projectTypeKey) {
            Intrinsics.checkNotNullParameter((Object)projectTypeKey, (String)"projectTypeKey");
            return Intrinsics.areEqual((Object)"service_desk", (Object)projectTypeKey);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/utils/JsdExportUtil$Companion$JsmApiFailureException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "(Ljava/lang/String;)V", "jira-migration-plugin"})
        public static final class JsmApiFailureException
        extends RuntimeException {
            public JsmApiFailureException(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super("A JSM API call responded unexpectedly: " + message);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/export/utils/JsdExportUtil$Companion$PagedRequestGenerator;", "", "()V", "limit", "", "getLimit", "()I", "<set-?>", "Ljava/util/concurrent/atomic/AtomicInteger;", "start", "getStart", "()Ljava/util/concurrent/atomic/AtomicInteger;", "generateRequest", "Lcom/atlassian/servicedesk/api/util/paging/PagedRequest;", "getCurrentStartValue", "incrementStart", "", "increaseBy", "jira-migration-plugin"})
        public static final class PagedRequestGenerator {
            @NotNull
            private AtomicInteger start = new AtomicInteger();
            private final int limit;

            public PagedRequestGenerator() {
                this.limit = 100;
            }

            @NotNull
            public final AtomicInteger getStart() {
                return this.start;
            }

            public final int getLimit() {
                return this.limit;
            }

            public final int getCurrentStartValue() {
                return this.start.get();
            }

            @NotNull
            public final PagedRequest generateRequest() {
                return (PagedRequest)new SimplePagedRequest(this.start.intValue(), this.limit);
            }

            public final void incrementStart(int increaseBy) {
                this.start.addAndGet(increaseBy);
            }
        }
    }
}

