/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.utils;

import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.export.framework.ExportEventHandler;
import com.atlassian.jira.migration.export.framework.JsonStreamingExportEventHandler;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\t\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\f\u0012\n\u0018\u00010\fj\u0004\u0018\u0001`\r0\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002Jg\u0010\u0011\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\f\u0012\n\u0018\u00010\fj\u0004\u0018\u0001`\r\u0018\u00010\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0010\b\u0002\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001bJ7\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u001e\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010 \u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/export/utils/JsonExportHandlerUtil;", "", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "accessCheck", "Lkotlin/Pair;", "Ljava/io/File;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "projectKey", "", "migrationId", "addStreamingHandler", "handlerList", "", "Lcom/atlassian/jira/migration/export/framework/ExportEventHandler;", "thresholdMet", "", "topProjects", "", "", "projectId", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;ZLjava/util/Set;Ljava/lang/Long;)Lkotlin/Pair;", "checkWriteRequired", "(ZLjava/lang/String;Ljava/util/Set;Ljava/lang/Long;)Z", "enableFileWrite", "", "outFile", "jira-migration-plugin"})
public final class JsonExportHandlerUtil {
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final ObjectMapper objectMapper;

    @Inject
    public JsonExportHandlerUtil(@NotNull LocalFileDataOutput localFileDataOutput, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.localFileDataOutput = localFileDataOutput;
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    @Nullable
    public final Pair<File, Exception> addStreamingHandler(@NotNull List<ExportEventHandler> handlerList, @NotNull String migrationId, @NotNull String projectKey, boolean thresholdMet, @Nullable Set<Long> topProjects, @Nullable Long projectId) {
        Intrinsics.checkNotNullParameter(handlerList, (String)"handlerList");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Pair<File, Exception> fileExceptionPair = this.accessCheck(projectKey, migrationId);
        boolean performWrite = this.checkWriteRequired(thresholdMet, projectKey, topProjects, projectId);
        Pair<File, Exception> pair = fileExceptionPair;
        if ((pair != null ? (File)pair.getFirst() : null) != null && performWrite) {
            Object object = fileExceptionPair.getFirst();
            Intrinsics.checkNotNull((Object)object);
            this.enableFileWrite(handlerList, (File)object);
        }
        return fileExceptionPair;
    }

    public static /* synthetic */ Pair addStreamingHandler$default(JsonExportHandlerUtil jsonExportHandlerUtil, List list, String string, String string2, boolean bl, Set set, Long l, int n, Object object) {
        if ((n & 0x10) != 0) {
            set = null;
        }
        if ((n & 0x20) != 0) {
            l = null;
        }
        return jsonExportHandlerUtil.addStreamingHandler(list, string, string2, bl, set, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkWriteRequired(boolean thresholdMet, String projectKey, Set<Long> topProjects, Long projectId) {
        if (thresholdMet) return false;
        if (Intrinsics.areEqual((Object)"CROSS-PROJECT-DATA", (Object)projectKey)) return true;
        Set<Long> set = topProjects;
        if (set == null) return false;
        if (!CollectionsKt.contains((Iterable)set, (Object)projectId)) return false;
        return true;
    }

    private final void enableFileWrite(List<ExportEventHandler> handlerList, File outFile) {
        JsonGenerator jsonGenerator = this.objectMapper.getFactory().createGenerator((OutputStream)new FileOutputStream(outFile));
        Intrinsics.checkNotNull((Object)jsonGenerator);
        handlerList.add(new JsonStreamingExportEventHandler(jsonGenerator));
    }

    private final Pair<File, Exception> accessCheck(String projectKey, String migrationId) {
        File outFile = null;
        Exception exception = null;
        try {
            outFile = LocalFileDataOutput.outputFileForProjectData$default(this.localFileDataOutput, migrationId, projectKey, null, 4, null);
        }
        catch (Exception e) {
            exception = e;
        }
        return new Pair(outFile, (Object)exception);
    }
}

