/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.utils;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\nJ,\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\t\u001a\u00020\nJ,\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/export/utils/TextSanitizer;", "", "()V", "sanitizedNullableText", "", "text", "log", "Lorg/slf4j/Logger;", "msg", "cloudLimit", "", "sanitizedText", "truncateTextToCloudLimit", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nExportUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportUtils.kt\ncom/atlassian/jira/migration/export/utils/TextSanitizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
public final class TextSanitizer {
    @NotNull
    public static final TextSanitizer INSTANCE = new TextSanitizer();

    private TextSanitizer() {
    }

    @NotNull
    public final String sanitizedText(@NotNull String text, @NotNull Logger log2, @Nullable String msg, int cloudLimit) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        return this.truncateTextToCloudLimit(StringsKt.replace$default((String)text, (char)'\u0000', (char)' ', (boolean)false, (int)4, null), log2, msg, cloudLimit);
    }

    public static /* synthetic */ String sanitizedText$default(TextSanitizer textSanitizer, String string, Logger logger2, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            n = Short.MAX_VALUE;
        }
        return textSanitizer.sanitizedText(string, logger2, string2, n);
    }

    private final String truncateTextToCloudLimit(String text, Logger log2, String msg, int cloudLimit) {
        String string;
        if (text.length() > cloudLimit) {
            Object[] objectArray = new String[2];
            StringBuilder stringBuilder = new StringBuilder().append("Truncated text \"");
            String string2 = text.substring(0, 20);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            objectArray[0] = stringBuilder.append(string2).append("...\" to cloud limit of ").append(cloudLimit).append(" chars").toString();
            objectArray[1] = msg;
            List logMsgs = CollectionsKt.listOfNotNull((Object[])objectArray);
            log2.info(CollectionsKt.joinToString$default((Iterable)logMsgs, null, null, null, (int)0, null, null, (int)63, null));
            String string3 = text.substring(0, cloudLimit);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = text;
        }
        return string;
    }

    static /* synthetic */ String truncateTextToCloudLimit$default(TextSanitizer textSanitizer, String string, Logger logger2, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        return textSanitizer.truncateTextToCloudLimit(string, logger2, string2, n);
    }

    @Nullable
    public final String sanitizedNullableText(@Nullable String text, @NotNull Logger log2, @NotNull String msg, int cloudLimit) {
        String string;
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        String string2 = text;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = INSTANCE.sanitizedText(it, log2, msg, cloudLimit);
        } else {
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String sanitizedNullableText$default(TextSanitizer textSanitizer, String string, Logger logger2, String string2, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = Short.MAX_VALUE;
        }
        return textSanitizer.sanitizedNullableText(string, logger2, string2, n);
    }
}

