/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.externalMapping.export;

import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.externalMapping.model.ExternalEntity;
import com.atlassian.jira.migration.externalMapping.model.MigExternalEntity;
import com.atlassian.jira.migration.externalMapping.util.ExternalMappingUtil;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.MRIType;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.core.ExternalMigrationIdMapping;
import com.atlassian.migration.core.MigrationCoreMriRegistry;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0002J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/externalMapping/export/ExternalMappingExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/externalMapping/model/ExternalEntity;", "Lcom/atlassian/jira/migration/externalMapping/model/MigExternalEntity;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "getCloudEntityMRI", "Lcom/atlassian/migration/base/mri/MRI;", "entityType", "entityKey", "getServerEntityMRI", "mriForEntity", "mriForKey", "postConstruct", "", "jira-migration-plugin"})
public final class ExternalMappingExporter
implements Exporter<String, ExternalEntity, MigExternalEntity> {
    @NotNull
    private final ExportService exportService;

    @Inject
    public ExternalMappingExporter(@NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.exportService = exportService;
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, ExternalEntity.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(ExternalMigrationIdMapping.Companion.getEntityType());
    }

    @Override
    @NotNull
    public MigExternalEntity exportData(@NotNull ExportContext ctx, @NotNull ExternalEntity entity) {
        MigExternalEntity migExternalEntity;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        MigExternalEntity it = migExternalEntity = new MigExternalEntity(this.mriForEntity(entity), this.getServerEntityMRI(entity.getType(), entity.getSourceId()), this.getCloudEntityMRI(entity.getType(), entity.getDestinationId()));
        boolean bl = false;
        if (entity.getExportChildren()) {
            ctx.addExportChildren(it.getMigrationId());
        }
        ctx.indexAsSeen(it.getMigrationId());
        return migExternalEntity;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull ExternalEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(StringsKt.replace$default((String)(entity.getType() + '-' + entity.getSourceId()), (String)":", (String)"-", (boolean)false, (int)4, null));
    }

    @Override
    @NotNull
    public MRI mriForKey(@NotNull String entityKey) {
        Intrinsics.checkNotNullParameter((Object)entityKey, (String)"entityKey");
        return MriExtensionsKt.mri$default(ExternalMigrationIdMapping.Companion.getEntityType(), entityKey, null, 2, null);
    }

    private final MRI getServerEntityMRI(String entityType, String entityKey) {
        EntityType entityType2 = ExternalMappingUtil.INSTANCE.getJiraEntityFromString(entityType);
        Intrinsics.checkNotNull((Object)entityType2);
        EntityType jiraEntity = entityType2;
        return Intrinsics.areEqual((Object)entityType, (Object)MigrationCoreMriRegistry.INSTANCE.getUser().fullName()) ? MriExtensionsKt.mri$default(jiraEntity, "jira.userkey/" + entityKey, null, 2, null) : MriExtensionsKt.mri$default(jiraEntity, entityKey, null, 2, null);
    }

    private final MRI getCloudEntityMRI(String entityType, String entityKey) {
        String formattedKey = Intrinsics.areEqual((Object)entityType, (Object)MigrationCoreMriRegistry.INSTANCE.getUser().fullName()) ? StringsKt.replace$default((String)entityKey, (String)"_", (String)":", (boolean)false, (int)4, null) : entityKey;
        EntityType entityType2 = ExternalMappingUtil.INSTANCE.getJiraEntityFromString(entityType);
        Intrinsics.checkNotNull((Object)entityType2);
        return MriExtensionsKt.mri(entityType2, formattedKey, MRIType.RESULTING);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull ExternalEntity entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public ExternalEntity extractServerEntity(@NotNull ExportContext ctx, @NotNull String entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull ExternalEntity entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

