/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.externalMapping.service;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.migration.externalMapping.model.ExternalEntity;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u0007H\u0080\u0002\u00a2\u0006\u0002\b\rJ\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0007R6\u0010\u0005\u001a*\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/externalMapping/service/ExternalMappingCache;", "", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "(Lcom/atlassian/cache/CacheManager;)V", "cache", "Lcom/atlassian/cache/Cache;", "", "kotlin.jvm.PlatformType", "", "Lcom/atlassian/jira/migration/externalMapping/model/ExternalEntity;", "get", "jobId", "get$jira_migration_plugin", "putExternalMappings", "", "externalMappings", "remove", "Companion", "jira-migration-plugin"})
public final class ExternalMappingCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<String, List<ExternalEntity>> cache;
    private static final Logger log = LoggerFactory.getLogger(ExternalMappingCache.class);
    private static final String CACHE_NAME = ExternalMappingCache.class.getName();
    private static final long CACHE_EXPIRY_DAYS = 4L;
    private static final int CACHE_MAX_ENTRIES = 1000;
    @NotNull
    private static final CacheSettings CACHE_SETTING;

    @Inject
    public ExternalMappingCache(@NotNull CacheManager cacheManager) {
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Cache cache2 = cacheManager.getCache(CACHE_NAME, null, CACHE_SETTING);
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"getCache(...)");
        this.cache = cache2;
    }

    public final void putExternalMappings(@NotNull String jobId, @NotNull List<ExternalEntity> externalMappings) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        Intrinsics.checkNotNullParameter(externalMappings, (String)"externalMappings");
        log.info("Adding external mappings for jobId = " + jobId);
        this.cache.put((Object)jobId, externalMappings);
    }

    public final void remove(@NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        log.info("Deleting external mappings for jobId = " + jobId);
        this.cache.remove((Object)jobId);
    }

    @Nullable
    public final List<ExternalEntity> get$jira_migration_plugin(@NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        return (List)this.cache.get((Object)jobId);
    }

    static {
        CacheSettings cacheSettings = new CacheSettingsBuilder().expireAfterWrite(4L, TimeUnit.DAYS).replicateViaCopy().remote().maxEntries(1000).build();
        Intrinsics.checkNotNullExpressionValue((Object)cacheSettings, (String)"build(...)");
        CACHE_SETTING = cacheSettings;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/externalMapping/service/ExternalMappingCache$Companion;", "", "()V", "CACHE_EXPIRY_DAYS", "", "CACHE_MAX_ENTRIES", "", "CACHE_NAME", "", "kotlin.jvm.PlatformType", "CACHE_SETTING", "Lcom/atlassian/cache/CacheSettings;", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

