/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.externalMapping.service;

import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportMode;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.externalMapping.model.ExternalEntity;
import com.atlassian.jira.migration.externalMapping.service.ExternalMappingCache;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMapping;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMappingRepository;
import com.atlassian.migration.base.mri.registry.EntityType;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/externalMapping/service/ExternalMappingExportService;", "", "publicPlanMappingRepository", "Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;", "externalMappingCache", "Lcom/atlassian/jira/migration/externalMapping/service/ExternalMappingCache;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;Lcom/atlassian/jira/migration/externalMapping/service/ExternalMappingCache;Lcom/atlassian/jira/migration/export/service/ExportService;)V", "checkIfExternalMapping", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "Lcom/atlassian/migration/base/mri/registry/EntityType;", "entityId", "", "exportExternalEntities", "", "getJobIdForExportContext", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nExternalMappingExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalMappingExportService.kt\ncom/atlassian/jira/migration/externalMapping/service/ExternalMappingExportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n1855#2,2:45\n1747#2,3:47\n*S KotlinDebug\n*F\n+ 1 ExternalMappingExportService.kt\ncom/atlassian/jira/migration/externalMapping/service/ExternalMappingExportService\n*L\n22#1:45,2\n31#1:47,3\n*E\n"})
public final class ExternalMappingExportService {
    @NotNull
    private final PublicPlanMappingRepository publicPlanMappingRepository;
    @NotNull
    private final ExternalMappingCache externalMappingCache;
    @NotNull
    private final ExportService exportService;

    @Inject
    public ExternalMappingExportService(@NotNull PublicPlanMappingRepository publicPlanMappingRepository, @NotNull ExternalMappingCache externalMappingCache, @NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)publicPlanMappingRepository, (String)"publicPlanMappingRepository");
        Intrinsics.checkNotNullParameter((Object)externalMappingCache, (String)"externalMappingCache");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.publicPlanMappingRepository = publicPlanMappingRepository;
        this.externalMappingCache = externalMappingCache;
        this.exportService = exportService;
    }

    public final void exportExternalEntities(@NotNull ExportContext ctx) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            String string = this.getJobIdForExportContext(ctx);
            if (string == null) break block2;
            String jobId = string;
            boolean bl = false;
            List<ExternalEntity> list = this.externalMappingCache.get$jira_migration_plugin(jobId);
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ExternalEntity externalEntity = (ExternalEntity)element$iv;
                    boolean bl2 = false;
                    ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, externalEntity, false, 4, null);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean checkIfExternalMapping(@NotNull ExportContext ctx, @NotNull EntityType entity, @NotNull String entityId) {
        boolean bl;
        String string;
        block3: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
            String string2 = this.getJobIdForExportContext(ctx);
            string = string2;
            if (string2 == null) return false;
            String jobId = string;
            boolean bl2 = false;
            List<ExternalEntity> list = this.externalMappingCache.get$jira_migration_plugin(jobId);
            if (list == null) return false;
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ExternalEntity it = (ExternalEntity)element$iv;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual((Object)it.getType(), (Object)(entity.getNamespace().getName() + ':' + entity.getType())) && Intrinsics.areEqual((Object)it.getSourceId(), (Object)entityId))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        Boolean bl4 = bl;
        string = bl4;
        if (bl4 == null) return false;
        boolean bl5 = (Boolean)((Object)string);
        return bl5;
    }

    private final String getJobIdForExportContext(ExportContext ctx) {
        String string;
        if (ctx.getExportMode() == ExportMode.COLLECT_PREFLIGHT_PROJECT_DATA) {
            PublicPlanMapping publicPlanMapping = this.publicPlanMappingRepository.getByPreflightExecutionId(ctx.getMigrationId());
            string = publicPlanMapping != null ? publicPlanMapping.getJobId() : null;
        } else {
            PublicPlanMapping publicPlanMapping = this.publicPlanMappingRepository.getByMigrationId(ctx.getMigrationId());
            string = publicPlanMapping != null ? publicPlanMapping.getJobId() : null;
        }
        return string;
    }
}

