/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.features;

import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.analytics.rollout.CodePathExecuted;
import com.atlassian.jira.migration.analytics.rollout.RolloutFlagType;
import com.atlassian.jira.migration.analytics.rollout.RolloutResult;
import com.atlassian.jira.migration.features.StatsigFx3Gates;
import com.atlassian.jira.migration.metrics.PrometheusMetrics;
import com.atlassian.jira.migration.tracking.utils.SystemTimeProvider;
import com.atlassian.jira.migration.tracking.utils.TimeProvider;
import io.prometheus.metrics.core.datapoints.CounterDataPoint;
import io.prometheus.metrics.core.datapoints.DistributionDataPoint;
import io.prometheus.metrics.core.metrics.Counter;
import io.prometheus.metrics.core.metrics.Summary;
import io.prometheus.metrics.model.registry.Collector;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J4\u0010\u0007\u001a\f\u0012\u0004\u0012\u0002H\t0\bR\u00020\u0000\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJ-\u0010\u0010\u001a\u0002H\t\"\u0004\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/features/RolloutService;", "", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "timeProvider", "Lcom/atlassian/jira/migration/tracking/utils/TimeProvider;", "(Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/tracking/utils/TimeProvider;)V", "withFeature", "Lcom/atlassian/jira/migration/features/RolloutService$KeyBasedRolloutBuilder;", "T", "key", "", "metricsEnabled", "", "isEnabled", "Lkotlin/Function0;", "timedCall", "Ljava/util/concurrent/Callable;", "timer", "Lio/prometheus/metrics/core/metrics/Summary;", "(Ljava/util/concurrent/Callable;Lio/prometheus/metrics/core/metrics/Summary;Ljava/lang/String;)Ljava/lang/Object;", "Companion", "KeyBasedRolloutBuilder", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nRolloutService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RolloutService.kt\ncom/atlassian/jira/migration/features/RolloutService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,227:1\n1855#2,2:228\n*S KotlinDebug\n*F\n+ 1 RolloutService.kt\ncom/atlassian/jira/migration/features/RolloutService\n*L\n110#1:228,2\n*E\n"})
public final class RolloutService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MetricsEventService metricsEventService;
    @NotNull
    private final TimeProvider timeProvider;
    private static final Logger log = LoggerFactory.getLogger(RolloutService.class);
    private static final Counter rolloutEnabledExecutionCounter;
    private static final Counter rolloutDisabledExecutionCounter;
    private static final Counter rolloutEnabledSuccessCounter;
    private static final Counter rolloutDisabledSuccessCounter;
    private static final Counter rolloutEnabledExceptionCounter;
    private static final Counter rolloutDisabledExceptionCounter;
    private static final Summary rolloutEnabledExecutionTimer;
    private static final Summary rolloutDisabledExecutionTimer;

    @Inject
    public RolloutService(@NotNull MetricsEventService metricsEventService, @NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        this.metricsEventService = metricsEventService;
        this.timeProvider = timeProvider;
        Iterable $this$forEach$iv = (Iterable)StatsigFx3Gates.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StatsigFx3Gates it = (StatsigFx3Gates)((Object)element$iv);
            boolean bl = false;
            String[] stringArray = new String[]{it.getGateKey()};
            ((CounterDataPoint)rolloutEnabledExecutionCounter.labelValues(stringArray)).inc(0L);
            stringArray = new String[]{it.getGateKey()};
            ((CounterDataPoint)rolloutDisabledExecutionCounter.labelValues(stringArray)).inc(0L);
            stringArray = new String[]{it.getGateKey()};
            ((CounterDataPoint)rolloutDisabledExceptionCounter.labelValues(stringArray)).inc(0L);
            stringArray = new String[]{it.getGateKey()};
            ((CounterDataPoint)rolloutEnabledExceptionCounter.labelValues(stringArray)).inc(0L);
            stringArray = new String[]{it.getGateKey()};
            ((CounterDataPoint)rolloutDisabledSuccessCounter.labelValues(stringArray)).inc(0L);
            stringArray = new String[]{it.getGateKey()};
            ((CounterDataPoint)rolloutEnabledSuccessCounter.labelValues(stringArray)).inc(0L);
        }
    }

    public /* synthetic */ RolloutService(MetricsEventService metricsEventService, TimeProvider timeProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            timeProvider = new SystemTimeProvider();
        }
        this(metricsEventService, timeProvider);
    }

    @NotNull
    public final <T> KeyBasedRolloutBuilder<T> withFeature(@NotNull String key, boolean metricsEnabled, @NotNull Function0<Boolean> isEnabled) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(isEnabled, (String)"isEnabled");
        return new KeyBasedRolloutBuilder(this, key, isEnabled, metricsEnabled);
    }

    private final <T> T timedCall(Callable<T> $this$timedCall, Summary timer, String key) {
        String[] stringArray = new String[]{key};
        return (T)((DistributionDataPoint)timer.labelValues(stringArray)).time($this$timedCall::call);
    }

    static {
        String[] stringArray = new String[]{"feature_flag_key"};
        rolloutEnabledExecutionCounter = (Counter)PrometheusMetrics.Companion.registerSilently((Collector)((Counter.Builder)((Counter.Builder)Counter.builder().name("jcma.rollout_service.execution.enabled").help("Count of enabled executions of a rollout by feature flag key")).labelNames(stringArray)).build());
        stringArray = new String[]{"feature_flag_key"};
        rolloutDisabledExecutionCounter = (Counter)PrometheusMetrics.Companion.registerSilently((Collector)((Counter.Builder)((Counter.Builder)Counter.builder().name("jcma.rollout_service.execution.disabled").help("Count of disabled executions of a rollout by feature flag key")).labelNames(stringArray)).build());
        stringArray = new String[]{"feature_flag_key"};
        rolloutEnabledSuccessCounter = (Counter)PrometheusMetrics.Companion.registerSilently((Collector)((Counter.Builder)((Counter.Builder)Counter.builder().name("jcma.rollout_service.success.enabled").help("Count of enabled executions of a rollout by feature flag key")).labelNames(stringArray)).build());
        stringArray = new String[]{"feature_flag_key"};
        rolloutDisabledSuccessCounter = (Counter)PrometheusMetrics.Companion.registerSilently((Collector)((Counter.Builder)((Counter.Builder)Counter.builder().name("jcma.rollout_service.success.disabled").help("Count of disabled executions of a rollout by feature flag key")).labelNames(stringArray)).build());
        stringArray = new String[]{"feature_flag_key"};
        rolloutEnabledExceptionCounter = (Counter)PrometheusMetrics.Companion.registerSilently((Collector)((Counter.Builder)((Counter.Builder)Counter.builder().name("jcma.rollout_service.exception.enabled").help("Count of enabled exceptions of a rollout by feature flag key")).labelNames(stringArray)).build());
        stringArray = new String[]{"feature_flag_key"};
        rolloutDisabledExceptionCounter = (Counter)PrometheusMetrics.Companion.registerSilently((Collector)((Counter.Builder)((Counter.Builder)Counter.builder().name("jcma.rollout_service.exception.disabled").help("Count of disabled exceptions of a rollout by feature flag key")).labelNames(stringArray)).build());
        stringArray = new String[]{"feature_flag_key"};
        rolloutEnabledExecutionTimer = (Summary)PrometheusMetrics.Companion.registerSilently((Collector)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.builder().name("jcma.rollout_service.execution.duration.enabled")).help("Execution duration of new code of a rollout by feature flag key")).labelNames(stringArray)).quantile(0.5).quantile(0.9).quantile(0.95).quantile(0.99).build());
        stringArray = new String[]{"feature_flag_key"};
        rolloutDisabledExecutionTimer = (Summary)PrometheusMetrics.Companion.registerSilently((Collector)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.builder().name("jcma.rollout_service.exception.duration.disabled")).help("Execution duration of old code of a rollout by feature flag key")).labelNames(stringArray)).quantile(0.5).quantile(0.9).quantile(0.95).quantile(0.99).build());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001c\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\r0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u001c\u0010\u0012\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u001c\u0010\u0014\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR\u001c\u0010\u0016\u001a\n \u0005*\u0004\u0018\u00010\r0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u001c\u0010\u0018\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/jira/migration/features/RolloutService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "rolloutDisabledExceptionCounter", "Lio/prometheus/metrics/core/metrics/Counter;", "getRolloutDisabledExceptionCounter$jira_migration_plugin", "()Lio/prometheus/metrics/core/metrics/Counter;", "rolloutDisabledExecutionCounter", "getRolloutDisabledExecutionCounter$jira_migration_plugin", "rolloutDisabledExecutionTimer", "Lio/prometheus/metrics/core/metrics/Summary;", "getRolloutDisabledExecutionTimer$jira_migration_plugin", "()Lio/prometheus/metrics/core/metrics/Summary;", "rolloutDisabledSuccessCounter", "getRolloutDisabledSuccessCounter$jira_migration_plugin", "rolloutEnabledExceptionCounter", "getRolloutEnabledExceptionCounter$jira_migration_plugin", "rolloutEnabledExecutionCounter", "getRolloutEnabledExecutionCounter$jira_migration_plugin", "rolloutEnabledExecutionTimer", "getRolloutEnabledExecutionTimer$jira_migration_plugin", "rolloutEnabledSuccessCounter", "getRolloutEnabledSuccessCounter$jira_migration_plugin", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final Counter getRolloutEnabledExecutionCounter$jira_migration_plugin() {
            return rolloutEnabledExecutionCounter;
        }

        public final Counter getRolloutDisabledExecutionCounter$jira_migration_plugin() {
            return rolloutDisabledExecutionCounter;
        }

        public final Counter getRolloutEnabledSuccessCounter$jira_migration_plugin() {
            return rolloutEnabledSuccessCounter;
        }

        public final Counter getRolloutDisabledSuccessCounter$jira_migration_plugin() {
            return rolloutDisabledSuccessCounter;
        }

        public final Counter getRolloutEnabledExceptionCounter$jira_migration_plugin() {
            return rolloutEnabledExceptionCounter;
        }

        public final Counter getRolloutDisabledExceptionCounter$jira_migration_plugin() {
            return rolloutDisabledExceptionCounter;
        }

        public final Summary getRolloutEnabledExecutionTimer$jira_migration_plugin() {
            return rolloutEnabledExecutionTimer;
        }

        public final Summary getRolloutDisabledExecutionTimer$jira_migration_plugin() {
            return rolloutDisabledExecutionTimer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010)\u001a\u00020\u0007J\r\u0010*\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010+J\u001e\u0010,\u001a\f\u0012\u0004\u0012\u00028\u00000\u0000R\u00020-2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eJ\u001e\u0010.\u001a\f\u0012\u0004\u0012\u00028\u00000\u0000R\u00020-2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eJ\u0018\u0010/\u001a\f\u0012\u0004\u0012\u00028\u00000\u0000R\u00020-2\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u00100\u001a\f\u0012\u0004\u0012\u00028\u00000\u0000R\u00020-2\u0006\u0010&\u001a\u00020\u0004R\u001a\u0010\n\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u001aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\fR\"\u0010\u001d\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010#\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R\u001c\u0010&\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0011\"\u0004\b(\u0010\u0013\u00a8\u00061"}, d2={"Lcom/atlassian/jira/migration/features/RolloutService$KeyBasedRolloutBuilder;", "T", "", "key", "", "isEnabled", "Lkotlin/Function0;", "", "metricsEnabled", "(Lcom/atlassian/jira/migration/features/RolloutService;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Z)V", "default", "getDefault", "()Z", "setDefault", "(Z)V", "feature", "getFeature", "()Ljava/lang/String;", "setFeature", "(Ljava/lang/String;)V", "flagType", "Lcom/atlassian/jira/migration/analytics/rollout/RolloutFlagType;", "getFlagType", "()Lcom/atlassian/jira/migration/analytics/rollout/RolloutFlagType;", "setFlagType", "(Lcom/atlassian/jira/migration/analytics/rollout/RolloutFlagType;)V", "()Lkotlin/jvm/functions/Function0;", "getKey", "getMetricsEnabled", "newCode", "Ljava/util/concurrent/Callable;", "getNewCode", "()Ljava/util/concurrent/Callable;", "setNewCode", "(Ljava/util/concurrent/Callable;)V", "oldCode", "getOldCode", "setOldCode", "override", "getOverride", "setOverride", "featureEnabled", "run", "()Ljava/lang/Object;", "whenDisabled", "Lcom/atlassian/jira/migration/features/RolloutService;", "whenEnabled", "withFlagType", "withJvmEnabledOverride", "jira-migration-plugin"})
    public final class KeyBasedRolloutBuilder<T> {
        @NotNull
        private final String key;
        @NotNull
        private final Function0<Boolean> isEnabled;
        private final boolean metricsEnabled;
        private boolean default;
        @Nullable
        private Callable<T> oldCode;
        @Nullable
        private Callable<T> newCode;
        @Nullable
        private String feature;
        @Nullable
        private String override;
        @NotNull
        private RolloutFlagType flagType;
        final /* synthetic */ RolloutService this$0;

        public KeyBasedRolloutBuilder(@NotNull RolloutService this$0, @NotNull String key, Function0<Boolean> isEnabled, boolean metricsEnabled) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(isEnabled, (String)"isEnabled");
            this.this$0 = this$0;
            this.key = key;
            this.isEnabled = isEnabled;
            this.metricsEnabled = metricsEnabled;
            this.flagType = RolloutFlagType.STATSIG;
        }

        public /* synthetic */ KeyBasedRolloutBuilder(RolloutService rolloutService, String string, Function0 function0, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(rolloutService, string, (Function0<Boolean>)function0, bl);
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final Function0<Boolean> isEnabled() {
            return this.isEnabled;
        }

        public final boolean getMetricsEnabled() {
            return this.metricsEnabled;
        }

        public final boolean getDefault() {
            return this.default;
        }

        public final void setDefault(boolean bl) {
            this.default = bl;
        }

        @Nullable
        public final Callable<T> getOldCode() {
            return this.oldCode;
        }

        public final void setOldCode(@Nullable Callable<T> callable) {
            this.oldCode = callable;
        }

        @Nullable
        public final Callable<T> getNewCode() {
            return this.newCode;
        }

        public final void setNewCode(@Nullable Callable<T> callable) {
            this.newCode = callable;
        }

        @Nullable
        public final String getFeature() {
            return this.feature;
        }

        public final void setFeature(@Nullable String string) {
            this.feature = string;
        }

        @Nullable
        public final String getOverride() {
            return this.override;
        }

        public final void setOverride(@Nullable String string) {
            this.override = string;
        }

        @NotNull
        public final RolloutFlagType getFlagType() {
            return this.flagType;
        }

        public final void setFlagType(@NotNull RolloutFlagType rolloutFlagType) {
            Intrinsics.checkNotNullParameter((Object)((Object)rolloutFlagType), (String)"<set-?>");
            this.flagType = rolloutFlagType;
        }

        @NotNull
        public final KeyBasedRolloutBuilder<T> whenDisabled(@NotNull Callable<T> oldCode) {
            Intrinsics.checkNotNullParameter(oldCode, (String)"oldCode");
            this.oldCode = oldCode;
            return this;
        }

        @NotNull
        public final KeyBasedRolloutBuilder<T> whenEnabled(@NotNull Callable<T> newCode) {
            Intrinsics.checkNotNullParameter(newCode, (String)"newCode");
            this.newCode = newCode;
            return this;
        }

        @NotNull
        public final KeyBasedRolloutBuilder<T> withJvmEnabledOverride(@NotNull String override) {
            Intrinsics.checkNotNullParameter((Object)override, (String)"override");
            this.override = override;
            return this;
        }

        public final boolean featureEnabled() {
            return (Boolean)this.isEnabled.invoke();
        }

        @NotNull
        public final KeyBasedRolloutBuilder<T> withFlagType(@NotNull RolloutFlagType flagType) {
            Intrinsics.checkNotNullParameter((Object)((Object)flagType), (String)"flagType");
            this.flagType = flagType;
            return this;
        }

        @Nullable
        public final T run() {
            boolean featureEnabled = false;
            boolean jvmOverride = false;
            UUID featureEvaluationTraceId = UUID.randomUUID();
            boolean executeEnabledCode = false;
            CodePathExecuted codePathExecuted = CodePathExecuted.DISABLED;
            Long startTime = null;
            try {
                Object object;
                String[] stringArray;
                Object it;
                Object object2;
                featureEnabled = this.featureEnabled();
                jvmOverride = Boolean.getBoolean(this.override);
                executeEnabledCode = featureEnabled || jvmOverride;
                codePathExecuted = executeEnabledCode ? CodePathExecuted.ENABLED : CodePathExecuted.DISABLED;
                startTime = this.this$0.timeProvider.now().toEpochMilli();
                log.debug("Running code for feature '" + this.key + "', featureEnabled = " + featureEnabled + ", jvmOverrideEnabled = " + jvmOverride + ", traceId = " + featureEvaluationTraceId);
                if (executeEnabledCode) {
                    Object object3;
                    log.debug("Calling new code for feature '" + this.key + "', featureEnabled = " + featureEnabled + ", jvmOverrideEnabled = " + jvmOverride + ", traceId = " + featureEvaluationTraceId);
                    object2 = new String[]{this.key};
                    ((CounterDataPoint)Companion.getRolloutEnabledExecutionCounter$jira_migration_plugin().labelValues(object2)).inc();
                    object2 = this.newCode;
                    if (object2 != null) {
                        Summary summary = Companion.getRolloutEnabledExecutionTimer$jira_migration_plugin();
                        Intrinsics.checkNotNullExpressionValue((Object)summary, (String)"<get-rolloutEnabledExecutionTimer>(...)");
                        object3 = this.this$0.timedCall((Callable)object2, summary, this.key);
                    } else {
                        object3 = null;
                    }
                    it = object2 = object3;
                    boolean bl = false;
                    stringArray = new String[]{this.key};
                    ((CounterDataPoint)Companion.getRolloutEnabledSuccessCounter$jira_migration_plugin().labelValues(stringArray)).inc();
                    object = object2;
                } else {
                    Object object4;
                    log.debug("Calling old code for feature '" + this.key + "', featureEnabled = " + featureEnabled + ", jvmOverrideEnabled = " + jvmOverride + ", traceId = " + featureEvaluationTraceId);
                    object2 = new String[]{this.key};
                    ((CounterDataPoint)Companion.getRolloutDisabledExecutionCounter$jira_migration_plugin().labelValues(object2)).inc();
                    object2 = this.oldCode;
                    if (object2 != null) {
                        Summary summary = Companion.getRolloutDisabledExecutionTimer$jira_migration_plugin();
                        Intrinsics.checkNotNullExpressionValue((Object)summary, (String)"<get-rolloutDisabledExecutionTimer>(...)");
                        object4 = this.this$0.timedCall((Callable)object2, summary, this.key);
                    } else {
                        object4 = null;
                    }
                    it = object2 = object4;
                    boolean bl = false;
                    stringArray = new String[]{this.key};
                    ((CounterDataPoint)Companion.getRolloutDisabledSuccessCounter$jira_migration_plugin().labelValues(stringArray)).inc();
                    object = object2;
                }
                Object result2 = object;
                log.debug("Completed code for feature '" + this.key + "', featureEnabled = " + featureEnabled + ", jvmOverrideEnabled = " + jvmOverride + ", traceId = " + featureEvaluationTraceId);
                if (this.metricsEnabled) {
                    MetricsEventService.sendFFExecutionResult$default(this.this$0.metricsEventService, RolloutResult.SUCCESS, this.key, this.flagType, jvmOverride, codePathExecuted, null, startTime, 32, null);
                }
                return (T)result2;
            }
            catch (Exception exception) {
                log.error("Error running code for feature '" + this.key + "', featureEnabled = " + featureEnabled + ", jvmOverrideEnabled = " + jvmOverride + ", traceId = " + featureEvaluationTraceId, (Throwable)exception);
                if (executeEnabledCode) {
                    String[] stringArray = new String[]{this.key};
                    ((CounterDataPoint)Companion.getRolloutEnabledExceptionCounter$jira_migration_plugin().labelValues(stringArray)).inc();
                } else {
                    String[] stringArray = new String[]{this.key};
                    ((CounterDataPoint)Companion.getRolloutDisabledExceptionCounter$jira_migration_plugin().labelValues(stringArray)).inc();
                }
                if (this.metricsEnabled) {
                    MetricsEventService metricsEventService = this.this$0.metricsEventService;
                    String string = exception.getClass().getSimpleName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
                    metricsEventService.sendFFExecutionResult(RolloutResult.EXCEPTION, this.key, this.flagType, jvmOverride, codePathExecuted, string, startTime);
                }
                throw exception;
            }
        }
    }
}

