/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.features.rest;

import com.atlassian.jira.migration.features.DarkFeaturesExtensionsKt;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.features.StatsigDynamicConfigs;
import com.atlassian.jira.migration.fx3.api.Fx3PluginClient;
import com.atlassian.jira.migration.fx3.util.StatsigMappings;
import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="dark-features")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001dB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\nH\u0007J\b\u0010\u000e\u001a\u00020\nH\u0007J\b\u0010\u000f\u001a\u00020\nH\u0007J\u0012\u0010\u0010\u001a\u00020\n2\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0007J\u0012\u0010\u0013\u001a\u00020\n2\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0007J\u0012\u0010\u0014\u001a\u00020\n2\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0015\u001a\u00020\nH\u0007J\b\u0010\u0016\u001a\u00020\nH\u0007J\b\u0010\u0017\u001a\u00020\nH\u0007J\u0012\u0010\u0018\u001a\u00020\n2\b\b\u0001\u0010\u0019\u001a\u00020\u0012H\u0007J\u001c\u0010\u001a\u001a\u00020\n2\b\b\u0001\u0010\u001b\u001a\u00020\u00122\b\b\u0001\u0010\u001c\u001a\u00020\u0012H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/features/rest/FeaturesResource;", "", "darkFeatureManager", "Lcom/atlassian/sal/api/features/DarkFeatureManager;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "fx3PluginClient", "Lcom/atlassian/jira/migration/fx3/api/Fx3PluginClient;", "(Lcom/atlassian/sal/api/features/DarkFeatureManager;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/fx3/api/Fx3PluginClient;)V", "addMappings", "Ljavax/ws/rs/core/Response;", "body", "Lcom/atlassian/jira/migration/features/rest/FeaturesResource$AddMappingsBody;", "getAllDynamicConfigKeys", "getEnabledFeatureGateKeys", "getEnabledFeatureKeys", "getEnabledFx3GateKey", "key", "", "getEnabledFx3Key", "getFx3DynamicConfigKey", "refreshFx3All", "refreshFx3Flags", "refreshFx3Statsig", "updateCloudId", "cloudId", "updateCustomAttributeValue", "customAttributeKey", "customAttributeValue", "AddMappingsBody", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nFeaturesResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeaturesResource.kt\ncom/atlassian/jira/migration/features/rest/FeaturesResource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,160:1\n766#2:161\n857#2,2:162\n766#2:164\n857#2,2:165\n1855#2,2:167\n8541#3,2:169\n8801#3,4:171\n*S KotlinDebug\n*F\n+ 1 FeaturesResource.kt\ncom/atlassian/jira/migration/features/rest/FeaturesResource\n*L\n53#1:161\n53#1:162,2\n67#1:164\n67#1:165,2\n82#1:167,2\n152#1:169,2\n152#1:171,4\n*E\n"})
public final class FeaturesResource {
    @NotNull
    private final DarkFeatureManager darkFeatureManager;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final Fx3PluginClient fx3PluginClient;

    @Inject
    public FeaturesResource(@NotNull DarkFeatureManager darkFeatureManager, @NotNull MigrationFeatures migrationFeatures, @NotNull Fx3PluginClient fx3PluginClient) {
        Intrinsics.checkNotNullParameter((Object)darkFeatureManager, (String)"darkFeatureManager");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)fx3PluginClient, (String)"fx3PluginClient");
        this.darkFeatureManager = darkFeatureManager;
        this.migrationFeatures = migrationFeatures;
        this.fx3PluginClient = fx3PluginClient;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/")
    @NotNull
    public final Response getEnabledFeatureKeys() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Set<String> darkFeatureKeys = DarkFeaturesExtensionsKt.getAllFeatureKeysEnabledForCurrentUser(this.darkFeatureManager);
        Set<String> fx3PluginFeatureIdKeys = this.fx3PluginClient.allFeatureKeysEnabledForCurrentUser();
        Set<String> fx3PluginStatsigGateKeys = this.fx3PluginClient.allFeatureGateKeysEnabledForCurrentUser();
        Set combinedFeatureKeys = SetsKt.plus((Set)SetsKt.plus(darkFeatureKeys, (Iterable)fx3PluginFeatureIdKeys), (Iterable)fx3PluginStatsigGateKeys);
        Iterable iterable = combinedFeatureKeys;
        boolean $i$f$filter = false;
        void var8_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = StringsKt.startsWith$default((String)it, (String)"com.atlassian.jira.migration", (boolean)false, (int)2, null) || this.migrationFeatures.isInIgnorePrefixList(it) || StringsKt.startsWith$default((String)it, (String)"jcma", (boolean)false, (int)2, null);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set features = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return ResponseUtils.INSTANCE.okOrNotFound(features);
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/gates")
    @NotNull
    public final Response getEnabledFeatureGateKeys() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.fx3PluginClient.allFeatureGateKeysEnabledForCurrentUser();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)"jcma", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set features = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return ResponseUtils.INSTANCE.okOrNotFound(features);
    }

    @GET
    @Path(value="/configs")
    @NotNull
    public final Response getAllDynamicConfigKeys() {
        Map<String, Object> configs = this.fx3PluginClient.allDynamicConfigsForCurrentUser();
        return ResponseUtils.INSTANCE.okOrNotFound(configs);
    }

    @POST
    @Path(value="/add-mappings")
    @NotNull
    public final Response addMappings(@NotNull AddMappingsBody body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Iterable $this$forEach$iv = body.getNames();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            StatsigMappings.INSTANCE.addMapping(it);
        }
        return ResponseUtils.INSTANCE.ok("Mappings added successfully");
    }

    @GET
    @Path(value="/fx3/refreshAll")
    @NotNull
    public final Response refreshFx3All() {
        this.fx3PluginClient.refreshAllAndNotify();
        return ResponseUtils.INSTANCE.ok("Feature Flags, Feature Gates, and Dynamic Configs Updated Successfully");
    }

    @GET
    @Deprecated(message="Use /fx3/refreshAll")
    @Path(value="/fx3/refreshFlags")
    @NotNull
    public final Response refreshFx3Flags() {
        return this.refreshFx3All();
    }

    @GET
    @Deprecated(message="Use /fx3/refreshAll")
    @Path(value="/fx3/refreshStatsig")
    @NotNull
    public final Response refreshFx3Statsig() {
        return this.refreshFx3All();
    }

    @POST
    @Path(value="/fx3/cloud/{cloudId}")
    @NotNull
    public final Response updateCloudId(@PathParam(value="cloudId") @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        this.fx3PluginClient.updateCloudId(cloudId2);
        return ResponseUtils.INSTANCE.ok("Cloud Id updated to " + cloudId2);
    }

    @POST
    @Path(value="/fx3/customattribute/{customAttributeKey}/{customAttributeValue}")
    @NotNull
    public final Response updateCustomAttributeValue(@PathParam(value="customAttributeKey") @NotNull String customAttributeKey, @PathParam(value="customAttributeValue") @NotNull String customAttributeValue) {
        Intrinsics.checkNotNullParameter((Object)customAttributeKey, (String)"customAttributeKey");
        Intrinsics.checkNotNullParameter((Object)customAttributeValue, (String)"customAttributeValue");
        this.fx3PluginClient.setUserCustomAttribute(customAttributeKey, customAttributeValue);
        return ResponseUtils.INSTANCE.ok("Custom attribute added or updated to " + customAttributeKey + " = " + customAttributeValue);
    }

    @GET
    @Path(value="/fx3/{key}")
    @NotNull
    public final Response getEnabledFx3Key(@PathParam(value="key") @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        boolean response2 = Fx3PluginClient.DefaultImpls.isEnabledForCurrentUser$default(this.fx3PluginClient, key, false, 2, null);
        return ResponseUtils.INSTANCE.okOrNotFound(response2);
    }

    @GET
    @Path(value="/fx3/gate/{key}")
    @NotNull
    public final Response getEnabledFx3GateKey(@PathParam(value="key") @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        boolean response2 = this.fx3PluginClient.isEnabledForCurrentStatsigUser(key);
        return ResponseUtils.INSTANCE.okOrNotFound(response2);
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/fx3/config/{key}")
    @NotNull
    public final Response getFx3DynamicConfigKey(@PathParam(value="key") @NotNull String key) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        StatsigDynamicConfigs[] $this$associateBy$iv = StatsigDynamicConfigs.values();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        StatsigDynamicConfigs[] statsigDynamicConfigsArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        int n = ((void)$this$associateByTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv$iv;
            void var12_11 = element$iv$iv = $this$associateByTo$iv$iv[i];
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getConfigKey(), element$iv$iv);
        }
        Map gateKeys = destination$iv$iv;
        StatsigDynamicConfigs statsigDynamicConfigs = (StatsigDynamicConfigs)((Object)gateKeys.get(key));
        Object t = statsigDynamicConfigs != null ? (Object)statsigDynamicConfigs.getValue(this.fx3PluginClient) : null;
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Any");
        Object response2 = t;
        return ResponseUtils.INSTANCE.okOrNotFound(response2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/features/rest/FeaturesResource$AddMappingsBody;", "", "names", "", "", "(Ljava/util/List;)V", "getNames", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class AddMappingsBody {
        @NotNull
        private final List<String> names;

        @org.codehaus.jackson.annotate.JsonCreator
        @JsonCreator
        public AddMappingsBody(@org.codehaus.jackson.annotate.JsonProperty(value="names") @JsonProperty(value="names") @NotNull List<String> names) {
            Intrinsics.checkNotNullParameter(names, (String)"names");
            this.names = names;
        }

        @NotNull
        public final List<String> getNames() {
            return this.names;
        }

        @NotNull
        public final List<String> component1() {
            return this.names;
        }

        @NotNull
        public final AddMappingsBody copy(@org.codehaus.jackson.annotate.JsonProperty(value="names") @JsonProperty(value="names") @NotNull List<String> names) {
            Intrinsics.checkNotNullParameter(names, (String)"names");
            return new AddMappingsBody(names);
        }

        public static /* synthetic */ AddMappingsBody copy$default(AddMappingsBody addMappingsBody, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = addMappingsBody.names;
            }
            return addMappingsBody.copy(list);
        }

        @NotNull
        public String toString() {
            return "AddMappingsBody(names=" + this.names + ')';
        }

        public int hashCode() {
            return ((Object)this.names).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AddMappingsBody)) {
                return false;
            }
            AddMappingsBody addMappingsBody = (AddMappingsBody)other;
            return Intrinsics.areEqual(this.names, addMappingsBody.names);
        }
    }
}

