/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.fx3;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.license.LicenseChangedEvent;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.fx3.Fx3ObjectMapperFactory;
import com.atlassian.jira.migration.fx3.api.Fx3PluginClient;
import com.atlassian.jira.migration.jiracloudservice.JiraCloudClient;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.migrationservice.ProductEditionDetails;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.jira.migration.serverdataextractors.AttachmentStatsDto;
import com.atlassian.jira.migration.serverdataextractors.ProjectsReader;
import com.atlassian.jira.migration.serverdataextractors.ServerDataAggregator;
import com.atlassian.jira.migration.serverdataextractors.ServerProjectDto;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.migration.api.ContainerToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u0007\u0018\u0000 12\u00020\u0001:\u0003123BO\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'H\u0007J\b\u0010(\u001a\u00020\u0016H\u0007J$\u0010)\u001a\u00020\u00162\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00010+2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J*\u0010,\u001a\u00020\u00162\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00010+2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020 0.H\u0002J\u0006\u0010/\u001a\u00020\u0016J\u000e\u00100\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/atlassian/jira/migration/fx3/Fx3Helper;", "", "fx3ObjectMapperFactory", "Lcom/atlassian/jira/migration/fx3/Fx3ObjectMapperFactory;", "fx3PluginClient", "Lcom/atlassian/jira/migration/fx3/api/Fx3PluginClient;", "serverDataAggregator", "Lcom/atlassian/jira/migration/serverdataextractors/ServerDataAggregator;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "jiraCloudClient", "Lcom/atlassian/jira/migration/jiracloudservice/JiraCloudClient;", "projectsReader", "Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "(Lcom/atlassian/jira/migration/fx3/Fx3ObjectMapperFactory;Lcom/atlassian/jira/migration/fx3/api/Fx3PluginClient;Lcom/atlassian/jira/migration/serverdataextractors/ServerDataAggregator;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/jiracloudservice/JiraCloudClient;Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;Lcom/atlassian/jira/migration/sen/SENSupplier;Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/event/api/EventPublisher;)V", "cleanup", "", "convertToDoubleForFx3", "", "count", "", "evaluateMigrationType", "Lcom/atlassian/jira/migration/fx3/Fx3Helper$MigrationType;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "fetchProductEditionDetails", "", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "fetchProductType", "Lcom/atlassian/jira/migration/fx3/Fx3Helper$ProductType;", "handleLicenseChangedEvent", "event", "Lcom/atlassian/jira/license/LicenseChangedEvent;", "init", "populatePlanCustomAttributes", "fx3UserCustomAttributesMap", "", "populateProjectCustomAttributes", "projectKeys", "", "updateFx3Config", "updateUserCustomAttributes", "Companion", "MigrationType", "ProductType", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nFx3Helper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fx3Helper.kt\ncom/atlassian/jira/migration/fx3/Fx3Helper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n766#2:179\n857#2:180\n1747#2,2:181\n1749#2:184\n858#2:185\n1603#2,9:186\n1855#2:195\n1856#2:197\n1612#2:198\n1747#2,3:199\n1855#2,2:202\n1#3:183\n1#3:196\n*S KotlinDebug\n*F\n+ 1 Fx3Helper.kt\ncom/atlassian/jira/migration/fx3/Fx3Helper\n*L\n89#1:179\n89#1:180\n90#1:181,2\n90#1:184\n89#1:185\n94#1:186,9\n94#1:195\n94#1:197\n94#1:198\n105#1:199,3\n136#1:202,2\n94#1:196\n*E\n"})
public final class Fx3Helper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Fx3ObjectMapperFactory fx3ObjectMapperFactory;
    @NotNull
    private final Fx3PluginClient fx3PluginClient;
    @NotNull
    private final ServerDataAggregator serverDataAggregator;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final JiraCloudClient jiraCloudClient;
    @NotNull
    private final ProjectsReader projectsReader;
    @NotNull
    private final SENSupplier senSupplier;
    @NotNull
    private final MigrationServiceClient migrationServiceClient;
    @NotNull
    private final EventPublisher eventPublisher;
    @NotNull
    private static final String MIGRATION_TAG = "migrationTag";
    @NotNull
    private static final String CLOUD_ID = "cloudID";
    @NotNull
    private static final String MIGRATION_TYPE = "migrationType";
    @NotNull
    private static final String EDITION = "edition";
    @NotNull
    public static final String DEFAULT_CLOUD_EDITION = "free";
    @NotNull
    private static final String APPS = "apps";
    @NotNull
    private static final String REGION = "region";
    @NotNull
    private static final String PROJECT_COUNT = "projectCount";
    @NotNull
    private static final String MAX_ISSUE_COUNT = "maxIssueCount";
    @NotNull
    private static final String TOTAL_ATTACHMENT_SIZE = "totalAttachmentSize";
    @NotNull
    private static final String PRODUCT_TYPE = "productType";
    @NotNull
    private static final String IS_ENTERPRISE_SERVER = "isEnterpriseServer";
    @NotNull
    private static final String PRODUCT_EDITION = "productEdition";
    @NotNull
    private static final String IS_SHADOW = "isShadow";
    @NotNull
    private static final Set<String> JIRA_PRODUCTS;
    private static final Logger log;

    @Inject
    public Fx3Helper(@NotNull Fx3ObjectMapperFactory fx3ObjectMapperFactory, @NotNull Fx3PluginClient fx3PluginClient, @NotNull ServerDataAggregator serverDataAggregator, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull JiraCloudClient jiraCloudClient, @NotNull ProjectsReader projectsReader, @NotNull SENSupplier senSupplier, @NotNull MigrationServiceClient migrationServiceClient, @NotNull EventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)fx3ObjectMapperFactory, (String)"fx3ObjectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)fx3PluginClient, (String)"fx3PluginClient");
        Intrinsics.checkNotNullParameter((Object)serverDataAggregator, (String)"serverDataAggregator");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)jiraCloudClient, (String)"jiraCloudClient");
        Intrinsics.checkNotNullParameter((Object)projectsReader, (String)"projectsReader");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        this.fx3ObjectMapperFactory = fx3ObjectMapperFactory;
        this.fx3PluginClient = fx3PluginClient;
        this.serverDataAggregator = serverDataAggregator;
        this.cloudSiteRepository = cloudSiteRepository;
        this.jiraCloudClient = jiraCloudClient;
        this.projectsReader = projectsReader;
        this.senSupplier = senSupplier;
        this.migrationServiceClient = migrationServiceClient;
        this.eventPublisher = eventPublisher;
    }

    public final void updateUserCustomAttributes(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        Map<String, Object> fx3UserCustomAttributesMap = this.fx3ObjectMapperFactory.createUserGlobalCustomAttributesMap();
        this.populatePlanCustomAttributes(fx3UserCustomAttributesMap, plan2);
        this.fx3PluginClient.updateUserCustomAttributes(fx3UserCustomAttributesMap);
    }

    public final void updateFx3Config() {
        this.fx3PluginClient.upsertConfig(this.fx3ObjectMapperFactory.createFx3Config());
    }

    @PostConstruct
    public final void init() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public final void cleanup() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public final void handleLicenseChangedEvent(@NotNull LicenseChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Map<String, Object> fx3UserCustomAttributesMap = this.fx3ObjectMapperFactory.createUserGlobalCustomAttributesMap();
        this.fx3PluginClient.updateUserCustomAttributes(fx3UserCustomAttributesMap);
    }

    private final void populatePlanCustomAttributes(Map<String, Object> fx3UserCustomAttributesMap, Plan plan2) {
        CloudSite cloudSite2;
        CloudSite cloudSite3 = cloudSite2 = this.cloudSiteRepository.getSite(plan2.getCloudId());
        ContainerToken containerToken = new ContainerToken(cloudSite3 != null ? cloudSite3.getContainerToken() : null);
        fx3UserCustomAttributesMap.put(MIGRATION_TAG, String.valueOf((Object)plan2.getMigrationTag()));
        fx3UserCustomAttributesMap.put(CLOUD_ID, plan2.getCloudId());
        fx3UserCustomAttributesMap.put(MIGRATION_TYPE, this.evaluateMigrationType(plan2).toString());
        Map<String, Object> map = fx3UserCustomAttributesMap;
        String string = EDITION;
        Object object = cloudSite2;
        if (object == null || (object = object.getCloudEdition()) == null) {
            object = DEFAULT_CLOUD_EDITION;
        }
        Object object2 = object;
        map.put(string, object2);
        fx3UserCustomAttributesMap.put(APPS, String.valueOf(plan2.getAppsMigrationOption().getIncludedApps()));
        map = fx3UserCustomAttributesMap;
        string = REGION;
        String string2 = plan2.getCloudRegion();
        if (string2 == null) {
            string2 = this.jiraCloudClient.getTenantInformation(containerToken, plan2.getCloudId()).getRegion();
        }
        object2 = string2;
        map.put(string, object2);
        fx3UserCustomAttributesMap.put(PRODUCT_TYPE, this.fetchProductType(plan2).toString());
        fx3UserCustomAttributesMap.put(IS_ENTERPRISE_SERVER, String.valueOf(this.senSupplier.isEnterprise()));
        fx3UserCustomAttributesMap.put(PRODUCT_EDITION, this.fetchProductEditionDetails(cloudSite2));
        fx3UserCustomAttributesMap.put(IS_SHADOW, String.valueOf(plan2.isShadowPlan()));
        this.populateProjectCustomAttributes(fx3UserCustomAttributesMap, plan2.getProjectKeys());
    }

    /*
     * WARNING - void declaration
     */
    private final String fetchProductEditionDetails(CloudSite cloudSite2) {
        String string;
        try {
            Set set;
            CloudSite cloudSite3 = cloudSite2;
            Intrinsics.checkNotNull((Object)cloudSite3);
            Object object = this.migrationServiceClient.fetchProductEditionDetails(cloudSite3.getContainerToken()).getData();
            if (object != null && (object = ((ProductEditionDetails.Data)object).getEssotEntitlement()) != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = (Iterable)object;
                boolean $i$f$filter22 = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    block11: {
                        ProductEditionDetails.Entitlement entitlement = (ProductEditionDetails.Entitlement)element$iv$iv;
                        boolean bl2 = false;
                        Iterable $this$any$iv = JIRA_PRODUCTS;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                boolean bl3;
                                String product = (String)element$iv;
                                boolean bl4 = false;
                                Object object2 = entitlement.getProductCatalogItem();
                                if (object2 != null && (object2 = ((ProductEditionDetails.ProductCatalogItem)object2).getName()) != null) {
                                    Object it = object2;
                                    boolean bl5 = false;
                                    bl3 = new Regex(product).containsMatchIn((CharSequence)it);
                                } else {
                                    bl3 = false;
                                }
                                if (!bl3) continue;
                                bl = true;
                                break block11;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $i$f$filter22 = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                destination$iv$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    ProductEditionDetails.Entitlement entitlement = (ProductEditionDetails.Entitlement)element$iv$iv;
                    boolean bl6 = false;
                    if (entitlement.getEdition() == null) continue;
                    boolean bl7 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            } else {
                set = null;
            }
            String productEditionList = String.valueOf(set);
            log.info("Fetched Product edition details from Hydra " + productEditionList);
        }
        catch (Exception e) {
            log.error("Error Occurred while fetching product edition details from Hydra " + e);
            string = DEFAULT_CLOUD_EDITION;
        }
        return string;
    }

    private final ProductType fetchProductType(Plan plan2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = plan2.getProjectKeys();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    ProjectTypeKey projectTypeKey = this.projectsReader.getProject(it).getProjectTypeKey();
                    if (!Intrinsics.areEqual((Object)(projectTypeKey != null ? projectTypeKey.getKey() : null), (Object)"service_desk")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl ? ProductType.JIRA_JSM : ProductType.JIRA;
    }

    private final MigrationType evaluateMigrationType(Plan plan2) {
        return plan2.isUsersOnly() ? MigrationType.USERS_AND_GROUPS_ONLY : (plan2.isLegacyAttachmentsOnly() || plan2.isV2AttachmentsOnly() ? MigrationType.ATTACHMENTS_ONLY : (plan2.isAppDataPreload() ? MigrationType.APP_DATA_PRELOAD : MigrationType.OTHER));
    }

    private final void populateProjectCustomAttributes(Map<String, Object> fx3UserCustomAttributesMap, List<String> projectKeys) {
        long maxIssueCount = 0L;
        AttachmentStatsDto attachmentStats = new AttachmentStatsDto(0L, 0L);
        Iterable $this$forEach$iv = this.serverDataAggregator.getProjects(projectKeys);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerProjectDto it = (ServerProjectDto)element$iv;
            boolean bl = false;
            it.getAttachments().plus(attachmentStats);
            maxIssueCount = Long.max(it.getTotalIssues(), maxIssueCount);
        }
        fx3UserCustomAttributesMap.put(MAX_ISSUE_COUNT, this.convertToDoubleForFx3(maxIssueCount));
        fx3UserCustomAttributesMap.put(TOTAL_ATTACHMENT_SIZE, this.convertToDoubleForFx3(attachmentStats.getTotalSizeBytes()));
        fx3UserCustomAttributesMap.put(PROJECT_COUNT, this.convertToDoubleForFx3(((Collection)projectKeys).size()));
    }

    private final double convertToDoubleForFx3(long count2) {
        return count2;
    }

    static {
        Object[] objectArray = new String[]{"Jira Service Management", "Jira", "Jira Work Management"};
        JIRA_PRODUCTS = SetsKt.setOf((Object[])objectArray);
        log = LoggerFactory.getLogger(Fx3Helper.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/fx3/Fx3Helper$Companion;", "", "()V", "APPS", "", "CLOUD_ID", "DEFAULT_CLOUD_EDITION", "EDITION", "IS_ENTERPRISE_SERVER", "IS_SHADOW", "JIRA_PRODUCTS", "", "MAX_ISSUE_COUNT", "MIGRATION_TAG", "MIGRATION_TYPE", "PRODUCT_EDITION", "PRODUCT_TYPE", "PROJECT_COUNT", "REGION", "TOTAL_ATTACHMENT_SIZE", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/fx3/Fx3Helper$MigrationType;", "", "(Ljava/lang/String;I)V", "USERS_AND_GROUPS_ONLY", "ATTACHMENTS_ONLY", "APP_DATA_PRELOAD", "OTHER", "jira-migration-plugin"})
    public static final class MigrationType
    extends Enum<MigrationType> {
        public static final /* enum */ MigrationType USERS_AND_GROUPS_ONLY = new MigrationType();
        public static final /* enum */ MigrationType ATTACHMENTS_ONLY = new MigrationType();
        public static final /* enum */ MigrationType APP_DATA_PRELOAD = new MigrationType();
        public static final /* enum */ MigrationType OTHER = new MigrationType();
        private static final /* synthetic */ MigrationType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MigrationType[] values() {
            return (MigrationType[])$VALUES.clone();
        }

        public static MigrationType valueOf(String value) {
            return Enum.valueOf(MigrationType.class, value);
        }

        @NotNull
        public static EnumEntries<MigrationType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = migrationTypeArray = new MigrationType[]{MigrationType.USERS_AND_GROUPS_ONLY, MigrationType.ATTACHMENTS_ONLY, MigrationType.APP_DATA_PRELOAD, MigrationType.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/fx3/Fx3Helper$ProductType;", "", "(Ljava/lang/String;I)V", "JIRA", "JIRA_JSM", "jira-migration-plugin"})
    public static final class ProductType
    extends Enum<ProductType> {
        public static final /* enum */ ProductType JIRA = new ProductType();
        public static final /* enum */ ProductType JIRA_JSM = new ProductType();
        private static final /* synthetic */ ProductType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ProductType[] values() {
            return (ProductType[])$VALUES.clone();
        }

        public static ProductType valueOf(String value) {
            return Enum.valueOf(ProductType.class, value);
        }

        @NotNull
        public static EnumEntries<ProductType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = productTypeArray = new ProductType[]{ProductType.JIRA, ProductType.JIRA_JSM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

