/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.fx3;

import com.atlassian.fx3.httpclient.HttpCallback;
import com.atlassian.fx3.setup.Fx3Config;
import com.atlassian.fx3.statsig.StatsigIdentifierType;
import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.db.InstallProductSchemaProviderHack;
import com.atlassian.jira.migration.httpclient.AbstractPluginHttpClient;
import com.atlassian.jira.migration.httpclient.Fx3HttpClient;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpRequest;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.jira.migration.serverdataextractors.JiraServerStatsReader;
import com.atlassian.jira.migration.version.JiraMigrationVersionService;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.message.BasicHeader;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B/\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u001eJ\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u001eR\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/fx3/Fx3ObjectMapperFactory;", "", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "jiraMigrationVersionService", "Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;", "migrationServicesConfiguration", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "jiraServerStatsReader", "Lcom/atlassian/jira/migration/serverdataextractors/JiraServerStatsReader;", "installProductSchemaProviderHack", "Lcom/atlassian/jira/migration/db/InstallProductSchemaProviderHack;", "(Lcom/atlassian/jira/migration/sen/SENSupplier;Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/serverdataextractors/JiraServerStatsReader;Lcom/atlassian/jira/migration/db/InstallProductSchemaProviderHack;)V", "fx3PluginHttpClient", "Lcom/atlassian/jira/migration/httpclient/Fx3HttpClient;", "configuration", "(Lcom/atlassian/jira/migration/sen/SENSupplier;Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;Lcom/atlassian/jira/migration/httpclient/Fx3HttpClient;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/serverdataextractors/JiraServerStatsReader;Lcom/atlassian/jira/migration/db/InstallProductSchemaProviderHack;)V", "convertLongForFx3", "", "count", "", "createDefaultStatsigIdentifiers", "", "Lcom/atlassian/fx3/statsig/StatsigIdentifierType;", "", "createFx3Config", "Lcom/atlassian/fx3/setup/Fx3Config;", "createFx3HttpCallback", "Lcom/atlassian/fx3/httpclient/HttpCallback;", "createFx3UserObject", "", "createUserGlobalCustomAttributesMap", "Companion", "jira-migration-plugin"})
public final class Fx3ObjectMapperFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SENSupplier senSupplier;
    @NotNull
    private final JiraMigrationVersionService jiraMigrationVersionService;
    @NotNull
    private final Fx3HttpClient fx3PluginHttpClient;
    @NotNull
    private final MigrationServicesConfiguration configuration;
    @NotNull
    private final JiraServerStatsReader jiraServerStatsReader;
    @NotNull
    private final InstallProductSchemaProviderHack installProductSchemaProviderHack;
    @NotNull
    public static final String JCMA_VERSION = "jcmaVersion";
    @NotNull
    public static final String SEN_ID = "senId";
    @NotNull
    public static final String CLOUD_ID = "cloudID";
    @NotNull
    public static final String JIRA_VERSION = "jiraVersion";
    @NotNull
    public static final String SERVER_PROJECT_COUNT = "serverProjectCount";
    @NotNull
    public static final String SERVER_ISSUE_COUNT = "serverIssueCount";
    @NotNull
    public static final String SERVER_USER_COUNT = "serverUserCount";
    @NotNull
    public static final String AGGREGATED_LICENSE_MAX_USERS_COUNT = "aggregatedLicenseMaxUsersCount";

    public Fx3ObjectMapperFactory(@NotNull SENSupplier senSupplier, @NotNull JiraMigrationVersionService jiraMigrationVersionService, @NotNull Fx3HttpClient fx3PluginHttpClient, @NotNull MigrationServicesConfiguration configuration, @NotNull JiraServerStatsReader jiraServerStatsReader, @NotNull InstallProductSchemaProviderHack installProductSchemaProviderHack) {
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        Intrinsics.checkNotNullParameter((Object)jiraMigrationVersionService, (String)"jiraMigrationVersionService");
        Intrinsics.checkNotNullParameter((Object)fx3PluginHttpClient, (String)"fx3PluginHttpClient");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)jiraServerStatsReader, (String)"jiraServerStatsReader");
        Intrinsics.checkNotNullParameter((Object)installProductSchemaProviderHack, (String)"installProductSchemaProviderHack");
        this.senSupplier = senSupplier;
        this.jiraMigrationVersionService = jiraMigrationVersionService;
        this.fx3PluginHttpClient = fx3PluginHttpClient;
        this.configuration = configuration;
        this.jiraServerStatsReader = jiraServerStatsReader;
        this.installProductSchemaProviderHack = installProductSchemaProviderHack;
    }

    @Inject
    public Fx3ObjectMapperFactory(@NotNull SENSupplier senSupplier, @NotNull JiraMigrationVersionService jiraMigrationVersionService, @NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull JiraServerStatsReader jiraServerStatsReader, @NotNull InstallProductSchemaProviderHack installProductSchemaProviderHack) {
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        Intrinsics.checkNotNullParameter((Object)jiraMigrationVersionService, (String)"jiraMigrationVersionService");
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)jiraServerStatsReader, (String)"jiraServerStatsReader");
        Intrinsics.checkNotNullParameter((Object)installProductSchemaProviderHack, (String)"installProductSchemaProviderHack");
        Gson gson = new GsonBuilder().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        this(senSupplier, jiraMigrationVersionService, new Fx3HttpClient(gson), migrationServicesConfiguration, jiraServerStatsReader, installProductSchemaProviderHack);
    }

    @NotNull
    public final Fx3Config createFx3Config() {
        return new Fx3Config(this.configuration.getFx3ServiceBaseURI(), this.configuration.getFx3ServiceAPIKey(), this.configuration.getFx3StatsigAPIKey(), this.configuration.getFx3StatsigTargetApp());
    }

    @NotNull
    public final Map<String, Object> createFx3UserObject() {
        this.installProductSchemaProviderHack.install();
        return this.createUserGlobalCustomAttributesMap();
    }

    @NotNull
    public final Map<String, Object> createUserGlobalCustomAttributesMap() {
        double totalProjects = this.convertLongForFx3(this.jiraServerStatsReader.calculateNumberOfProjects());
        double totalIssues = this.convertLongForFx3(this.jiraServerStatsReader.calculateNumberOfIssues());
        double totalUsers = this.convertLongForFx3(JiraServerStatsReader.getAllUsersCount$default(this.jiraServerStatsReader, null, 1, null));
        double aggregatedLicenseMaxUsersCount = this.convertLongForFx3(this.senSupplier.getMaxNumberOfUsersFromLicenses());
        Pair[] pairArray = new Pair[8];
        pairArray[0] = TuplesKt.to((Object)JCMA_VERSION, (Object)this.jiraMigrationVersionService.getPluginVersion());
        String string = this.senSupplier.getFirstSen();
        if (string == null) {
            string = "";
        }
        pairArray[1] = TuplesKt.to((Object)SEN_ID, (Object)string);
        pairArray[2] = TuplesKt.to((Object)CLOUD_ID, (Object)"dummy-cloud");
        pairArray[3] = TuplesKt.to((Object)JIRA_VERSION, (Object)this.jiraMigrationVersionService.getJiraServerVersion());
        pairArray[4] = TuplesKt.to((Object)SERVER_PROJECT_COUNT, (Object)totalProjects);
        pairArray[5] = TuplesKt.to((Object)SERVER_ISSUE_COUNT, (Object)totalIssues);
        pairArray[6] = TuplesKt.to((Object)SERVER_USER_COUNT, (Object)totalUsers);
        pairArray[7] = TuplesKt.to((Object)AGGREGATED_LICENSE_MAX_USERS_COUNT, (Object)aggregatedLicenseMaxUsersCount);
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @NotNull
    public final Map<StatsigIdentifierType, String> createDefaultStatsigIdentifiers() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)StatsigIdentifierType.TENANT_ID, (Object)"defaultTenantId"));
    }

    private final double convertLongForFx3(long count2) {
        return count2;
    }

    @NotNull
    public final HttpCallback createFx3HttpCallback() {
        return new HttpCallback(this){
            final /* synthetic */ Fx3ObjectMapperFactory this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public Pair<Integer, String> post(@NotNull URL path, @NotNull Map<String, ? extends List<String>> headers, @NotNull String body) {
                void $this$mapTo$iv$iv;
                void $this$map$iv22;
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter(headers, (String)"headers");
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                Object object = SetsKt.setOf((Object)200);
                Object object2 = path.toURI();
                Map<String, ? extends List<String>> map = headers;
                Object object3 = Fx3ObjectMapperFactory.access$getFx3PluginHttpClient$p(this.this$0);
                boolean $i$f$map = false;
                void var10_10 = $this$map$iv22;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv22.size());
                boolean $i$f$mapTo = false;
                Iterator<Map.Entry<K, V>> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String key = (String)entry.getKey();
                    List value = (List)entry.getValue();
                    collection.add(new BasicHeader(key, (String)CollectionsKt.first((List)value)));
                }
                Object object4 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                Intrinsics.checkNotNull((Object)object2);
                CloseableHttpResponse response2 = ((AbstractPluginHttpClient)object3).getResponse(new MigrationPluginHttpRequest("POST", (URI)object2, (Set<Integer>)object, body, (List<Header>)object4, "application/json"));
                Integer n = response2.getStatusLine().getStatusCode();
                InputStream inputStream = response2.getEntity().getContent();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getContent(...)");
                object = inputStream;
                object2 = Charsets.UTF_8;
                object4 = new InputStreamReader((InputStream)object, (Charset)object2);
                int $this$map$iv22 = 8192;
                object = object4 instanceof BufferedReader ? (BufferedReader)object4 : new BufferedReader((Reader)object4, $this$map$iv22);
                object3 = n;
                object2 = null;
                try {
                    BufferedReader p0 = (BufferedReader)object;
                    boolean bl = false;
                    object4 = TextStreamsKt.readText((Reader)p0);
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
                return TuplesKt.to((Object)object3, (Object)object4);
            }
        };
    }

    public static final /* synthetic */ Fx3HttpClient access$getFx3PluginHttpClient$p(Fx3ObjectMapperFactory $this) {
        return $this.fx3PluginHttpClient;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0016\u0010\u0006\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u0016\u0010\b\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002R\u0016\u0010\n\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002R\u0016\u0010\f\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0002R\u0016\u0010\u000e\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0002R\u0016\u0010\u0010\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u0002R\u0016\u0010\u0012\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u0002\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/fx3/Fx3ObjectMapperFactory$Companion;", "", "()V", "AGGREGATED_LICENSE_MAX_USERS_COUNT", "", "getAGGREGATED_LICENSE_MAX_USERS_COUNT$annotations", "CLOUD_ID", "getCLOUD_ID$annotations", "JCMA_VERSION", "getJCMA_VERSION$annotations", "JIRA_VERSION", "getJIRA_VERSION$annotations", "SEN_ID", "getSEN_ID$annotations", "SERVER_ISSUE_COUNT", "getSERVER_ISSUE_COUNT$annotations", "SERVER_PROJECT_COUNT", "getSERVER_PROJECT_COUNT$annotations", "SERVER_USER_COUNT", "getSERVER_USER_COUNT$annotations", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getJCMA_VERSION$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getSEN_ID$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getCLOUD_ID$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getJIRA_VERSION$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getSERVER_PROJECT_COUNT$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getSERVER_ISSUE_COUNT$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getSERVER_USER_COUNT$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getAGGREGATED_LICENSE_MAX_USERS_COUNT$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

