/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.fx3;

import com.atlassian.fx3.Fx3Client;
import com.atlassian.fx3.evaluation.BooleanKey;
import com.atlassian.fx3.evaluation.ErrorKind;
import com.atlassian.fx3.evaluation.EvaluationReason;
import com.atlassian.fx3.evaluation.FeatureFlagKey;
import com.atlassian.fx3.evaluation.FeatureFlagValue;
import com.atlassian.fx3.setup.Fx3Config;
import com.atlassian.jira.migration.features.StatsigFx3Gates;
import com.atlassian.jira.migration.fx3.Fx3ObjectMapperFactory;
import com.atlassian.jira.migration.fx3.Fx3PluginClientImplKt;
import com.atlassian.jira.migration.fx3.Fx3State;
import com.atlassian.jira.migration.fx3.Fx3StateRepository;
import com.atlassian.jira.migration.fx3.api.Fx3PluginClient;
import com.atlassian.jira.migration.fx3.util.StatsigMappings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.prometheus.metrics.core.datapoints.GaugeDataPoint;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 T2\u00020\u0001:\u0001TB\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0016\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00150(H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0*H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0*H\u0016J\b\u0010,\u001a\u00020-H\u0007J\u0018\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\u001cH\u0016J\u0018\u00101\u001a\u0002022\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u000202H\u0016J$\u00103\u001a\b\u0012\u0004\u0012\u000202042\u0006\u0010/\u001a\u00020\f2\f\u00100\u001a\b\u0012\u0004\u0012\u00020204H\u0016J\u0018\u00105\u001a\u00020\f2\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\fH\u0016J$\u00106\u001a\b\u0012\u0004\u0012\u00020\f042\u0006\u0010/\u001a\u00020\f2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\f04H\u0016J\u0010\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\fH\u0016J\u0018\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020\f2\u0006\u00100\u001a\u00020\u001cH\u0017J\b\u0010;\u001a\u00020-H\u0002J\b\u0010<\u001a\u00020-H\u0002J\b\u0010=\u001a\u00020-H\u0016J\u0006\u0010>\u001a\u00020-J\b\u0010?\u001a\u00020-H\u0002J\b\u0010@\u001a\u00020-H\u0002J-\u0010A\u001a\u0002HB\"\b\b\u0000\u0010B*\u00020\u00152\f\u0010C\u001a\b\u0012\u0004\u0012\u0002HB0D2\u0006\u00100\u001a\u0002HBH\u0002\u00a2\u0006\u0002\u0010EJ\u001a\u0010F\u001a\u0004\u0018\u00010\u00152\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\u0015H\u0002J\u0010\u0010G\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\fH\u0002J\u0018\u0010H\u001a\u00020-2\u0006\u0010I\u001a\u00020\f2\u0006\u0010J\u001a\u00020\u0015H\u0016J\n\u0010K\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010L\u001a\u00020-2\u0006\u0010M\u001a\u00020\fH\u0016J\u001c\u0010N\u001a\u00020-2\u0012\u0010O\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00150(H\u0016J\u0010\u0010P\u001a\u00020-2\u0006\u0010Q\u001a\u00020RH\u0016J\u0006\u0010S\u001a\u00020-R$\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R0\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00150\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0016\u0010\u000e\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010 \u001a\u00020!8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\"\u0010\u000e\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006U"}, d2={"Lcom/atlassian/jira/migration/fx3/Fx3PluginClientImpl;", "Lcom/atlassian/jira/migration/fx3/api/Fx3PluginClient;", "fx3ObjectMapperFactory", "Lcom/atlassian/jira/migration/fx3/Fx3ObjectMapperFactory;", "fx3StateRepository", "Lcom/atlassian/jira/migration/fx3/Fx3StateRepository;", "(Lcom/atlassian/jira/migration/fx3/Fx3ObjectMapperFactory;Lcom/atlassian/jira/migration/fx3/Fx3StateRepository;)V", "fx3ClientProvider", "Lkotlin/Function0;", "Lcom/atlassian/fx3/Fx3Client;", "(Lkotlin/jvm/functions/Function0;Lcom/atlassian/jira/migration/fx3/Fx3StateRepository;)V", "currentCloudId", "", "getCurrentCloudId$annotations", "()V", "getCurrentCloudId", "()Ljava/lang/String;", "setCurrentCloudId", "(Ljava/lang/String;)V", "currentFx3UserCustomAttributes", "", "", "getCurrentFx3UserCustomAttributes$annotations", "getCurrentFx3UserCustomAttributes", "()Ljava/util/Map;", "setCurrentFx3UserCustomAttributes", "(Ljava/util/Map;)V", "destroyed", "", "fx3Client", "fx3ClientFuture", "Ljava/util/concurrent/CompletableFuture;", "lastUpdatedTime", "", "getLastUpdatedTime$annotations", "getLastUpdatedTime", "()J", "setLastUpdatedTime", "(J)V", "allDynamicConfigsForCurrentUser", "", "allFeatureGateKeysEnabledForCurrentUser", "", "allFeatureKeysEnabledForCurrentUser", "cleanUp", "", "getBooleanConfigForCurrentStatsigUser", "configKey", "default", "getNumberConfigForCurrentStatsigUser", "", "getNumberListConfigForCurrentStatsigUser", "", "getStringConfigForCurrentStatsigUser", "getStringListConfigForCurrentStatsigUser", "isEnabledForCurrentStatsigUser", "gateKey", "isEnabledForCurrentUser", "flagKey", "notifyFx3AttributesChanged", "refreshAll", "refreshAllAndNotify", "refreshAllIfRequired", "refreshFx3Flags", "refreshFx3Statsig", "returnFFValueForCurrentUser", "T", "featureFlagKey", "Lcom/atlassian/fx3/evaluation/FeatureFlagKey;", "(Lcom/atlassian/fx3/evaluation/FeatureFlagKey;Ljava/lang/Object;)Ljava/lang/Object;", "returnStatsigDynamicConfigValueForCurrentUser", "returnStatsigFeatureGateValueForCurrentUser", "setUserCustomAttribute", "key", "value", "tryGetFx3Client", "updateCloudId", "cloudId", "updateUserCustomAttributes", "customAttributes", "upsertConfig", "fx3Config", "Lcom/atlassian/fx3/setup/Fx3Config;", "waitForInitialization", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nFx3PluginClientImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fx3PluginClientImpl.kt\ncom/atlassian/jira/migration/fx3/Fx3PluginClientImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,357:1\n1603#2,9:358\n1855#2:367\n1856#2:369\n1612#2:370\n1603#2,9:371\n1855#2:380\n1856#2:382\n1612#2:383\n1855#2,2:384\n1603#2,9:386\n1855#2:395\n1856#2:397\n1612#2:398\n1855#2,2:399\n1603#2,9:401\n1855#2:410\n1856#2:412\n1612#2:413\n1#3:368\n1#3:381\n1#3:396\n1#3:411\n13309#4,2:414\n*S KotlinDebug\n*F\n+ 1 Fx3PluginClientImpl.kt\ncom/atlassian/jira/migration/fx3/Fx3PluginClientImpl\n*L\n121#1:358,9\n121#1:367\n121#1:369\n121#1:370\n130#1:371,9\n130#1:380\n130#1:382\n130#1:383\n170#1:384,2\n179#1:386,9\n179#1:395\n179#1:397\n179#1:398\n183#1:399,2\n192#1:401,9\n192#1:410\n192#1:412\n192#1:413\n121#1:368\n130#1:381\n179#1:396\n192#1:411\n208#1:414,2\n*E\n"})
public final class Fx3PluginClientImpl
implements Fx3PluginClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Fx3Client> fx3ClientProvider;
    @NotNull
    private final Fx3StateRepository fx3StateRepository;
    @NotNull
    private Map<String, Object> currentFx3UserCustomAttributes;
    @NotNull
    private String currentCloudId;
    private long lastUpdatedTime;
    @Nullable
    private volatile Fx3Client fx3Client;
    @Nullable
    private CompletableFuture<Fx3Client> fx3ClientFuture;
    private boolean destroyed;
    private static final Logger log = LoggerFactory.getLogger(Fx3PluginClientImpl.class);

    public Fx3PluginClientImpl(@NotNull Function0<Fx3Client> fx3ClientProvider, @NotNull Fx3StateRepository fx3StateRepository) {
        Intrinsics.checkNotNullParameter(fx3ClientProvider, (String)"fx3ClientProvider");
        Intrinsics.checkNotNullParameter((Object)fx3StateRepository, (String)"fx3StateRepository");
        this.fx3ClientProvider = fx3ClientProvider;
        this.fx3StateRepository = fx3StateRepository;
        this.currentFx3UserCustomAttributes = new LinkedHashMap();
        this.currentCloudId = "dummy-cloud";
    }

    @NotNull
    public final Map<String, Object> getCurrentFx3UserCustomAttributes() {
        return this.currentFx3UserCustomAttributes;
    }

    public final void setCurrentFx3UserCustomAttributes(@NotNull Map<String, Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.currentFx3UserCustomAttributes = map;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCurrentFx3UserCustomAttributes$annotations() {
    }

    @NotNull
    public final String getCurrentCloudId() {
        return this.currentCloudId;
    }

    public final void setCurrentCloudId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.currentCloudId = string;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCurrentCloudId$annotations() {
    }

    public final long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final void setLastUpdatedTime(long l) {
        this.lastUpdatedTime = l;
    }

    @VisibleForTesting
    public static /* synthetic */ void getLastUpdatedTime$annotations() {
    }

    @Inject
    public Fx3PluginClientImpl(final @NotNull Fx3ObjectMapperFactory fx3ObjectMapperFactory, @NotNull Fx3StateRepository fx3StateRepository) {
        Intrinsics.checkNotNullParameter((Object)fx3ObjectMapperFactory, (String)"fx3ObjectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)fx3StateRepository, (String)"fx3StateRepository");
        this((Function0<Fx3Client>)((Function0)new Function0<Fx3Client>(){

            @NotNull
            public final Fx3Client invoke() {
                return Fx3Client.Companion.init(fx3ObjectMapperFactory.createFx3Config(), fx3ObjectMapperFactory.createFx3UserObject(), fx3ObjectMapperFactory.createFx3HttpCallback(), fx3ObjectMapperFactory.createDefaultStatsigIdentifiers());
            }
        }), fx3StateRepository);
        this.currentFx3UserCustomAttributes = fx3ObjectMapperFactory.createFx3UserObject();
    }

    @Override
    public void updateCloudId(@NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        this.currentCloudId = cloudId2;
        Fx3Client fx3Client = this.tryGetFx3Client();
        if (fx3Client == null) {
            throw new RuntimeException("Failed to updateCloudId for fx3Client. cloudId = " + cloudId2);
        }
        Fx3Client client = fx3Client;
        client.updateUserIdentifier(cloudId2);
        this.notifyFx3AttributesChanged();
    }

    @Override
    @Deprecated(message="LaunchDarkly has been deprecated. All flags must be migrated to Statsig.")
    public boolean isEnabledForCurrentUser(@NotNull String flagKey, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)flagKey, (String)"flagKey");
        this.refreshAllIfRequired();
        Boolean bl2 = this.returnFFValueForCurrentUser((FeatureFlagKey)new BooleanKey(flagKey, null, 2, null), bl);
        boolean it = bl2;
        boolean bl3 = false;
        String[] stringArray = new String[]{flagKey};
        ((GaugeDataPoint)Fx3PluginClientImplKt.access$getLaunchDarklyFeatureFlagState$p().labelValues(stringArray)).set(it ? 1.0 : 0.0);
        return bl2;
    }

    @Override
    public boolean isEnabledForCurrentStatsigUser(@NotNull String gateKey) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)gateKey, (String)"gateKey");
        this.refreshAllIfRequired();
        boolean it = bl = this.returnStatsigFeatureGateValueForCurrentUser(gateKey);
        boolean bl2 = false;
        String[] stringArray = new String[]{gateKey};
        ((GaugeDataPoint)Fx3PluginClientImplKt.access$getStatSigGateState$p().labelValues(stringArray)).set(it ? 1.0 : 0.0);
        return bl;
    }

    @Override
    public boolean getBooleanConfigForCurrentStatsigUser(@NotNull String configKey, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
        Object object = this.returnStatsigDynamicConfigValueForCurrentUser(configKey, bl);
        Boolean bl2 = object instanceof Boolean ? (Boolean)object : null;
        boolean res = bl2 != null ? bl2 : bl;
        String[] stringArray = new String[]{configKey};
        ((GaugeDataPoint)Fx3PluginClientImplKt.access$getStatSigGateState$p().labelValues(stringArray)).set(res ? 1.0 : 0.0);
        return res;
    }

    @Override
    public double getNumberConfigForCurrentStatsigUser(@NotNull String configKey, double d) {
        Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
        Object object = this.returnStatsigDynamicConfigValueForCurrentUser(configKey, d);
        Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
        return number != null ? number.doubleValue() : d;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Double> getNumberListConfigForCurrentStatsigUser(@NotNull String configKey, @NotNull List<Double> list) {
        List list2;
        List list3;
        Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
        Intrinsics.checkNotNullParameter(list, (String)"default");
        Object object = this.returnStatsigDynamicConfigValueForCurrentUser(configKey, list);
        List list4 = list3 = object instanceof List ? (List)object : null;
        if (list3 != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = list3;
            boolean $i$f$mapNotNull = false;
            void var7_7 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Double it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Object it = element$iv$iv;
                boolean bl2 = false;
                Number number = it instanceof Number ? (Number)((Number)it) : (Number)null;
                if ((number != null ? Double.valueOf(number.doubleValue()) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list;
        }
        return list2;
    }

    @Override
    @NotNull
    public String getStringConfigForCurrentStatsigUser(@NotNull String configKey, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
        Intrinsics.checkNotNullParameter((Object)string, (String)"default");
        Object object = this.returnStatsigDynamicConfigValueForCurrentUser(configKey, string);
        String string2 = object instanceof String ? (String)object : null;
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getStringListConfigForCurrentStatsigUser(@NotNull String configKey, @NotNull List<String> list) {
        List list2;
        List list3;
        Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
        Intrinsics.checkNotNullParameter(list, (String)"default");
        Object object = this.returnStatsigDynamicConfigValueForCurrentUser(configKey, list);
        List list4 = list3 = object instanceof List ? (List)object : null;
        if (list3 != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = list3;
            boolean $i$f$mapNotNull = false;
            void var7_7 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Object it = element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof String ? (String)it : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list;
        }
        return list2;
    }

    private final boolean returnStatsigFeatureGateValueForCurrentUser(String gateKey) {
        try {
            Object object = this.tryGetFx3Client();
            return object != null && (object = object.getGateFromStatsig(gateKey)) != null && (object = object.getValue()) != null ? (Boolean)object : false;
        }
        catch (Exception ex) {
            log.error("Failed to fetch the gate: [" + gateKey + "}] with " + ex);
            return false;
        }
    }

    private final Object returnStatsigDynamicConfigValueForCurrentUser(String configKey, Object object) {
        try {
            Fx3Client fx3Client = this.tryGetFx3Client();
            return fx3Client != null && (fx3Client = fx3Client.getConfigFromStatsig(configKey)) != null && (fx3Client = fx3Client.getValue()) != null ? fx3Client.getValue() : null;
        }
        catch (Exception ex) {
            log.error("Failed to fetch the config: [" + configKey + "}] with " + ex);
            return object;
        }
    }

    private final <T> T returnFFValueForCurrentUser(FeatureFlagKey<T> featureFlagKey, T t) {
        T t2;
        try {
            Object object;
            Fx3Client fx3Client = this.tryGetFx3Client();
            if (fx3Client == null) {
                return t;
            }
            Fx3Client client = fx3Client;
            FeatureFlagValue result2 = client.getFlag(featureFlagKey);
            if (Intrinsics.areEqual((Object)result2.getEvaluationReason(), (Object)new EvaluationReason.Error(ErrorKind.FLAG_NOT_FOUND))) {
                object = t;
            } else {
                object = result2.getValue();
                if (object == null) {
                    object = t;
                }
            }
            t2 = object;
        }
        catch (Exception ex) {
            log.error("Failed to fetch the flag: [" + featureFlagKey.getIdentifier() + "] with " + ex);
            t2 = t;
        }
        return t2;
    }

    @Override
    @NotNull
    public Set<String> allFeatureKeysEnabledForCurrentUser() {
        Object object;
        Object object2 = this.tryGetFx3Client();
        if (object2 == null || (object2 = object2.getAllEnabledFlagsForUser()) == null) {
            object2 = SetsKt.emptySet();
        }
        Object it = object = object2;
        boolean bl = false;
        Iterable $this$forEach$iv = (Iterable)it;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl2 = false;
            String[] stringArray = new String[]{it2};
            ((GaugeDataPoint)Fx3PluginClientImplKt.access$getLaunchDarklyFeatureFlagState$p().labelValues(stringArray)).set(1.0);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> allFeatureGateKeysEnabledForCurrentUser() {
        Set set;
        void $this$mapNotNullTo$iv$iv;
        Object object = this.tryGetFx3Client();
        if (object == null || (object = object.getAllEnabledGatesForUserFromStatsig()) == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
            object = SetsKt.emptySet();
        }
        Object hashedKeys = object;
        Iterable $this$mapNotNull$iv = (Iterable)hashedKeys;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String hash = (String)element$iv$iv;
            boolean bl2 = false;
            if (StatsigMappings.INSTANCE.decodeHashToName(hash) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set it = set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean bl = false;
        Iterable $this$forEach$iv = it;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl4 = false;
            String[] stringArray = new String[]{it2};
            ((GaugeDataPoint)Fx3PluginClientImplKt.access$getStatSigGateState$p().labelValues(stringArray)).set(1.0);
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Object> allDynamicConfigsForCurrentUser() {
        void $this$mapNotNullTo$iv$iv;
        Object object = this.tryGetFx3Client();
        if (object == null || (object = object.getAllConfigsForUserFromStatsig()) == null) {
            object = MapsKt.emptyMap();
        }
        Object dynamicConfigs = object;
        Iterable $this$mapNotNull$iv = dynamicConfigs.entrySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            String hashedKey = (String)entry.getKey();
            Object value = entry.getValue();
            String unhashedName = StatsigMappings.INSTANCE.decodeHashToName(hashedKey);
            if ((unhashedName != null ? TuplesKt.to((Object)unhashedName, value) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final void refreshFx3Flags() {
        block0: {
            Fx3Client fx3Client = this.tryGetFx3Client();
            if (fx3Client == null) break block0;
            fx3Client.performManualFetch();
        }
    }

    private final void refreshFx3Statsig() {
        Fx3Client fx3Client = this.tryGetFx3Client();
        if (fx3Client != null) {
            fx3Client.performBackgroundFetchFromStatsig();
        }
        StatsigFx3Gates[] $this$forEach$iv = StatsigFx3Gates.values();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            StatsigFx3Gates element$iv;
            StatsigFx3Gates it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Fx3PluginClientImpl fx3PluginClientImpl = this;
            try {
                Fx3PluginClientImpl $this$refreshFx3Statsig_u24lambda_u2411_u24lambda_u2410 = fx3PluginClientImpl;
                boolean bl2 = false;
                Fx3Client fx3Client2 = $this$refreshFx3Statsig_u24lambda_u2411_u24lambda_u2410.tryGetFx3Client();
                boolean res = fx3Client2 != null && (fx3Client2 = fx3Client2.getGateFromStatsig(it.getGateKey())) != null ? Intrinsics.areEqual((Object)fx3Client2.getValue(), (Object)true) : false;
                String[] stringArray = new String[]{it.getGateKey()};
                ((GaugeDataPoint)Fx3PluginClientImplKt.access$getStatSigGateState$p().labelValues(stringArray)).set(res ? 1.0 : 0.0);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
                continue;
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }

    private final void refreshAll() {
        Fx3Client fx3Client = this.tryGetFx3Client();
        if (fx3Client != null) {
            fx3Client.updateUserIdentifier(this.currentCloudId);
        }
        Fx3Client fx3Client2 = this.tryGetFx3Client();
        if (fx3Client2 != null) {
            fx3Client2.updateUserCustomAttributes(this.currentFx3UserCustomAttributes);
        }
        this.refreshFx3Flags();
        this.refreshFx3Statsig();
        this.lastUpdatedTime = Instant.now().toEpochMilli();
    }

    @Override
    public void refreshAllAndNotify() {
        this.refreshAll();
        this.notifyFx3AttributesChanged();
    }

    @Override
    public void updateUserCustomAttributes(@NotNull Map<String, ? extends Object> customAttributes) {
        Intrinsics.checkNotNullParameter(customAttributes, (String)"customAttributes");
        Fx3Client fx3Client = this.tryGetFx3Client();
        if (fx3Client != null) {
            fx3Client.updateUserCustomAttributes(customAttributes);
        }
        this.currentFx3UserCustomAttributes = MapsKt.toMutableMap(customAttributes);
        this.notifyFx3AttributesChanged();
    }

    @Override
    public void setUserCustomAttribute(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Map customAttributes = MapsKt.toMutableMap(this.currentFx3UserCustomAttributes);
        customAttributes.put(key, value);
        this.updateUserCustomAttributes(customAttributes);
    }

    @Override
    public void upsertConfig(@NotNull Fx3Config fx3Config) {
        Intrinsics.checkNotNullParameter((Object)fx3Config, (String)"fx3Config");
        try {
            Fx3Client fx3Client;
            log.debug("update fx3 client on cloud type switch |{}|", (Object)fx3Config.getBaseUrl());
            Fx3Client fx3Client2 = fx3Client = this.tryGetFx3Client();
            if (fx3Client2 != null) {
                fx3Client2.updateFx3Config(fx3Config);
            }
        }
        catch (Exception ex) {
            log.error("Error updating the client on cloud switch " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Fx3Client tryGetFx3Client() {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0);
        if (this.fx3Client == null) {
            CompletableFuture<Fx3Client> completableFuture = this.fx3ClientFuture;
            if (!(completableFuture != null ? !completableFuture.isDone() : false)) {
                Fx3PluginClientImpl fx3PluginClientImpl = this;
                synchronized (fx3PluginClientImpl) {
                    boolean bl = false;
                    if (this.fx3Client == null) {
                        CompletableFuture<Fx3Client> completableFuture2 = this.fx3ClientFuture;
                        if (!(completableFuture2 != null ? !completableFuture2.isDone() : false)) {
                            this.fx3ClientFuture = CompletableFuture.supplyAsync(() -> Fx3PluginClientImpl.tryGetFx3Client$lambda$13$lambda$12(this));
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
        CompletableFuture<Fx3Client> completableFuture = this.fx3ClientFuture;
        boolean bl = completableFuture != null ? !completableFuture.isDone() : false;
        if (bl) {
            return null;
        }
        return this.fx3Client;
    }

    @PreDestroy
    public final void cleanUp() {
        Fx3Client fx3Client = this.fx3Client;
        if (fx3Client != null) {
            fx3Client.cleanUp();
        }
        this.destroyed = true;
    }

    public final void waitForInitialization() {
        block0: {
            this.tryGetFx3Client();
            CompletableFuture<Fx3Client> completableFuture = this.fx3ClientFuture;
            if (completableFuture == null) break block0;
            completableFuture.get();
        }
    }

    public final void refreshAllIfRequired() {
        Fx3State remoteState = null;
        try {
            remoteState = this.fx3StateRepository.retrieveFx3State();
        }
        catch (Exception e) {
            log.error("Failed to fetch remote Fx3 state", (Throwable)e);
        }
        if (remoteState == null) {
            log.info("Remote is null, creating new state");
            try {
                this.refreshAll();
                this.fx3StateRepository.createAndUpdateFx3StateIfNotExists(new Fx3State(this.currentCloudId, this.lastUpdatedTime, this.currentFx3UserCustomAttributes, ""));
            }
            catch (Exception e) {
                log.error("Failed to create Fx3 state", (Throwable)e);
            }
        } else if (!Intrinsics.areEqual((Object)remoteState.getCloudId(), (Object)this.currentCloudId) || !Intrinsics.areEqual(remoteState.getCustomAttributes(), this.currentFx3UserCustomAttributes) || remoteState.getFx3FetchTime() > this.lastUpdatedTime) {
            log.info("Remote " + remoteState + " has changed, updating local state " + this.currentCloudId + ", " + this.lastUpdatedTime + ", " + this.currentFx3UserCustomAttributes);
            this.currentCloudId = remoteState.getCloudId();
            this.currentFx3UserCustomAttributes = MapsKt.toMutableMap(remoteState.getCustomAttributes());
            this.refreshAll();
            log.info("Local state after refresh: " + this.currentCloudId + ", " + this.lastUpdatedTime + ", " + this.currentFx3UserCustomAttributes);
        }
    }

    private final void notifyFx3AttributesChanged() {
        log.info("Fx3 attributes changed, updating remote state");
        try {
            this.fx3StateRepository.updateFx3State(new Fx3State(this.currentCloudId, this.lastUpdatedTime, this.currentFx3UserCustomAttributes, ""));
        }
        catch (Exception e) {
            log.error("Failed to update Fx3 state " + this.currentCloudId + ' ' + this.lastUpdatedTime + ' ' + this.currentFx3UserCustomAttributes, (Throwable)e);
        }
    }

    private static final Fx3Client tryGetFx3Client$lambda$13$lambda$12(Fx3PluginClientImpl this$0) {
        Fx3Client fx3Client;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            fx3Client = this$0.fx3Client = (Fx3Client)this$0.fx3ClientProvider.invoke();
        }
        catch (RuntimeException e) {
            log.error("Failed to initialize fx3Client.", (Throwable)e);
            fx3Client = null;
        }
        return fx3Client;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/fx3/Fx3PluginClientImpl$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

