/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.fx3;

import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.fx3.Fx3State;
import com.atlassian.jira.migration.fx3.Fx3StateTable;
import com.atlassian.jira.migration.migration.MigrationRepositoryException;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u0004\u0018\u00010\fJ\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/fx3/Fx3StateRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "createAndUpdateFx3StateIfNotExists", "", "fx3State", "Lcom/atlassian/jira/migration/fx3/Fx3State;", "fromTupleToFx3State", "tuple", "Lcom/querydsl/core/Tuple;", "retrieveFx3State", "updateFx3State", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nFx3StateRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fx3StateRepository.kt\ncom/atlassian/jira/migration/fx3/Fx3StateRepository\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n51#2:150\n1#3:151\n*S KotlinDebug\n*F\n+ 1 Fx3StateRepository.kt\ncom/atlassian/jira/migration/fx3/Fx3StateRepository\n*L\n90#1:150\n*E\n"})
public final class Fx3StateRepository {
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final ObjectMapper mapper;

    @Inject
    public Fx3StateRepository(@NotNull DatabaseAccessor databaseAccessor, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.databaseAccessor = databaseAccessor;
        this.mapper = objectMapperFactory.createObjectMapper();
    }

    public final void createAndUpdateFx3StateIfNotExists(@NotNull Fx3State fx3State) {
        Intrinsics.checkNotNullParameter((Object)fx3State, (String)"fx3State");
        this.databaseAccessor.runInNewTransaction(arg_0 -> Fx3StateRepository.createAndUpdateFx3StateIfNotExists$lambda$0(fx3State, this, arg_0), OnRollback.NOOP);
        this.updateFx3State(fx3State);
    }

    @Nullable
    public final Fx3State retrieveFx3State() {
        return (Fx3State)this.databaseAccessor.run(arg_0 -> Fx3StateRepository.retrieveFx3State$lambda$2(this, arg_0), Fx3StateRepository::retrieveFx3State$lambda$3);
    }

    public final void updateFx3State(@NotNull Fx3State fx3State) {
        Intrinsics.checkNotNullParameter((Object)fx3State, (String)"fx3State");
        this.databaseAccessor.run(arg_0 -> Fx3StateRepository.updateFx3State$lambda$4(fx3State, this, arg_0), Fx3StateRepository::updateFx3State$lambda$5);
    }

    private final Fx3State fromTupleToFx3State(Tuple tuple) {
        Map customAttributes = null;
        try {
            boolean $i$f$jacksonTypeRef = false;
            Object object = this.mapper.readValue((String)tuple.get((Expression)Fx3StateTable.Companion.getFX3_STATE_TABLE().getCUSTOM_ATTRIBUTES()), (TypeReference)new TypeReference<Map<String, ? extends Object>>(){});
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
            customAttributes = (Map)object;
        }
        catch (IOException e) {
            throw new MigrationRepositoryException("JSON deserialization error for customAttributes=" + (String)tuple.get((Expression)Fx3StateTable.Companion.getFX3_STATE_TABLE().getCUSTOM_ATTRIBUTES()), e);
        }
        Object object = tuple.get((Expression)Fx3StateTable.Companion.getFX3_STATE_TABLE().getCLOUD_ID());
        Intrinsics.checkNotNull((Object)object);
        String string = (String)object;
        Long l = (Long)tuple.get((Expression)Fx3StateTable.Companion.getFX3_STATE_TABLE().getFX3_FETCH_TIME());
        if (l == null) {
            l = 0L;
        }
        long l2 = ((Number)l).longValue();
        String string2 = (String)tuple.get((Expression)Fx3StateTable.Companion.getFX3_STATE_TABLE().getFX3_PAYLOAD());
        if (string2 == null) {
            string2 = "";
        }
        return new Fx3State(string, l2, customAttributes, string2);
    }

    private static final Unit createAndUpdateFx3StateIfNotExists$lambda$0(Fx3State $fx3State, Fx3StateRepository this$0, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$fx3State, (String)"$fx3State");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (((SQLQuery)db.select((Expression)Fx3StateTable.Companion.getFX3_STATE_TABLE().getFX3_STATE_ID()).from((Expression)Fx3StateTable.Companion.getFX3_STATE_TABLE())).fetchFirst() == null) {
            db.insert((RelationalPath)Fx3StateTable.Companion.getFX3_STATE_TABLE()).set((Path)Fx3StateTable.Companion.getFX3_STATE_TABLE().getCLOUD_ID(), (Object)$fx3State.getCloudId()).set((Path)Fx3StateTable.Companion.getFX3_STATE_TABLE().getFX3_FETCH_TIME(), (Object)$fx3State.getFx3FetchTime()).set((Path)Fx3StateTable.Companion.getFX3_STATE_TABLE().getCUSTOM_ATTRIBUTES(), (Object)this$0.mapper.writeValueAsString($fx3State.getCustomAttributes())).set((Path)Fx3StateTable.Companion.getFX3_STATE_TABLE().getFX3_PAYLOAD(), (Object)$fx3State.getPayload()).execute();
        }
        return Unit.INSTANCE;
    }

    private static final Fx3State retrieveFx3State$lambda$2(Fx3StateRepository this$0, DatabaseConnection db) {
        Fx3State fx3State;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Expression[] expressionArray = new Expression[]{Fx3StateTable.Companion.getFX3_STATE_TABLE().getFX3_STATE_ID(), Fx3StateTable.Companion.getFX3_STATE_TABLE().getCLOUD_ID(), Fx3StateTable.Companion.getFX3_STATE_TABLE().getFX3_FETCH_TIME(), Fx3StateTable.Companion.getFX3_STATE_TABLE().getCUSTOM_ATTRIBUTES(), Fx3StateTable.Companion.getFX3_STATE_TABLE().getFX3_PAYLOAD()};
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)Fx3StateTable.Companion.getFX3_STATE_TABLE())).orderBy(Fx3StateTable.Companion.getFX3_STATE_TABLE().getFX3_FETCH_TIME().desc())).fetchFirst();
        if (tuple != null) {
            Tuple it = tuple;
            boolean bl = false;
            fx3State = this$0.fromTupleToFx3State(it);
        } else {
            fx3State = null;
        }
        return fx3State;
    }

    private static final void retrieveFx3State$lambda$3() {
    }

    private static final Long updateFx3State$lambda$4(Fx3State $fx3State, Fx3StateRepository this$0, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$fx3State, (String)"$fx3State");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return db.update((RelationalPath)Fx3StateTable.Companion.getFX3_STATE_TABLE()).set((Path)Fx3StateTable.Companion.getFX3_STATE_TABLE().getCLOUD_ID(), (Object)$fx3State.getCloudId()).set((Path)Fx3StateTable.Companion.getFX3_STATE_TABLE().getFX3_FETCH_TIME(), (Object)$fx3State.getFx3FetchTime()).set((Path)Fx3StateTable.Companion.getFX3_STATE_TABLE().getCUSTOM_ATTRIBUTES(), (Object)this$0.mapper.writeValueAsString($fx3State.getCustomAttributes())).set((Path)Fx3StateTable.Companion.getFX3_STATE_TABLE().getFX3_PAYLOAD(), (Object)$fx3State.getPayload()).execute();
    }

    private static final void updateFx3State$lambda$5() {
    }
}

