/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.migration.guardrails.AccessLogConsumer;
import com.atlassian.jira.migration.guardrails.AccessLogConsumerFactory;
import com.atlassian.jira.migration.guardrails.AccessLogConsumerFactoryDailyUsageMetrics;
import com.atlassian.jira.migration.guardrails.AccessLogProcessingJobRunner;
import com.atlassian.jira.migration.guardrails.DailyTrafficFileWriterService;
import com.atlassian.jira.migration.guardrails.DailyUsageMetricsService;
import com.atlassian.jira.migration.guardrails.InstanceAssessmentServiceKt;
import com.atlassian.jira.migration.guardrails.logs.LogEntry;
import java.time.LocalDate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0002\r\u000eB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/guardrails/AccessLogConsumerFactoryDailyUsageMetrics;", "Lcom/atlassian/jira/migration/guardrails/AccessLogConsumerFactory;", "dailyUsageMetricsService", "Lcom/atlassian/jira/migration/guardrails/DailyUsageMetricsService;", "clusterManager", "Lcom/atlassian/jira/cluster/ClusterManager;", "dailyTrafficFileWriterService", "Lcom/atlassian/jira/migration/guardrails/DailyTrafficFileWriterService;", "(Lcom/atlassian/jira/migration/guardrails/DailyUsageMetricsService;Lcom/atlassian/jira/cluster/ClusterManager;Lcom/atlassian/jira/migration/guardrails/DailyTrafficFileWriterService;)V", "createAccessLogConsumer", "Lcom/atlassian/jira/migration/guardrails/AccessLogConsumer;", "accessLogDate", "Ljava/time/LocalDate;", "AccessLogConsumerDailyUsageMetrics", "Companion", "jira-migration-plugin"})
public final class AccessLogConsumerFactoryDailyUsageMetrics
implements AccessLogConsumerFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DailyUsageMetricsService dailyUsageMetricsService;
    @NotNull
    private final ClusterManager clusterManager;
    @NotNull
    private final DailyTrafficFileWriterService dailyTrafficFileWriterService;
    private static final int DAY_HOUR_KEY_LENGTH = 14;

    @Inject
    public AccessLogConsumerFactoryDailyUsageMetrics(@NotNull DailyUsageMetricsService dailyUsageMetricsService, @NotNull ClusterManager clusterManager, @NotNull DailyTrafficFileWriterService dailyTrafficFileWriterService) {
        Intrinsics.checkNotNullParameter((Object)dailyUsageMetricsService, (String)"dailyUsageMetricsService");
        Intrinsics.checkNotNullParameter((Object)clusterManager, (String)"clusterManager");
        Intrinsics.checkNotNullParameter((Object)dailyTrafficFileWriterService, (String)"dailyTrafficFileWriterService");
        this.dailyUsageMetricsService = dailyUsageMetricsService;
        this.clusterManager = clusterManager;
        this.dailyTrafficFileWriterService = dailyTrafficFileWriterService;
    }

    @Override
    @NotNull
    public AccessLogConsumer createAccessLogConsumer(@NotNull LocalDate accessLogDate) {
        Intrinsics.checkNotNullParameter((Object)accessLogDate, (String)"accessLogDate");
        return new AccessLogConsumerDailyUsageMetrics(accessLogDate);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0087\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/guardrails/AccessLogConsumerFactoryDailyUsageMetrics$AccessLogConsumerDailyUsageMetrics;", "Lcom/atlassian/jira/migration/guardrails/AccessLogConsumer;", "accessLogDate", "Ljava/time/LocalDate;", "(Lcom/atlassian/jira/migration/guardrails/AccessLogConsumerFactoryDailyUsageMetrics;Ljava/time/LocalDate;)V", "userTrafficByHour", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "close", "", "consume", "line", "Lcom/atlassian/jira/migration/guardrails/logs/LogEntry;", "jira-migration-plugin"})
    @ThreadSafe
    public final class AccessLogConsumerDailyUsageMetrics
    implements AccessLogConsumer {
        @NotNull
        private final LocalDate accessLogDate;
        @NotNull
        private final ConcurrentHashMap<String, Integer> userTrafficByHour;

        public AccessLogConsumerDailyUsageMetrics(LocalDate accessLogDate) {
            Intrinsics.checkNotNullParameter((Object)accessLogDate, (String)"accessLogDate");
            this.accessLogDate = accessLogDate;
            this.userTrafficByHour = new ConcurrentHashMap();
        }

        @Override
        public void consume(@NotNull LogEntry line) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                String string = line.getDate().substring(0, 14);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String dayHourKey = string;
                String string2 = line.getUser();
                if (string2 == null) break block1;
                String userId = string2;
                boolean bl = false;
                if (!StringsKt.isBlank((CharSequence)userId) && !Intrinsics.areEqual((Object)userId, (Object)"-")) {
                    this.userTrafficByHour.merge(dayHourKey + ',' + userId, 1, (arg_0, arg_1) -> AccessLogConsumerDailyUsageMetrics.consume$lambda$1$lambda$0(consume.1.1.INSTANCE, arg_0, arg_1));
                }
            }
        }

        @Override
        public void close() {
            AccessLogProcessingJobRunner.Companion.getLog().info("Creating csv file on shared home folder for date " + this.accessLogDate + '.');
            String csvFilePath = AccessLogConsumerFactoryDailyUsageMetrics.this.dailyUsageMetricsService.getDailyTrafficByHourFilePath(this.accessLogDate, InstanceAssessmentServiceKt.getNodeIdOrDefault(AccessLogConsumerFactoryDailyUsageMetrics.this.clusterManager));
            AccessLogConsumerFactoryDailyUsageMetrics.this.dailyTrafficFileWriterService.writeCsvFileWithDailyTraffic((Map<String, Integer>)this.userTrafficByHour, csvFilePath);
        }

        private static final Integer consume$lambda$1$lambda$0(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Integer)$tmp0.invoke(p0, p1);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/guardrails/AccessLogConsumerFactoryDailyUsageMetrics$Companion;", "", "()V", "DAY_HOUR_KEY_LENGTH", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

