/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import com.atlassian.jira.migration.guardrails.AccessLogConsumer;
import com.atlassian.jira.migration.guardrails.AccessLogConsumerFactory;
import com.atlassian.jira.migration.guardrails.logs.LogEntry;
import com.atlassian.jira.migration.guardrails.logs.TomcatAccessLogParserV2;
import java.io.File;
import java.nio.file.Files;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/guardrails/AccessLogFileProcessor;", "", "accessLogParserV2", "Lcom/atlassian/jira/migration/guardrails/logs/TomcatAccessLogParserV2;", "consumerFactories", "", "Lcom/atlassian/jira/migration/guardrails/AccessLogConsumerFactory;", "(Lcom/atlassian/jira/migration/guardrails/logs/TomcatAccessLogParserV2;Ljava/util/List;)V", "processLogFile", "", "file", "Ljava/io/File;", "key", "Ljava/time/LocalDate;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAccessLogFileProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessLogFileProcessor.kt\ncom/atlassian/jira/migration/guardrails/AccessLogFileProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n1549#2:34\n1620#2,3:35\n1855#2,2:38\n*S KotlinDebug\n*F\n+ 1 AccessLogFileProcessor.kt\ncom/atlassian/jira/migration/guardrails/AccessLogFileProcessor\n*L\n16#1:34\n16#1:35,3\n28#1:38,2\n*E\n"})
public final class AccessLogFileProcessor {
    @NotNull
    private final TomcatAccessLogParserV2 accessLogParserV2;
    @NotNull
    private final List<AccessLogConsumerFactory> consumerFactories;

    @Inject
    public AccessLogFileProcessor(@NotNull TomcatAccessLogParserV2 accessLogParserV2, @NotNull List<? extends AccessLogConsumerFactory> consumerFactories) {
        Intrinsics.checkNotNullParameter((Object)accessLogParserV2, (String)"accessLogParserV2");
        Intrinsics.checkNotNullParameter(consumerFactories, (String)"consumerFactories");
        this.accessLogParserV2 = accessLogParserV2;
        this.consumerFactories = consumerFactories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void processLogFile(@NotNull File file2, @NotNull LocalDate key) {
        Iterator $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Iterable $this$map$iv = this.consumerFactories;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv = iterator2.next();
            AccessLogConsumerFactory accessLogConsumerFactory = (AccessLogConsumerFactory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.createAccessLogConsumer(key));
        }
        List accessLogConsumers = (List)destination$iv$iv;
        try {
            ((Stream)Files.lines(file2.toPath()).parallel()).map(arg_0 -> AccessLogFileProcessor.processLogFile$lambda$1((Function1)new Function1<String, LogEntry>(this){
                final /* synthetic */ AccessLogFileProcessor this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final LogEntry invoke(String it) {
                    TomcatAccessLogParserV2 tomcatAccessLogParserV2 = AccessLogFileProcessor.access$getAccessLogParserV2$p(this.this$0);
                    Intrinsics.checkNotNull((Object)it);
                    return tomcatAccessLogParserV2.parseLine(it);
                }
            }, arg_0)).forEach(arg_0 -> AccessLogFileProcessor.processLogFile$lambda$2((Function1)new Function1<LogEntry, Unit>((List<? extends AccessLogConsumer>)accessLogConsumers){
                final /* synthetic */ List<AccessLogConsumer> $accessLogConsumers;
                {
                    this.$accessLogConsumers = $accessLogConsumers;
                    super(1);
                }

                public final void invoke(LogEntry it) {
                    Iterable $this$forEach$iv = this.$accessLogConsumers;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        AccessLogConsumer consumer = (AccessLogConsumer)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        consumer.consume(it);
                    }
                }
            }, arg_0));
        }
        finally {
            Iterable $this$forEach$iv = accessLogConsumers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AccessLogConsumer it = (AccessLogConsumer)element$iv;
                boolean bl = false;
                it.close();
            }
        }
    }

    private static final LogEntry processLogFile$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LogEntry)$tmp0.invoke(p0);
    }

    private static final void processLogFile$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ TomcatAccessLogParserV2 access$getAccessLogParserV2$p(AccessLogFileProcessor $this) {
        return $this.accessLogParserV2;
    }
}

