/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import com.atlassian.jira.migration.guardrails.repository.AccessLogProcessingControl;
import com.atlassian.jira.migration.guardrails.repository.AccessLogProcessingItem;
import com.atlassian.jira.migration.guardrails.repository.AccessLogProcessingItemRepository;
import com.atlassian.jira.migration.guardrails.repository.InstAnalysisCtrl;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ%\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/jira/migration/guardrails/AccessLogProcessingItemService;", "", "accessLogProcessingItemRepository", "Lcom/atlassian/jira/migration/guardrails/repository/AccessLogProcessingItemRepository;", "(Lcom/atlassian/jira/migration/guardrails/repository/AccessLogProcessingItemRepository;)V", "findByAccessLogProcCtrl", "Lcom/atlassian/jira/migration/guardrails/repository/AccessLogProcessingItem;", "accessLogProcessingControl", "Lcom/atlassian/jira/migration/guardrails/repository/AccessLogProcessingControl;", "date", "Ljava/util/Date;", "findByInstAnalysysCtrlAndDate", "", "instAnalysisCtrl", "Lcom/atlassian/jira/migration/guardrails/repository/InstAnalysisCtrl;", "localDate", "Ljava/time/LocalDate;", "(Lcom/atlassian/jira/migration/guardrails/repository/InstAnalysisCtrl;Ljava/time/LocalDate;)[Lcom/atlassian/jira/migration/guardrails/repository/AccessLogProcessingItem;", "findOrCreateAccessLogProcessingItem", "recordAccessLogProcessingItem", "processingDate", "recordAccessLogProcessingItemForControl", "", "accessLogPrcControl", "updateAccessLogProcessingItem", "accessLogProcessingItem", "jira-migration-plugin"})
public final class AccessLogProcessingItemService {
    @NotNull
    private final AccessLogProcessingItemRepository accessLogProcessingItemRepository;

    @Inject
    public AccessLogProcessingItemService(@NotNull AccessLogProcessingItemRepository accessLogProcessingItemRepository) {
        Intrinsics.checkNotNullParameter((Object)accessLogProcessingItemRepository, (String)"accessLogProcessingItemRepository");
        this.accessLogProcessingItemRepository = accessLogProcessingItemRepository;
    }

    @NotNull
    public final AccessLogProcessingItem recordAccessLogProcessingItem(@NotNull AccessLogProcessingControl accessLogProcessingControl, @NotNull Date processingDate) {
        Intrinsics.checkNotNullParameter((Object)accessLogProcessingControl, (String)"accessLogProcessingControl");
        Intrinsics.checkNotNullParameter((Object)processingDate, (String)"processingDate");
        return this.accessLogProcessingItemRepository.createAccessLogProcessingItem(accessLogProcessingControl, processingDate);
    }

    public final void updateAccessLogProcessingItem(@NotNull AccessLogProcessingItem accessLogProcessingItem) {
        Intrinsics.checkNotNullParameter((Object)accessLogProcessingItem, (String)"accessLogProcessingItem");
        this.accessLogProcessingItemRepository.updateAccessLogProcessingItem(accessLogProcessingItem);
    }

    @NotNull
    public final AccessLogProcessingItem findOrCreateAccessLogProcessingItem(@NotNull AccessLogProcessingControl accessLogProcessingControl, @NotNull LocalDate localDate) {
        Intrinsics.checkNotNullParameter((Object)accessLogProcessingControl, (String)"accessLogProcessingControl");
        Intrinsics.checkNotNullParameter((Object)localDate, (String)"localDate");
        Date date = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
        Intrinsics.checkNotNull((Object)date);
        AccessLogProcessingItem accessLogProcessingItem = this.findByAccessLogProcCtrl(accessLogProcessingControl, date);
        AccessLogProcessingItem accessLogProcessingItem2 = accessLogProcessingItem;
        if (accessLogProcessingItem2 == null) {
            accessLogProcessingItem2 = this.recordAccessLogProcessingItem(accessLogProcessingControl, date);
        }
        return accessLogProcessingItem2;
    }

    @Nullable
    public final AccessLogProcessingItem findByAccessLogProcCtrl(@NotNull AccessLogProcessingControl accessLogProcessingControl, @NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)accessLogProcessingControl, (String)"accessLogProcessingControl");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.accessLogProcessingItemRepository.findByAccessLogProcCtrl(accessLogProcessingControl, date);
    }

    @Nullable
    public final AccessLogProcessingItem[] findByInstAnalysysCtrlAndDate(@NotNull InstAnalysisCtrl instAnalysisCtrl, @NotNull LocalDate localDate) {
        Intrinsics.checkNotNullParameter((Object)instAnalysisCtrl, (String)"instAnalysisCtrl");
        Intrinsics.checkNotNullParameter((Object)localDate, (String)"localDate");
        Date date = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
        Intrinsics.checkNotNull((Object)date);
        return this.accessLogProcessingItemRepository.findByInstAnalysysCtrlAndDate(instAnalysisCtrl, date);
    }

    public final void recordAccessLogProcessingItemForControl(@NotNull AccessLogProcessingControl accessLogPrcControl) {
        Intrinsics.checkNotNullParameter((Object)accessLogPrcControl, (String)"accessLogPrcControl");
        LocalDate today = LocalDate.now();
        LocalDate startDate = today.minusDays(14L);
        for (int i = 0; i < 14; ++i) {
            LocalDate localDate = startDate.plusDays(i).atStartOfDay().toLocalDate();
            Date date = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"from(...)");
            this.recordAccessLogProcessingItem(accessLogPrcControl, date);
        }
    }
}

