/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.guardrails.AccessLogFileProcessor;
import com.atlassian.jira.migration.guardrails.AccessLogProcessingControlService;
import com.atlassian.jira.migration.guardrails.AccessLogProcessingItemService;
import com.atlassian.jira.migration.guardrails.DailyTrafficFileWriterService;
import com.atlassian.jira.migration.guardrails.DailyUsageMetricsService;
import com.atlassian.jira.migration.guardrails.InstanceAnalysisControlService;
import com.atlassian.jira.migration.guardrails.InstanceAssessmentServiceKt;
import com.atlassian.jira.migration.guardrails.repository.AccessLogProcessingControl;
import com.atlassian.jira.migration.guardrails.repository.AccessLogProcessingControlRepositoryKt;
import com.atlassian.jira.migration.guardrails.repository.AccessLogProcessingControlStatus;
import com.atlassian.jira.migration.guardrails.repository.AccessLogProcessingItem;
import com.atlassian.jira.migration.guardrails.repository.AccessLogProcessingItemStatus;
import com.atlassian.jira.migration.guardrails.repository.InstAnalysisCtrl;
import com.atlassian.jira.migration.guardrails.repository.InstanceAnalysisControlRepositoryKt;
import com.atlassian.jira.migration.guardrails.util.ExceptionUtils;
import com.atlassian.jira.migration.guardrails.util.TomcatAccessLogParser;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import java.io.File;
import java.time.LocalDate;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 12\u00020\u0001:\u00011BW\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0007J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u0018H\u0007J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J&\u0010(\u001a\u00020\u001b2\u0014\u0010)\u001a\u0010\u0012\u0004\u0012\u00020%\u0012\u0006\u0012\u0004\u0018\u00010#0*2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/atlassian/jira/migration/guardrails/AccessLogProcessingJobRunner;", "Lcom/atlassian/scheduler/JobRunner;", "clusterManager", "Lcom/atlassian/jira/cluster/ClusterManager;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "dailyUsageMetricsService", "Lcom/atlassian/jira/migration/guardrails/DailyUsageMetricsService;", "instanceAnalysisControlService", "Lcom/atlassian/jira/migration/guardrails/InstanceAnalysisControlService;", "accessLogProcessingControlService", "Lcom/atlassian/jira/migration/guardrails/AccessLogProcessingControlService;", "accessLogProcessingItemService", "Lcom/atlassian/jira/migration/guardrails/AccessLogProcessingItemService;", "accessLogParser", "Lcom/atlassian/jira/migration/guardrails/util/TomcatAccessLogParser;", "dailyTrafficFileWriterService", "Lcom/atlassian/jira/migration/guardrails/DailyTrafficFileWriterService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "accessLogFileProcessor", "Lcom/atlassian/jira/migration/guardrails/AccessLogFileProcessor;", "(Lcom/atlassian/jira/cluster/ClusterManager;Lcom/atlassian/scheduler/SchedulerService;Lcom/atlassian/jira/migration/guardrails/DailyUsageMetricsService;Lcom/atlassian/jira/migration/guardrails/InstanceAnalysisControlService;Lcom/atlassian/jira/migration/guardrails/AccessLogProcessingControlService;Lcom/atlassian/jira/migration/guardrails/AccessLogProcessingItemService;Lcom/atlassian/jira/migration/guardrails/util/TomcatAccessLogParser;Lcom/atlassian/jira/migration/guardrails/DailyTrafficFileWriterService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/guardrails/AccessLogFileProcessor;)V", "cleanup", "", "finishProcessingSingleAccessLogFile", "accessLogProcItem", "Lcom/atlassian/jira/migration/guardrails/repository/AccessLogProcessingItem;", "accessLogProcCtrl", "Lcom/atlassian/jira/migration/guardrails/repository/AccessLogProcessingControl;", "handleAccessLogProcessingError", "e", "", "parseSingleLogFile", "file", "Ljava/io/File;", "fileDate", "Ljava/time/LocalDate;", "postConstruct", "processAccessLogFiles", "processSingleAccessLogFile", "accessLogFile", "", "runJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "request", "Lcom/atlassian/scheduler/JobRunnerRequest;", "shouldProcessAccessLogFiles", "", "Companion", "jira-migration-plugin"})
public final class AccessLogProcessingJobRunner
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClusterManager clusterManager;
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private final DailyUsageMetricsService dailyUsageMetricsService;
    @NotNull
    private final InstanceAnalysisControlService instanceAnalysisControlService;
    @NotNull
    private final AccessLogProcessingControlService accessLogProcessingControlService;
    @NotNull
    private final AccessLogProcessingItemService accessLogProcessingItemService;
    @NotNull
    private final TomcatAccessLogParser accessLogParser;
    @NotNull
    private final DailyTrafficFileWriterService dailyTrafficFileWriterService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final AccessLogFileProcessor accessLogFileProcessor;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final JobRunnerKey JOB_RUNNER_KEY;
    @NotNull
    private static final JobId JOB_ID;
    public static final long SCHEDULER_INTERVAL_IN_HOUR = 1L;
    public static final int MAX_PROCESSING_RETRY = 3;

    @Inject
    public AccessLogProcessingJobRunner(@NotNull ClusterManager clusterManager, @NotNull SchedulerService schedulerService, @NotNull DailyUsageMetricsService dailyUsageMetricsService, @NotNull InstanceAnalysisControlService instanceAnalysisControlService, @NotNull AccessLogProcessingControlService accessLogProcessingControlService, @NotNull AccessLogProcessingItemService accessLogProcessingItemService, @NotNull TomcatAccessLogParser accessLogParser, @NotNull DailyTrafficFileWriterService dailyTrafficFileWriterService, @NotNull MigrationFeatures migrationFeatures, @NotNull AccessLogFileProcessor accessLogFileProcessor) {
        Intrinsics.checkNotNullParameter((Object)clusterManager, (String)"clusterManager");
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        Intrinsics.checkNotNullParameter((Object)dailyUsageMetricsService, (String)"dailyUsageMetricsService");
        Intrinsics.checkNotNullParameter((Object)instanceAnalysisControlService, (String)"instanceAnalysisControlService");
        Intrinsics.checkNotNullParameter((Object)accessLogProcessingControlService, (String)"accessLogProcessingControlService");
        Intrinsics.checkNotNullParameter((Object)accessLogProcessingItemService, (String)"accessLogProcessingItemService");
        Intrinsics.checkNotNullParameter((Object)accessLogParser, (String)"accessLogParser");
        Intrinsics.checkNotNullParameter((Object)dailyTrafficFileWriterService, (String)"dailyTrafficFileWriterService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)accessLogFileProcessor, (String)"accessLogFileProcessor");
        this.clusterManager = clusterManager;
        this.schedulerService = schedulerService;
        this.dailyUsageMetricsService = dailyUsageMetricsService;
        this.instanceAnalysisControlService = instanceAnalysisControlService;
        this.accessLogProcessingControlService = accessLogProcessingControlService;
        this.accessLogProcessingItemService = accessLogProcessingItemService;
        this.accessLogParser = accessLogParser;
        this.dailyTrafficFileWriterService = dailyTrafficFileWriterService;
        this.migrationFeatures = migrationFeatures;
        this.accessLogFileProcessor = accessLogFileProcessor;
    }

    @PostConstruct
    public final void postConstruct() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(this.instanceAnalysisControlService.lowTrafficOnlyHourlySchedule()));
        log.info("Successfully registered access log processing job {}.", (Object)JOB_RUNNER_KEY);
    }

    @PreDestroy
    public final void cleanup() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        log.info("Successfully unregistered access log processing job {}.", (Object)JOB_RUNNER_KEY);
    }

    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        JobRunnerResponse jobRunnerResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            log.info("Running job - jobId: " + request.getJobId() + " - nodeId: " + InstanceAssessmentServiceKt.getNodeIdOrDefault(this.clusterManager));
            InstAnalysisCtrl instAnalysisCtrl = this.instanceAnalysisControlService.findInstanceAnalysisControl("USAGE_METRICS");
            if (instAnalysisCtrl == null || InstanceAnalysisControlRepositoryKt.isFinished(instAnalysisCtrl)) {
                log.info("Ignoring job: usage metrics analysis is not enabled or already finished.");
                return JobRunnerResponse.success((String)request.getJobId().toString());
            }
            AccessLogProcessingControl accessLogProcCtrl = this.accessLogProcessingControlService.findOrCreateAccessLogProcessingControl(instAnalysisCtrl, InstanceAssessmentServiceKt.getNodeIdOrDefault(this.clusterManager));
            if (this.shouldProcessAccessLogFiles(accessLogProcCtrl)) {
                this.processAccessLogFiles(accessLogProcCtrl);
            } else if (AccessLogProcessingControlRepositoryKt.isFinished(accessLogProcCtrl)) {
                log.info("Access log processing already done for this node, ignoring job.");
            } else {
                log.info("Access log processing updated less than 30 minutes ago for this node, ignoring job.");
            }
            jobRunnerResponse = JobRunnerResponse.success((String)request.getJobId().toString());
        }
        catch (Throwable e) {
            String errorMessage2 = "Failed to run job - jobId: " + request.getJobId() + " - nodeId: " + InstanceAssessmentServiceKt.getNodeIdOrDefault(this.clusterManager) + " - " + e.getMessage();
            log.error(errorMessage2, e);
            jobRunnerResponse = JobRunnerResponse.failed((String)errorMessage2);
        }
        return jobRunnerResponse;
    }

    private final boolean shouldProcessAccessLogFiles(AccessLogProcessingControl accessLogProcCtrl) {
        return !AccessLogProcessingControlRepositoryKt.isFinished(accessLogProcCtrl) && AccessLogProcessingControlRepositoryKt.isNewOrUpdatedMoreThan30MinAgo(accessLogProcCtrl);
    }

    private final void processAccessLogFiles(AccessLogProcessingControl accessLogProcCtrl) {
        try {
            long startTimestamp = System.currentTimeMillis();
            log.info("Starting access log processing.");
            accessLogProcCtrl.setStatus(AccessLogProcessingControlStatus.IN_PROGRESS);
            this.accessLogProcessingControlService.updateAccessLogProcessingControl(accessLogProcCtrl);
            Map<LocalDate, File> accessLogFilesMap = this.accessLogParser.listAccessLogFilesFromDaysAgo(14);
            for (Map.Entry<LocalDate, File> accessLogFile : accessLogFilesMap.entrySet()) {
                AccessLogProcessingItem accessLogProcItem = this.accessLogProcessingItemService.findOrCreateAccessLogProcessingItem(accessLogProcCtrl, accessLogFile.getKey());
                if (accessLogProcItem.getStatus() == AccessLogProcessingItemStatus.COMPLETE) continue;
                accessLogProcItem.setStatus(AccessLogProcessingItemStatus.IN_PROGRESS);
                accessLogProcItem.setStartTimestamp(System.currentTimeMillis());
                this.accessLogProcessingItemService.updateAccessLogProcessingItem(accessLogProcItem);
                this.processSingleAccessLogFile(accessLogFile, accessLogProcItem);
                this.finishProcessingSingleAccessLogFile(accessLogProcItem, accessLogProcCtrl);
            }
            accessLogProcCtrl.setStatus(AccessLogProcessingControlStatus.COMPLETE);
            accessLogProcCtrl.setEndTimestamp(System.currentTimeMillis());
            this.accessLogProcessingControlService.updateAccessLogProcessingControl(accessLogProcCtrl);
            log.info("Finalizing access log processing - time taken: " + (System.currentTimeMillis() - startTimestamp) + "ms");
        }
        catch (Throwable e) {
            this.handleAccessLogProcessingError(e, accessLogProcCtrl);
        }
    }

    private final AccessLogProcessingItem processSingleAccessLogFile(Map.Entry<LocalDate, ? extends File> accessLogFile, AccessLogProcessingItem accessLogProcItem) {
        if (accessLogFile.getValue() != null) {
            File file2 = accessLogFile.getValue();
            Intrinsics.checkNotNull((Object)file2);
            File file3 = file2;
            accessLogProcItem.setFileName(file3.getName());
            try {
                long startTimestampAccessLog = System.currentTimeMillis();
                log.info("Parsing access log file " + file3.getName() + '.');
                this.parseSingleLogFile(file3, accessLogFile.getKey());
                log.info("Finalizing parsing access log file - time taken: " + (System.currentTimeMillis() - startTimestampAccessLog) + "ms");
                accessLogProcItem.setStatus(AccessLogProcessingItemStatus.COMPLETE);
            }
            catch (Throwable e) {
                log.error("Failed to parse access log file " + file3.getName() + '.', e);
                accessLogProcItem.setStatus(AccessLogProcessingItemStatus.FAILED);
                accessLogProcItem.setMessage(ExceptionUtils.INSTANCE.getStackTraceAsLimitedString(e));
            }
        } else {
            log.info("Access log file for date " + accessLogFile.getKey() + " not found.");
            accessLogProcItem.setStatus(AccessLogProcessingItemStatus.MISSING_FILE);
        }
        return accessLogProcItem;
    }

    private final void parseSingleLogFile(File file2, LocalDate fileDate) {
        if (this.migrationFeatures.getEnableApiUsageAssessment()) {
            this.accessLogFileProcessor.processLogFile(file2, fileDate);
        } else {
            Map<String, Integer> userTrafficByHour = this.accessLogParser.processLogFile(file2);
            log.info("Creating csv file on shared home folder for date " + fileDate + '.');
            String csvFilePath = this.dailyUsageMetricsService.getDailyTrafficByHourFilePath(fileDate, InstanceAssessmentServiceKt.getNodeIdOrDefault(this.clusterManager));
            this.dailyTrafficFileWriterService.writeCsvFileWithDailyTraffic(userTrafficByHour, csvFilePath);
        }
    }

    private final void finishProcessingSingleAccessLogFile(AccessLogProcessingItem accessLogProcItem, AccessLogProcessingControl accessLogProcCtrl) {
        accessLogProcCtrl.setLastUpdateTimestamp(System.currentTimeMillis());
        this.accessLogProcessingControlService.updateAccessLogProcessingControl(accessLogProcCtrl);
        accessLogProcItem.setEndTimestamp(System.currentTimeMillis());
        this.accessLogProcessingItemService.updateAccessLogProcessingItem(accessLogProcItem);
    }

    private final void handleAccessLogProcessingError(Throwable e, AccessLogProcessingControl accessLogProcCtrl) {
        log.error("Failed to process access log files.", e);
        accessLogProcCtrl.setStatus(AccessLogProcessingControlStatus.FAILED);
        accessLogProcCtrl.setRetryCount(accessLogProcCtrl.getRetryCount() + 1);
        accessLogProcCtrl.setMessage(ExceptionUtils.INSTANCE.getStackTraceAsLimitedString(e));
        if (accessLogProcCtrl.getRetryCount() >= 3) {
            log.error("Access log processing failed after 3 retries.", e);
            accessLogProcCtrl.setEndTimestamp(System.currentTimeMillis());
        } else {
            log.info("Access log processing failed, retrying.");
        }
        this.accessLogProcessingControlService.updateAccessLogProcessingControl(accessLogProcCtrl);
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(AccessLogProcessingJobRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"jira-migration-access-log-processing-job-key");
        Intrinsics.checkNotNull((Object)jobRunnerKey);
        JOB_RUNNER_KEY = jobRunnerKey;
        JobId jobId = JobId.of((String)"jira-migration-access-log-processing-job-id");
        Intrinsics.checkNotNull((Object)jobId);
        JOB_ID = jobId;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/guardrails/AccessLogProcessingJobRunner$Companion;", "", "()V", "JOB_ID", "Lcom/atlassian/scheduler/config/JobId;", "getJOB_ID", "()Lcom/atlassian/scheduler/config/JobId;", "JOB_RUNNER_KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "getJOB_RUNNER_KEY", "()Lcom/atlassian/scheduler/config/JobRunnerKey;", "MAX_PROCESSING_RETRY", "", "SCHEDULER_INTERVAL_IN_HOUR", "", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final JobRunnerKey getJOB_RUNNER_KEY() {
            return JOB_RUNNER_KEY;
        }

        @NotNull
        public final JobId getJOB_ID() {
            return JOB_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

