/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.jira.migration.guardrails.model.ApplinkAppType;
import com.atlassian.jira.migration.guardrails.model.ApplinkDto;
import com.atlassian.jira.migration.guardrails.model.ApplinkTargetEnv;
import com.atlassian.jira.migration.guardrails.util.AppLinkExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/guardrails/AssessmentApplinkService;", "", "applicationLinkService", "Lcom/atlassian/applinks/api/ApplicationLinkService;", "manifestRetriever", "Lcom/atlassian/applinks/spi/manifest/ManifestRetriever;", "(Lcom/atlassian/applinks/api/ApplicationLinkService;Lcom/atlassian/applinks/spi/manifest/ManifestRetriever;)V", "getApplinks", "", "Lcom/atlassian/jira/migration/guardrails/model/ApplinkDto;", "getManifest", "Lcom/atlassian/applinks/spi/Manifest;", "applink", "Lcom/atlassian/applinks/api/ApplicationLink;", "getTargetEnv", "Lcom/atlassian/jira/migration/guardrails/model/ApplinkTargetEnv;", "manifest", "toDto", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAssessmentApplinkService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssessmentApplinkService.kt\ncom/atlassian/jira/migration/guardrails/AssessmentApplinkService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1549#2:66\n1620#2,3:67\n*S KotlinDebug\n*F\n+ 1 AssessmentApplinkService.kt\ncom/atlassian/jira/migration/guardrails/AssessmentApplinkService\n*L\n23#1:66\n23#1:67,3\n*E\n"})
public final class AssessmentApplinkService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationLinkService applicationLinkService;
    @NotNull
    private final ManifestRetriever manifestRetriever;
    private static final Logger LOG = LoggerFactory.getLogger(AssessmentApplinkService.class);

    @Inject
    public AssessmentApplinkService(@NotNull ApplicationLinkService applicationLinkService, @NotNull ManifestRetriever manifestRetriever) {
        Intrinsics.checkNotNullParameter((Object)applicationLinkService, (String)"applicationLinkService");
        Intrinsics.checkNotNullParameter((Object)manifestRetriever, (String)"manifestRetriever");
        this.applicationLinkService = applicationLinkService;
        this.manifestRetriever = manifestRetriever;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ApplinkDto> getApplinks() {
        void $this$mapTo$iv$iv;
        Iterable iterable = this.applicationLinkService.getApplicationLinks();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getApplicationLinks(...)");
        Iterable $this$map$iv = iterable;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ApplicationLink applicationLink = (ApplicationLink)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.toDto((ApplicationLink)it));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final ApplinkDto toDto(ApplicationLink applink) {
        String string;
        Manifest manifest = this.getManifest(applink);
        ApplinkTargetEnv targetEnv = this.getTargetEnv(applink, manifest);
        String string2 = applink.getId().get();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
        String string3 = applink.getRpcUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        ApplinkAppType applinkAppType = AppLinkExtensionsKt.getAppType(applink);
        if (targetEnv == ApplinkTargetEnv.ON_PREMISE) {
            Manifest manifest2 = manifest;
            string = manifest2 != null ? manifest2.getVersion() : null;
        } else {
            string = null;
        }
        return new ApplinkDto(string2, string3, applinkAppType, targetEnv, string);
    }

    private final ApplinkTargetEnv getTargetEnv(ApplicationLink applink, Manifest manifest) {
        ApplinkTargetEnv applinkTargetEnv;
        ApplinkAppType appType = AppLinkExtensionsKt.getAppType(applink);
        if (ApplinkAppType.Companion.getCLOUD_ONLY_APPS().contains((Object)appType)) {
            applinkTargetEnv = ApplinkTargetEnv.CLOUD;
        } else if (ApplinkAppType.Companion.getON_PREMISE_ONLY_APPS().contains((Object)appType)) {
            applinkTargetEnv = ApplinkTargetEnv.ON_PREMISE;
        } else {
            Object object = manifest;
            if (object == null || (object = AppLinkExtensionsKt.isCloud((Manifest)object)) == null) {
                AssessmentApplinkService $this$getTargetEnv_u24lambda_u241 = this;
                boolean bl = false;
                LOG.warn("Could not determine target environment for: {}", (Object)applink.getRpcUrl());
                return ApplinkTargetEnv.NO_CONNECTION;
            }
            boolean isCloud = (Boolean)object;
            applinkTargetEnv = isCloud ? ApplinkTargetEnv.CLOUD : ApplinkTargetEnv.ON_PREMISE;
        }
        return applinkTargetEnv;
    }

    private final Manifest getManifest(ApplicationLink applink) {
        try {
            return this.manifestRetriever.getManifest(applink.getRpcUrl());
        }
        catch (ManifestNotFoundException e) {
            LOG.warn("Could not fetch manifest for rpcUrl: {}", (Object)applink.getRpcUrl(), (Object)e);
            return null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/guardrails/AssessmentApplinkService$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

