/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import com.atlassian.jira.migration.guardrails.repository.BrowserMetricsRepository;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/guardrails/BrowserMetricsCleanupScheduler;", "Lcom/atlassian/scheduler/JobRunner;", "browserMetricsRepository", "Lcom/atlassian/jira/migration/guardrails/repository/BrowserMetricsRepository;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "(Lcom/atlassian/jira/migration/guardrails/repository/BrowserMetricsRepository;Lcom/atlassian/scheduler/SchedulerService;)V", "postConstruct", "", "preDestroy", "runJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "request", "Lcom/atlassian/scheduler/JobRunnerRequest;", "Companion", "jira-migration-plugin"})
public final class BrowserMetricsCleanupScheduler
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BrowserMetricsRepository browserMetricsRepository;
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final JobRunnerKey RUNNER_KEY;
    @NotNull
    private static final JobId JOB_ID;

    @Inject
    public BrowserMetricsCleanupScheduler(@NotNull BrowserMetricsRepository browserMetricsRepository, @NotNull SchedulerService schedulerService) {
        Intrinsics.checkNotNullParameter((Object)browserMetricsRepository, (String)"browserMetricsRepository");
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        this.browserMetricsRepository = browserMetricsRepository;
        this.schedulerService = schedulerService;
    }

    @PostConstruct
    public final void postConstruct() {
        this.schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
        SchedulerService $this$postConstruct_u24lambda_u240 = this.schedulerService;
        boolean bl = false;
        $this$postConstruct_u24lambda_u240.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forCronExpression((String)"0 0 0 ? * SUN *")));
        log.info("Browser metrics cleanup job registered successfully.");
    }

    @PreDestroy
    public final void preDestroy() {
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
        log.info("Browser metrics cleanup job unregistered successfully.");
    }

    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        JobRunnerResponse jobRunnerResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            log.info("Running browser metrics cleanup job. Metrics older than two weeks will be deleted.");
            this.browserMetricsRepository.deleteStaleMetrics();
            jobRunnerResponse = JobRunnerResponse.success((String)request.getJobId().toString());
        }
        catch (Throwable e) {
            log.error("Failed to run browser metrics cleanup job: " + e.getMessage(), e);
            jobRunnerResponse = JobRunnerResponse.failed((Throwable)e);
        }
        return jobRunnerResponse;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(BrowserMetricsCleanupScheduler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"com.atlassian.jira.migration.guardrails.BrowserMetricsCleanupScheduler");
        Intrinsics.checkNotNull((Object)jobRunnerKey);
        RUNNER_KEY = jobRunnerKey;
        JobId jobId = JobId.of((String)"browser-metrics-job-id");
        Intrinsics.checkNotNull((Object)jobId);
        JOB_ID = jobId;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/guardrails/BrowserMetricsCleanupScheduler$Companion;", "", "()V", "JOB_ID", "Lcom/atlassian/scheduler/config/JobId;", "RUNNER_KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

