/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.migration.common.Hasher;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.guardrails.ExamplesFactory;
import com.atlassian.jira.migration.guardrails.InstanceAnalysisControlService;
import com.atlassian.jira.migration.guardrails.exceptions.InvalidDataException;
import com.atlassian.jira.migration.guardrails.model.BrowserMetricsDto;
import com.atlassian.jira.migration.guardrails.model.DeviceDto;
import com.atlassian.jira.migration.guardrails.model.NetworkDto;
import com.atlassian.jira.migration.guardrails.repository.BrowserMetrics;
import com.atlassian.jira.migration.guardrails.repository.BrowserMetricsRepository;
import com.atlassian.jira.migration.utils.FileUtil;
import com.atlassian.jira.user.ApplicationUser;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.StreamingOutput;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 I2\u00020\u0001:\u0001IB7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ(\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0011H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020 H\u0002J\b\u0010&\u001a\u00020$H\u0007J\u0016\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)J\u0012\u0010-\u001a\u00020$2\b\u0010.\u001a\u0004\u0018\u00010\u0011H\u0002J\u0017\u0010/\u001a\u00020$2\b\u00100\u001a\u0004\u0018\u000101H\u0002\u00a2\u0006\u0002\u00102J\u0012\u00103\u001a\u00020$2\b\u00104\u001a\u0004\u0018\u00010\u0011H\u0002J\u0017\u00105\u001a\u00020$2\b\u00106\u001a\u0004\u0018\u000107H\u0002\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0002J\u0012\u0010:\u001a\u00020$2\b\u0010;\u001a\u0004\u0018\u00010\u0011H\u0002J\u0017\u0010<\u001a\u00020$2\b\u0010=\u001a\u0004\u0018\u000107H\u0002\u00a2\u0006\u0002\u00108J\u0017\u0010>\u001a\u00020$2\b\u0010?\u001a\u0004\u0018\u000107H\u0002\u00a2\u0006\u0002\u00108J6\u0010@\u001a\u00020$2\u0006\u0010A\u001a\u00020B2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010D\u001a\u00020\u00122\u0006\u0010E\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J8\u0010F\u001a\u00020$2\u0006\u0010A\u001a\u00020B2\u0006\u0010G\u001a\u0002072\u0006\u0010H\u001a\u0002072\u0006\u0010D\u001a\u00020\u00122\u0006\u0010E\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011H\u0002R'\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/atlassian/jira/migration/guardrails/BrowserMetricsService;", "", "instanceAnalysisControlService", "Lcom/atlassian/jira/migration/guardrails/InstanceAnalysisControlService;", "browserMetricsRepository", "Lcom/atlassian/jira/migration/guardrails/repository/BrowserMetricsRepository;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "features", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "examplesFactory", "Lcom/atlassian/jira/migration/guardrails/ExamplesFactory;", "(Lcom/atlassian/jira/migration/guardrails/InstanceAnalysisControlService;Lcom/atlassian/jira/migration/guardrails/repository/BrowserMetricsRepository;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/cache/CacheManager;Lcom/atlassian/jira/migration/guardrails/ExamplesFactory;)V", "browserMetricsCache", "Lcom/atlassian/cache/Cache;", "", "", "getBrowserMetricsCache", "()Lcom/atlassian/cache/Cache;", "browserMetricsCache$delegate", "Lkotlin/Lazy;", "exportBrowserMetrics", "Ljava/nio/file/Path;", "filename", "serverID", "assessmentDate", "isExample", "", "getExampleBrowserMetrics", "", "Lcom/atlassian/jira/migration/guardrails/repository/BrowserMetrics;", "hashUserKey", "userKey", "insertMetricsToCache", "", "metrics", "preDestroy", "recordBrowserMetrics", "loggedInUser", "Lcom/atlassian/jira/user/ApplicationUser;", "browserMetricsDto", "Lcom/atlassian/jira/migration/guardrails/model/BrowserMetricsDto;", "shouldCollectBrowserMetrics", "validateBrowserName", "userAgent", "validateDownlink", "downlink", "", "(Ljava/lang/Double;)V", "validateEffectiveType", "effectiveType", "validateMemory", "memory", "", "(Ljava/lang/Integer;)V", "validateMetrics", "validatePlatform", "platform", "validateProcessors", "processors", "validateRtt", "rtt", "writeBrowserMetricsJsonToInMemoryOutput", "writer", "Ljava/io/BufferedWriter;", "result", "randomSeed", "serverId", "writeWithPagination", "pageSize", "totalPages", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nBrowserMetricsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserMetricsService.kt\ncom/atlassian/jira/migration/guardrails/BrowserMetricsService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n1#2:247\n*E\n"})
public final class BrowserMetricsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InstanceAnalysisControlService instanceAnalysisControlService;
    @NotNull
    private final BrowserMetricsRepository browserMetricsRepository;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final MigrationFeatures features;
    @NotNull
    private final CacheManager cacheManager;
    @NotNull
    private final ExamplesFactory examplesFactory;
    @NotNull
    private final Lazy browserMetricsCache$delegate;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final Hasher HASHER;

    @Inject
    public BrowserMetricsService(@NotNull InstanceAnalysisControlService instanceAnalysisControlService, @NotNull BrowserMetricsRepository browserMetricsRepository, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull MigrationFeatures features, @NotNull CacheManager cacheManager, @NotNull ExamplesFactory examplesFactory) {
        Intrinsics.checkNotNullParameter((Object)instanceAnalysisControlService, (String)"instanceAnalysisControlService");
        Intrinsics.checkNotNullParameter((Object)browserMetricsRepository, (String)"browserMetricsRepository");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)features, (String)"features");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)examplesFactory, (String)"examplesFactory");
        this.instanceAnalysisControlService = instanceAnalysisControlService;
        this.browserMetricsRepository = browserMetricsRepository;
        this.localFileDataOutput = localFileDataOutput;
        this.features = features;
        this.cacheManager = cacheManager;
        this.examplesFactory = examplesFactory;
        this.browserMetricsCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Cache<String, Long>>(this){
            final /* synthetic */ BrowserMetricsService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Cache<String, Long> invoke() {
                return BrowserMetricsService.access$getCacheManager$p(this.this$0).getCache(BrowserMetricsService.class.getName() + ".cache", null, new CacheSettingsBuilder().expireAfterWrite(6L, TimeUnit.HOURS).maxEntries(100000).remote().build());
            }
        }));
    }

    private final Cache<String, Long> getBrowserMetricsCache() {
        Lazy lazy = this.browserMetricsCache$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Cache)object;
    }

    @PreDestroy
    public final void preDestroy() {
        this.getBrowserMetricsCache().removeAll();
        log.info("Browser-metrics cache has been cleared.");
    }

    public final void recordBrowserMetrics(@NotNull ApplicationUser loggedInUser, @NotNull BrowserMetricsDto browserMetricsDto) {
        Intrinsics.checkNotNullParameter((Object)loggedInUser, (String)"loggedInUser");
        Intrinsics.checkNotNullParameter((Object)browserMetricsDto, (String)"browserMetricsDto");
        if (this.shouldCollectBrowserMetrics(loggedInUser)) {
            this.validateMetrics(browserMetricsDto);
            this.insertMetricsToCache(this.browserMetricsRepository.createBrowserMetrics(loggedInUser, browserMetricsDto));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldCollectBrowserMetrics(@NotNull ApplicationUser loggedInUser) {
        BrowserMetrics browserMetrics;
        Intrinsics.checkNotNullParameter((Object)loggedInUser, (String)"loggedInUser");
        if (!this.features.getCollectL1Metrics()) return false;
        if (!this.instanceAnalysisControlService.hasActiveAssessment()) return false;
        if (this.getBrowserMetricsCache().get((Object)loggedInUser.getKey()) != null) return false;
        BrowserMetrics browserMetrics2 = this.browserMetricsRepository.findMostRecent(loggedInUser);
        if (browserMetrics2 == null) return true;
        BrowserMetrics p0 = browserMetrics = browserMetrics2;
        boolean bl = false;
        this.insertMetricsToCache(p0);
        BrowserMetrics browserMetrics3 = browserMetrics;
        if (browserMetrics3 != null) return false;
        return true;
    }

    private final void insertMetricsToCache(BrowserMetrics metrics) {
        this.getBrowserMetricsCache().put((Object)metrics.getUserKey(), (Object)metrics.getCreatedAt());
    }

    private final void validateMetrics(BrowserMetricsDto browserMetricsDto) {
        log.info("Validating metrics data received from the browser.");
        BrowserMetricsDto $this$validateMetrics_u24lambda_u240 = browserMetricsDto;
        boolean bl = false;
        DeviceDto deviceDto = $this$validateMetrics_u24lambda_u240.getDevice();
        this.validateProcessors(deviceDto != null ? deviceDto.getProcessors() : null);
        DeviceDto deviceDto2 = $this$validateMetrics_u24lambda_u240.getDevice();
        this.validateMemory(deviceDto2 != null ? deviceDto2.getMemory() : null);
        NetworkDto networkDto = $this$validateMetrics_u24lambda_u240.getNetwork();
        this.validateDownlink(networkDto != null ? networkDto.getDownlink() : null);
        NetworkDto networkDto2 = $this$validateMetrics_u24lambda_u240.getNetwork();
        this.validateRtt(networkDto2 != null ? networkDto2.getRtt() : null);
        NetworkDto networkDto3 = $this$validateMetrics_u24lambda_u240.getNetwork();
        this.validateEffectiveType(networkDto3 != null ? networkDto3.getEffectiveType() : null);
        this.validatePlatform($this$validateMetrics_u24lambda_u240.getPlatform());
        this.validateBrowserName(browserMetricsDto.getBrowserName());
    }

    private final void validateProcessors(Integer processors) {
        if (processors != null) {
            Integer n;
            Integer n2 = processors;
            int it = ((Number)n2).intValue();
            boolean bl = false;
            Integer n3 = n = !(1 <= it ? it < 65 : false) ? n2 : null;
            if (n != null) {
                it = ((Number)n).intValue();
                boolean bl2 = false;
                throw new InvalidDataException("Number of processors invalid. It should be between 1 and 64. Value provided " + it + '.');
            }
        }
    }

    private final void validateMemory(Integer memory) {
        if (memory != null) {
            Integer n;
            Integer n2 = memory;
            int it = ((Number)n2).intValue();
            boolean bl = false;
            Integer n3 = n = it <= 0 ? n2 : null;
            if (n != null) {
                it = ((Number)n).intValue();
                boolean bl2 = false;
                throw new InvalidDataException("Memory is invalid. It shouldn't be a negative number. Value provided " + it + '.');
            }
        }
    }

    private final void validateDownlink(Double downlink) {
        if (downlink != null) {
            Double d;
            Double d2 = downlink;
            double it = ((Number)d2).doubleValue();
            boolean bl = false;
            Double d3 = d = it <= 0.0 ? d2 : null;
            if (d != null) {
                it = ((Number)d).doubleValue();
                boolean bl2 = false;
                throw new InvalidDataException("Downlink is invalid. It shouldn't be a negative number. Value provided " + it + '.');
            }
        }
    }

    private final void validateRtt(Integer rtt) {
        if (rtt != null) {
            Integer n;
            Integer n2 = rtt;
            int it = ((Number)n2).intValue();
            boolean bl = false;
            Integer n3 = n = it <= 0 ? n2 : null;
            if (n != null) {
                it = ((Number)n).intValue();
                boolean bl2 = false;
                throw new InvalidDataException("RTT is invalid. It shouldn't be a negative number. Value provided " + it + '.');
            }
        }
    }

    private final void validateEffectiveType(String effectiveType) {
        if (effectiveType != null) {
            String string;
            String string2;
            String it = string2 = effectiveType;
            boolean bl = false;
            String string3 = string = it.length() > 255 ? string2 : null;
            if (string != null) {
                it = string;
                boolean bl2 = false;
                throw new InvalidDataException("Effective type is invalid. Length is greater than 255 characters.");
            }
        }
    }

    private final void validatePlatform(String platform) {
        if (platform != null) {
            String string;
            String string2;
            String it = string2 = platform;
            boolean bl = false;
            String string3 = string = it.length() > 512 ? string2 : null;
            if (string != null) {
                it = string;
                boolean bl2 = false;
                throw new InvalidDataException("Platform is invalid. Length is greater than 512 characters.");
            }
        }
    }

    private final void validateBrowserName(String userAgent2) {
        if (userAgent2 != null) {
            String string;
            String string2;
            String it = string2 = userAgent2;
            boolean bl = false;
            String string3 = string = it.length() > 512 ? string2 : null;
            if (string != null) {
                it = string;
                boolean bl2 = false;
                throw new InvalidDataException("User-agent is invalid. Length is greater than 512 characters.");
            }
        }
    }

    @Nullable
    public final Path exportBrowserMetrics(@NotNull String filename, @NotNull String serverID, @NotNull String assessmentDate, boolean isExample) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)serverID, (String)"serverID");
        Intrinsics.checkNotNullParameter((Object)assessmentDate, (String)"assessmentDate");
        log.info("Exporting browser-metrics.");
        int rowsCount = this.browserMetricsRepository.getCount();
        if (!this.features.getCollectL1Metrics()) {
            log.info("No browser-metrics to export.");
            return null;
        }
        long randomSeed = new SecureRandom().nextLong();
        int totalPages = (rowsCount + 1000 - 1) / 1000;
        StreamingOutput browserMetricsStreamOutput = arg_0 -> BrowserMetricsService.exportBrowserMetrics$lambda$16(rowsCount, isExample, this, totalPages, randomSeed, serverID, assessmentDate, arg_0);
        Path jsonlPathFile = this.localFileDataOutput.exportDirectory().resolve(filename + ".jsonl");
        Intrinsics.checkNotNull((Object)jsonlPathFile);
        FileUtil.INSTANCE.createAndWriteToFile(browserMetricsStreamOutput, jsonlPathFile);
        log.info("Browser-metrics exported.");
        return jsonlPathFile;
    }

    private final List<BrowserMetrics> getExampleBrowserMetrics() {
        return this.examplesFactory.getExampleBrowserMetrics();
    }

    private final void writeBrowserMetricsJsonToInMemoryOutput(BufferedWriter writer, List<? extends BrowserMetrics> result2, long randomSeed, String serverId, String assessmentDate) {
        writer.write(result2.stream().map(arg_0 -> BrowserMetricsService.writeBrowserMetricsJsonToInMemoryOutput$lambda$17((Function1)new Function1<BrowserMetrics, String>(this, randomSeed, serverId, assessmentDate){
            final /* synthetic */ BrowserMetricsService this$0;
            final /* synthetic */ long $randomSeed;
            final /* synthetic */ String $serverId;
            final /* synthetic */ String $assessmentDate;
            {
                this.this$0 = $receiver;
                this.$randomSeed = $randomSeed;
                this.$serverId = $serverId;
                this.$assessmentDate = $assessmentDate;
                super(1);
            }

            public final String invoke(BrowserMetrics entity) {
                return "{\"user\":\"" + BrowserMetricsService.access$hashUserKey(this.this$0, entity.getUserKey() + this.$randomSeed) + "\",\"browserData\":" + entity.getMetricsJson() + ",\"serverId\":\"" + this.$serverId + "\",\"assessmentDate\":\"" + this.$assessmentDate + "\"}";
            }
        }, arg_0)).collect(Collectors.joining("\n")));
    }

    private final void writeWithPagination(BufferedWriter writer, int pageSize, int totalPages, long randomSeed, String serverId, String assessmentDate) {
        int offSet = 0;
        int lastPage = totalPages - 1;
        for (int page = 0; page < totalPages; ++page) {
            List<BrowserMetrics> result2 = this.browserMetricsRepository.getPage(pageSize, offSet);
            this.writeBrowserMetricsJsonToInMemoryOutput(writer, result2, randomSeed, serverId, assessmentDate);
            if (lastPage != page) {
                writer.newLine();
            }
            offSet += pageSize;
        }
    }

    private final String hashUserKey(String userKey) {
        return HASHER.hash(userKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void exportBrowserMetrics$lambda$16(int $rowsCount, boolean $isExample, BrowserMetricsService this$0, int $totalPages, long $randomSeed, String $serverID, String $assessmentDate, OutputStream it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$serverID, (String)"$serverID");
        Intrinsics.checkNotNullParameter((Object)$assessmentDate, (String)"$assessmentDate");
        try {
            Intrinsics.checkNotNull((Object)it);
            Closeable closeable = it;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Object object = charset;
            closeable = new BufferedWriter(new OutputStreamWriter((OutputStream)closeable, (Charset)object));
            object = null;
            try {
                BufferedWriter writer = (BufferedWriter)closeable;
                boolean bl = false;
                if ($rowsCount > 1000 && !$isExample) {
                    this$0.writeWithPagination(writer, 1000, $totalPages, $randomSeed, $serverID, $assessmentDate);
                } else {
                    List<BrowserMetrics> list;
                    boolean bl2 = $isExample;
                    if (bl2) {
                        list = this$0.getExampleBrowserMetrics();
                    } else if (!bl2) {
                        list = this$0.browserMetricsRepository.findAll();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    List<BrowserMetrics> result2 = list;
                    this$0.writeBrowserMetricsJsonToInMemoryOutput(writer, result2, $randomSeed, $serverID, $assessmentDate);
                }
                writer.newLine();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
        catch (RuntimeException e) {
            throw new IOException("Unable to export browser-metrics: " + e.getMessage(), e);
        }
    }

    private static final String writeBrowserMetricsJsonToInMemoryOutput$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$hashUserKey(BrowserMetricsService $this, String userKey) {
        return $this.hashUserKey(userKey);
    }

    public static final /* synthetic */ CacheManager access$getCacheManager$p(BrowserMetricsService $this) {
        return $this.cacheManager;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(BrowserMetricsService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
        HASHER = new Hasher();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/guardrails/BrowserMetricsService$Companion;", "", "()V", "HASHER", "Lcom/atlassian/jira/migration/common/Hasher;", "getHASHER", "()Lcom/atlassian/jira/migration/common/Hasher;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final Hasher getHASHER() {
            return HASHER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

