/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/guardrails/DailyTrafficFileWriterService;", "", "()V", "writeCsvFileWithDailyTraffic", "", "userTrafficInfoMap", "", "", "", "csvFilePath", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nDailyTrafficFileWriterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DailyTrafficFileWriterService.kt\ncom/atlassian/jira/migration/guardrails/DailyTrafficFileWriterService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,42:1\n215#2,2:43\n*S KotlinDebug\n*F\n+ 1 DailyTrafficFileWriterService.kt\ncom/atlassian/jira/migration/guardrails/DailyTrafficFileWriterService\n*L\n25#1:43,2\n*E\n"})
public final class DailyTrafficFileWriterService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeCsvFileWithDailyTraffic(@NotNull Map<String, Integer> userTrafficInfoMap, @NotNull String csvFilePath) {
        Object $this$writeCsvFileWithDailyTraffic_u24lambda_u242;
        Intrinsics.checkNotNullParameter(userTrafficInfoMap, (String)"userTrafficInfoMap");
        Intrinsics.checkNotNullParameter((Object)csvFilePath, (String)"csvFilePath");
        Object object = this;
        try {
            $this$writeCsvFileWithDailyTraffic_u24lambda_u242 = object;
            boolean bl = false;
            Path filePath = Paths.get(csvFilePath, new String[0]);
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            if (Files.exists(filePath, new LinkOption[0])) {
                Files.delete(filePath);
            }
            Files.createFile(filePath, new FileAttribute[0]);
            Object object2 = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
            object2 = Files.newBufferedWriter(filePath, object2);
            Throwable throwable = null;
            try {
                BufferedWriter fileWriter = (BufferedWriter)object2;
                boolean bl2 = false;
                Map<String, Integer> $this$forEach$iv = userTrafficInfoMap;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, Integer>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, Integer> element$iv;
                    Map.Entry<String, Integer> entry = element$iv = iterator2.next();
                    boolean bl3 = false;
                    String dayHourKeyUserId = entry.getKey();
                    int requestCount = ((Number)entry.getValue()).intValue();
                    fileWriter.write(dayHourKeyUserId + ',' + requestCount);
                    fileWriter.newLine();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
            $this$writeCsvFileWithDailyTraffic_u24lambda_u242 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$writeCsvFileWithDailyTraffic_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$writeCsvFileWithDailyTraffic_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object it = $this$writeCsvFileWithDailyTraffic_u24lambda_u242 = throwable;
            boolean bl = false;
            log.error("Failed to write csv file with user traffic.", (Throwable)it);
            throw it;
        }
        if (Result.isSuccess-impl((Object)object)) {
            Unit it = (Unit)object;
            boolean bl = false;
            log.info("Successfully wrote csv file with user traffic.");
        }
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(DailyTrafficFileWriterService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/guardrails/DailyTrafficFileWriterService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

